﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.Security;
using TailspinSpyworks;

//--------------------------------------------------------------------------------------------------------------------------------------------------+
// TODO: In a "real"  On Line Store we would implement Shipping qand Payment Processes
//--------------------------------------------------------------------------------------------------------------------------------------------------+
namespace TailspinSpyworks
{
    public partial class CheckOut : System.Web.UI.Page
    {
        decimal _CartTotal = 0;

        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void Page_Load(object sender, EventArgs e)
        {
            CheckOutHeader.InnerText = "购物车还没有东西";
            LabelCartHeader.Text = "";
            CheckoutBtn.Visible = false;
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void CheckoutBtn_Click(object sender, ImageClickEventArgs e)
        {
            MyShoppingCart usersShoppingCart = new MyShoppingCart();//实例化MyShoppingCart
            //调用MyShoppingCart的SubmitOrder方法提交订单
            if (usersShoppingCart.SubmitOrder(User.Identity.Name) == true)
            {
                CheckOutHeader.InnerText = "谢谢，订单己经完成";   //显示订单完成信息
                Message.Visible = false;
                CheckoutBtn.Visible = false;
            }
            else                                                   //显示订单失败信息
            {
                CheckOutHeader.InnerText = "提单提交失败，请再试一次 ";
            }           
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void MyList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
                {
                    TailspinSpyworks.Data_Access.ViewCart myCart = new Data_Access.ViewCart();
                    myCart = (TailspinSpyworks.Data_Access.ViewCart) e.Row.DataItem;
                    _CartTotal += myCart.UnitCost * myCart.Quantity;            
                }
            else if (e.Row.RowType == DataControlRowType.Footer)
                {

                    if (_CartTotal > 0)
                    {
                        CheckOutHeader.InnerText = "回顾且提交你的订单";
                        LabelCartHeader.Text = "请确认下面所有信息的正确性";
                        CheckoutBtn.Visible = true;
                        e.Row.Cells[5].Text = "合计: " + _CartTotal.ToString("C");
                    }
                }
        }
    }
}