﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Styles/Site.Master" AutoEventWireup="true" CodeBehind="CheckOut.aspx.cs" Inherits="TailspinSpyworks.CheckOut" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div id="CheckOutHeader" runat="server" class="ContentHead">回顾&提交订单</div>
    <span id="Message" runat="server"><br />     
        <asp:Label ID="LabelCartHeader" runat="server" Text="Please check all the information below to be sure it&#39;s correct."></asp:Label>
    </span><br /> 
    <asp:GridView ID="MyList" runat="server" AutoGenerateColumns="False" DataKeyNames="ProductID,UnitCost,Quantity" DataSourceID="EDS_Cart" 
                  CellPadding="4" GridLines="Vertical" CssClass="CartListItem" onrowdatabound="MyList_RowDataBound" ShowFooter="True">
        <AlternatingRowStyle CssClass="CartListItemAlt" />
        <Columns>
            <asp:BoundField DataField="ProductID" HeaderText="产品编号" ReadOnly="True" SortExpression="ProductID"  />
            <asp:BoundField DataField="ModelNumber" HeaderText="产品型号" SortExpression="ModelNumber" />
            <asp:BoundField DataField="ModelName" HeaderText="产品名称" SortExpression="ModelName" />
            <asp:BoundField DataField="UnitCost" HeaderText="单价" ReadOnly="True" SortExpression="UnitCost" DataFormatString="{0:c}" />
            <asp:BoundField DataField="Quantity" HeaderText="数量" ReadOnly="True" SortExpression="Quantity" />
            <asp:TemplateField> 
                <HeaderTemplate>合计</HeaderTemplate>
                <ItemTemplate>
                     <%# (Convert.ToDouble(Eval("Quantity")) *  Convert.ToDouble(Eval("UnitCost")))%>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <FooterStyle CssClass="CartListFooter"/>
        <HeaderStyle  CssClass="CartListHead" />
    </asp:GridView>   
    <br />
    <asp:imagebutton id="CheckoutBtn" runat="server" ImageURL="Styles/Images/submit.gif" onclick="CheckoutBtn_Click"></asp:imagebutton>
    <asp:EntityDataSource ID="EDS_Cart" runat="server" 
            ConnectionString="name=CommerceEntities" 
            DefaultContainerName="CommerceEntities" EnableFlattening="False" 
            EnableUpdate="True" EntitySetName="ViewCarts" 
            AutoGenerateWhereClause="True" EntityTypeFilter="" Select="" Where="">
        <WhereParameters>
            <asp:SessionParameter Name="CartID" DefaultValue="0" SessionField="TailSpinSpyWorks_CartID" />
        </WhereParameters>
    </asp:EntityDataSource>
</asp:Content>