﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using TailspinSpyworks.Data_Access;

namespace TailspinSpyworks.Account
{
    public partial class OrderDetails : System.Web.UI.Page
    {
        decimal _CartTotal = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(Request.QueryString["OrderId"]))
            {
                Response.Redirect("~/Account/OrderList.aspx");
            }
        }

        protected void MyList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            //如果当前类型为DataRow
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //将DataRow绑定到的基础对象转换为ViewOrderDetail实体集
                TailspinSpyworks.Data_Access.VewOrderDetail myCart = 
                    (TailspinSpyworks.Data_Access.VewOrderDetail)e.Row.DataItem;
                //计算合计功能
                _CartTotal += Convert.ToDecimal(myCart.UnitCost * myCart.Quantity);
            }
            else if (e.Row.RowType == DataControlRowType.Footer)  //如果当前行为页脚
            {
                //在页脚显示总计信息
                e.Row.Cells[5].Text = "总计: " + _CartTotal.ToString("C");
            }
        }
    }
}