﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;

namespace TailspinSpyworks.Account
{
    public partial class Login : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)               //在首次加载页面时记录Url
            {
                if (Page.Request.UrlReferrer != null)
                {   //保存客户端上次请求的Url值
                    Session["LoginReferrer"] = Page.Request.UrlReferrer.ToString();
                }
            }          
            if (User.Identity.IsAuthenticated)  //如果用户己经验证
            {
                FormsAuthentication.SignOut();  //注销当前客户
                Response.Redirect("~/");        //导航到首页
            }
        }

        protected void LoginUser_LoggedIn(object sender, EventArgs e)
        {
            MyShoppingCart usersShoppingCart = new MyShoppingCart(); //新建购物车
            String cartId = usersShoppingCart.GetShoppingCartId();   //从会话字典中得到购物车Id
            usersShoppingCart.MigrateCart(cartId, LoginUser.UserName);//迁移内容           
            if(Session["LoginReferrer"] != null)  //判断上次请求Url是否指定
            {   //重定向到上次请求的Url
                Response.Redirect(Session["LoginReferrer"].ToString());
            }
            Session["UserName"] = LoginUser.UserName;               //在Session中记录用户名称
        }
    }
}
