---
layout: post
title: Weekly
category: Weekly
author: 东岳

---

- [xxHash](https://github.com/Cyan4973/xxHash/), extremely fast non-cryptographic hash algorithm
- [The Art of Command Line](https://github.com/jlevy/the-art-of-command-line), master the command line, in one page.
- [The Power of Ten](http://spinroot.com/p10/), 10 Rules for Writing Safety Critical Code
 > 1. Restrict to simple control flow constructs.
 > 2. Give all loops a fixed upper-bound.
 > 3. Do not use dynamic memory allocation after initialization.
 > 4. Limit functions to no more than 60 lines of text.
 > 5. Use minimally two assertions per function on average.
 > 6. Declare data objects at the smallest possible level of scope.
 > 7. Check the return value of non-void functions, and check the validity of function parameters.
 > 8. Limit the use of the preprocessor to file inclusion and simple macros.
 > 9. Limit the use of pointers. Use no more than two levels of dereferencing per expression.
 > 10. Compile with all warnings enabled, and use one or more source code analyzers.
[@ComMouse](https://github.com/ComMouse)
- [Top-down learning path: Machine Learning for Software Engineers](https://github.com/ZuzooVn/machine-learning-for-software-engineers)
 > This is my multi-month study plan for going from mobile developer (self-taught, no CS degree) to machine learning engineer.
 > 
 > My main goal was to find an approach to studying Machine Learning that is mainly hands-on and abstracts most of the math for the beginner. This approach is unconventional because it’s the top-down and results-first approach designed for software engineers.
- [Portainer](http://portainer.io/), a lightweight management UI which allows you to easily manage your Docker host or Swarm cluster
[@gaocegege](https://github.com/gaocegege)
- [10 principles for smooth web animations](https://blog.gyrosco.pe/smooth-css-animations-7d8ffc2c1d29), the complete guide to getting 60fps animations with CSS.
[@gaocegege](https://github.com/gaocegege), [@LukeXuan](https://github.com/LukeXuan)
- [css-architecture](https://github.com/jareware/css-architecture), 8 simple rules for a robust, scalable CSS architecture
[@swaylq](https://github.com/swaylq), [@ComMouse](https://github.com/ComMouse)
- [RPyC](https://github.com/tomerfiliba/rpyc), Remote Python Call, a transparent library for symmetrical remote procedure calls, clustering, and distributed-computing.
[@mrmiywj](https://github.com/mrmiywj)
- [Benefits of using tmux - lessons from streamlining a development environment](https://blog.bugsnag.com/benefits-of-using-tmux/)
- [Awesome Perf Cpp](https://fenbf.github.io/AwesomePerfCpp/), a curated list of awesome C/C++ performance resources: talks, articles, books, libraries, tools libraries, sites. Inspired by awesome.
