<a href="#"><img src="https://user-images.githubusercontent.com/25837540/229469147-781d4141-7f35-4957-ad76-d483bb699b16.png" src="ChatGPTUI" width="300px"></a>

ChatGPT 🤖 with Textual User Interface (TUI) mode written in Go.

ChatGPTUI is an interactive tool that allows users to interact with OpenAI's GPT (Generative Pre-trained Transformer) language model in real-time, using a text-based user interface (TUI). This tool provides a convenient and intuitive way to communicate with the language model and generate human-like text responses, making it an ideal tool for anyone looking to explore the capabilities of language models or create conversational applications.

<a href="#"><img src="https://user-images.githubusercontent.com/25837540/229366591-b8185557-1e57-48d9-a265-9034d0ba92ac.gif" align="right" width="400px"/></a>

ChatGPTUI is designed to be easy to use and highly customizable. The tool supports a range of configuration options, allowing users to select the language model they want to use, set the length of generated responses, and more. Additionally, ChatGPTUI provides a range of keyboard shortcuts for quick and easy navigation through the available options, making the tool more user-friendly and efficient.

## Install

1. Grab the pre-built binary from the [releases page](https://github.com/dwisiswant0/chatgptui/releases), unpack & run! Or
2. If you have [Go1.19+](https://go.dev/dl/) compiler installed & configured:

```bash
go install github.com/dwisiswant0/chatgptui@latest
```

## Usage

Here are all the options it supports.

```console
$ chatgptui -h

  ChatGPTUI 🤖 v1.0.0
  --
  ChatGPT with Textual User Interface
  made with 💖 by dw1

Usage: chatgptui [options]

Options:
  -e, --edit         Edit configuration
  -l, --list         List all supported OpenAI model
      --rm           Remove configuration
  -V, --version      Show current version

Examples:
  chatgptui
  chatgptui --edit
```

### Interactive

The TUI mode of the ChatGPT tool can be accessed by running the **`chatgptui`** command without any additional flags. Upon executing the command, you will be prompted to provide the necessary configuration inputs that are required to use the language model.

The configuration inputs may include parameters such as the OpenAI API key, model, maximum length of the generated text, etc. These settings can be adjusted to tailor the output generated by the model according to your requirements.

Once you have provided the required configuration inputs, the system will direct you to the chat view model. Here, you can start generating responses by entering your prompts into the interface. The chat view model displays the conversation history, making it easier to keep track of the ongoing conversation.

#### Shortcuts

To improve the user experience and make ChatGPTUI more user-friendly, the tool offers a range of keyboard shortcuts that can be used in both the configuration and chat view models. These shortcuts allow you to perform various actions quickly, and make it easier to use the tool and interact with the language model.

* `↑`/`↓`: Use the up and down arrow keys to navigate through the options in the view model.
* `ctrl+c`/`esc`: Use these keyboard combinations to quit the ChatGPTUI.
* `tab`: Use this key to fill in the default value for a field in the configuration view model.

In addition to those shortcuts, ChatGPTUI also provides a convenient way to clear the chat history. Simply type `/clear` or `/c` in the text area of the chat view model to clear the chat history and start a new conversation.

Those keyboard shortcuts can help you streamline your workflow & increase your productivity, and save your time & make the ChatGPTUI tool more convenient to use. They allow you to navigate through the available options quickly, fill in default values easily, and clear the chat history with just a few keystrokes, improving your overall experience with the tool!

#### Configurations

When you run the  **`chatgptui`** command, it will immediately direct you to the chat view model, where you can start chatting with the language model. The chat view model will display the conversation history, and you can type in your prompt to generate a response from the model.

If you want to change any of the configuration settings, such as the model or temperature, you can use the `-e`/`--edit` flag. This will redirect you to the configuration view model, where you can modify the necessary fields according to your needs. Once you've updated the configuration, you can return to the chat view model to continue chatting with the updated settings.

```bash
chatgptui --edit
```

In case you want to remove the configuration entirely, you can use the `--rm` flag. This will delete the configuration and all associated data, allowing you to start fresh with a new configuration.

```bash
chatgptui --rm
```

#### Models

ChatGPTUI provides support for multiple OpenAI language models, each with its own unique set of features and capabilities. To view a list of all the available models that you can choose from when configuring the language model, you can use the `-l`/`--list` flag.

Using the `-l` flag will display a list of all the OpenAI models that are currently supported by ChatGPTUI.

```console
$ chatgptui --list
gpt-4-32k-0314
gpt-4-32k
gpt-4-0314
gpt-4
gpt-3.5-turbo-0301
gpt-3.5-turbo
text-davinci-003
text-davinci-002
text-curie-001
text-babbage-001
text-ada-001
text-davinci-001
davinci-instruct-beta
davinci
curie-instruct-beta
curie
ada
babbage
code-davinci-002
code-cushman-001
code-davinci-001
```

By viewing this list, you can easily select the model that best fits your needs, based on its capabilities and performance. Once you have selected the model you want to use, you can configure it according to your requirements using the configuration view model.

## Acknowledments

**ChatGPTUI** built with [sashabaranov/go-openai](https://github.com/sashabaranov/go-openai), and [bubbles](https://github.com/charmbracelet/bubbles), [bubbletea](https://github.com/charmbracelet/bubbletea) & [lipgloss](https://github.com/charmbracelet/lipgloss) by [charmbracelet](https://github.com/charmbracelet).

## License

Contributions are welcome!

**ChatGPTUI** released under MIT. See `LICENSE` file.

