# [**React.js Koans**](https://github.com/arkency/reactjs_koans)

If you want to learn React.js you came to the right place. We prepared a set of practical exercises that will help you learn React.js from square one. The only thing you need to know is JavaScript. Here we are using [ECMAScript 2015 standard](https://babeljs.io/docs/learn-es2015/).

The Koans are a set of tasks to complete. Prepared tests checks if they are done correctly.

## Installation

Make sure you have Node.js and Python 2 installed.

  1. `git clone https://github.com/arkency/reactjs_koans.git`
  2. `cd reactjs_koans`
  3. `npm run setup`

## Koans structure

 * Edit the files found in the **`exercises`** directory.
 * The `koans` directory contains the source of all the exercises. `test` contains the tests.
 * `src` contains files compiled from `exercises`.
 * `build` contains sources launched in the web browser version of Koans.

## Start a local web server (optional)

You can run a webserver and see your changes live in your web browser:

  1. Run command `npm run start`
  2. Visit http://localhost:8080/

## Instructions

  1. Remember about running the setup script before you start working on Koans!
  2. Work on the code found in the `exercises` directory and run the tests to see if you did everything right.
  3. You need to do the exercises in the given order.
  4. Try to not peek at the test files! They contain spoilers.
  5. To run the tests, use `npm run test`. To automatically run tests when your code changes, use `npm run watch`.

## Video walkthrough

 * [Koans Installation](https://www.youtube.com/watch?v=Csf909B5_Qg)
 * [Walkthrough - Exercise #1](https://www.youtube.com/watch?v=wSC2Jqy3xLU)
 * [Walkthrough - Exercise #2](https://www.youtube.com/watch?v=2iuVq17YQxM)

## More than just Koans

### Blog

If you want to read more about React.js and modern JavaScript applications, check out our [React Kung Fu blog](http://reactkungfu.com/).

### The book

For people who finished Koans, we prepared something to go continue: the *React by example book*. In this book, we explain how to create common widgets like password-strength meter or credit card input.

For the price of the ebook, you get:

* Over 140 pages of React content. From fast introduction to React to example Todo app;
* 11 practical real-world examples;
* Repositories with code for most of the examples;

It's an early version of the book. It means some wording in book may change and there will be more examples later. All updates for the book are free.

You can use special **20% discount code: REACTKOANS**.
[Grab your copy today](https://arkency.dpdcart.com/cart/add?product_id=113689&method_id=120078) or [download a free chapter](http://reactkungfu.com/assets/misc/sample.pdf)

## Additional resources

  * [React docs](https://facebook.github.io/react/docs/getting-started.html) - it's a great source of in-depth information about React.
  * [Why keys are important in React](http://blog.arkency.com/2014/10/react-dot-js-and-dynamic-children-why-the-keys-are-important/) - great reading explaining the reason for React's keys.
  * [Reactiflux](http://www.reactiflux.com/). User group on Slack. You can meet a lot of people using React there. There's a channel for beginners `needhelp`.


## About

<img src="http://arkency.com/images/arkency.png" alt="Arkency" width="14%" align="left" />

React Koans is funded and maintained by Arkency. Check out our other [open-source projects](https://github.com/arkency).

You can also [hire us](http://arkency.com) or [read our blog](http://blog.arkency.com).
