# Computer Vision

Many applications in the area of computer vision are closely related to our daily lives, now and in the future, whether medical diagnostics, driverless vehicles, camera monitoring, or smart filters. In recent years, deep learning technology has greatly enhanced computer vision systems' performance. It can be said that the most advanced computer vision applications are nearly inseparable from deep learning.

We have introduced deep learning models commonly used in the area of computer vision in the chapter "Convolutional Neural Networks" and have practiced simple image classification tasks. In this chapter, we will introduce image augmentation and fine tuning methods and apply them to image classification. Then, we will explore various methods of object detection. After that, we will learn how to use fully convolutional networks to perform semantic segmentation on images. Then, we explain how to use style transfer technology to generate images that look like the cover of this book. Finally, we will perform practice exercises on two important computer vision data sets to review the content of this chapter and the previous chapters.

### INDEX

- Image Augmentation
- Fine Tuning
- Object Detection and Bounding Boxes
- Anchor Boxes
- Multiscale Object Detection
- Object Detection Data Set (Pikachu)
- Single Shot Multibox Detection (SSD)
- Region-based CNNs (R-CNNs)
- Semantic Segmentation and Data Sets
- Transposed Convolution
- Fully Convolutional Networks (FCN)
- Neural Style Transfer
- Image Classification (CIFAR-10) on Kaggle
- Dog Breed Identification (ImageNet Dogs) on Kaggle