# Changelog

This project follows semantic versioning.

Possible log types:

- `[added]` for new features.
- `[changed]` for changes in existing functionality.
- `[deprecated]` for once-stable features removed in upcoming releases.
- `[removed]` for deprecated features removed in this release.
- `[fixed]` for any bug fixes.
- `[security]` to invite users to upgrade in case of vulnerabilities.

### Unreleased

### v0.14.2 (2021-04-25)

- [fixed] Fixed thread field names corruption in `thr::pool!` macro
- [fixed] Fixed memory leak inside `fib::Chain`

### v0.14.0 (2021-04-09)

- [removed] `heaptrace` feature has been removed in favor of the new
  `trace_port` option in `heap!` macro
- [added] Added support for multiple heaps
- [added] `heap` option for `heap!` macro has been renamed to `metadata`
- [added] Added `global` option to `heap!` macro
- [changed] Changed function signature for outer thread handlers
- [changed] `fib::Chain::drain` method now returns an iterator, which can be
  queried for whether any fiber was executed.
- [added] Added a new synchronization primitive: lock-free singly-linked list
  `sync::LinkedList`
- [changed] `sync::Mutex` was rewritten to be futures-aware
- [removed] `sync::RwLock` was removed, because in its current non-futures-aware
  form it was unusable
- [renamed] `FiberRoot` trait is now `RootFiber`
- [changed] Changed semantics of `RootFiber::advance`
- [added] Added `*_factory` method variants for creating non-`Send` fibers
- [fixed] Removed one layer of indirection in `fib::Chain`
- [changed] `thr!` macro has been renamed to `thr::pool!` and the syntax has
  been changed
- [added] `thr::ThrExec` trait from `drone-cortexm` has been moved to the core with
- [changed] `thr::Thread` and `thr::ThrToken` trait definitions have been
  changed
- [removed] `thr::ThreadLocal` trait has been removed
- [changed] `thr::local` and `thr::thread_call` free-standing functions have
  been moved to `thr::Thread` trait with changes in semantics
- [added] Added software-driven thread pools (see `thr::soft` module and
  `thr::soft!` macro)

### v0.13.0 (2020-11-28)

- [changed] Use `typenum` crate instead of `const_generics` feature for
  `inventory` module
- [removed] Removed deprecated stream methods on thread tokens
- [changed] Changed syntax of `thr!` macro
- [changed] Renamed `drone_macros_core::compile_error` macro to
  `drone_macros_core::parse_error`
- [changed] Renamed `ThrToken::THR_NUM` associated constant to
  ``ThrToken::THR_IDX``
- [changed] Changed signature of `thr::thread_resume` function to work on thread
  types instead of thread token types
- [added] Added `thr::thread_call` function
- [changed] Changed syntax of `heap!` macro
- [changed] Changed syntax of `reg_tokens!` macro
- [changed] Changed syntax of `reg!` macro

### v0.12.1 (2020-05-13)

- [changed] Renamed streams methods on thread tokens
- [added] Added `store_reg` and `modify_reg` methods for register tokens

### v0.12.0 (2020-05-01)

- [added] Implemented multi-variant registers
- [added] Added `load_bits`, `store_bits` methods for register tokens
- [removed] Removed hooks from `heap!` macro in favor of the new `heaptrace`
  feature
- [added] Added `reg::assert_taken!` macro
- [added] Added ability to exclude some registers for macros generated by
  `reg::tokens!`
- [changed] `drone-core` is responsible for defining lang items now
- [added] Implemented `log` facade
- [added] Added `dbg`, `eprint`, `eprintln`, `print`, `println` to `prelude`
- [removed] Removed `future::init` function and `future::fallback` module
- [changed] Renamed `drone_core::sync::spsc::*::Sender::poll_cancel` to
  `poll_canceled`
- [changed] Renamed `drone_core::sync::spsc::{pulse,ring}::Sender::try_recv` to
  `try_next`
- [changed] Redesigned `inventory` counters to use Rust's `consts_generics`
  feature

### v0.11.1 (2019-11-27)

- [added] Implemented 11 `inventory` counters (was 9)
- [changed] Upgraded to `syn` 1.0
- [changed] Switched to the recently released `futures` 0.3 instead of
  `futures-preview` 0.3-alpha

### v0.11.0 (2019-11-06)

- [changed] Renamed `to_ptr`/`to_mut_ptr` to `as_ptr`/`as_mut_ptr`
- [removed] Removed `bmp_uart_baudrate!` macro in favor of
  `drone_cortex_m::itm::update_prescaler!` macro
- [added] `periph!`, `periph_map!`, `periph_singular!` now accept arbitrary
  condition compilation flags
- [fixed] Accept `VAL` as a field name in `reg!` macro

### v0.10.1 (2019-09-27)

- [fixed] Fixed API documentation by moving to self-hosted
  https://api.drone-os.com
