# How to contribute

One of the easiest ways to contribute is to participate in [discussions](../../discussions) or filing [issues](../../issues) for problems you encounter. You can also contribute by submitting pull requests with code changes.

## General feedback and discussions?

Please start a [discussion](../../discussions) or go to the [repo issue tracker](../../issues). Not sure which one to choose? Discussions are an open forum that serve as a repository to search through. While questions or suggestions can be achieved through an issue, they will eventually be closed for maintenance purposes. Searching through closed issues makes it more difficult for the community to discover.

## Bugs and feature requests?

Please log a new [issue](../../issues).

## Contributing code and content

### Identifying the scale

If you would like to contribute to the repository, first identify the scale of what you would like to contribute. If it is small (grammar/spelling or a bug fix) feel free to start working on a fix. If you are submitting a feature or substantial code contribution, please discuss it with the team and ensure it follows the product roadmap. You might also read these two blogs posts on contributing code: [Open Source Contribution Etiquette](http://tirania.org/blog/archive/2010/Dec-31.html) by Miguel de Icaza and [Don't "Push" Your Pull Requests](https://www.igvita.com/2011/12/19/dont-push-your-pull-requests/) by Ilya Grigorik. Note that all code submissions will be rigorously reviewed and tested by the team, and only those that meet an extremely high bar for quality, design, and roadmap will be merged into the source.

### Submitting a pull request

You will need to sign a [Contributor License Agreement](https://cla.dotnetfoundation.org/dotnet/aspnet-api-versioning) when submitting your pull request. To complete the Contributor License Agreement (CLA), you
will need to follow the instructions provided by the CLA bot when you send the pull request. This needs to only be done once for any .NET Foundation OSS project.

If you don't know what a pull request is read this article: https://help.github.com/articles/using-pull-requests. Make sure that the repository can build and that all tests pass. Familiarize yourself with the project workflow and our coding conventions. The coding and style guidelines are described and enforced by `.editorconfig` as well as .NET Compiler Platform analyzers. These tools will automatically override your default settings without changing your environment. Violations will cause the build to fail.

### Tests

-  Tests need to be provided for every bug or feature that is completed.
-  Tests only need to be present for issues that need to be verified (e.g. not tasks)

### Feedback

Your pull request will now go through extensive checks by the subject matter experts on our team; please be patient. Update your pull request according to feedback until it is approved by one of the team members. After that, one of our team members may adjust the branch you merge into based on the expected release schedule.
