(*
  Dokan API wrapper for Delphi based on Release 2.2.0.1000
  https://github.com/dokan-dev/dokany/releases/tag/v2.2.0.1000
  Copyright (C) 2019 - 2024 Sven Harazim

  Dokan : user-mode file system library for Windows

  Copyright (C) 2015 - 2019 Adrien J. <liryna.stark@gmail.com> and Maxime C. <maxime@islog.com>
  Copyright (C) 2020 Google, Inc.
  Copyright (C) 2007 - 2011 Hiroki Asakawa <info@dokan-dev.net>

  http://dokan-dev.github.io

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 3 of the License, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this program. If not, see <http://www.gnu.org/licenses/>.
*)

unit DokanWin;

{$ifdef FPC}
  {$mode delphi}
{$endif FPC}

{$align 8}
{$minenumsize 4}

interface

uses
  Windows;

type
  USHORT = Word;
  ULONG64 = UInt64;
  PACCESS_MASK = ^ACCESS_MASK;

  LPVOID = Pointer;
  PVOID = Pointer;

  _UNICODE_STRING = record
    Length: USHORT;
    MaximumLength: USHORT;
    Buffer: LPWSTR;
  end;
  UNICODE_STRING = _UNICODE_STRING;
  PUNICODE_STRING = ^_UNICODE_STRING;
  TUnicodeString = UNICODE_STRING;
  PUnicodeString = PUNICODE_STRING;

  _WIN32_FIND_STREAM_DATA = record
    StreamSize: LARGE_INTEGER;
    cStreamName: array [0 .. (MAX_PATH+36) - 1] of WCHAR;
  end;
  WIN32_FIND_STREAM_DATA = _WIN32_FIND_STREAM_DATA;
  PWIN32_FIND_STREAM_DATA = ^_WIN32_FIND_STREAM_DATA;
  TWin32FindStreamData = WIN32_FIND_STREAM_DATA;
  PWin32FindStreamData = PWIN32_FIND_STREAM_DATA;

  NTSTATUS = LongInt;
  TNtStatus = NTSTATUS;

const
  // DesiredAccess

  FILE_READ_DATA            = $0001;
  FILE_LIST_DIRECTORY       = $0001;
  FILE_WRITE_DATA           = $0002;
  FILE_ADD_FILE             = $0002;
  FILE_APPEND_DATA          = $0004;
  FILE_ADD_SUBDIRECTORY     = $0004;
  FILE_CREATE_PIPE_INSTANCE = $0004;
  FILE_READ_EA              = $0008;
  FILE_WRITE_EA             = $0010;
  FILE_EXECUTE              = $0020;
  FILE_TRAVERSE             = $0020;
  FILE_DELETE_CHILD         = $0040;
  FILE_READ_ATTRIBUTES      = $0080;
  FILE_WRITE_ATTRIBUTES     = $0100;

  DELETE                 = $00010000;
  READ_CONTROL           = $00020000;
  WRITE_DAC              = $00040000;
  WRITE_OWNER            = $00080000;
  SYNCHRONIZE            = $00100000;
  ACCESS_SYSTEM_SECURITY = $01000000;
  MAXIMUM_ALLOWED        = $02000000;
  GENERIC_ALL            = $10000000;
  GENERIC_EXECUTE        = $20000000;
  GENERIC_WRITE          = $40000000;
  GENERIC_READ           = $80000000;

  FILE_GENERIC_READ     = STANDARD_RIGHTS_READ
                       or FILE_READ_DATA
                       or FILE_READ_ATTRIBUTES
                       or FILE_READ_EA
                       or SYNCHRONIZE;

  FILE_GENERIC_WRITE    = STANDARD_RIGHTS_WRITE
                       or FILE_WRITE_DATA
                       or FILE_WRITE_ATTRIBUTES
                       or FILE_WRITE_EA
                       or FILE_APPEND_DATA
                       or SYNCHRONIZE;

  FILE_GENERIC_EXECUTE  = STANDARD_RIGHTS_EXECUTE
                       or FILE_READ_ATTRIBUTES
                       or FILE_EXECUTE
                       or SYNCHRONIZE;

  // FileAttributes

  FILE_ATTRIBUTE_READONLY              = $00000001;
  FILE_ATTRIBUTE_HIDDEN                = $00000002;
  FILE_ATTRIBUTE_SYSTEM                = $00000004;
  FILE_ATTRIBUTE_DIRECTORY             = $00000010;
  FILE_ATTRIBUTE_ARCHIVE               = $00000020;
  FILE_ATTRIBUTE_DEVICE                = $00000040;
  FILE_ATTRIBUTE_NORMAL                = $00000080;
  FILE_ATTRIBUTE_TEMPORARY             = $00000100;
  FILE_ATTRIBUTE_SPARSE_FILE           = $00000200;
  FILE_ATTRIBUTE_REPARSE_POINT         = $00000400;
  FILE_ATTRIBUTE_COMPRESSED            = $00000800;
  FILE_ATTRIBUTE_OFFLINE               = $00001000;
  FILE_ATTRIBUTE_NOT_CONTENT_INDEXED   = $00002000;
  FILE_ATTRIBUTE_ENCRYPTED             = $00004000;
  FILE_ATTRIBUTE_INTEGRITY_STREAM      = $00008000;
  FILE_ATTRIBUTE_VIRTUAL               = $00010000;
  FILE_ATTRIBUTE_NO_SCRUB_DATA         = $00020000;
  FILE_ATTRIBUTE_RECALL_ON_OPEN        = $00040000;
  FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS = $00400000;
  INVALID_FILE_ATTRIBUTES              = $FFFFFFFF;

  // FileFlags

  FILE_FLAG_OPEN_REQUIRING_OPLOCK = $00040000;
  FILE_FLAG_FIRST_PIPE_INSTANCE   = $00080000;
  FILE_FLAG_OPEN_NO_RECALL        = $00100000;
  FILE_FLAG_OPEN_REPARSE_POINT    = $00200000;
  FILE_FLAG_SESSION_AWARE         = $00800000;
  FILE_FLAG_POSIX_SEMANTICS       = $01000000;
  FILE_FLAG_BACKUP_SEMANTICS      = $02000000;
  FILE_FLAG_DELETE_ON_CLOSE       = $04000000;
  FILE_FLAG_SEQUENTIAL_SCAN       = $08000000;
  FILE_FLAG_RANDOM_ACCESS         = $10000000;
  FILE_FLAG_NO_BUFFERING          = $20000000;
  FILE_FLAG_OVERLAPPED            = $40000000;
  FILE_FLAG_WRITE_THROUGH         = $80000000;

  // CreateDisposition

  FILE_SUPERSEDE    = $00000000;
  FILE_OPEN         = $00000001;
  FILE_CREATE       = $00000002;
  FILE_OPEN_IF      = $00000003;
  FILE_OVERWRITE    = $00000004;
  FILE_OVERWRITE_IF = $00000005;

  // CreateOptions

  FILE_DIRECTORY_FILE            = $00000001;
  FILE_WRITE_THROUGH             = $00000002;
  FILE_SEQUENTIAL_ONLY           = $00000004;
  FILE_NO_INTERMEDIATE_BUFFERING = $00000008;
  FILE_SYNCHRONOUS_IO_ALERT      = $00000010;
  FILE_SYNCHRONOUS_IO_NONALERT   = $00000020;
  FILE_NON_DIRECTORY_FILE        = $00000040;
  FILE_CREATE_TREE_CONNECTION    = $00000080;
  FILE_COMPLETE_IF_OPLOCKED      = $00000100;
  FILE_NO_EA_KNOWLEDGE           = $00000200;
  FILE_OPEN_FOR_RECOVERY         = $00000400;
  FILE_RANDOM_ACCESS             = $00000800;
  FILE_DELETE_ON_CLOSE           = $00001000;
  FILE_OPEN_BY_FILE_ID           = $00002000;
  FILE_OPEN_FOR_BACKUP_INTENT    = $00004000;
  FILE_NO_COMPRESSION            = $00008000;
  FILE_OPEN_REQUIRING_OPLOCK     = $00010000;
  FILE_DISALLOW_EXCLUSIVE        = $00020000;
  FILE_SESSION_AWARE             = $00040000;
  FILE_RESERVE_OPFILTER          = $00100000;
  FILE_OPEN_REPARSE_POINT        = $00200000;
  FILE_OPEN_NO_RECALL            = $00400000;
  FILE_OPEN_FOR_FREE_SPACE_QUERY = $00800000;

  // SecurityInformation

  OWNER_SECURITY_INFORMATION               = $00000001;
  GROUP_SECURITY_INFORMATION               = $00000002;
  DACL_SECURITY_INFORMATION                = $00000004;
  SACL_SECURITY_INFORMATION                = $00000008;
  LABEL_SECURITY_INFORMATION               = $00000010;
  ATTRIBUTE_SECURITY_INFORMATION           = $00000020;
  SCOPE_SECURITY_INFORMATION               = $00000040;
  PROCESS_TRUST_LABEL_SECURITY_INFORMATION = $00000080;
  BACKUP_SECURITY_INFORMATION              = $00010000;
  UNPROTECTED_SACL_SECURITY_INFORMATION    = $10000000;
  UNPROTECTED_DACL_SECURITY_INFORMATION    = $20000000;
  PROTECTED_SACL_SECURITY_INFORMATION      = $40000000;
  PROTECTED_DACL_SECURITY_INFORMATION      = $80000000;

  // FileSystemFlags

  FILE_CASE_SENSITIVE_SEARCH        = $00000001;
  FILE_CASE_PRESERVED_NAMES         = $00000002;
  FILE_UNICODE_ON_DISK              = $00000004;
  FILE_PERSISTENT_ACLS              = $00000008;
  FILE_FILE_COMPRESSION             = $00000010;
  FILE_VOLUME_QUOTAS                = $00000020;
  FILE_SUPPORTS_SPARSE_FILES        = $00000040;
  FILE_SUPPORTS_REPARSE_POINTS      = $00000080;
  FILE_SUPPORTS_REMOTE_STORAGE      = $00000100;
  FILE_VOLUME_IS_COMPRESSED         = $00008000;
  FILE_SUPPORTS_OBJECT_IDS          = $00010000;
  FILE_SUPPORTS_ENCRYPTION          = $00020000;
  FILE_NAMED_STREAMS                = $00040000;
  FILE_READ_ONLY_VOLUME             = $00080000;
  FILE_SEQUENTIAL_WRITE_ONCE        = $00100000;
  FILE_SUPPORTS_TRANSACTIONS        = $00200000;
  FILE_SUPPORTS_HARD_LINKS          = $00400000;
  FILE_SUPPORTS_EXTENDED_ATTRIBUTES = $00800000;
  FILE_SUPPORTS_OPEN_BY_FILE_ID     = $01000000;
  FILE_SUPPORTS_USN_JOURNAL         = $02000000;

  // AccessState Flags

  TOKEN_HAS_TRAVERSE_PRIVILEGE = $01;
  TOKEN_HAS_BACKUP_PRIVILEGE   = $02;
  TOKEN_HAS_RESTORE_PRIVILEGE  = $04;
  TOKEN_HAS_ADMIN_GROUP        = $08;
  TOKEN_IS_RESTRICTED          = $10;

  // NTSTATUS

  STATUS_SUCCESS                            = NTSTATUS($00000000);
  STATUS_BUFFER_OVERFLOW                    = NTSTATUS($80000005);
  STATUS_NO_MORE_FILES                      = NTSTATUS($80000006);
  STATUS_UNSUCCESSFUL                       = NTSTATUS($C0000001);
  STATUS_NOT_IMPLEMENTED                    = NTSTATUS($C0000002);
  STATUS_INVALID_HANDLE                     = NTSTATUS($C0000008);
  STATUS_INVALID_PARAMETER                  = NTSTATUS($C000000D);
  STATUS_NO_SUCH_FILE                       = NTSTATUS($C000000F);
  STATUS_END_OF_FILE                        = NTSTATUS($C0000011);
  STATUS_NO_MEMORY                          = NTSTATUS($C0000017);
  STATUS_ACCESS_DENIED                      = NTSTATUS($C0000022);
  STATUS_BUFFER_TOO_SMALL                   = NTSTATUS($C0000023);
  STATUS_OBJECT_NAME_INVALID                = NTSTATUS($C0000033);
  STATUS_OBJECT_NAME_NOT_FOUND              = NTSTATUS($C0000034);
  STATUS_OBJECT_NAME_COLLISION              = NTSTATUS($C0000035);
  STATUS_OBJECT_PATH_NOT_FOUND              = NTSTATUS($C000003A);
  STATUS_SHARING_VIOLATION                  = NTSTATUS($C0000043);
  STATUS_LOCK_NOT_GRANTED                   = NTSTATUS($C0000055);
  STATUS_PRIVILEGE_NOT_HELD                 = NTSTATUS($C0000061);
  STATUS_DISK_FULL                          = NTSTATUS($C000007F);
  STATUS_INSUFFICIENT_RESOURCES             = NTSTATUS($C000009A);
  STATUS_DEVICE_NOT_READY                   = NTSTATUS($C00000A3);
  STATUS_FILE_IS_A_DIRECTORY                = NTSTATUS($C00000BA);
  STATUS_NOT_SUPPORTED                      = NTSTATUS($C00000BB);
  STATUS_INTERNAL_ERROR                     = NTSTATUS($C00000E5);
  STATUS_DIRECTORY_NOT_EMPTY                = NTSTATUS($C0000101);
  STATUS_NOT_A_DIRECTORY                    = NTSTATUS($C0000103);
  STATUS_NAME_TOO_LONG                      = NTSTATUS($C0000106);
  STATUS_CANNOT_DELETE                      = NTSTATUS($C0000121);
  STATUS_NOT_FOUND                          = NTSTATUS($C0000225);

  VOLUME_SECURITY_DESCRIPTOR_MAX_SIZE = 1024 * 16;

implementation

end.
