module.exports = {
	parser: '@typescript-eslint/parser',
	parserOptions: {
		project: './tsconfig.json'
	},
	extends: [
		"eslint:recommended",
		'plugin:@typescript-eslint/recommended',
	],
	env: {
		es6: true,
		node: true
	},
	rules: {
		// Possible Errors
		"for-direction": "error",
		"no-await-in-loop": "error",
		"no-console": "off",
		"no-debugger": "warn",
		"no-extra-boolean-cast": "warn",
		"no-extra-parens": "off",
		"no-unsafe-finally": "error",
		"no-prototype-builtins": "off",
		"no-template-curly-in-string": "error",
		"valid-jsdoc": ["warn", {
			"prefer": {
				"return": "returns",
				"argument": "param",
				"arg": "param",
				"constructor": "class",
				"virtual": "abstract"
			},
			"preferType": {
				"Boolean": "boolean",
				"Number": "number",
				"String": "string",
				"object": "Object",
				"array": "Array",
				"date": "Date"
			},
			"matchDescription": ".+",
			"requireParamDescription": true,
			"requireReturnDescription": true,
			"requireReturn": false,
			"requireReturnType": true
		}],

		// Best Practices
		"array-callback-return": "warn",
		"class-methods-use-this": "warn",
		"complexity": ["warn", 30],
		"consistent-return": "warn",
		"curly": ["error", "all"],
		"default-case": "error",
		"dot-notation": ["error", {"allowKeywords": true, "allowPattern": "^[a-zA-Z]+(_[a-zA-Z]+)+$"}],
		"eqeqeq": "error",
		"guard-for-in": "off",
		"no-alert": "off",
		"no-caller": "error",
		"no-case-declarations": "error",
		"no-div-regex": "error",
		"no-else-return": "warn",
		"no-empty-pattern": "warn",
		"no-eq-null": "error",
		"no-eval": "error",
		"no-extend-native": "error",
		"no-extra-bind": "error",
		"no-extra-label": "warn",
		"no-fallthrough": "warn",
		"no-floating-decimal": "error",
		"no-implicit-coercion": ["warn", {"boolean": true, "number": true, "string": true}],
		"no-implicit-globals": "warn",
		"no-implied-eval": "error",
		"no-iterator": "error",
		"no-labels": ["error", {"allowLoop": false, "allowSwitch": false}],
		"no-lone-blocks": "warn",
		"no-loop-func": "error",
		"no-magic-numbers": "off",
		"no-multi-spaces": ["warn", {"ignoreEOLComments": true}],
		"no-multi-str": "error",
		"no-native-reassign": "error",
		"no-new": "error",
		"no-new-func": "error",
		"no-new-wrappers": "error",
		"no-octal-escape": "error",
		"no-octal": "error",
		"no-process-env": "off",
		"no-proto": "error",
		"no-redeclare": "error",
		"no-return-assign": "error",
		"no-script-url": "error",
		"no-self-assign": "error",
		"no-self-compare": "error",
		"no-sequences": "error",
		"no-throw-literal": "error",
		"no-unmodified-loop-condition": "warn",
		"no-unused-expressions": "error",
		"no-unused-labels": "error",
		"no-useless-call": "error",
		"no-useless-concat": "warn",
		"no-useless-return": "warn",
		"no-void": "error",
		"no-warning-comments": "off",
		"no-with": "error",
		"radix": "error",
		"vars-on-top": "error",
		"wrap-iife": ["error", "outside"],
		"yoda": ["error", "never", {"exceptRange": true}],

		// Strict Mode
		"strict": ["error", "global"],

		// Variables
		"no-catch-shadow": "error",
		"no-delete-var": "error",
		"no-label-var": "error",
		"no-shadow-restricted-names": "error",
		"no-shadow": ["warn", {"builtinGlobals": false}],
		"no-undef": "error",
		"no-undef-init": "error",
		"no-undefined": "warn",
		"no-unused-vars": ["warn", {"vars": "all", "args": "after-used"}],
		"no-use-before-define": ["error", "nofunc"],

		// Node.js and CommonJS
		"global-require": "warn",
		"handle-callback-err": "warn",
		"no-buffer-constructor": "warn",
		"no-new-require": "warn",
		"no-path-concat": "warn",

		// Stylistic Issues
		"array-bracket-newline": "off",
		"array-bracket-spacing": ["warn", "never"],
		"block-spacing": ["warn", "never"],
		"brace-style": ["warn", "1tbs"],
		"camelcase": "warn",
		"comma-spacing": ["warn", {"before": false, "after": true}],
		"comma-style": ["warn", "last"],
		"computed-property-spacing": ["warn", "never"],
		"consistent-this": ["warn", "that"],
		"eol-last": "warn",
		"func-call-spacing": ["warn", "never"],
		"func-names": "off",
		"func-style": "off",
		"function-paren-newline": ["warn", "multiline"],
		"id-blacklist": "off",
		"id-length": "off",
		"id-match": "off",
		"indent": ["warn", "tab", {"SwitchCase": 1}],
		"jsx-quotes": "off",
		"key-spacing": ["warn", {"beforeColon": false, "afterColon": true}],
		"keyword-spacing": ["error", {"before": true, "after": true, "overrides": {}}],
		"linebreak-style": "off",
		"lines-around-comment": "off",
		"max-depth": ["warn", 10],
		"max-len":  ["warn", 500],
		"max-lines": ["warn", 1000],
		"max-nested-callbacks": ["warn", 10],
		"max-params": ["warn", 10],
		"max-statements": ["warn", 150],
		"max-statements-per-line": ["warn", {"max": 2}],
		"new-cap": "warn",
		"new-parens": "warn",
		"newline-per-chained-call": "off",
		"no-array-constructor": "warn",
		"no-bitwise": "warn",
		"no-continue": "warn",
		"no-inline-comments": "off",
		"no-lonely-if": "off",
		"no-mixed-spaces-and-tabs": "warn",
		"no-multiple-empty-lines": "off",
		"no-multi-assign": "off",
		"no-negated-condition": "off",
		"no-nested-ternary": "warn",
		"no-new-object": "warn",
		"no-plusplus": "off",
		"no-restricted-syntax": ["warn", "WithStatement"],
		"no-ternary": "off",
		"no-trailing-spaces": "warn",
		"no-underscore-dangle": "off",
		"no-unneeded-ternary": "warn",
		"no-whitespace-before-property": "warn",
		"object-curly-newline": "off",
		"object-curly-spacing": ["warn", "never"],
		"one-var-declaration-per-line": "off",
		"operator-assignment": "off",
		"operator-linebreak": ["warn", "after", {"overrides": {"?": "ignore", ":": "ignore"}}],
		"padded-blocks": "off",
		"padding-line-between-statements": "off",
		"quote-props": ["warn", "consistent"],
		"quotes": ["warn", "single", "avoid-escape"],
		"require-jsdoc": "off",
		"semi": ["warn", "always"],
		"semi-spacing": ["warn", {"before": false, "after": true}],
		"semi-style": ["error", "last"],
		"sort-imports": "off",
		"sort-vars": "off",
		"space-before-blocks": "warn",
		"space-before-function-paren": ["warn", {"anonymous": "always", "named": "never"}],
		"spaced-comment": ["off", "always"],
		"switch-colon-spacing": ["error", {"after": true, "before": false}],
		"unicode-bom": ["error", "never"],
		"wrap-regex": "off",

		// ECMAScript 6
		"arrow-body-style": ["warn", "as-needed"],
		"arrow-parens": ["warn", "as-needed"],
		"arrow-spacing": ["warn", {"before": true, "after": true}],
		"constructor-super": "error",
		"generator-star-spacing": ["warn", {"before": true, "after": false}],
		"no-class-assign": "error",
		"no-confusing-arrow": "error",
		"no-const-assign": "error",
		"no-dupe-class-members": "error",
		"no-duplicate-imports":  "error",
		"no-new-symbol": "error",
		"no-this-before-super": "error",
		"no-useless-constructor": "error",
		"no-useless-computed-key": "warn",
		"no-useless-rename": "warn",
		"no-var": "error",
		"object-shorthand": "off",
		"prefer-arrow-callback": "off",
		"prefer-const": "warn",
		"prefer-reflect": "off",
		"prefer-rest-params": "off",
		"prefer-spread": "off",
		"prefer-template": "off",
		"require-yield": "error",
		"template-curly-spacing": "error",
		"yield-star-spacing": "error",

		// typescript
		'@typescript-eslint/array-type': ['warn', {'default': 'generic'}],
		'@typescript-eslint/ban-ts-comment': ['warn',
			{
				'ts-expect-error': false,
				'ts-ignore': true,
				'ts-nocheck': true,
				'ts-check': false
			}
		],
		'camelcase': 'off',
		'@typescript-eslint/explicit-function-return-type': 'off',
		'@typescript-eslint/explicit-member-accessibility': 'off',
		'indent': 'off',
		'@typescript-eslint/indent': ['warn', 'tab', {'SwitchCase': 1}],
		'@typescript-eslint/member-delimiter-style': ['warn',
			{
				singleline: {
					delimiter: 'semi',
					requireLast: false
				},
				multiline: {
					delimiter: 'semi',
					requireLast: true
				}
			}
		],
		'@typescript-eslint/naming-convention': [
			'error',
			{
				selector: 'variable',
				modifiers: ['const'],
				format: ['camelCase', 'UPPER_CASE'],
			},
			{
				selector: 'variable',
				format: ['camelCase'],
				leadingUnderscore: 'allow',
			},
			{
				selector: 'function',
				format: ['camelCase'],
				leadingUnderscore: 'allow',
			},
			{
				selector: 'parameter',
				format: ['camelCase'],
				leadingUnderscore: 'allow',
			},
			{
				selector: ['property', 'typeProperty'],
				format: null,
			},
			/*
			{
				selector: 'parameterProperty',
				format: ['camelCase'],
			},
			*/
			{
				selector: 'class',
				format: ['PascalCase'],
			},
			{
				selector: 'method',
				format: ['camelCase'],
				leadingUnderscore: 'allow',
			},
			/*
			{
				selector: 'accessor',
				format: ['camelCase'],
			},
			{
				selector: 'enumMember',
				format: ['camelCase'],
			},
			{
				selector: 'interface',
				format: ['camelCase'],
			},
			{
				selector: 'typeAlias',
				format: ['camelCase'],
			},
			{
				selector: 'enum',
				format: ['camelCase'],
			},
			{
				selector: 'typeParameter',
				format: ['camelCase'],
			},
			*/
		],
		'@typescript-eslint/no-explicit-any': 'off',
		'@typescript-eslint/no-extraneous-class': 'warn',
		'@typescript-eslint/no-inferrable-types': 'off',
		'no-unused-vars': 'off',
		'@typescript-eslint/no-unused-vars': 'warn',
		'@typescript-eslint/no-unnecessary-type-assertion': 'warn',
		'@typescript-eslint/no-useless-constructor': 'warn',
		'@typescript-eslint/no-this-alias': [
			'warn',
			{
				allowDestructuring: true,
				allowedNames: ['that']
			}
		],
		'@typescript-eslint/no-use-before-define': 'off',
		'@typescript-eslint/prefer-interface': 'off',
		'@typescript-eslint/restrict-plus-operands': 'off',
	}
};
