package systems.dmx.core;



public class Constants {

    // Bootstrap
    public static final String META_TYPE            = "dmx.core.meta_type";

    // Meta Types
    public static final String TOPIC_TYPE           = "dmx.core.topic_type";
    public static final String ASSOC_TYPE           = "dmx.core.assoc_type";

    // Topic Types
    public static final String DATA_TYPE            = "dmx.core.data_type";
    public static final String ROLE_TYPE            = "dmx.core.role_type";
    public static final String CARDINALITY          = "dmx.core.cardinality";
    public static final String IDENTITY_ATTR        = "dmx.core.identity_attr";
    public static final String INCLUDE_IN_LABEL     = "dmx.core.include_in_label";
    //
    public static final String PLUGIN               = "dmx.core.plugin";
    public static final String PLUGIN_NAME          = "dmx.core.plugin_name";
    public static final String PLUGIN_SYMBOLIC_NAME = "dmx.core.plugin_symbolic_name";
    public static final String PLUGIN_MIGRATION_NR  = "dmx.core.plugin_migration_nr";

    // Assoc Types
    public static final String ASSOCIATION          = "dmx.core.association";
    public static final String COMPOSITION          = "dmx.core.composition";
    public static final String INSTANTIATION        = "dmx.core.instantiation";
    public static final String SEQUENCE             = "dmx.core.sequence";
    public static final String COMPOSITION_DEF      = "dmx.core.composition_def";
    public static final String CUSTOM_ASSOC_TYPE    = "dmx.core.custom_assoc_type";

    // Data Types
    public static final String TEXT                 = "dmx.core.text";
    public static final String HTML                 = "dmx.core.html";
    public static final String NUMBER               = "dmx.core.number";
    public static final String BOOLEAN              = "dmx.core.boolean";
    public static final String COMPOSITE            = "dmx.core.composite";
    public static final String VALUE                = "dmx.core.value";
    public static final String ENTITY               = "dmx.core.entity";

    // Role Types
    public static final String DEFAULT              = "dmx.core.default";
    public static final String TYPE                 = "dmx.core.type";
    public static final String INSTANCE             = "dmx.core.instance";
    public static final String PARENT               = "dmx.core.parent";
    public static final String CHILD                = "dmx.core.child";
    public static final String PARENT_TYPE          = "dmx.core.parent_type";
    public static final String CHILD_TYPE           = "dmx.core.child_type";
    public static final String PREDECESSOR          = "dmx.core.predecessor";
    public static final String SUCCESSOR            = "dmx.core.successor";
    public static final String SEQUENCE_START       = "dmx.core.sequence_start";

    // Cardinalities
    public static final String ONE                  = "dmx.core.one";
    public static final String MANY                 = "dmx.core.many";
}
