package dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.NamingException;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import util.ConnectionPool;

public class DirectorDAO {
	public boolean insert(String uid, String jsonstr) throws NamingException, SQLException {
		Connection conn = ConnectionPool.get();
		PreparedStatement stmt = null;
		try {
			
		  String sql = "INSERT INTO director(id, jsonstr) VALUES(?, ?)";
		  stmt = conn.prepareStatement(sql);
		  stmt.setString(1, uid);
		  stmt.setString(2, jsonstr);

		  int count = stmt.executeUpdate(); 
		  return (count ==1) ? true : false;
		  
		} finally {
			if (stmt != null) stmt.close(); 
		    if (conn != null) conn.close();
		}
	}

public boolean exists(String uid) throws NamingException, SQLException {
	Connection conn = ConnectionPool.get();
	PreparedStatement stmt = null;
	ResultSet rs = null;
	try { 
	  String sql = "SELECT id FROM director WHERE id = ?";
	  stmt = conn.prepareStatement(sql);
	  stmt.setString(1, uid);

	  rs = stmt.executeQuery(); 
	  return rs.next();
	  
	} finally {
		if (rs != null) rs.close();
	    if (stmt != null) stmt.close(); 
	    if (conn != null) conn.close();
	}
	}

	public boolean delete(String uid) throws NamingException, SQLException {
		Connection conn = ConnectionPool.get();
		PreparedStatement stmt = null;
		try {
			String sql = "delete from director where id = ?";
			  stmt = conn.prepareStatement(sql);
			  stmt.setString(1, uid);

		  int count = stmt.executeUpdate(); 
		  return (count ==1) ? true : false;
		  
		} finally {
			if (stmt != null) stmt.close(); 
		    if (conn != null) conn.close();
		}
	}
	
	public int login(String uid, String upass) throws NamingException, SQLException, ParseException {
		Connection conn = ConnectionPool.get();
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT jsonstr FROM director WHERE id = ?";
		   
			conn = ConnectionPool.get();
		    stmt = conn.prepareStatement(sql);
		    stmt.setString(1, uid);
		
		    rs = stmt.executeQuery();
		    if (!rs.next()) return 1;
		    
		    String jsonstr = rs.getString("jsonstr");
		    JSONObject obj = (JSONObject) (new JSONParser()).parse(jsonstr);
		    String pass = obj.get("password").toString();
		    if (!upass.equals(pass)) return 2;
		    return 0;
		    
		} finally {
			if (rs != null) rs.close();
		    if (stmt != null) stmt.close(); 
		    if (conn != null) conn.close();
		}
	}
	
	public String getList() throws NamingException, SQLException {
		Connection conn = ConnectionPool.get();
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT jsonstr FROM director";
			stmt = conn.prepareStatement(sql);
			rs = stmt.executeQuery();
			
			String str = "[";
			int cnt = 0;
			while(rs.next()) {
				if (cnt++ > 0) str += ", ";
				str += rs.getString("jsonstr");
			}
			return str + "]";
			
		} finally {
			if (rs != null) rs.close();
			if (stmt != null) stmt.close(); 
		    if (conn != null) conn.close();
		}
	}
	
	public String get(String uid) throws NamingException, SQLException {
		Connection conn = ConnectionPool.get();
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT jsonstr FROM director WHERE id = ?";
			stmt = conn.prepareStatement(sql);
			stmt.setString(1, uid);
			
			rs = stmt.executeQuery();
			return rs.next() ? rs.getString("jsonstr") : "{}";
		} finally {
			if (rs != null) rs.close();
			if (stmt != null) stmt.close();
			if (conn != null) conn.close();
		}
	}
	
	public boolean update(String uid, String jsonstr) throws NamingException, SQLException {
		Connection conn = ConnectionPool.get();
		PreparedStatement stmt = null;
		try {
		  
		  String sql = "UPDATE director SET jsonstr = ? WHERE id = ?";
		  stmt = conn.prepareStatement(sql);
		  stmt.setString(1, jsonstr.replace("\r\n", "<br>"));
		  stmt.setString(2, uid);
		  
		  int count = stmt.executeUpdate(); 

		  return (count ==1) ? true : false;
		  
		} finally {
			if (stmt != null) stmt.close(); 
		    if (conn != null) conn.close();
		}
	}
}