import mongoose from "mongoose";

const dreamTeamSchema = mongoose.Schema(
  {
    element: {
      type: Number,
      required: true,
      unique: true,
    },
    form: {
      type: Number,
      required: true,
    },
    totalPoints: {
      type: Number,
      required: true,
    },
    ict: {
      type: Number,
      required: false,
    },
    ownership: {
      type: Number,
      required: true,
    },
    name: {
      type: String,
      required: true,
    },
    teamID: {
      type: Number,
      required: true,
    },
  },
  {
    timestamps: true,
  }
);

const SuggestionsSchema = mongoose.Schema({
  element: {
    type: Number,
    required: true,
    unique: true,
  },
  name: {
    type: String,
    required: true,
  },
  ownership: {
    type: Number,
    required: true,
  },
  index: {
    type: Number,
    required: true,
  },
  position: {
    type: String,
    required: true,
  },
  teamID: {
    type: Number,
    required: true,
  },
  combined_index: {
    type: Number,
    required: true,
  },
});

const FixturesSchema = new mongoose.Schema({
  id: Number,
  code: Number,
  team_h: Number,
  team_h_score: Number,
  team_a: Number,
  team_a_score: Number,
  event: Number,
  finished: Boolean,
  minutes: Number,
  provisional_start_time: Boolean,
  kickoff_time: String,
  event_name: String,
  is_home: Boolean,
  difficulty: Number,
});

const PlayerHistorySchema = new mongoose.Schema({
  element: Number,
  fixture: Number,
  opponent_team: Number,
  total_points: Number,
  was_home: Boolean,
  kickoff_time: String,
  team_h_score: Number,
  team_a_score: Number,
  round: Number,
  minutes: Number,
  goals_scored: Number,
  assists: Number,
  clean_sheets: Number,
  goals_conceded: Number,
  own_goals: Number,
  penalties_saved: Number,
  penalties_missed: Number,
  yellow_cards: Number,
  red_cards: Number,
  saves: Number,
  bonus: Number,
  bps: Number,
  influence: String,
  creativity: String,
  threat: String,
  ict_index: String,
  starts: Number,
  expected_goals: String,
  expected_assists: String,
  expected_goal_involvements: String,
  expected_goals_conceded: String,
  value: Number,
  transfers_balance: Number,
  selected: Number,
  transfers_in: Number,
  transfers_out: Number,
});

const HistoryPastSchema = new mongoose.Schema({
  season_name: String,
  element_code: Number,
  start_cost: Number,
  end_cost: Number,
  total_points: Number,
  minutes: Number,
  goals_scored: Number,
  assists: Number,
  clean_sheets: Number,
  goals_conceded: Number,
  own_goals: Number,
  penalties_saved: Number,
  penalties_missed: Number,
  yellow_cards: Number,
  red_cards: Number,
  saves: Number,
  bonus: Number,
  bps: Number,
  influence: String,
  creativity: String,
  threat: String,
  ict_index: String,
  starts: Number,
  expected_goals: String,
  expected_assists: String,
  expected_goal_involvements: String,
  expected_goals_conceded: String,
});
const ElementSummarySchema = new mongoose.Schema({
  element_code: Number,
  fixtures: [FixturesSchema],
  history: [PlayerHistorySchema],
  history_past: [HistoryPastSchema],
});

const PlayerDataSchema = new mongoose.Schema(
  {
    chance_of_playing_next_round: { type: Number, required: false },
    chance_of_playing_this_round: { type: Number, required: false },
    code: { type: Number, required: false },
    cost_change_event: { type: Number, required: false },
    cost_change_event_fall: { type: Number, required: false },
    cost_change_start: { type: Number, required: false },
    cost_change_start_fall: { type: Number, required: false },
    dreamteam_count: { type: Number, required: false },
    element_type: { type: Number, required: false },
    ep_next: { type: String, required: false },
    ep_this: { type: String, required: false },
    event_points: { type: Number, required: false },
    first_name: { type: String, required: false },
    form: { type: String, required: false },
    id: { type: Number, required: true },
    in_dreamteam: { type: Boolean, required: false },
    news: { type: String, required: false },
    news_added: { type: String, required: false },
    now_cost: { type: Number, required: false },
    photo: { type: String, required: false },
    points_per_game: { type: String, required: false },
    second_name: { type: String, required: false },
    selected_by_percent: { type: String, required: false },
    special: { type: Boolean, required: false },
    squad_number: { type: Number, required: false },
    status: { type: String, required: false },
    team: { type: Number, required: false },
    team_code: { type: Number, required: false },
    total_points: { type: Number, required: false },
    transfers_in: { type: Number, required: false },
    transfers_in_event: { type: Number, required: false },
    transfers_out: { type: Number, required: false },
    transfers_out_event: { type: Number, required: false },
    value_form: { type: String, required: false },
    value_season: { type: String, required: false },
    web_name: { type: String, required: false },
    minutes: { type: Number, required: false },
    goals_scored: { type: Number, required: false },
    assists: { type: Number, required: false },
    clean_sheets: { type: Number, required: false },
    goals_conceded: { type: Number, required: false },
    own_goals: { type: Number, required: false },
    penalties_saved: { type: Number, required: false },
    penalties_missed: { type: Number, required: false },
    yellow_cards: { type: Number, required: false },
    red_cards: { type: Number, required: false },
    saves: { type: Number, required: false },
    bonus: { type: Number, required: false },
    bps: { type: Number, required: false },
    influence: { type: String, required: false },
    creativity: { type: String, required: false },
    threat: { type: String, required: false },
    ict_index: { type: String, required: false },
    starts: { type: Number, required: false },
    expected_goals: { type: String, required: false },
    expected_assists: { type: String, required: false },
    expected_goal_involvements: { type: String, required: false },
    expected_goals_conceded: { type: String, required: false },
    influence_rank: { type: Number, required: false },
    influence_rank_type: { type: Number, required: false },
    creativity_rank: { type: Number, required: false },
    creativity_rank_type: { type: Number, required: false },
    threat_rank: { type: Number, required: false },
    threat_rank_type: { type: Number, required: false },
    ict_index_rank: { type: Number, required: false },
    ict_index_rank_type: { type: Number, required: false },
    corners_and_indirect_freekicks_order: { type: Number, required: false },
    corners_and_indirect_freekicks_text: { type: String, required: false },
    direct_freekicks_order: { type: Number, required: false },
    direct_freekicks_text: { type: String, required: false },
    penalties_order: { type: Number, required: false },
    penalties_text: { type: String, required: false },
    expected_goals_per_90: { type: Number, required: false },
    saves_per_90: { type: Number, required: false },
    expected_assists_per_90: { type: Number, required: false },
    expected_goal_involvements_per_90: { type: Number, required: false },
    expected_goals_conceded_per_90: { type: Number, required: false },
    goals_conceded_per_90: { type: Number, required: false },
    now_cost_rank: { type: Number, required: false },
    now_cost_rank_type: { type: Number, required: false },
    form_rank: { type: Number, required: false },
    form_rank_type: { type: Number, required: false },
    points_per_game_rank: { type: Number, required: false },
    points_per_game_rank_type: { type: Number, required: false },
    selected_rank: { type: Number, required: false },
    selected_rank_type: { type: Number, required: false },
    starts_per_90: { type: Number, required: false },
    clean_sheets_per_90: { type: Number, required: false },
    combined_index: { type: Number, required: false },
    fixtures: [FixturesSchema],
    history: [PlayerHistorySchema],
    history_past: [HistoryPastSchema],
  },
  { timestamps: true }
);

const DreamTeam = mongoose.model("DreamTeam", dreamTeamSchema);
const Suggestions = mongoose.model("Suggestions", SuggestionsSchema);
const PlayerData = mongoose.model("PlayerData", PlayerDataSchema);
const ElementSummary = mongoose.model("Element Summary", ElementSummarySchema);

export default DreamTeam;
export { Suggestions, PlayerData, ElementSummary };
