"use client"
import React, { useState } from 'react';
import Sheet from '@mui/joy/Sheet';
const { Configuration, OpenAIApi } = require("openai");

import InputBox from '@/components/InputBox';
import ThoughtCard from '@/components/ThoughtCard';
import LyricsCard from '@/components/LyricsCard';
import Chip from '@/components/chip';
import PromptCard from '@/components/PromptCard';
import Link from '@/components/Link';
import Audio from '@/components/Audio';
import Deco from '@/components/Deco'
import { Box } from '@mui/joy';

const configuration = new Configuration({
  apiKey: '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',
});
const openai = new OpenAIApi(configuration);


export default function Home() {
  const [prompt, setInputValue] = useState('');
  const [thought, setThought] = useState('');
  const [middle, setMiddle] = useState('');
  const [lyrics, setLyrics] = useState('');
  const [showInputBox, setShowInputBox] = useState(true);

  const handleGenerate = async () => {
    setShowInputBox(false);
    const responseThought = await openai.createChatCompletion({
      model: "gpt-4",
      messages: [
        {
          "role": "system",
          "content": "Given the thematic and stylistic nuances present in prompt \"{}\", devise a multi-node state machine using functions tuned for lyrical creativity that will iteratively build a coherent, catchy, thematically relevant, and engaging song. \n\nIncorporate the following functions: \n* explorative: `generate_lyrical_variations` to create initial lyrics based on the theme, `extend_lyrical_idea` to expand an initial idea into a full stanza, `use_rhyme` to incorporate specific rhyming schemes or structures such as ABAB, ABCABC, AABB, `transform_melodic_rules` to vary the rhyming and melodic pattern of the stanza)\n* combinatory: `combine_lyrical_ideas` to combine ideas from multiple themes into a single stanza, `cultural_blend` to join influences from multiple cultural backgrounds, `serendipitous_lyrical_interaction` to add creative wordplay, `remix_lyrics` to generate variations of a stanza that maintain the original theme) \n* context-awareness: (`adopt_musical_persona` to adopt a specific genre, style, or persona of music, `inject_lyrical_context` for referencing particular stories or memories or to maintain a particular theme across multiple stanzas, `extract_emotion_from_theme` to determine what emotions the song needs to express in order to satisfy the constraints of the theme, and `incorporate_cultural_references` to add references to cultural artifacts that will resonate with the user's emotions.\n\nShape the state machine such that the initial two nodes develop context necessary to build the core of the song with relevant thematic and stylistic information. then, add two branches with two nodes each that incorporate emotional depth, metaphoric creativity, and cultural references. then, add a node that combines the previous two branches, then have the final three nodes concentrate on refining, intertwining, and perfecting to form a coherent, catchy song. The final node should be an output node that generates the final song with several stanzas of varying length. Each decision node should be guided by the song's theme and tone, aiming for coherence and catchy bars. The final song should have the following structure: intro, verse 1, hook, chorus, verse 2, chorus, verse 3, outro. Output the state machine in YAML format for subsequent evaluation by an emulator that can execute the state machine to produce the concrete output. The document should be formatted as an ordered list of nodes, where some nodes may have children. Use the following format for each node.\n\nnode:\n  call_function: {function},\n  additional_context:  {context},\n  function_call_output: {output},\n  sample_verses: {verses},\n  child_nodes: [{child_nodes}]\n\nThe final output nodes should encode information about how many lines each stanza should have. Vary the number of lines in each verse: don't just use 4-line bars. Some verses should be longer, up to 8 thematically-consistent lines, while hooks and choruses should be shorter and catchy, something that people can sing along to easily.\n\nThe definition of these functions:\n```\n1. Function: `adopt_musical_persona(state, style)`\n   Input: The current song state, a musical style or persona.\n   Output: Altered behavior and language of the AI, reflecting the adopted musical style in the context of the song state.\n   System Prompt: `'Adopt the musical style of \"{style}\". Assume this style's melodic tendencies, rhythmic patterns, and typical lyric themes when engaging with users.'`\n   Instruction: Use this function when you aim to mimic a specific musical style effectively, be it rock, pop, blues, country, a particular artist, or any other. This function should not result in the name of the persona itself being written to the song state, it should only take inspiration from what the persona represents. If the persona is an artist, make sure to strictly adhere to that artist's unique style and refer to their discography for inspiration on how to generate a song matching their style.\n\n2. Function: `inject_lyrical_context(state, prompt, context)`\n   Input: The current song state, A songwriting prompt and related contextual knowledge.\n   Output: A context-compatible lyrical line or verse given the current song state\n   System Prompt: `'Based on the given prompt \"{prompt}\" and the context provided \"{context}\", generate a lyric line or verse that takes the context into consideration.'`\n   Instruction: Use this function when you need to personalize your lyrics based on a specific story, memory, or sentiment.\n\n3. Function: `extract_emotion_from_theme(theme)`\n   Input: A song theme.\n   Output: Recognition of emotions associated with the theme.\n   System Prompt: `'Identify and list the emotions typically conveyed by the theme: \"{theme}\".'`\n   Instruction: When you must recognize the emotions inherent in a song's theme, use this function to create lyrics that resonate emotionally with listeners.\n\n4. Function: `use_rhyme(state, pattern, stanza)`\n   Input: The current song state, A rhyming structure or pattern and a song stanza.\n   Output: A lyrical verse following the given rhyming pattern or structure.\n   System Prompt: `'Adapt the following stanza: \"{stanza}\" to use the rhyming pattern \"{pattern}\"'`\n   Instruction: This function is vital for creating catchy, rhythmically pleasing lyrics that listeners will remember and sing along to.\n\n5. Function: `incorporate_cultural_references(state, reference, theme)`\n   Input: The current song state, A cultural reference and a song theme.\n   Output: A lyric line or verse integrating the cultural reference and theme.\n   System Prompt: `'Given the cultural reference \"{reference}\", generate a lyric line or verse for the theme \"{theme}\" that includes this reference.'`\n   Instruction: Use this function to connect your lyrics to shared cultural experiences, enhancing their relatability and depth.\n\n6. Function: `serendipitous_lyrical_interaction(state, line1, line2)`\n   Input: The current song state, Two unrelated lyrical bars.\n   Output: A creative lyrical connection between the two bars or stanzas.\n   System Prompt: `'Combine these seemingly unrelated lyrical lines in a creative, surprising, or impactful way: \"{line1}\" and \"{line2}\".'`\n   Instruction: Use this function to create creative, unexpected lyrical connections, adding depth and intrigue to your songs.\n\n7. Function: `cultural_blend(state, culture1, culture2)`\n   Input: The current song state, the first culture to blend, the second culture to blend\n   Output: A lyric line or verse that blends elements of the two cultures within the theme.\n   System Prompt: `'Generate a lyric line or verse for the song state that blends elements from \"{culture1}\" and \"{culture2}\" cultures.'`\n   Instruction: This function enriches your lyrics by blending diverse cultural perspectives, making your songs resonate with a wider audience.\n\n8. Function: `remix_lyrics(state, lyric_pool)`\n   Input: The current song state, A pool of previously written lyrics.\n   Output: A new lyric line or verse formed by recombining different lyrics within the pool.\n   System Prompt: `'Remix and combine the following lyrics into a new, innovative line or verse within the context of the song state: {selected_lyrics}'`.\n   Instruction: This function recombines existing lyrics to create fresh and interesting lines, useful when you need to rekindle creativity or find a new angle on a theme. The remixed lyrics should continue adhere to the style of the adopted persona and not deviate too strongly from it.\n\n10. Function: `generate_lyrical_variations(state, bars)`\n   Input: The current song state, A specific lyric line or bar.\n   Output: Various alternative bars based on the original bar.\n   System Prompt: `'Generate creative lyrical variations for the stanza \"{bars}\" that maintain the same theme in the current song state'`.\n   Instruction: This function helps you explore different lyrical possibilities for a given line, perfect for finding the perfect wording or phrasing. The variations should adhere to the style of the persona previously adopted.\n\n11. Function: `extend_lyrical_idea(state, verse, idea)`\n   Input: The current song state, A lyrical verse and a specific idea to expand upon.\n   Output: An expansion of the verse that fits the idea\n   System Prompt: `'Expand upon the lyrical idea  in\"{verse}\" within the theme of \"{idea}\".'`\n   Instruction: Use this function to expand upon a lyrical idea, adding more details or context to enhance its impact or relevance or add upon or finish the story started in the original verse. Make sure to maintain the style of the persona adopted. It's not necessary that the expanded verse be more lyrically complex, it's more important to maintain the coherence and consistency of the verse.\n\n12. Function: `combine_lyrical_ideas(state, line1, line2)`\n   Input: The current song state, Two distinct lyrical verses to be combined.\n   Output: A new lyrical verse that merges elements of the input lines.\n   System Prompt: `'Combine these two verses to create a new lyrical idea: \"{line1}\" and \"{line2}\".'`\n   Instruction: This function fuses separate lyrical ideas into a fresh line, useful for creating innovative lyrics or thematic bridges within the context of the current song. The combined ideas should still closely match the adopted persona and not deviate from the original themes in the state.\n\n13. Function: transform_melodic_rules(state, rules, verse)\nInput: The current song state, A set of melodic rules and a song verse.\nOutput: A transformed melody that respects the given rules but still reflects the original verse theme.\nSystem Prompt: 'Given the melodic rules \"{rules}\", generate a transformed melody that captures the essence of the themes in \"{verse}\" within the current song state.'\nInstruction: Use this function when you want to adhere to certain melodic principles but also infuse the melody with the emotion or atmosphere of the existing theme. This function helps ensure your new melody matches your existing lyrical content, leading to a more cohesive and impactful song.\n```"
        },
        {
          "role": "user",
          "content": prompt
        }
      ],
      temperature: 1.2,
      max_tokens: 3500,
      top_p: 1,
      frequency_penalty: 0,
      presence_penalty: 0
    });
    console.log(responseThought.data.choices[0].message.content);
    setThought(responseThought.data.choices[0].message.content);

    const responseMiddle = await openai.createChatCompletion({
      model: "gpt-4",
      messages: [
        {
          "role": "system",
          "content": "Given the thematic and stylistic nuances present in prompt \"{}\", devise a multi-node state machine using functions tuned for lyrical creativity that will iteratively build a coherent, catchy, thematically relevant, and engaging song. \n\nIncorporate the following functions: \n* explorative: `generate_lyrical_variations` to create initial lyrics based on the theme, `extend_lyrical_idea` to expand an initial idea into a full stanza, `use_rhyme` to incorporate specific rhyming schemes or structures such as ABAB, ABCABC, AABB, `transform_melodic_rules` to vary the rhyming and melodic pattern of the stanza)\n* combinatory: `combine_lyrical_ideas` to combine ideas from multiple themes into a single stanza, `cultural_blend` to join influences from multiple cultural backgrounds, `serendipitous_lyrical_interaction` to add creative wordplay, `remix_lyrics` to generate variations of a stanza that maintain the original theme) \n* context-awareness: (`adopt_musical_persona` to adopt a specific genre, style, or persona of music, `inject_lyrical_context` for referencing particular stories or memories or to maintain a particular theme across multiple stanzas, `extract_emotion_from_theme` to determine what emotions the song needs to express in order to satisfy the constraints of the theme, and `incorporate_cultural_references` to add references to cultural artifacts that will resonate with the user's emotions.\n\nShape the state machine such that the initial two nodes develop context necessary to build the core of the song with relevant thematic and stylistic information. then, add two branches with two nodes each that incorporate emotional depth, metaphoric creativity, and cultural references. then, add a node that combines the previous two branches, then have the final three nodes concentrate on refining, intertwining, and perfecting to form a coherent, catchy song. The final node should be an output node that generates the final song with several stanzas of varying length. Each decision node should be guided by the song's theme and tone, aiming for coherence and catchy bars. The final song should have the following structure: intro, verse 1, hook, chorus, verse 2, chorus, verse 3, outro. Output the state machine in YAML format for subsequent evaluation by an emulator that can execute the state machine to produce the concrete output. The document should be formatted as an ordered list of nodes, where some nodes may have children. Use the following format for each node.\n\nnode:\n  call_function: {function},\n  additional_context:  {context},\n  function_call_output: {output},\n  sample_verses: {verses},\n  child_nodes: [{child_nodes}]\n\nThe final output nodes should encode information about how many lines each stanza should have. Vary the number of lines in each verse: don't just use 4-line bars. Some verses should be longer, up to 8 thematically-consistent lines, while hooks and choruses should be shorter and catchy, something that people can sing along to easily.\n\nThe definition of these functions:\n```\n1. Function: `adopt_musical_persona(state, style)`\n   Input: The current song state, a musical style or persona.\n   Output: Altered behavior and language of the AI, reflecting the adopted musical style in the context of the song state.\n   System Prompt: `'Adopt the musical style of \"{style}\". Assume this style's melodic tendencies, rhythmic patterns, and typical lyric themes when engaging with users.'`\n   Instruction: Use this function when you aim to mimic a specific musical style effectively, be it rock, pop, blues, country, a particular artist, or any other. This function should not result in the name of the persona itself being written to the song state, it should only take inspiration from what the persona represents. If the persona is an artist, make sure to strictly adhere to that artist's unique style and refer to their discography for inspiration on how to generate a song matching their style.\n\n2. Function: `inject_lyrical_context(state, prompt, context)`\n   Input: The current song state, A songwriting prompt and related contextual knowledge.\n   Output: A context-compatible lyrical line or verse given the current song state\n   System Prompt: `'Based on the given prompt \"{prompt}\" and the context provided \"{context}\", generate a lyric line or verse that takes the context into consideration.'`\n   Instruction: Use this function when you need to personalize your lyrics based on a specific story, memory, or sentiment.\n\n3. Function: `extract_emotion_from_theme(theme)`\n   Input: A song theme.\n   Output: Recognition of emotions associated with the theme.\n   System Prompt: `'Identify and list the emotions typically conveyed by the theme: \"{theme}\".'`\n   Instruction: When you must recognize the emotions inherent in a song's theme, use this function to create lyrics that resonate emotionally with listeners.\n\n4. Function: `use_rhyme(state, pattern, stanza)`\n   Input: The current song state, A rhyming structure or pattern and a song stanza.\n   Output: A lyrical verse following the given rhyming pattern or structure.\n   System Prompt: `'Adapt the following stanza: \"{stanza}\" to use the rhyming pattern \"{pattern}\"'`\n   Instruction: This function is vital for creating catchy, rhythmically pleasing lyrics that listeners will remember and sing along to.\n\n5. Function: `incorporate_cultural_references(state, reference, theme)`\n   Input: The current song state, A cultural reference and a song theme.\n   Output: A lyric line or verse integrating the cultural reference and theme.\n   System Prompt: `'Given the cultural reference \"{reference}\", generate a lyric line or verse for the theme \"{theme}\" that includes this reference.'`\n   Instruction: Use this function to connect your lyrics to shared cultural experiences, enhancing their relatability and depth.\n\n6. Function: `serendipitous_lyrical_interaction(state, line1, line2)`\n   Input: The current song state, Two unrelated lyrical bars.\n   Output: A creative lyrical connection between the two bars or stanzas.\n   System Prompt: `'Combine these seemingly unrelated lyrical lines in a creative, surprising, or impactful way: \"{line1}\" and \"{line2}\".'`\n   Instruction: Use this function to create creative, unexpected lyrical connections, adding depth and intrigue to your songs.\n\n7. Function: `cultural_blend(state, culture1, culture2)`\n   Input: The current song state, the first culture to blend, the second culture to blend\n   Output: A lyric line or verse that blends elements of the two cultures within the theme.\n   System Prompt: `'Generate a lyric line or verse for the song state that blends elements from \"{culture1}\" and \"{culture2}\" cultures.'`\n   Instruction: This function enriches your lyrics by blending diverse cultural perspectives, making your songs resonate with a wider audience.\n\n8. Function: `remix_lyrics(state, lyric_pool)`\n   Input: The current song state, A pool of previously written lyrics.\n   Output: A new lyric line or verse formed by recombining different lyrics within the pool.\n   System Prompt: `'Remix and combine the following lyrics into a new, innovative line or verse within the context of the song state: {selected_lyrics}'`.\n   Instruction: This function recombines existing lyrics to create fresh and interesting lines, useful when you need to rekindle creativity or find a new angle on a theme. The remixed lyrics should continue adhere to the style of the adopted persona and not deviate too strongly from it.\n\n10. Function: `generate_lyrical_variations(state, bars)`\n   Input: The current song state, A specific lyric line or bar.\n   Output: Various alternative bars based on the original bar.\n   System Prompt: `'Generate creative lyrical variations for the stanza \"{bars}\" that maintain the same theme in the current song state'`.\n   Instruction: This function helps you explore different lyrical possibilities for a given line, perfect for finding the perfect wording or phrasing. The variations should adhere to the style of the persona previously adopted.\n\n11. Function: `extend_lyrical_idea(state, verse, idea)`\n   Input: The current song state, A lyrical verse and a specific idea to expand upon.\n   Output: An expansion of the verse that fits the idea\n   System Prompt: `'Expand upon the lyrical idea  in\"{verse}\" within the theme of \"{idea}\".'`\n   Instruction: Use this function to expand upon a lyrical idea, adding more details or context to enhance its impact or relevance or add upon or finish the story started in the original verse. Make sure to maintain the style of the persona adopted. It's not necessary that the expanded verse be more lyrically complex, it's more important to maintain the coherence and consistency of the verse.\n\n12. Function: `combine_lyrical_ideas(state, line1, line2)`\n   Input: The current song state, Two distinct lyrical verses to be combined.\n   Output: A new lyrical verse that merges elements of the input lines.\n   System Prompt: `'Combine these two verses to create a new lyrical idea: \"{line1}\" and \"{line2}\".'`\n   Instruction: This function fuses separate lyrical ideas into a fresh line, useful for creating innovative lyrics or thematic bridges within the context of the current song. The combined ideas should still closely match the adopted persona and not deviate from the original themes in the state.\n\n13. Function: transform_melodic_rules(state, rules, verse)\nInput: The current song state, A set of melodic rules and a song verse.\nOutput: A transformed melody that respects the given rules but still reflects the original verse theme.\nSystem Prompt: 'Given the melodic rules \"{rules}\", generate a transformed melody that captures the essence of the themes in \"{verse}\" within the current song state.'\nInstruction: Use this function when you want to adhere to certain melodic principles but also infuse the melody with the emotion or atmosphere of the existing theme. This function helps ensure your new melody matches your existing lyrical content, leading to a more cohesive and impactful song.\n```"
        },
        {
          "role": "user",
          "content": prompt
        },
        {
          "role": "assistant",
          "content": thought
        },
        {
          "role": "user",
          "content": "you are a creative writing runtime environment. simulate the execution of this state machine following its logical structure and produce a complete song as final output."
        },
      ],
      temperature: 1.2,
      max_tokens: 3500,
      top_p: 1,
      frequency_penalty: 0,
      presence_penalty: 0
    });
    console.log(responseMiddle.data.choices[0].message.content);
    setMiddle(responseMiddle.data.choices[0].message.content);

    const responseLyrics = await openai.createChatCompletion({
      model: "gpt-4",
      messages: [
        {
          "role": "system",
          "content": "Given the thematic and stylistic nuances present in prompt \"{}\", devise a multi-node state machine using functions tuned for lyrical creativity that will iteratively build a coherent, catchy, thematically relevant, and engaging song. \n\nIncorporate the following functions: \n* explorative: `generate_lyrical_variations` to create initial lyrics based on the theme, `extend_lyrical_idea` to expand an initial idea into a full stanza, `use_rhyme` to incorporate specific rhyming schemes or structures such as ABAB, ABCABC, AABB, `transform_melodic_rules` to vary the rhyming and melodic pattern of the stanza)\n* combinatory: `combine_lyrical_ideas` to combine ideas from multiple themes into a single stanza, `cultural_blend` to join influences from multiple cultural backgrounds, `serendipitous_lyrical_interaction` to add creative wordplay, `remix_lyrics` to generate variations of a stanza that maintain the original theme) \n* context-awareness: (`adopt_musical_persona` to adopt a specific genre, style, or persona of music, `inject_lyrical_context` for referencing particular stories or memories or to maintain a particular theme across multiple stanzas, `extract_emotion_from_theme` to determine what emotions the song needs to express in order to satisfy the constraints of the theme, and `incorporate_cultural_references` to add references to cultural artifacts that will resonate with the user's emotions.\n\nShape the state machine such that the initial two nodes develop context necessary to build the core of the song with relevant thematic and stylistic information. then, add two branches with two nodes each that incorporate emotional depth, metaphoric creativity, and cultural references. then, add a node that combines the previous two branches, then have the final three nodes concentrate on refining, intertwining, and perfecting to form a coherent, catchy song. The final node should be an output node that generates the final song with several stanzas of varying length. Each decision node should be guided by the song's theme and tone, aiming for coherence and catchy bars. The final song should have the following structure: intro, verse 1, hook, chorus, verse 2, chorus, verse 3, outro. Output the state machine in YAML format for subsequent evaluation by an emulator that can execute the state machine to produce the concrete output. The document should be formatted as an ordered list of nodes, where some nodes may have children. Use the following format for each node.\n\nnode:\n  call_function: {function},\n  additional_context:  {context},\n  function_call_output: {output},\n  sample_verses: {verses},\n  child_nodes: [{child_nodes}]\n\nThe final output nodes should encode information about how many lines each stanza should have. Vary the number of lines in each verse: don't just use 4-line bars. Some verses should be longer, up to 8 thematically-consistent lines, while hooks and choruses should be shorter and catchy, something that people can sing along to easily.\n\nThe definition of these functions:\n```\n1. Function: `adopt_musical_persona(state, style)`\n   Input: The current song state, a musical style or persona.\n   Output: Altered behavior and language of the AI, reflecting the adopted musical style in the context of the song state.\n   System Prompt: `'Adopt the musical style of \"{style}\". Assume this style's melodic tendencies, rhythmic patterns, and typical lyric themes when engaging with users.'`\n   Instruction: Use this function when you aim to mimic a specific musical style effectively, be it rock, pop, blues, country, a particular artist, or any other. This function should not result in the name of the persona itself being written to the song state, it should only take inspiration from what the persona represents. If the persona is an artist, make sure to strictly adhere to that artist's unique style and refer to their discography for inspiration on how to generate a song matching their style.\n\n2. Function: `inject_lyrical_context(state, prompt, context)`\n   Input: The current song state, A songwriting prompt and related contextual knowledge.\n   Output: A context-compatible lyrical line or verse given the current song state\n   System Prompt: `'Based on the given prompt \"{prompt}\" and the context provided \"{context}\", generate a lyric line or verse that takes the context into consideration.'`\n   Instruction: Use this function when you need to personalize your lyrics based on a specific story, memory, or sentiment.\n\n3. Function: `extract_emotion_from_theme(theme)`\n   Input: A song theme.\n   Output: Recognition of emotions associated with the theme.\n   System Prompt: `'Identify and list the emotions typically conveyed by the theme: \"{theme}\".'`\n   Instruction: When you must recognize the emotions inherent in a song's theme, use this function to create lyrics that resonate emotionally with listeners.\n\n4. Function: `use_rhyme(state, pattern, stanza)`\n   Input: The current song state, A rhyming structure or pattern and a song stanza.\n   Output: A lyrical verse following the given rhyming pattern or structure.\n   System Prompt: `'Adapt the following stanza: \"{stanza}\" to use the rhyming pattern \"{pattern}\"'`\n   Instruction: This function is vital for creating catchy, rhythmically pleasing lyrics that listeners will remember and sing along to.\n\n5. Function: `incorporate_cultural_references(state, reference, theme)`\n   Input: The current song state, A cultural reference and a song theme.\n   Output: A lyric line or verse integrating the cultural reference and theme.\n   System Prompt: `'Given the cultural reference \"{reference}\", generate a lyric line or verse for the theme \"{theme}\" that includes this reference.'`\n   Instruction: Use this function to connect your lyrics to shared cultural experiences, enhancing their relatability and depth.\n\n6. Function: `serendipitous_lyrical_interaction(state, line1, line2)`\n   Input: The current song state, Two unrelated lyrical bars.\n   Output: A creative lyrical connection between the two bars or stanzas.\n   System Prompt: `'Combine these seemingly unrelated lyrical lines in a creative, surprising, or impactful way: \"{line1}\" and \"{line2}\".'`\n   Instruction: Use this function to create creative, unexpected lyrical connections, adding depth and intrigue to your songs.\n\n7. Function: `cultural_blend(state, culture1, culture2)`\n   Input: The current song state, the first culture to blend, the second culture to blend\n   Output: A lyric line or verse that blends elements of the two cultures within the theme.\n   System Prompt: `'Generate a lyric line or verse for the song state that blends elements from \"{culture1}\" and \"{culture2}\" cultures.'`\n   Instruction: This function enriches your lyrics by blending diverse cultural perspectives, making your songs resonate with a wider audience.\n\n8. Function: `remix_lyrics(state, lyric_pool)`\n   Input: The current song state, A pool of previously written lyrics.\n   Output: A new lyric line or verse formed by recombining different lyrics within the pool.\n   System Prompt: `'Remix and combine the following lyrics into a new, innovative line or verse within the context of the song state: {selected_lyrics}'`.\n   Instruction: This function recombines existing lyrics to create fresh and interesting lines, useful when you need to rekindle creativity or find a new angle on a theme. The remixed lyrics should continue adhere to the style of the adopted persona and not deviate too strongly from it.\n\n10. Function: `generate_lyrical_variations(state, bars)`\n   Input: The current song state, A specific lyric line or bar.\n   Output: Various alternative bars based on the original bar.\n   System Prompt: `'Generate creative lyrical variations for the stanza \"{bars}\" that maintain the same theme in the current song state'`.\n   Instruction: This function helps you explore different lyrical possibilities for a given line, perfect for finding the perfect wording or phrasing. The variations should adhere to the style of the persona previously adopted.\n\n11. Function: `extend_lyrical_idea(state, verse, idea)`\n   Input: The current song state, A lyrical verse and a specific idea to expand upon.\n   Output: An expansion of the verse that fits the idea\n   System Prompt: `'Expand upon the lyrical idea  in\"{verse}\" within the theme of \"{idea}\".'`\n   Instruction: Use this function to expand upon a lyrical idea, adding more details or context to enhance its impact or relevance or add upon or finish the story started in the original verse. Make sure to maintain the style of the persona adopted. It's not necessary that the expanded verse be more lyrically complex, it's more important to maintain the coherence and consistency of the verse.\n\n12. Function: `combine_lyrical_ideas(state, line1, line2)`\n   Input: The current song state, Two distinct lyrical verses to be combined.\n   Output: A new lyrical verse that merges elements of the input lines.\n   System Prompt: `'Combine these two verses to create a new lyrical idea: \"{line1}\" and \"{line2}\".'`\n   Instruction: This function fuses separate lyrical ideas into a fresh line, useful for creating innovative lyrics or thematic bridges within the context of the current song. The combined ideas should still closely match the adopted persona and not deviate from the original themes in the state.\n\n13. Function: transform_melodic_rules(state, rules, verse)\nInput: The current song state, A set of melodic rules and a song verse.\nOutput: A transformed melody that respects the given rules but still reflects the original verse theme.\nSystem Prompt: 'Given the melodic rules \"{rules}\", generate a transformed melody that captures the essence of the themes in \"{verse}\" within the current song state.'\nInstruction: Use this function when you want to adhere to certain melodic principles but also infuse the melody with the emotion or atmosphere of the existing theme. This function helps ensure your new melody matches your existing lyrical content, leading to a more cohesive and impactful song.\n```"
        },
        {
          "role": "user",
          "content": prompt
        },
        {
          "role": "assistant",
          "content": thought
        },
        {
          "role": "user",
          "content": "you are a creative writing runtime environment. simulate the execution of this state machine following its logical structure and produce a complete song as final output."
        },
        {
          "role": "assistant",
          "content": middle
        },
        {
          "role": "user",
          "content": "Using your previous response, print only the song lyrics you generated."
        }
      ],
      temperature: 1.0,
      max_tokens: 3500,
      top_p: 1,
      frequency_penalty: 0,
      presence_penalty: 0
    });
    console.log(responseLyrics.data.choices[0].message.content);
    setLyrics(responseLyrics.data.choices[0].message.content);
  };

  return (
    <Sheet
      sx={{
        display: 'flex',
        flexFlow: 'column nowrap',
        justifyContent: 'center',
        alignItems: 'center',
        minHeight: '100vh',
      }}
    >
      <Chip/>
      {showInputBox && <InputBox onGenerate={handleGenerate} onChange={setInputValue} />}
      {!showInputBox && <PromptCard prompt={prompt}/>}
      {!showInputBox && <ThoughtCard thought={thought} />}
      {thought && <LyricsCard lyrics={lyrics}/>}

      <Audio/>
      <Link/>
      

    <Box display="flex" justifyContent="center" width="100%" margin={-2}>
      <Deco lyrics='"For I am the queenbee always, Brutally, Softly Vogue bout Hip HOP! in my gauge"'/>
      <Deco lyrics='"Yo, this ain’t a comedy, aint no Shakespeare delight, This the harsh life, it aint black n white"'/>
      <Deco lyrics='"Yeah, E40 in the streets, hyping SF pride, keeping alive the beat, City by the bay with its own suite"'/>
      <Deco lyrics='"LLL, echoing heartbeat, laying stethoscope track, A thousand dollar speeches selling across the rack"'/>
    </Box>
      


      

    </Sheet>
  );
}