<?php

/*
 * This file is a part of the DiscordPHP project.
 *
 * Copyright (c) 2015-present David Cole <david.cole1340@gmail.com>
 *
 * This file is subject to the MIT license that is bundled
 * with this source code in the LICENSE.md file.
 */

namespace Discord\WebSockets\Events;

use Discord\Parts\User\Member;
use Discord\WebSockets\Event;
use Discord\Parts\Guild\Guild;

/**
 * @link https://discord.com/developers/docs/topics/gateway-events#guild-member-add
 *
 * @since 2.1.3
 */
class GuildMemberAdd extends Event
{
    /**
     * {@inheritDoc}
     */
    public function handle($data)
    {
        /** @var Member */
        $memberPart = $this->factory->part(Member::class, (array) $data, true);

        /** @var ?Guild */
        if ($guild = yield $this->discord->guilds->cacheGet($data->guild_id)) {
            $guild->members->set($data->user->id, $memberPart);
            ++$guild->member_count;
        }

        $this->cacheUser($data->user);

        return $memberPart;
    }
}
