import { youtubeRegex } from './getMessageWithMediaPlayer';

// eslint-disable-next-line no-useless-escape
const LINK_DETECTION_REGEX = /(([a-z]+:\/\/)?(([a-z0-9\-]+\.)+([a-z]{2}|aero|arpa|biz|com|coop|edu|gov|info|int|jobs|mil|museum|name|nato|net|org|pro|travel|local|internal))(:[0-9]{1,5})?(\/[a-z0-9_\-\.~]+)*(\/([a-z0-9_\-\.]*)(\?[a-z0-9+_\-\.%=&amp;]*)?)?(#[a-zA-Z0-9!$&'()*+.=-_~:@/?]*)?)(\s+|$)/gi;

export default (text: string) =>
  text.replace(LINK_DETECTION_REGEX, url =>
    url.match(youtubeRegex)
      ? url
      : `<a target="_blank" rel="noopener noreferrer" href="${url}">${url}</a>`
  );
