import React from 'react';
import { withTheme } from 'styled-components';
import { Theme } from 'libs/facets/theme';

interface Props {
  filled?: boolean;
  theme: Theme;
}

const Information = ({ filled, theme }: Props) => {
  const fill = filled ? theme.secondaryColor : '#fff';

  return (
    <svg width="11.453" height="24.922" viewBox=" 0 0 11.453 24.922">
      <path
        fill={fill}
        d="M11.11 22.124c-1.187 2.419-4.362 2.8-5.218 2.8a4.5 4.5 0 0 1-3.068-.962 3.118 3.118 0 0
      1-1.095-2.445 8.6 8.6 0 0 1 .082-1.178q.084-.6.265-1.358l1.358-4.806q.182-.689.306-1.308a5.741 5.741
      0 0 0 .124-1.126 1.717 1.717 0 0 0-.38-1.285c-1.016-.933-3.217.017-3.483.116 1.231-2.8 4.5-2.8
      5.225-2.8a4.394 4.394 0 0 1 3.022.947A3.144 3.144 0 0 1 9.31 11.18a9.865 9.865 0 0 1-.345 2.552l-1.352
      4.787a12.764 12.764 0 0 0-.3 1.319 6.749 6.749 0 0 0-.132 1.119 1.923 1.923 0 0 0 .425 1.3c.947 1.164
      3.315-.042 3.5-.131zm.343-19.1a2.8 2.8 0 0 1-.946 2.132 3.219 3.219 0 0 1-2.277.881 3.256 3.256 0 0
      1-2.289-.881 2.8 2.8 0 0 1-.955-2.132A2.823 2.823 0 0 1 5.941.885a3.378 3.378 0 0 1 4.566 0 2.827 2.827 0 0 1 .946 2.139zm0 0"
      />
    </svg>
  );
};

export default withTheme(Information);
