# Windows Forms App
## Overview
This project is a full-stack Windows Forms application that consists of a frontend built with VB.NET and a backend built with Node.js and Express. The application allows users to create, view, edit, and delete submissions, with additional features such as a stopwatch and email search functionality. It was written as part of Slidely's assessment task 2.

| Form  |  How it looks |
|---|---|
| **Landing** |  ![Form1](/assets/landing.png) |
|  **Create Submission**| ![CreateSub](/assets/createsub.png)  |
| **View Submissions** and Delete, Edit, and Export to CSV | ![ViewSubs](/assets/viewsubs.png)  |

## Features

- **Create Submission:** Users can create new submissions with fields for name, email, phone number, GitHub link, and stopwatch time.
- **View Submissions:** Users can view existing submissions, navigate through them, and see the details of each submission.
- **Edit Submission:** Users can edit existing submissions and save their changes.
- **Delete Submission:** Users can delete submissions.
- **Email Search:** Users can search for submissions by email.
- **Stopwatch:** Users can start, stop, and reset a stopwatch timer while filling out the submission form.
- **Validation Checks:** Validation for name (no numbers or special characters), email (valid email format), and phone number (10 numeric digits, but can be empty).
- **Duplicate Entry Prevention:** Ensures that duplicate submissions cannot be made based on email.
- **Export to CSV:** Users can export all submissions to a CSV file.

<br>

# Running the App
## Prerequisites

- Machine must be running Windows >8.1.
- [Node.js and npm](https://nodejs.org/) installed on your machine.
- [Visual Studio](https://visualstudio.microsoft.com/) installed on your machine.

### Running the Backend: Ref. [backend README.md](/backend/README.md).
### Running the Frontend: Ref. [frontend README.md](/frontend/README.md)
