# coding: utf-8

from dohq_teamcity.custom.base_model import TeamCityObject


# from dohq_teamcity.models.backup_process_info import BackupProcessInfo  # noqa: F401,E501
# from dohq_teamcity.models.exception import Exception  # noqa: F401,E501
# from dohq_teamcity.models.progress_info import ProgressInfo  # noqa: F401,E501


class BackupProcess(TeamCityObject):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brief_info': 'BackupProcessInfo',
        'progress_info': 'ProgressInfo',
        'process_kind': 'str',
        'exceptions': 'list[Exception]',
        'progress_status': 'str',
        'process_id': 'int',
        'finished': 'bool'
    }

    attribute_map = {
        'brief_info': 'briefInfo',
        'progress_info': 'progressInfo',
        'process_kind': 'processKind',
        'exceptions': 'exceptions',
        'progress_status': 'progressStatus',
        'process_id': 'processId',
        'finished': 'finished'
    }

    def __init__(self, brief_info=None, progress_info=None, process_kind=None, exceptions=None, progress_status=None, process_id=None, finished=False, teamcity=None):  # noqa: E501
        """BackupProcess - a model defined in Swagger"""  # noqa: E501

        self._brief_info = None
        self._progress_info = None
        self._process_kind = None
        self._exceptions = None
        self._progress_status = None
        self._process_id = None
        self._finished = None
        self.discriminator = None

        if brief_info is not None:
            self.brief_info = brief_info
        if progress_info is not None:
            self.progress_info = progress_info
        if process_kind is not None:
            self.process_kind = process_kind
        if exceptions is not None:
            self.exceptions = exceptions
        if progress_status is not None:
            self.progress_status = progress_status
        if process_id is not None:
            self.process_id = process_id
        if finished is not None:
            self.finished = finished
        super(BackupProcess, self).__init__(teamcity=teamcity)

    @property
    def brief_info(self):
        """Gets the brief_info of this BackupProcess.  # noqa: E501


        :return: The brief_info of this BackupProcess.  # noqa: E501
        :rtype: BackupProcessInfo
        """
        return self._brief_info

    @brief_info.setter
    def brief_info(self, brief_info):
        """Sets the brief_info of this BackupProcess.


        :param brief_info: The brief_info of this BackupProcess.  # noqa: E501
        :type: BackupProcessInfo
        """

        self._brief_info = brief_info

    @property
    def progress_info(self):
        """Gets the progress_info of this BackupProcess.  # noqa: E501


        :return: The progress_info of this BackupProcess.  # noqa: E501
        :rtype: ProgressInfo
        """
        return self._progress_info

    @progress_info.setter
    def progress_info(self, progress_info):
        """Sets the progress_info of this BackupProcess.


        :param progress_info: The progress_info of this BackupProcess.  # noqa: E501
        :type: ProgressInfo
        """

        self._progress_info = progress_info

    @property
    def process_kind(self):
        """Gets the process_kind of this BackupProcess.  # noqa: E501


        :return: The process_kind of this BackupProcess.  # noqa: E501
        :rtype: str
        """
        return self._process_kind

    @process_kind.setter
    def process_kind(self, process_kind):
        """Sets the process_kind of this BackupProcess.


        :param process_kind: The process_kind of this BackupProcess.  # noqa: E501
        :type: str
        """
        allowed_values = ["Backup", "Restore", "Cleanup"]  # noqa: E501
        if process_kind not in allowed_values:
            raise ValueError(
                "Invalid value for `process_kind` ({0}), must be one of {1}"  # noqa: E501
                .format(process_kind, allowed_values)
            )

        self._process_kind = process_kind

    @property
    def exceptions(self):
        """Gets the exceptions of this BackupProcess.  # noqa: E501


        :return: The exceptions of this BackupProcess.  # noqa: E501
        :rtype: list[Exception]
        """
        return self._exceptions

    @exceptions.setter
    def exceptions(self, exceptions):
        """Sets the exceptions of this BackupProcess.


        :param exceptions: The exceptions of this BackupProcess.  # noqa: E501
        :type: list[Exception]
        """

        self._exceptions = exceptions

    @property
    def progress_status(self):
        """Gets the progress_status of this BackupProcess.  # noqa: E501


        :return: The progress_status of this BackupProcess.  # noqa: E501
        :rtype: str
        """
        return self._progress_status

    @progress_status.setter
    def progress_status(self, progress_status):
        """Sets the progress_status of this BackupProcess.


        :param progress_status: The progress_status of this BackupProcess.  # noqa: E501
        :type: str
        """
        allowed_values = ["Running", "Cancelling", "Cancelled", "Finished", "Fault"]  # noqa: E501
        if progress_status not in allowed_values:
            raise ValueError(
                "Invalid value for `progress_status` ({0}), must be one of {1}"  # noqa: E501
                .format(progress_status, allowed_values)
            )

        self._progress_status = progress_status

    @property
    def process_id(self):
        """Gets the process_id of this BackupProcess.  # noqa: E501


        :return: The process_id of this BackupProcess.  # noqa: E501
        :rtype: int
        """
        return self._process_id

    @process_id.setter
    def process_id(self, process_id):
        """Sets the process_id of this BackupProcess.


        :param process_id: The process_id of this BackupProcess.  # noqa: E501
        :type: int
        """

        self._process_id = process_id

    @property
    def finished(self):
        """Gets the finished of this BackupProcess.  # noqa: E501


        :return: The finished of this BackupProcess.  # noqa: E501
        :rtype: bool
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this BackupProcess.


        :param finished: The finished of this BackupProcess.  # noqa: E501
        :type: bool
        """

        self._finished = finished
