# coding: utf-8

"""
    TeamCity REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2018.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import
from dohq_teamcity.custom.base_model import TeamCityObject

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dohq_teamcity.models.backup_process_manager import BackupProcessManager  # noqa: F401,E501
from dohq_teamcity.models.file import File  # noqa: F401,E501
from dohq_teamcity.models.files import Files  # noqa: F401,E501
from dohq_teamcity.models.license_key import LicenseKey  # noqa: F401,E501
from dohq_teamcity.models.license_keys import LicenseKeys  # noqa: F401,E501
from dohq_teamcity.models.licensing_data import LicensingData  # noqa: F401,E501
from dohq_teamcity.models.plugins import Plugins  # noqa: F401,E501
from dohq_teamcity.models.server import Server  # noqa: F401,E501


class ServerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
    base_name = 'Server'

    def __init__(self, api_client=None):
        self.api_client = api_client

    def add_license_keys(self, **kwargs):  # noqa: E501
        """add_license_keys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_license_keys(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str body:
        :param str fields:
        :return: LicenseKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__add_license_keys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__add_license_keys_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_license_key(self, license_key, **kwargs):  # noqa: E501
        """delete_license_key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_license_key(license_key, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str license_key: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__delete_license_key_with_http_info(license_key, **kwargs)  # noqa: E501
        else:
            (data) = self.__delete_license_key_with_http_info(license_key, **kwargs)  # noqa: E501
            return data

    def get_backup_status(self, **kwargs):  # noqa: E501
        """get_backup_status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_backup_status(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param BackupProcessManager body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_backup_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__get_backup_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_children(self, path, area_id, **kwargs):  # noqa: E501
        """get_children  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_children(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str path: (required)
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str fields:
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_children_with_http_info(path, area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_children_with_http_info(path, area_id, **kwargs)  # noqa: E501
            return data

    def get_children_alias(self, path, area_id, **kwargs):  # noqa: E501
        """get_children_alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_children_alias(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str path: (required)
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str fields:
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_children_alias_with_http_info(path, area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_children_alias_with_http_info(path, area_id, **kwargs)  # noqa: E501
            return data

    def get_content(self, path, area_id, **kwargs):  # noqa: E501
        """get_content  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_content(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str path: (required)
        :param str area_id: (required)
        :param str response_builder:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_content_with_http_info(path, area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_content_with_http_info(path, area_id, **kwargs)  # noqa: E501
            return data

    def get_content_alias(self, path, area_id, **kwargs):  # noqa: E501
        """get_content_alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_content_alias(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str path: (required)
        :param str area_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_content_alias_with_http_info(path, area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_content_alias_with_http_info(path, area_id, **kwargs)  # noqa: E501
            return data

    def get_license_key(self, license_key, **kwargs):  # noqa: E501
        """get_license_key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_license_key(license_key, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str license_key: (required)
        :param str fields:
        :return: LicenseKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_license_key_with_http_info(license_key, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_license_key_with_http_info(license_key, **kwargs)  # noqa: E501
            return data

    def get_license_keys(self, **kwargs):  # noqa: E501
        """get_license_keys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_license_keys(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str fields:
        :return: LicenseKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_license_keys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__get_license_keys_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_licensing_data(self, **kwargs):  # noqa: E501
        """get_licensing_data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_licensing_data(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str fields:
        :return: LicensingData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_licensing_data_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__get_licensing_data_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_metadata(self, path, area_id, **kwargs):  # noqa: E501
        """get_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str path: (required)
        :param str area_id: (required)
        :param str fields:
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_metadata_with_http_info(path, area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_metadata_with_http_info(path, area_id, **kwargs)  # noqa: E501
            return data

    def get_root(self, area_id, **kwargs):  # noqa: E501
        """get_root  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_root(area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str fields:
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_root_with_http_info(area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_root_with_http_info(area_id, **kwargs)  # noqa: E501
            return data

    def get_zipped(self, path, area_id, **kwargs):  # noqa: E501
        """get_zipped  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zipped(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str path: (required)
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str name:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_zipped_with_http_info(path, area_id, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_zipped_with_http_info(path, area_id, **kwargs)  # noqa: E501
            return data

    def serve_plugins(self, **kwargs):  # noqa: E501
        """serve_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.serve_plugins(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str fields:
        :return: Plugins
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__serve_plugins_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__serve_plugins_with_http_info(**kwargs)  # noqa: E501
            return data

    def serve_server_info(self, **kwargs):  # noqa: E501
        """serve_server_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.serve_server_info(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str fields:
        :return: Server
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__serve_server_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__serve_server_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def serve_server_version(self, field, **kwargs):  # noqa: E501
        """serve_server_version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.serve_server_version(field, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str field: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__serve_server_version_with_http_info(field, **kwargs)  # noqa: E501
        else:
            (data) = self.__serve_server_version_with_http_info(field, **kwargs)  # noqa: E501
            return data

    def start_backup(self, **kwargs):  # noqa: E501
        """start_backup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_backup(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str file_name:
        :param bool add_timestamp:
        :param bool include_configs:
        :param bool include_database:
        :param bool include_build_logs:
        :param bool include_personal_changes:
        :param bool include_running_builds:
        :param bool include_supplimentary_data:
        :param BackupProcessManager body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__start_backup_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__start_backup_with_http_info(**kwargs)  # noqa: E501
            return data

    def __add_license_keys_with_http_info(self, **kwargs):  # noqa: E501
        """add_license_keys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__add_license_keys_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body:
        :param str fields:
        :return: LicenseKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_license_keys" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/licensingData/licenseKeys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseKeys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __delete_license_key_with_http_info(self, license_key, **kwargs):  # noqa: E501
        """delete_license_key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__delete_license_key_with_http_info(license_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str license_key: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_license_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_key' is set
        if ('license_key' not in params or
                params['license_key'] is None):
            raise ValueError("Missing the required parameter `license_key` when calling `delete_license_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'license_key' in params:
            if isinstance(params['license_key'], TeamCityObject):
                path_params['licenseKey'] = params['license_key'].locator_id
            else:
                path_params['licenseKey'] = params['license_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/licensingData/licenseKeys/{licenseKey}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_backup_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_backup_status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_backup_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BackupProcessManager body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_backup_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/backup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_children_with_http_info(self, path, area_id, **kwargs):  # noqa: E501
        """get_children  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_children_with_http_info(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str fields:
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'area_id', 'base_path', 'locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_children" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_children`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_children`")  # noqa: E501

        if 'path' in params and not re.search('(\/.*)?', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_children`, must conform to the pattern `/(\/.*)?/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in params:
            if isinstance(params['path'], TeamCityObject):
                path_params['path'] = params['path'].locator_id
            else:
                path_params['path'] = params['path']  # noqa: E501
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []
        if 'base_path' in params:
            query_params.append(('basePath', params['base_path']))  # noqa: E501
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}/children{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Files',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_children_alias_with_http_info(self, path, area_id, **kwargs):  # noqa: E501
        """get_children_alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_children_alias_with_http_info(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str fields:
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'area_id', 'base_path', 'locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_children_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_children_alias`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_children_alias`")  # noqa: E501

        if 'path' in params and not re.search('(.*)?', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_children_alias`, must conform to the pattern `/(.*)?/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in params:
            if isinstance(params['path'], TeamCityObject):
                path_params['path'] = params['path'].locator_id
            else:
                path_params['path'] = params['path']  # noqa: E501
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []
        if 'base_path' in params:
            query_params.append(('basePath', params['base_path']))  # noqa: E501
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Files',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_content_with_http_info(self, path, area_id, **kwargs):  # noqa: E501
        """get_content  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_content_with_http_info(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str area_id: (required)
        :param str response_builder:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'area_id', 'response_builder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_content`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_content`")  # noqa: E501

        if 'path' in params and not re.search('(\/.*)?', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_content`, must conform to the pattern `/(\/.*)?/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in params:
            if isinstance(params['path'], TeamCityObject):
                path_params['path'] = params['path'].locator_id
            else:
                path_params['path'] = params['path']  # noqa: E501
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []
        if 'response_builder' in params:
            query_params.append(('responseBuilder', params['response_builder']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}/content{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_content_alias_with_http_info(self, path, area_id, **kwargs):  # noqa: E501
        """get_content_alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_content_alias_with_http_info(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str area_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'area_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_content_alias`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_content_alias`")  # noqa: E501

        if 'path' in params and not re.search('(\/.*)?', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_content_alias`, must conform to the pattern `/(\/.*)?/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in params:
            if isinstance(params['path'], TeamCityObject):
                path_params['path'] = params['path'].locator_id
            else:
                path_params['path'] = params['path']  # noqa: E501
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}/files{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_license_key_with_http_info(self, license_key, **kwargs):  # noqa: E501
        """get_license_key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_license_key_with_http_info(license_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str license_key: (required)
        :param str fields:
        :return: LicenseKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_key', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_license_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_key' is set
        if ('license_key' not in params or
                params['license_key'] is None):
            raise ValueError("Missing the required parameter `license_key` when calling `get_license_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'license_key' in params:
            if isinstance(params['license_key'], TeamCityObject):
                path_params['licenseKey'] = params['license_key'].locator_id
            else:
                path_params['licenseKey'] = params['license_key']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/licensingData/licenseKeys/{licenseKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_license_keys_with_http_info(self, **kwargs):  # noqa: E501
        """get_license_keys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_license_keys_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :return: LicenseKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_license_keys" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/licensingData/licenseKeys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseKeys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_licensing_data_with_http_info(self, **kwargs):  # noqa: E501
        """get_licensing_data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_licensing_data_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :return: LicensingData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_licensing_data" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/licensingData', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicensingData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_metadata_with_http_info(self, path, area_id, **kwargs):  # noqa: E501
        """get_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_metadata_with_http_info(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str area_id: (required)
        :param str fields:
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'area_id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_metadata`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_metadata`")  # noqa: E501

        if 'path' in params and not re.search('(\/.*)?', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_metadata`, must conform to the pattern `/(\/.*)?/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in params:
            if isinstance(params['path'], TeamCityObject):
                path_params['path'] = params['path'].locator_id
            else:
                path_params['path'] = params['path']  # noqa: E501
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}/metadata{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_root_with_http_info(self, area_id, **kwargs):  # noqa: E501
        """get_root  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_root_with_http_info(area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str fields:
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['area_id', 'base_path', 'locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_root" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_root`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []
        if 'base_path' in params:
            query_params.append(('basePath', params['base_path']))  # noqa: E501
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Files',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_zipped_with_http_info(self, path, area_id, **kwargs):  # noqa: E501
        """get_zipped  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_zipped_with_http_info(path, area_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str area_id: (required)
        :param str base_path:
        :param str locator:
        :param str name:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'area_id', 'base_path', 'locator', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zipped" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_zipped`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if ('area_id' not in params or
                params['area_id'] is None):
            raise ValueError("Missing the required parameter `area_id` when calling `get_zipped`")  # noqa: E501

        if 'path' in params and not re.search('(\/.*)?', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_zipped`, must conform to the pattern `/(\/.*)?/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in params:
            if isinstance(params['path'], TeamCityObject):
                path_params['path'] = params['path'].locator_id
            else:
                path_params['path'] = params['path']  # noqa: E501
        if 'area_id' in params:
            if isinstance(params['area_id'], TeamCityObject):
                path_params['areaId'] = params['area_id'].locator_id
            else:
                path_params['areaId'] = params['area_id']  # noqa: E501

        query_params = []
        if 'base_path' in params:
            query_params.append(('basePath', params['base_path']))  # noqa: E501
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/files/{areaId}/archived{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __serve_plugins_with_http_info(self, **kwargs):  # noqa: E501
        """serve_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__serve_plugins_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :return: Plugins
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method serve_plugins" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/plugins', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plugins',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __serve_server_info_with_http_info(self, **kwargs):  # noqa: E501
        """serve_server_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__serve_server_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :return: Server
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method serve_server_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Server',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __serve_server_version_with_http_info(self, field, **kwargs):  # noqa: E501
        """serve_server_version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__serve_server_version_with_http_info(field, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str field: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method serve_server_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'field' is set
        if ('field' not in params or
                params['field'] is None):
            raise ValueError("Missing the required parameter `field` when calling `serve_server_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'field' in params:
            if isinstance(params['field'], TeamCityObject):
                path_params['field'] = params['field'].locator_id
            else:
                path_params['field'] = params['field']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/{field}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __start_backup_with_http_info(self, **kwargs):  # noqa: E501
        """start_backup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__start_backup_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name:
        :param bool add_timestamp:
        :param bool include_configs:
        :param bool include_database:
        :param bool include_build_logs:
        :param bool include_personal_changes:
        :param bool include_running_builds:
        :param bool include_supplimentary_data:
        :param BackupProcessManager body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_name', 'add_timestamp', 'include_configs', 'include_database', 'include_build_logs', 'include_personal_changes', 'include_running_builds', 'include_supplimentary_data', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_backup" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'file_name' in params:
            query_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'add_timestamp' in params:
            query_params.append(('addTimestamp', params['add_timestamp']))  # noqa: E501
        if 'include_configs' in params:
            query_params.append(('includeConfigs', params['include_configs']))  # noqa: E501
        if 'include_database' in params:
            query_params.append(('includeDatabase', params['include_database']))  # noqa: E501
        if 'include_build_logs' in params:
            query_params.append(('includeBuildLogs', params['include_build_logs']))  # noqa: E501
        if 'include_personal_changes' in params:
            query_params.append(('includePersonalChanges', params['include_personal_changes']))  # noqa: E501
        if 'include_running_builds' in params:
            query_params.append(('includeRunningBuilds', params['include_running_builds']))  # noqa: E501
        if 'include_supplimentary_data' in params:
            query_params.append(('includeSupplimentaryData', params['include_supplimentary_data']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/server/backup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
