# coding: utf-8

"""
    TeamCity REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2018.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import
from dohq_teamcity.custom.base_model import TeamCityObject

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dohq_teamcity.models.agents import Agents  # noqa: F401,E501
from dohq_teamcity.models.build import Build  # noqa: F401,E501
from dohq_teamcity.models.build_cancel_request import BuildCancelRequest  # noqa: F401,E501
from dohq_teamcity.models.builds import Builds  # noqa: F401,E501
from dohq_teamcity.models.tags import Tags  # noqa: F401,E501


class BuildQueueApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
    base_name = 'BuildQueue'

    def __init__(self, api_client=None):
        self.api_client = api_client

    def add_tags(self, build_locator, **kwargs):  # noqa: E501
        """add_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_tags(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str build_locator: (required)
        :param Tags body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__add_tags_with_http_info(build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__add_tags_with_http_info(build_locator, **kwargs)  # noqa: E501
            return data

    def cancel_build(self, build_locator, **kwargs):  # noqa: E501
        """cancel_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_build(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str build_locator: (required)
        :return: BuildCancelRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__cancel_build_with_http_info(build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__cancel_build_with_http_info(build_locator, **kwargs)  # noqa: E501
            return data

    def cancel_build_0(self, queued_build_locator, **kwargs):  # noqa: E501
        """cancel_build_0  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_build_0(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str queued_build_locator: (required)
        :param BuildCancelRequest body:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__cancel_build_0_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__cancel_build_0_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
            return data

    def delete_build(self, queued_build_locator, **kwargs):  # noqa: E501
        """delete_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_build(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str queued_build_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__delete_build_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__delete_build_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
            return data

    def delete_builds_experimental(self, **kwargs):  # noqa: E501
        """delete_builds_experimental  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_builds_experimental(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str locator:
        :param str fields:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__delete_builds_experimental_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__delete_builds_experimental_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_build(self, queued_build_locator, **kwargs):  # noqa: E501
        """get_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_build(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str queued_build_locator: (required)
        :param str fields:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_build_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_build_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
            return data

    def get_builds(self, **kwargs):  # noqa: E501
        """get_builds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_builds(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str locator:
        :param str fields:
        :return: Builds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_builds_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__get_builds_with_http_info(**kwargs)  # noqa: E501
            return data

    def queue_new_build(self, **kwargs):  # noqa: E501
        """queue_new_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.queue_new_build(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param Build body:
        :param bool move_to_top:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__queue_new_build_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__queue_new_build_with_http_info(**kwargs)  # noqa: E501
            return data

    def replace_builds(self, **kwargs):  # noqa: E501
        """replace_builds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_builds(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param Builds body:
        :param str fields:
        :return: Builds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__replace_builds_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__replace_builds_with_http_info(**kwargs)  # noqa: E501
            return data

    def replace_tags(self, build_locator, **kwargs):  # noqa: E501
        """replace_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_tags(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str build_locator: (required)
        :param str locator:
        :param Tags body:
        :param str fields:
        :return: Tags
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__replace_tags_with_http_info(build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__replace_tags_with_http_info(build_locator, **kwargs)  # noqa: E501
            return data

    def serve_build_field_by_build_only(self, build_locator, field, **kwargs):  # noqa: E501
        """serve_build_field_by_build_only  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.serve_build_field_by_build_only(build_locator, field, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str build_locator: (required)
        :param str field: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__serve_build_field_by_build_only_with_http_info(build_locator, field, **kwargs)  # noqa: E501
        else:
            (data) = self.__serve_build_field_by_build_only_with_http_info(build_locator, field, **kwargs)  # noqa: E501
            return data

    def serve_compatible_agents(self, queued_build_locator, **kwargs):  # noqa: E501
        """serve_compatible_agents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.serve_compatible_agents(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str queued_build_locator: (required)
        :param str fields:
        :return: Agents
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__serve_compatible_agents_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__serve_compatible_agents_with_http_info(queued_build_locator, **kwargs)  # noqa: E501
            return data

    def serve_tags(self, build_locator, **kwargs):  # noqa: E501
        """serve_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.serve_tags(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str build_locator: (required)
        :param str locator:
        :param str fields:
        :return: Tags
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__serve_tags_with_http_info(build_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__serve_tags_with_http_info(build_locator, **kwargs)  # noqa: E501
            return data

    def set_build_queue_order(self, **kwargs):  # noqa: E501
        """set_build_queue_order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_build_queue_order(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param Builds body:
        :param str fields:
        :return: Builds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__set_build_queue_order_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__set_build_queue_order_with_http_info(**kwargs)  # noqa: E501
            return data

    def set_build_queue_position(self, queue_position, **kwargs):  # noqa: E501
        """set_build_queue_position  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_build_queue_position(queue_position, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str queue_position: (required)
        :param str fields:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__set_build_queue_position_with_http_info(queue_position, **kwargs)  # noqa: E501
        else:
            (data) = self.__set_build_queue_position_with_http_info(queue_position, **kwargs)  # noqa: E501
            return data

    def set_build_queue_position_0(self, queue_position, **kwargs):  # noqa: E501
        """set_build_queue_position_0  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_build_queue_position_0(queue_position, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str queue_position: (required)
        :param Build body:
        :param str fields:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__set_build_queue_position_0_with_http_info(queue_position, **kwargs)  # noqa: E501
        else:
            (data) = self.__set_build_queue_position_0_with_http_info(queue_position, **kwargs)  # noqa: E501
            return data

    def __add_tags_with_http_info(self, build_locator, **kwargs):  # noqa: E501
        """add_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__add_tags_with_http_info(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str build_locator: (required)
        :param Tags body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['build_locator', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'build_locator' is set
        if ('build_locator' not in params or
                params['build_locator'] is None):
            raise ValueError("Missing the required parameter `build_locator` when calling `add_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'build_locator' in params:
            if isinstance(params['build_locator'], TeamCityObject):
                path_params['buildLocator'] = params['build_locator'].locator_id
            else:
                path_params['buildLocator'] = params['build_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{buildLocator}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __cancel_build_with_http_info(self, build_locator, **kwargs):  # noqa: E501
        """cancel_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__cancel_build_with_http_info(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str build_locator: (required)
        :return: BuildCancelRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['build_locator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_build" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'build_locator' is set
        if ('build_locator' not in params or
                params['build_locator'] is None):
            raise ValueError("Missing the required parameter `build_locator` when calling `cancel_build`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'build_locator' in params:
            if isinstance(params['build_locator'], TeamCityObject):
                path_params['buildLocator'] = params['build_locator'].locator_id
            else:
                path_params['buildLocator'] = params['build_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{buildLocator}/example/buildCancelRequest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildCancelRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __cancel_build_0_with_http_info(self, queued_build_locator, **kwargs):  # noqa: E501
        """cancel_build_0  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__cancel_build_0_with_http_info(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str queued_build_locator: (required)
        :param BuildCancelRequest body:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queued_build_locator', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_build_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'queued_build_locator' is set
        if ('queued_build_locator' not in params or
                params['queued_build_locator'] is None):
            raise ValueError("Missing the required parameter `queued_build_locator` when calling `cancel_build_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'queued_build_locator' in params:
            if isinstance(params['queued_build_locator'], TeamCityObject):
                path_params['queuedBuildLocator'] = params['queued_build_locator'].locator_id
            else:
                path_params['queuedBuildLocator'] = params['queued_build_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{queuedBuildLocator}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Build',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __delete_build_with_http_info(self, queued_build_locator, **kwargs):  # noqa: E501
        """delete_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__delete_build_with_http_info(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str queued_build_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queued_build_locator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_build" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'queued_build_locator' is set
        if ('queued_build_locator' not in params or
                params['queued_build_locator'] is None):
            raise ValueError("Missing the required parameter `queued_build_locator` when calling `delete_build`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'queued_build_locator' in params:
            if isinstance(params['queued_build_locator'], TeamCityObject):
                path_params['queuedBuildLocator'] = params['queued_build_locator'].locator_id
            else:
                path_params['queuedBuildLocator'] = params['queued_build_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{queuedBuildLocator}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __delete_builds_experimental_with_http_info(self, **kwargs):  # noqa: E501
        """delete_builds_experimental  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__delete_builds_experimental_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locator:
        :param str fields:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_builds_experimental" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_build_with_http_info(self, queued_build_locator, **kwargs):  # noqa: E501
        """get_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_build_with_http_info(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str queued_build_locator: (required)
        :param str fields:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queued_build_locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_build" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'queued_build_locator' is set
        if ('queued_build_locator' not in params or
                params['queued_build_locator'] is None):
            raise ValueError("Missing the required parameter `queued_build_locator` when calling `get_build`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'queued_build_locator' in params:
            if isinstance(params['queued_build_locator'], TeamCityObject):
                path_params['queuedBuildLocator'] = params['queued_build_locator'].locator_id
            else:
                path_params['queuedBuildLocator'] = params['queued_build_locator']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{queuedBuildLocator}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Build',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_builds_with_http_info(self, **kwargs):  # noqa: E501
        """get_builds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_builds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locator:
        :param str fields:
        :return: Builds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_builds" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Builds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __queue_new_build_with_http_info(self, **kwargs):  # noqa: E501
        """queue_new_build  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__queue_new_build_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Build body:
        :param bool move_to_top:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'move_to_top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method queue_new_build" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'move_to_top' in params:
            query_params.append(('moveToTop', params['move_to_top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Build',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __replace_builds_with_http_info(self, **kwargs):  # noqa: E501
        """replace_builds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__replace_builds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Builds body:
        :param str fields:
        :return: Builds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_builds" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Builds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __replace_tags_with_http_info(self, build_locator, **kwargs):  # noqa: E501
        """replace_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__replace_tags_with_http_info(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str build_locator: (required)
        :param str locator:
        :param Tags body:
        :param str fields:
        :return: Tags
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['build_locator', 'locator', 'body', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'build_locator' is set
        if ('build_locator' not in params or
                params['build_locator'] is None):
            raise ValueError("Missing the required parameter `build_locator` when calling `replace_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'build_locator' in params:
            if isinstance(params['build_locator'], TeamCityObject):
                path_params['buildLocator'] = params['build_locator'].locator_id
            else:
                path_params['buildLocator'] = params['build_locator']  # noqa: E501

        query_params = []
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{buildLocator}/tags', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tags',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __serve_build_field_by_build_only_with_http_info(self, build_locator, field, **kwargs):  # noqa: E501
        """serve_build_field_by_build_only  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__serve_build_field_by_build_only_with_http_info(build_locator, field, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str build_locator: (required)
        :param str field: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['build_locator', 'field']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method serve_build_field_by_build_only" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'build_locator' is set
        if ('build_locator' not in params or
                params['build_locator'] is None):
            raise ValueError("Missing the required parameter `build_locator` when calling `serve_build_field_by_build_only`")  # noqa: E501
        # verify the required parameter 'field' is set
        if ('field' not in params or
                params['field'] is None):
            raise ValueError("Missing the required parameter `field` when calling `serve_build_field_by_build_only`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'build_locator' in params:
            if isinstance(params['build_locator'], TeamCityObject):
                path_params['buildLocator'] = params['build_locator'].locator_id
            else:
                path_params['buildLocator'] = params['build_locator']  # noqa: E501
        if 'field' in params:
            if isinstance(params['field'], TeamCityObject):
                path_params['field'] = params['field'].locator_id
            else:
                path_params['field'] = params['field']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{buildLocator}/{field}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __serve_compatible_agents_with_http_info(self, queued_build_locator, **kwargs):  # noqa: E501
        """serve_compatible_agents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__serve_compatible_agents_with_http_info(queued_build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str queued_build_locator: (required)
        :param str fields:
        :return: Agents
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queued_build_locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method serve_compatible_agents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'queued_build_locator' is set
        if ('queued_build_locator' not in params or
                params['queued_build_locator'] is None):
            raise ValueError("Missing the required parameter `queued_build_locator` when calling `serve_compatible_agents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'queued_build_locator' in params:
            if isinstance(params['queued_build_locator'], TeamCityObject):
                path_params['queuedBuildLocator'] = params['queued_build_locator'].locator_id
            else:
                path_params['queuedBuildLocator'] = params['queued_build_locator']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{queuedBuildLocator}/compatibleAgents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Agents',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __serve_tags_with_http_info(self, build_locator, **kwargs):  # noqa: E501
        """serve_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__serve_tags_with_http_info(build_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str build_locator: (required)
        :param str locator:
        :param str fields:
        :return: Tags
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['build_locator', 'locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method serve_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'build_locator' is set
        if ('build_locator' not in params or
                params['build_locator'] is None):
            raise ValueError("Missing the required parameter `build_locator` when calling `serve_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'build_locator' in params:
            if isinstance(params['build_locator'], TeamCityObject):
                path_params['buildLocator'] = params['build_locator'].locator_id
            else:
                path_params['buildLocator'] = params['build_locator']  # noqa: E501

        query_params = []
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/{buildLocator}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tags',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __set_build_queue_order_with_http_info(self, **kwargs):  # noqa: E501
        """set_build_queue_order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__set_build_queue_order_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Builds body:
        :param str fields:
        :return: Builds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_build_queue_order" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/order', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Builds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __set_build_queue_position_with_http_info(self, queue_position, **kwargs):  # noqa: E501
        """set_build_queue_position  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__set_build_queue_position_with_http_info(queue_position, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str queue_position: (required)
        :param str fields:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_position', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_build_queue_position" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'queue_position' is set
        if ('queue_position' not in params or
                params['queue_position'] is None):
            raise ValueError("Missing the required parameter `queue_position` when calling `set_build_queue_position`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'queue_position' in params:
            if isinstance(params['queue_position'], TeamCityObject):
                path_params['queuePosition'] = params['queue_position'].locator_id
            else:
                path_params['queuePosition'] = params['queue_position']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/order/{queuePosition}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Build',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __set_build_queue_position_0_with_http_info(self, queue_position, **kwargs):  # noqa: E501
        """set_build_queue_position_0  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__set_build_queue_position_0_with_http_info(queue_position, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str queue_position: (required)
        :param Build body:
        :param str fields:
        :return: Build
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_position', 'body', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_build_queue_position_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'queue_position' is set
        if ('queue_position' not in params or
                params['queue_position'] is None):
            raise ValueError("Missing the required parameter `queue_position` when calling `set_build_queue_position_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'queue_position' in params:
            if isinstance(params['queue_position'], TeamCityObject):
                path_params['queuePosition'] = params['queue_position'].locator_id
            else:
                path_params['queuePosition'] = params['queue_position']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/buildQueue/order/{queuePosition}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Build',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
