# coding: utf-8

"""
    TeamCity REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2018.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import
from dohq_teamcity.custom.base_model import TeamCityObject

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dohq_teamcity.models.agent import Agent  # noqa: F401,E501
from dohq_teamcity.models.agent_pool import AgentPool  # noqa: F401,E501
from dohq_teamcity.models.agent_pools import AgentPools  # noqa: F401,E501
from dohq_teamcity.models.agents import Agents  # noqa: F401,E501
from dohq_teamcity.models.project import Project  # noqa: F401,E501
from dohq_teamcity.models.projects import Projects  # noqa: F401,E501


class AgentPoolApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
    base_name = 'AgentPool'

    def __init__(self, api_client=None):
        self.api_client = api_client

    def add_agent(self, agent_pool_locator, **kwargs):  # noqa: E501
        """add_agent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_agent(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param Agent body:
        :param str fields:
        :return: Agent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__add_agent_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__add_agent_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def add_project(self, agent_pool_locator, **kwargs):  # noqa: E501
        """add_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_project(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param Project body:
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__add_project_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__add_project_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def create_pool(self, **kwargs):  # noqa: E501
        """create_pool  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pool(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param AgentPool body:
        :return: AgentPool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__create_pool_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__create_pool_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_pool(self, agent_pool_locator, **kwargs):  # noqa: E501
        """delete_pool  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pool(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__delete_pool_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__delete_pool_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def delete_pool_project(self, agent_pool_locator, project_locator, **kwargs):  # noqa: E501
        """delete_pool_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pool_project(agent_pool_locator, project_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str project_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__delete_pool_project_with_http_info(agent_pool_locator, project_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__delete_pool_project_with_http_info(agent_pool_locator, project_locator, **kwargs)  # noqa: E501
            return data

    def delete_projects(self, agent_pool_locator, **kwargs):  # noqa: E501
        """delete_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_projects(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__delete_projects_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__delete_projects_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def get_field(self, agent_pool_locator, field, **kwargs):  # noqa: E501
        """get_field  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_field(agent_pool_locator, field, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str field: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_field_with_http_info(agent_pool_locator, field, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_field_with_http_info(agent_pool_locator, field, **kwargs)  # noqa: E501
            return data

    def get_pool(self, agent_pool_locator, **kwargs):  # noqa: E501
        """get_pool  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pool(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str fields:
        :return: AgentPool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_pool_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_pool_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def get_pool_agents(self, agent_pool_locator, **kwargs):  # noqa: E501
        """get_pool_agents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pool_agents(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str locator:
        :param str fields:
        :return: Agents
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_pool_agents_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_pool_agents_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def get_pool_project(self, agent_pool_locator, project_locator, **kwargs):  # noqa: E501
        """get_pool_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pool_project(agent_pool_locator, project_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str project_locator: (required)
        :param str fields:
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_pool_project_with_http_info(agent_pool_locator, project_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_pool_project_with_http_info(agent_pool_locator, project_locator, **kwargs)  # noqa: E501
            return data

    def get_pool_projects(self, agent_pool_locator, **kwargs):  # noqa: E501
        """get_pool_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pool_projects(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str fields:
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_pool_projects_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__get_pool_projects_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def get_pools(self, **kwargs):  # noqa: E501
        """get_pools  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pools(async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str locator:
        :param str fields:
        :return: AgentPools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__get_pools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.__get_pools_with_http_info(**kwargs)  # noqa: E501
            return data

    def replace_projects(self, agent_pool_locator, **kwargs):  # noqa: E501
        """replace_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_projects(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param Projects body:
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__replace_projects_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
        else:
            (data) = self.__replace_projects_with_http_info(agent_pool_locator, **kwargs)  # noqa: E501
            return data

    def set_field(self, agent_pool_locator, field, **kwargs):  # noqa: E501
        """set_field  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_field(agent_pool_locator, field, async_req=True)
        >>> result = thread.get()

        :param async_req: bool
        :param str agent_pool_locator: (required)
        :param str field: (required)
        :param str body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.__set_field_with_http_info(agent_pool_locator, field, **kwargs)  # noqa: E501
        else:
            (data) = self.__set_field_with_http_info(agent_pool_locator, field, **kwargs)  # noqa: E501
            return data

    def __add_agent_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """add_agent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__add_agent_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param Agent body:
        :param str fields:
        :return: Agent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'body', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `add_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/agents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Agent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __add_project_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """add_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__add_project_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param Project body:
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `add_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __create_pool_with_http_info(self, **kwargs):  # noqa: E501
        """create_pool  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__create_pool_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AgentPool body:
        :return: AgentPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pool" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentPool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __delete_pool_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """delete_pool  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__delete_pool_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `delete_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __delete_pool_project_with_http_info(self, agent_pool_locator, project_locator, **kwargs):  # noqa: E501
        """delete_pool_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__delete_pool_project_with_http_info(agent_pool_locator, project_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str project_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'project_locator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pool_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `delete_pool_project`")  # noqa: E501
        # verify the required parameter 'project_locator' is set
        if ('project_locator' not in params or
                params['project_locator'] is None):
            raise ValueError("Missing the required parameter `project_locator` when calling `delete_pool_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501
        if 'project_locator' in params:
            if isinstance(params['project_locator'], TeamCityObject):
                path_params['projectLocator'] = params['project_locator'].locator_id
            else:
                path_params['projectLocator'] = params['project_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/projects/{projectLocator}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __delete_projects_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """delete_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__delete_projects_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_projects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `delete_projects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/projects', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_field_with_http_info(self, agent_pool_locator, field, **kwargs):  # noqa: E501
        """get_field  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_field_with_http_info(agent_pool_locator, field, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str field: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'field']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `get_field`")  # noqa: E501
        # verify the required parameter 'field' is set
        if ('field' not in params or
                params['field'] is None):
            raise ValueError("Missing the required parameter `field` when calling `get_field`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501
        if 'field' in params:
            if isinstance(params['field'], TeamCityObject):
                path_params['field'] = params['field'].locator_id
            else:
                path_params['field'] = params['field']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/{field}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_pool_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """get_pool  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_pool_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str fields:
        :return: AgentPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `get_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentPool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_pool_agents_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """get_pool_agents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_pool_agents_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str locator:
        :param str fields:
        :return: Agents
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pool_agents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `get_pool_agents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Agents',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_pool_project_with_http_info(self, agent_pool_locator, project_locator, **kwargs):  # noqa: E501
        """get_pool_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_pool_project_with_http_info(agent_pool_locator, project_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str project_locator: (required)
        :param str fields:
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'project_locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pool_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `get_pool_project`")  # noqa: E501
        # verify the required parameter 'project_locator' is set
        if ('project_locator' not in params or
                params['project_locator'] is None):
            raise ValueError("Missing the required parameter `project_locator` when calling `get_pool_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501
        if 'project_locator' in params:
            if isinstance(params['project_locator'], TeamCityObject):
                path_params['projectLocator'] = params['project_locator'].locator_id
            else:
                path_params['projectLocator'] = params['project_locator']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/projects/{projectLocator}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_pool_projects_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """get_pool_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_pool_projects_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str fields:
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pool_projects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `get_pool_projects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __get_pools_with_http_info(self, **kwargs):  # noqa: E501
        """get_pools  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__get_pools_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locator:
        :param str fields:
        :return: AgentPools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locator', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pools" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'locator' in params:
            query_params.append(('locator', params['locator']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentPools',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __replace_projects_with_http_info(self, agent_pool_locator, **kwargs):  # noqa: E501
        """replace_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__replace_projects_with_http_info(agent_pool_locator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param Projects body:
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_projects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `replace_projects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/projects', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def __set_field_with_http_info(self, agent_pool_locator, field, **kwargs):  # noqa: E501
        """set_field  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.__set_field_with_http_info(agent_pool_locator, field, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_pool_locator: (required)
        :param str field: (required)
        :param str body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_pool_locator', 'field', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_pool_locator' is set
        if ('agent_pool_locator' not in params or
                params['agent_pool_locator'] is None):
            raise ValueError("Missing the required parameter `agent_pool_locator` when calling `set_field`")  # noqa: E501
        # verify the required parameter 'field' is set
        if ('field' not in params or
                params['field'] is None):
            raise ValueError("Missing the required parameter `field` when calling `set_field`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_pool_locator' in params:
            if isinstance(params['agent_pool_locator'], TeamCityObject):
                path_params['agentPoolLocator'] = params['agent_pool_locator'].locator_id
            else:
                path_params['agentPoolLocator'] = params['agent_pool_locator']  # noqa: E501
        if 'field' in params:
            if isinstance(params['field'], TeamCityObject):
                path_params['field'] = params['field'].locator_id
            else:
                path_params['field'] = params['field']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/app/rest/agentPools/{agentPoolLocator}/{field}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
