# 🔖 auth_system_appwrite

A new Flutter project Auth System Mobile App using Flutter with Appwrite.

## 🎬 Getting Started

Appwrite is an end-to-end backend server for Web, Mobile, Native, or Backend apps packaged as a set of Docker microservices. Appwrite abstracts the complexity and repetitiveness required to build a modern backend API from scratch and allows you to build secure apps faster.

### 🤘 Install Appwrite

Follow our simple [Installation Guide](https://appwrite.io/docs/installation) to get Appwrite up and running in no time. You can either deploy Appwrite on your local machine or, on any cloud provider of your choice.

  > Note: If you setup Appwrite on your local machine, you will need to create a public IP 
so that your hosted frontend can access it.

1. We need to make a few configuration changes to your Appwrite server.

    Add a new Flutter App (Android or iOS or both) in Appwrite and enter application id
    of your application (io.appwrite.auth etc) 

![image](https://user-images.githubusercontent.com/73419211/122684732-e9eac700-d226-11eb-954c-f7cb5327d042.png)

2. Update ```appwriteConstant.dart``` with your own endpoint and project id.
3. Run ```flutter pub``` get to get the dependencies

### 🚀 Run the Application

First get the dependencies by running ```flutter pub get```. Then you can run the application simply using ```flutter run``` command. It works on Android, iOS and Web platforms.

##

## Features

  - User can Login,Logout and Signup the app.
  - User can change their name, email and password.

##

## Screenshots
<p>
<img src="https://user-images.githubusercontent.com/73419211/123602651-b3114400-d818-11eb-906c-3f065cea2810.jpg" height="500" width="260">
<img src="https://user-images.githubusercontent.com/73419211/123602666-b6a4cb00-d818-11eb-8433-53bd150353b7.jpg" height="500" width="260">  
<img src="https://user-images.githubusercontent.com/73419211/123602696-bf959c80-d818-11eb-836b-806c70b61080.jpg" height="500" width="260">
<img src="https://user-images.githubusercontent.com/73419211/123602690-bdcbd900-d818-11eb-8e3d-efa23fa19fb0.jpg" height="500" width="260">
</p>


## 🤕 Support

If you get stuck anywhere, hop onto one of our [support channels in discord](https://discord.com/invite/GSeTUeA) and we'd be delighted to help you out 🤝

## 😧 Help Wanted

Our access credentials were recently compromised and someone tried to ruin these demos. They decided to leave behind 15 easter eggs 🥚 for you to discover. If you find them, submit a PR cleaning up that section of the code (One PR per person across all the repos). You can track the number of claimed Easter Eggs using the badge at the top.

The first 15 people to get their PRs merged will receive some Appwrite Swags 🤩 . Just head over to our [Discord channel](https://discord.com/invite/GSeTUeA)
 and share your PR link with us.

