import styled from 'styled-components'
import React from 'react'

const SocialButton = styled.a`
  cursor: pointer;
  svg {
    width: 36px;
  }
  div > svg {
    width: 24px;
  }

  #github {
    width: 38px;
  }
  margin-left: 20px;
`

export const Twitter = ({
  target,
  rel,
  href = '//twitter.com/poweredbyClubs '
}: {
  target?: string
  rel?: string
  href?: string
}) => (
  <SocialButton href={href} target={target} rel={rel}>
    <svg
      height="100%"
      fillRule="evenodd"
      clipRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      version="1.1"
      viewBox="0 0 512 512"
      width="100%"
    >
      <g>
        <circle cx="256" cy="256" id="Dark_Blue" r="256" fill="#1da1f2" />
        <path
          d="M209.152,391.04c113.536,0 175.616,-94.08 175.616,-175.616c0,-2.688 0,-5.376 -0.128,-7.936c12.032,-8.704 22.528,-19.584 30.848,-32c-11.008,4.864 -22.912,8.192 -35.456,9.728c12.8,-7.68 22.528,-19.712 27.136,-34.176c-11.904,7.04 -25.088,12.16 -39.168,14.976c-11.264,-12.032 -27.264,-19.456 -45.056,-19.456c-34.048,0 -61.696,27.648 -61.696,61.696c0,4.864 0.512,9.6 1.664,14.08c-51.328,-2.56 -96.768,-27.136 -127.232,-64.512c-5.248,9.088 -8.32,19.712 -8.32,30.976c0,21.376 10.88,40.32 27.52,51.328c-10.112,-0.256 -19.584,-3.072 -27.904,-7.68l0,0.768c0,29.952 21.248,54.784 49.536,60.544c-5.12,1.408 -10.624,2.176 -16.256,2.176c-3.968,0 -7.808,-0.384 -11.648,-1.152c7.808,24.576 30.592,42.368 57.6,42.88c-21.12,16.512 -47.744,26.368 -76.672,26.368c-4.992,0 -9.856,-0.256 -14.72,-0.896c27.008,17.664 59.52,27.904 94.336,27.904"
          id="Logo__x2014__FIXED"
          fill="#fff"
          fillRule="nonzero"
        />
      </g>
    </svg>
  </SocialButton>
)

export const Discord = () => (
  <SocialButton target="_blank" rel="noopener noreferrer" href="//discord.gg/PBaaTvn56f">
    <svg enableBackground="new 0 0 512 512" id="Layer_1" version="1.1" viewBox="0 0 512 512">
      <circle cx="256" cy="256" fill="#8C9EFF" id="ellipse" r="256" />
      <path
        d="M372.4,168.7c0,0-33.3-26.1-72.7-29.1l-3.5,7.1c35.6,8.7,51.9,21.2,69,36.5  c-29.4-15-58.5-29.1-109.1-29.1s-79.7,14.1-109.1,29.1c17.1-15.3,36.5-29.2,69-36.5l-3.5-7.1c-41.3,3.9-72.7,29.1-72.7,29.1  s-37.2,54-43.6,160c37.5,43.3,94.5,43.6,94.5,43.6l11.9-15.9c-20.2-7-43.1-19.6-62.8-42.3c23.5,17.8,59.1,36.4,116.4,36.4  s92.8-18.5,116.4-36.4c-19.7,22.7-42.6,35.3-62.8,42.3l11.9,15.9c0,0,57-0.3,94.5-43.6C409.6,222.7,372.4,168.7,372.4,168.7z   M208.7,299.6c-14.1,0-25.5-13-25.5-29.1s11.4-29.1,25.5-29.1c14.1,0,25.5,13,25.5,29.1S222.8,299.6,208.7,299.6z M303.3,299.6  c-14.1,0-25.5-13-25.5-29.1s11.4-29.1,25.5-29.1s25.5,13,25.5,29.1S317.3,299.6,303.3,299.6z"
        fill="#FFFFFF"
        id="logo"
      />
    </svg>
  </SocialButton>
)

export const Github = ({
  target,
  rel,
  href = 'https://github.com/dev-protocol/stakes.social'
}: {
  target?: string
  rel?: string
  href?: string
}) => (
  <SocialButton href={href} target={target} rel={rel}>
    <svg id="github" enableBackground="new 0 0 64 64" version="1.1" viewBox="0 0 64 64">
      <g id="Layer_3">
        <g>
          <g>
            <path
              d="M32,0C14.327,0,0,14.327,0,32c0,17.673,14.327,32,32,32s32-14.327,32-32C64,14.327,49.673,0,32,0z"
              fill="#333333"
            />
          </g>
        </g>
        <g id="Outline_Filled">
          <path
            d="M38.592,50.166h-4.84h-4.844c0,0,0.014-2.874,0-4.844c-6.629,1.428-8.479-3.633-8.479-3.633    c-1.21-2.423-2.423-3.633-2.423-3.633c-2.423-1.438,0-1.21,0-1.21c2.423,0,3.633,2.423,3.633,2.423    c2.126,3.609,5.908,3.028,7.266,2.423c0-1.21,0.53-3.042,1.21-3.633c-5.29-0.595-9.693-3.633-9.693-9.689s1.216-7.266,2.427-8.479    c-0.244-0.597-1.259-2.805,0.037-6.056c0,0,2.38,0,4.803,3.633c1.2-1.2,4.844-1.21,6.056-1.21c1.208,0,4.854,0.01,6.054,1.21    c2.423-3.633,4.809-3.633,4.809-3.633c1.296,3.251,0.282,5.459,0.037,6.056c1.21,1.21,2.423,2.423,2.423,8.479    s-4.397,9.092-9.689,9.689c0.682,0.591,1.21,2.675,1.21,3.633L38.592,50.166L38.592,50.166z"
            fill="#FFFFFF"
            id="Cat_3_"
          />
        </g>
      </g>
    </svg>
  </SocialButton>
)

export const Medium = () => (
  <SocialButton target="_blank" rel="noopener noreferrer" href="//medium.com/devtoken">
    <div
      style={{
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        width: '36px',
        height: '36px',
        borderRadius: '90px',
        backgroundColor: 'white'
      }}
    >
      <svg
        fillRule="evenodd"
        clipRule="evenodd"
        strokeLinejoin="round"
        strokeMiterlimit="2"
        version="1.1"
        viewBox="0 0 512 512"
      >
        <path
          d="M60.713,135.684c0.637,-6.285 -1.759,-12.499 -6.453,-16.728l-47.807,-57.59l0,-8.603l148.437,0l114.735,251.627l100.872,-251.627l141.503,0.001l0,8.602l-40.874,39.189c-3.525,2.685 -5.272,7.102 -4.541,11.472l0,287.947c-0.731,4.37 1.016,8.786 4.541,11.471l39.917,39.19l0,8.602l-200.782,0l0,-8.602l41.35,-40.147c4.065,-4.061 4.065,-5.257 4.065,-11.468l0,-232.749l-114.973,292.009l-15.536,0l-133.859,-292.009l0,195.709c-1.114,8.228 1.618,16.513 7.41,22.462l53.784,65.235l0,8.603l-152.502,0l0,-8.603l53.784,-65.235c5.749,-5.96 8.321,-14.301 6.929,-22.462l0,-226.296Z"
          id="Shape"
          fillRule="nonzero"
        />
      </svg>
    </div>
  </SocialButton>
)

export const Spectrum = () => (
  <SocialButton href="//spectrum.chat/devtoken">
    <svg width="35" height="38" viewBox="0 0 35 38" fill="none" xmlns="http://www.w3.org/2000/svg">
      <rect x="3" y="5" width="27" height="22" fill="#000C18" />
      <path
        d="M4.085 33.5603H26.6617L25.5835 30.0691C25.7434 30.2084 34.8333 38 34.8333 38V3.91875C34.7257 1.80025 32.9017 0 30.6407 0L4.09292 0.00475C1.8335 0.00475 0 1.80817 0 3.92667V29.64C0 31.8741 1.83033 33.5603 4.085 33.5603ZM20.786 8.99808L20.7337 9.01708L20.7527 8.99808H20.786ZM8.70358 11.0073C11.6058 8.89517 14.2959 8.9965 14.2959 8.9965L14.5128 9.21025C10.9614 10.0573 9.35117 11.6438 9.35117 11.6438C9.51583 11.609 16.6867 7.47175 25.3761 11.7483C25.3761 11.7483 23.7627 10.2647 20.4297 9.31475L20.7242 9.025C21.185 9.02658 23.6233 9.11208 26.2327 11.02C26.2327 11.02 29.1523 16.0075 29.1523 22.135C29.0557 22.0178 27.341 24.7728 22.9282 24.8678C22.9282 24.8678 22.1809 24.0223 21.6489 23.2845C24.2297 22.5435 25.1956 21.0615 25.1956 21.0615C20.1717 24.225 15.7684 23.731 10.5007 21.5935C10.4516 21.5935 10.4294 21.5713 10.4041 21.546V21.5365C10.3787 21.5127 10.3566 21.489 10.3075 21.489H10.2125C9.8895 21.2768 9.67417 21.1723 9.67417 21.1723C9.67417 21.1723 10.6384 22.6543 13.1163 23.3953C12.4656 24.1379 11.8212 24.9818 11.8212 24.9818C7.41 24.8773 5.80133 22.1223 5.80133 22.1223C5.80133 15.9853 8.70358 11.0073 8.70358 11.0073Z"
        fill="#000C18"
      />
      <path
        d="M21.0698 20.2208C22.1956 20.2208 23.1123 19.2708 23.1123 18.0991C23.1123 16.9354 22.2003 15.9854 21.0698 15.9854V15.9901C19.9488 15.9901 19.0305 16.9369 19.0273 18.1086C19.0273 19.2708 19.9441 20.2208 21.0698 20.2208Z"
        fill="#000C18"
      />
      <path
        d="M13.7573 20.2208C14.8831 20.2208 15.7998 19.2708 15.7998 18.0991C15.7998 16.9354 14.8894 15.9854 13.7637 15.9854L13.7573 15.9901C12.6316 15.9901 11.7148 16.9369 11.7148 18.1086C11.7148 19.2708 12.6316 20.2208 13.7573 20.2208Z"
        fill="#000C18"
      />
      <rect x="2" y="9" width="32" height="14" fill="url(#pattern0)" />
      <defs>
        <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
          <use xlinkHref="#image0" transform="translate(-0.075 -0.852941) scale(0.002875 0.00676471)" />
        </pattern>
        <image
          id="image0"
          width="400"
          height="400"
          xlinkHref="data:image/jpeg;base64,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"
        />
      </defs>
    </svg>
  </SocialButton>
)
