#ifndef DETHRACE_ASCII_TABLES_H
#define DETHRACE_ASCII_TABLES_H

typedef struct {
    int ascii[128];
    int ascii_shift[128];
} dethrace_ascii_tables;

dethrace_ascii_tables carmageddon_ascii_tables = {
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        '0',  /* KEY_0 */
        '1',  /* KEY_1 */
        '2',  /* KEY_2 */
        '3',  /* KEY_3 */
        '4',  /* KEY_4 */
        '5',  /* KEY_5 */
        '6',  /* KEY_6 */
        '7',  /* KEY_7 */
        '8',  /* KEY_8 */
        '9',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Y',  /* KEY_Y */
        'Z',  /* KEY_Z */
        '`',  /* KEY_GRAVE */
        '-',  /* KEY_MINUS */
        '=',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        0x03, /* KEY_KP_ENTER */
        '\t', /* KEY_TAB */
        '/',  /* KEY_SLASH */
        '\\', /* KEY_UNKNOWN_55 */
        ';',  /* KEY_SEMICOLON */
        '\'', /* KEY_APOSTROPHE */
        '.',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        '[',  /* KEY_LBRACKET */
        ']',  /* KEY_RBRACKET */
        '#',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0x7f, /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0x1c, /* KEY_LEFT */
        0x1d, /* KEY_RIGHT */
        0x1e, /* KEY_UP */
        0x1f, /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        '/',  /* KEY_KP_DIVIDE */
        '*',  /* KEY_KP_MULTIPLY */
        '-',  /* KEY_KP_MINUS */
        '+',  /* KEY_KP_PLUS */
        '.',  /* KEY_KP_PERIOD */
        '=',  /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        ')',  /* KEY_0 */
        '!',  /* KEY_1 */
        '"',  /* KEY_2 */
        0xa3, /* KEY_3 (£) */
        '$',  /* KEY_4 */
        '%',  /* KEY_5 */
        '^',  /* KEY_6 */
        '&',  /* KEY_7 */
        '*',  /* KEY_8 */
        '(',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Y',  /* KEY_Y */
        'Z',  /* KEY_Z */
        0xac, /* KEY_GRAVE (¬) */
        '_',  /* KEY_MINUS */
        '+',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        '\r', /* KEY_KP_ENTER */
        0,    /* KEY_TAB */
        '?',  /* KEY_SLASH */
        '|',  /* KEY_UNKNOWN_55 */
        ':',  /* KEY_SEMICOLON */
        '@',  /* KEY_APOSTROPHE */
        '>',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        '{',  /* KEY_LBRACKET */
        '}',  /* KEY_RBRACKET */
        '~',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0,    /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0,    /* KEY_LEFT */
        0,    /* KEY_RIGHT */
        0,    /* KEY_UP */
        0,    /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        '/',  /* KEY_KP_DIVIDE */
        '*',  /* KEY_KP_MULTIPLY */
        '-',  /* KEY_KP_MINUS */
        '+',  /* KEY_KP_PLUS */
        '.',  /* KEY_KP_PERIOD */
        0,    /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
};

dethrace_ascii_tables carmageddon_german_ascii_tables = {
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        '0',  /* KEY_0 */
        '1',  /* KEY_1 */
        '2',  /* KEY_2 */
        '3',  /* KEY_3 */
        '4',  /* KEY_4 */
        '5',  /* KEY_5 */
        '6',  /* KEY_6 */
        '7',  /* KEY_7 */
        '8',  /* KEY_8 */
        '9',  /* KEY_9 */
        'a',  /* KEY_A */
        'b',  /* KEY_B */
        'c',  /* KEY_C */
        'd',  /* KEY_D */
        'e',  /* KEY_E */
        'f',  /* KEY_F */
        'g',  /* KEY_G */
        'h',  /* KEY_H */
        'i',  /* KEY_I */
        'j',  /* KEY_J */
        'k',  /* KEY_K */
        'l',  /* KEY_L */
        'm',  /* KEY_M */
        'n',  /* KEY_N */
        'o',  /* KEY_O */
        'p',  /* KEY_P */
        'q',  /* KEY_Q */
        'r',  /* KEY_R */
        's',  /* KEY_S */
        't',  /* KEY_T */
        'u',  /* KEY_U */
        'v',  /* KEY_V */
        'w',  /* KEY_W */
        'x',  /* KEY_X */
        'z',  /* KEY_Y */
        'y',  /* KEY_Z */
        '^',  /* KEY_GRAVE */
        0xdf, /* KEY_MINUS (ß) */
        0xb4, /* KEY_EQUALS (´) */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        '\r', /* KEY_KP_ENTER */
        0,    /* KEY_TAB */
        '-',  /* KEY_SLASH */
        '<',  /* KEY_UNKNOWN_55 */
        0xf6, /* KEY_SEMICOLON (ö) */
        0xe4, /* KEY_APOSTROPHE (ä) */
        '.',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        0xfc, /* KEY_LBRACKET (ü) */
        '+',  /* KEY_RBRACKET */
        '#',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0,    /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0,    /* KEY_LEFT */
        0,    /* KEY_RIGHT */
        0,    /* KEY_UP */
        0,    /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        0xfc, /* KEY_KP_DIVIDE (ü) */
        '8',  /* KEY_KP_MULTIPLY */
        0xdf, /* KEY_KP_MINUS (ß) */
        0xb4, /* KEY_KP_PLUS (´) */
        '.',  /* KEY_KP_PERIOD */
        0,    /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        '=',  /* KEY_0 */
        '!',  /* KEY_1 */
        '"',  /* KEY_2 */
        0xa7, /* KEY_3 (§) */
        '$',  /* KEY_4 */
        '%',  /* KEY_5 */
        '&',  /* KEY_6 */
        '/',  /* KEY_7 */
        '(',  /* KEY_8 */
        ')',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Z',  /* KEY_Y */
        'Y',  /* KEY_Z */
        0xb0, /* KEY_GRAVE (°) */
        '?',  /* KEY_MINUS */
        '`',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        '\r', /* KEY_KP_ENTER */
        0,    /* KEY_TAB */
        '_',  /* KEY_SLASH */
        '>',  /* KEY_UNKNOWN_55 */
        0xd6, /* KEY_SEMICOLON (Ö) */
        0xc4, /* KEY_APOSTROPHE (Ä) */
        ':',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        0xdc, /* KEY_LBRACKET (Ü) */
        '*',  /* KEY_RBRACKET */
        '\'', /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0,    /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0,    /* KEY_LEFT */
        0,    /* KEY_RIGHT */
        0,    /* KEY_UP */
        0,    /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        0xfc, /* KEY_KP_DIVIDE (ü) */
        '8',  /* KEY_KP_MULTIPLY */
        0xdf, /* KEY_KP_MINUS (ß) */
        0xb4, /* KEY_KP_PLUS (´) */
        '.',  /* KEY_KP_PERIOD */
        0,    /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
};

dethrace_ascii_tables demo_ascii_tables = {
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        '0',  /* KEY_0 */
        '1',  /* KEY_1 */
        '2',  /* KEY_2 */
        '3',  /* KEY_3 */
        '4',  /* KEY_4 */
        '5',  /* KEY_5 */
        '6',  /* KEY_6 */
        '7',  /* KEY_7 */
        '8',  /* KEY_8 */
        '9',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Y',  /* KEY_Y */
        'Z',  /* KEY_Z */
        '`',  /* KEY_GRAVE */
        '-',  /* KEY_MINUS */
        '=',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        0x03, /* KEY_KP_ENTER */
        '\t', /* KEY_TAB */
        '/',  /* KEY_SLASH */
        '\\', /* KEY_UNKNOWN_55 */
        ';',  /* KEY_SEMICOLON */
        '\'', /* KEY_APOSTROPHE */
        '.',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        '[',  /* KEY_LBRACKET */
        ']',  /* KEY_RBRACKET */
        '#',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0x7f, /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0x1c, /* KEY_LEFT */
        0x1d, /* KEY_RIGHT */
        0x1e, /* KEY_UP */
        0x1f, /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        '/',  /* KEY_KP_DIVIDE */
        '*',  /* KEY_KP_MULTIPLY */
        '-',  /* KEY_KP_MINUS */
        '+',  /* KEY_KP_PLUS */
        '.',  /* KEY_KP_PERIOD */
        '=',  /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        ')',  /* KEY_0 */
        '!',  /* KEY_1 */
        '"',  /* KEY_2 */
        0xa3, /* KEY_3 (£) */
        '$',  /* KEY_4 */
        '%',  /* KEY_5 */
        '^',  /* KEY_6 */
        '&',  /* KEY_7 */
        '*',  /* KEY_8 */
        '(',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Y',  /* KEY_Y */
        'Z',  /* KEY_Z */
        0xac, /* KEY_GRAVE (¬) */
        '_',  /* KEY_MINUS */
        '+',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        '\r', /* KEY_KP_ENTER */
        0,    /* KEY_TAB */
        '?',  /* KEY_SLASH */
        '|',  /* KEY_UNKNOWN_55 */
        ':',  /* KEY_SEMICOLON */
        '@',  /* KEY_APOSTROPHE */
        '>',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        '{',  /* KEY_LBRACKET */
        '}',  /* KEY_RBRACKET */
        '~',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0,    /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0,    /* KEY_LEFT */
        0,    /* KEY_RIGHT */
        0,    /* KEY_UP */
        0,    /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        '/',  /* KEY_KP_DIVIDE */
        '*',  /* KEY_KP_MULTIPLY */
        '-',  /* KEY_KP_MINUS */
        '+',  /* KEY_KP_PLUS */
        '.',  /* KEY_KP_PERIOD */
        0,    /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
};

dethrace_ascii_tables xmas_ascii_tables = {
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        '0',  /* KEY_0 */
        '1',  /* KEY_1 */
        '2',  /* KEY_2 */
        '3',  /* KEY_3 */
        '4',  /* KEY_4 */
        '5',  /* KEY_5 */
        '6',  /* KEY_6 */
        '7',  /* KEY_7 */
        '8',  /* KEY_8 */
        '9',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Y',  /* KEY_Y */
        'Z',  /* KEY_Z */
        '`',  /* KEY_GRAVE */
        '-',  /* KEY_MINUS */
        '=',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        0x03, /* KEY_KP_ENTER */
        '\t', /* KEY_TAB */
        '/',  /* KEY_SLASH */
        '\\', /* KEY_UNKNOWN_55 */
        ';',  /* KEY_SEMICOLON */
        '\'', /* KEY_APOSTROPHE */
        '.',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        '[',  /* KEY_LBRACKET */
        ']',  /* KEY_RBRACKET */
        '#',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0x7f, /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0x1c, /* KEY_LEFT */
        0x1d, /* KEY_RIGHT */
        0x1e, /* KEY_UP */
        0x1f, /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        '/',  /* KEY_KP_DIVIDE */
        '*',  /* KEY_KP_MULTIPLY */
        '-',  /* KEY_KP_MINUS */
        '+',  /* KEY_KP_PLUS */
        '.',  /* KEY_KP_PERIOD */
        '=',  /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
    {
        0,    /* KEY_SHIFT_ANY */
        0,    /* KEY_ALT_ANY */
        0,    /* KEY_CTRL_ANY */
        0,    /* KEY_CTRL_ANY_2 */
        0,    /* KEY_CAPSLOCK */
        0,    /* KEY_RSHIFT */
        0,    /* KEY_RALT */
        0,    /* KEY_RCTRL */
        0,    /* KEY_LSHIFT */
        0,    /* KEY_LALT */
        0,    /* KEY_LCTRL */
        ')',  /* KEY_0 */
        '!',  /* KEY_1 */
        '"',  /* KEY_2 */
        0xa3, /* KEY_3 (£) */
        '$',  /* KEY_4 */
        '%',  /* KEY_5 */
        '^',  /* KEY_6 */
        '&',  /* KEY_7 */
        '*',  /* KEY_8 */
        '(',  /* KEY_9 */
        'A',  /* KEY_A */
        'B',  /* KEY_B */
        'C',  /* KEY_C */
        'D',  /* KEY_D */
        'E',  /* KEY_E */
        'F',  /* KEY_F */
        'G',  /* KEY_G */
        'H',  /* KEY_H */
        'I',  /* KEY_I */
        'J',  /* KEY_J */
        'K',  /* KEY_K */
        'L',  /* KEY_L */
        'M',  /* KEY_M */
        'N',  /* KEY_N */
        'O',  /* KEY_O */
        'P',  /* KEY_P */
        'Q',  /* KEY_Q */
        'R',  /* KEY_R */
        'S',  /* KEY_S */
        'T',  /* KEY_T */
        'U',  /* KEY_U */
        'V',  /* KEY_V */
        'W',  /* KEY_W */
        'X',  /* KEY_X */
        'Y',  /* KEY_Y */
        'Z',  /* KEY_Z */
        0xac, /* KEY_GRAVE (¬) */
        '_',  /* KEY_MINUS */
        '+',  /* KEY_EQUALS */
        '\b', /* KEY_BACKSPACE */
        '\r', /* KEY_RETURN */
        '\r', /* KEY_KP_ENTER */
        0,    /* KEY_TAB */
        '?',  /* KEY_SLASH */
        '|',  /* KEY_UNKNOWN_55 */
        ':',  /* KEY_SEMICOLON */
        '@',  /* KEY_APOSTROPHE */
        '>',  /* KEY_PERIOD */
        ',',  /* KEY_COMMA */
        '{',  /* KEY_LBRACKET */
        '}',  /* KEY_RBRACKET */
        '~',  /* KEY_BACKSLASH */
        0x1b, /* KEY_ESCAPE */
        0,    /* KEY_INSERT */
        0,    /* KEY_DELETE */
        0,    /* KEY_HOME */
        0,    /* KEY_END */
        0,    /* KEY_PAGEUP */
        0,    /* KEY_PAGEDOWN */
        0,    /* KEY_LEFT */
        0,    /* KEY_RIGHT */
        0,    /* KEY_UP */
        0,    /* KEY_DOWN */
        0,    /* KEY_KP_NUMLOCK */
        '/',  /* KEY_KP_DIVIDE */
        '*',  /* KEY_KP_MULTIPLY */
        '-',  /* KEY_KP_MINUS */
        '+',  /* KEY_KP_PLUS */
        '.',  /* KEY_KP_PERIOD */
        0,    /* KEY_KP_EQUALS */
        '0',  /* KEY_KP_0 */
        '1',  /* KEY_KP_1 */
        '2',  /* KEY_KP_2 */
        '3',  /* KEY_KP_3 */
        '4',  /* KEY_KP_4 */
        '5',  /* KEY_KP_5 */
        '6',  /* KEY_KP_6 */
        '7',  /* KEY_KP_7 */
        '8',  /* KEY_KP_8 */
        '9',  /* KEY_KP_9 */
        0,    /* KEY_F1 */
        0,    /* KEY_F2 */
        0,    /* KEY_F3 */
        0,    /* KEY_F4 */
        0,    /* KEY_F5 */
        0,    /* KEY_F6 */
        0,    /* KEY_F7 */
        0,    /* KEY_F8 */
        0,    /* KEY_F9 */
        0,    /* KEY_F10 */
        0,    /* KEY_F11 */
        0,    /* KEY_F12 */
        0,    /* KEY_PRTSCN */
        0,    /* KEY_SCRLK */
        0,    /* KEY_PAUSE */
        ' ',  /* KEY_SPACE */
    },
};

#endif /* DETHRACE_ASCII_TABLES_H */
