     _                                         _     _             _
    | | ___  __ _ _ __ _ __  _   _  ___  _   _| |__ | |_ _ __ ___ | |
    | |/ _ \/ _` | '__| '_ \| | | |/ _ \| | | | '_ \| __| '_ ` _ \| |
    | |  __/ (_| | |  | | | | |_| | (_) | |_| | | | | |_| | | | | | |
    |_|\___|\__,_|_|  |_| |_|\__, |\___/ \__,_|_| |_|\__|_| |_| |_|_|
                             |___/

Welcome to **learnyouhtml**!

### What is HTML?

**HTML** or **HyperText Markup Language** is a markup language for creating webpages. Webpages are usually viewed in a web browser. They can include writing, links, pictures, and even sound and video. HTML is used to mark and describe each of these kinds of content so the web browser can show them correctly.

HTML can also be used to add meta information to a webpage. Meta information is information _about_ the web page. For example, the name of the person who made it. Meta information is not usually shown by web browsers.

HTML was made by the **World Wide Web Consortium (W3C)**. There are many versions of HTML. The current standard is HTML5. So, it is the version the W3C recommends.

### Why do I need to learn HTML?

HTML is a cornerstone of web. It's what you see in your browser every time you open a favorite site.

If you're going to work in web development area, then you definitely need to know what is HTML, how to read it and how to use it.

### Browser

You need to have a _browser_ — a program to read HTML documents and display them. There are a lot of them, but we recommend one of these:

* [Google Chrome](https://www.google.com/chrome)
* [Mozilla Firefox](https://www.mozilla.org/en-US/firefox/new)

### Editor

HTML-document could be created in any text editor, even Notepad. Nevertheless, it would be better if you will use a special editor with useful features, like syntax highlighting, tabs, autocompletions, etc.

We recommend you one of these text editors:

* [Atom](https://atom.io)
* [Sublime Text](https://www.sublimetext.com/)
* [Brackets](http://brackets.io/)

### How to use this workshopper?

This workshopper will guide you through the simple exercises which explain the core principles of HTML. In most cases, it's enough to use only three commands:

* `learnyouhtml run file.html` will serve a local server at `http://localhost:3000/` with a preview of `file.html`.
* `learnyouhtml verify file.html` will verify your file.
* `learnyouhtml help` shows a help message.

## THE CHALLENGE

Create a new empty file called `index.html` and put these lines in there:

```html
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Hello, world!</title>
  </head>
  <body>
    here is a body
  </body>
</html>
```

This is your boilerplate for all of next exercises. Everything you're going to do you'll do with that snippet.

It's okay if you don't understand what is going on. This lines will be explained in following exercises.

Run `learnyouhtml verify` to verify your solution or `learnyouhtml run` to see the result in the browser.

---
