Almost in any article or blog post you need to divide your content by logical parts with corresponding heading. HTML provide six levels of heading elements.

Headings play important role on a web page. First, they show the importance of the section they belong to. Remember in the newspapers and magazines the most important news are typed in large print, thereby attracting attention to them and saying: "This is something that must be read". Secondly, with the help of different headings it is easy to adjust the size of the text. The higher the header level, the larger the font size.

There are six levels of heading. The following code shows all the heading levels, in use:

```html
<h1>Heading level 1</h1>
<h2>Heading level 2</h2>
<h3>Heading level 3</h3>
<h4>Heading level 4</h4>
<h5>Heading level 5</h5>
<h6>Heading level 6</h6>
```

Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.

Despite the fact that headlines increase font size, do not use lower levels for that purpose. There are corresponding CSS-properties.

Avoid skipping heading levels: always start from `<h1>`, next use `<h2>` and so on.

Typically, the web page uses headings from the first to the third level, they are enough. Rarely when you need to use headers of a lower level.

## THE CHALLENGE

You know how to create heading and paragraphs. Please, create a document with these structure:

---

# Heading elements
## Summary
Some text here...

## Examples
### Example 1
Some text here...

### Example 2
Some text here...

## See also
Some text here...

---

Above amount of `#`s indicates of heading's level. When you finish, don't forget to check your solution with `learnyouhtml verify`.

---
