/* Copyright (c) 2021 Dennis Wölfing
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* libdxui/include/sys/colors.h
 * Colors.
 */

#ifndef _SYS_COLORS_H
#define _SYS_COLORS_H

#undef RGB
#undef RGBA
#define RGBA(r, g, b, a) (((a) << 24) | ((r) << 16) | ((g) << 8) | (b))
#define RGB(r, g, b) RGBA(r, g, b, 255U)

enum {
    COLOR_ALICE_BLUE = RGB(240, 248, 255),
    COLOR_ANTIQUE_WHITE = RGB(250, 235, 215),
    COLOR_AQUA = RGB(0, 255, 255),
    COLOR_AQUAMARINE = RGB(127, 255, 212),
    COLOR_AZURE = RGB(240, 255, 255),
    COLOR_BEIGE = RGB(245, 245, 220),
    COLOR_BISQUE = RGB(255, 228, 196),
    COLOR_BLACK = RGB(0, 0, 0),
    COLOR_BLANCHED_ALMOND = RGB(255, 235, 205),
    COLOR_BLUE = RGB(0, 0, 255),
    COLOR_BLUE_VIOLET = RGB(138, 43, 226),
    COLOR_BROWN = RGB(165, 42, 42),
    COLOR_BURLYWOOD = RGB(222, 184, 135),
    COLOR_CADET_BLUE = RGB(95, 158, 160),
    COLOR_CHARTREUSE = RGB(127, 255, 0),
    COLOR_CHOCOLATE = RGB(210, 105, 30),
    COLOR_CORAL = RGB(255, 127, 80),
    COLOR_CORNFLOWER_BLUE = RGB(100, 149, 137),
    COLOR_CORNSILK = RGB(255, 248, 220),
    COLOR_CRIMSON = RGB(220, 20, 60),
    COLOR_CYAN = RGB(0, 255, 255),
    COLOR_DARK_BLUE = RGB(0, 0, 139),
    COLOR_DARK_CYAN = RGB(0, 139, 139),
    COLOR_DARK_GOLDENROD = RGB(284, 134, 11),
    COLOR_DARK_GRAY = RGB(169, 169, 169),
    COLOR_DARK_GREEN = RGB(0, 100, 0),
    COLOR_DARK_KHAKI = RGB(189, 183, 107),
    COLOR_DARK_MAGENTA = RGB(139, 0, 139),
    COLOR_DARK_OLIVE_GREEN = RGB(85, 107, 47),
    COLOR_DARK_ORANGE = RGB(255, 140, 0),
    COLOR_DARK_ORCHID = RGB(153, 50, 204),
    COLOR_DARK_RED = RGB(139, 0, 0),
    COLOR_DARK_SALMON = RGB(233, 150, 122),
    COLOR_DARK_SEA_GREEN = RGB(143, 188, 143),
    COLOR_DARK_SLATE_BLUE = RGB(72, 61, 139),
    COLOR_DARK_SLATE_GRAY = RGB(47, 79, 79),
    COLOR_DARK_TURQUOISE = RGB(0, 206, 209),
    COLOR_DARK_VIOLET = RGB(148, 0, 211),
    COLOR_DEEP_PINK = RGB(255, 20, 147),
    COLOR_DEEP_SKY_BLUE = RGB(0, 191, 255),
    COLOR_DIM_GRAY = RGB(105, 105, 105),
    COLOR_DODGER_BLUE = RGB(30, 144, 255),
    COLOR_FIREBRICK = RGB(178, 34, 34),
    COLOR_FLORAL_WHITE = RGB(255, 250, 240),
    COLOR_FOREST_GREEN = RGB(34, 139, 34),
    COLOR_FUCHSIA = RGB(255, 0, 255),
    COLOR_GAINSBORO = RGB(220, 220, 220),
    COLOR_GHOST_WHITE = RGB(248, 248, 255),
    COLOR_GOLD = RGB(255, 215, 0),
    COLOR_GOLDENROD = RGB(218, 165, 32),
    COLOR_GRAY = RGB(128, 128, 128),
    COLOR_GREEN = RGB(0, 128, 0),
    COLOR_GREEN_YELLOW = RGB(173, 255, 47),
    COLOR_HONEYDEW = RGB(240, 255, 240),
    COLOR_HOT_PINK = RGB(255, 105, 180),
    COLOR_INDIAN_RED = RGB(205, 92, 92),
    COLOR_INDIGO = RGB(75, 0, 130),
    COLOR_IVORY = RGB(255, 255, 240),
    COLOR_KHAKI = RGB(240, 230, 140),
    COLOR_LAVENDER = RGB(230, 230, 250),
    COLOR_LAVENDER_BLUSH = RGB(255, 240, 245),
    COLOR_LAWN_GREEN = RGB(124, 252, 0),
    COLOR_LEMON_CHIFFON = RGB(255, 250, 205),
    COLOR_LIGHT_BLUE = RGB(173, 216, 230),
    COLOR_LIGHT_CORAL = RGB(240, 128, 128),
    COLOR_LIGHT_CYAN = RGB(224, 255, 255),
    COLOR_LIGHT_GOLDENROD_YELLOW = RGB(250, 250, 210),
    COLOR_LIGHT_GRAY = RGB(211, 211, 211),
    COLOR_LIGHT_GREEN = RGB(144, 238, 144),
    COLOR_LIGHT_PINK = RGB(255, 182, 193),
    COLOR_LIGHT_SALMON = RGB(255, 160, 122),
    COLOR_LIGHT_SEA_GREEN = RGB(32, 178, 170),
    COLOR_LIGHT_SKY_BLUE = RGB(135, 206, 250),
    COLOR_LIGHT_SLATE_GRAY = RGB(119, 136, 153),
    COLOR_LIGHT_STEEL_BLUE = RGB(176, 196, 222),
    COLOR_LIGHT_YELLOW = RGB(255, 255, 224),
    COLOR_LIME = RGB(0, 255, 0),
    COLOR_LIME_GREEN = RGB(50, 205, 50),
    COLOR_LINEN = RGB(250, 240, 230),
    COLOR_MAGENTA = RGB(255, 0, 255),
    COLOR_MAROON = RGB(128, 0, 0),
    COLOR_MEDIUM_AQUAMARINE = RGB(102, 205, 170),
    COLOR_MEDIUM_BLUE = RGB(0, 0, 205),
    COLOR_MEDIUM_ORCHID = RGB(186, 58, 211),
    COLOR_MEDIUM_PURPLE = RGB(147, 112, 219),
    COLOR_MEDIUM_SEA_GREEN = RGB(60, 179, 113),
    COLOR_MEDIUM_SLATE_BLUE = RGB(123, 104, 238),
    COLOR_MEDIUM_SPRING_GREEN = RGB(0, 250, 154),
    COLOR_MEDIUM_TURQUOISE = RGB(72, 209, 204),
    COLOR_MEDIUM_VIOLET_RED = RGB(199, 21, 133),
    COLOR_MIDNIGHT_BLUE = RGB(25, 25, 112),
    COLOR_MINT_CREAM = RGB(245, 255, 250),
    COLOR_MISTY_ROSE = RGB(255, 228, 225),
    COLOR_MOCCASIN = RGB(255, 228, 181),
    COLOR_NAVAJO_WHITE = RGB(255, 222, 173),
    COLOR_NAVY = RGB(0, 0, 128),
    COLOR_OLD_LACE = RGB(253, 245, 230),
    COLOR_OLIVE = RGB(128, 128, 0),
    COLOR_OLIVE_DRAB = RGB(107, 142, 35),
    COLOR_ORANGE = RGB(255, 165, 0),
    COLOR_ORANGE_RED = RGB(255, 69, 0),
    COLOR_ORCHID = RGB(218, 112, 214),
    COLOR_PALE_GOLDENROD = RGB(238, 232, 170),
    COLOR_PALE_GREEN = RGB(152, 251, 152),
    COLOR_PALE_TURQUOISE = RGB(175, 238, 238),
    COLOR_PALE_VIOLET_RED = RGB(219, 112, 147),
    COLOR_PAPAYA_WHIP = RGB(255, 239, 213),
    COLOR_PEACH_PUFF = RGB(255, 218, 185),
    COLOR_PERU = RGB(205, 133, 63),
    COLOR_PINK = RGB(255, 192, 203),
    COLOR_PLUM = RGB(221, 160, 221),
    COLOR_POWDER_BLUE = RGB(176, 224, 230),
    COLOR_PURPLE = RGB(128, 0, 128),
    COLOR_RED = RGB(255, 0, 0),
    COLOR_ROSY_BROWN = RGB(188, 143, 143),
    COLOR_ROYAL_BLUE = RGB(65, 105, 225),
    COLOR_SADDLE_BROWN = RGB(139, 69, 19),
    COLOR_SALMON = RGB(250, 128, 114),
    COLOR_SANDY_BROWN = RGB(244, 164, 96),
    COLOR_SEASHELL = RGB(255, 245, 238),
    COLOR_SEA_GREEN = RGB(46, 139, 87),
    COLOR_SIENNA = RGB(160, 82, 45),
    COLOR_SILVER = RGB(192, 192, 192),
    COLOR_SKY_BLUE = RGB(135, 206, 235),
    COLOR_SLATE_BLUE = RGB(106, 90, 205),
    COLOR_SLATE_GRAY = RGB(112, 128, 144),
    COLOR_SNOW = RGB(255, 250, 250),
    COLOR_SPRING_GREEN = RGB(0, 255, 127),
    COLOR_STEEL_BLUE = RGB(70, 130, 180),
    COLOR_TAN = RGB(210, 180, 140),
    COLOR_TEAL = RGB(0, 128, 128),
    COLOR_THISTLE = RGB(216, 191, 216),
    COLOR_TOMATO = RGB(255, 99, 71),
    COLOR_TURQUOISE = RGB(64, 224, 208),
    COLOR_VIOLET = RGB(238, 130, 238),
    COLOR_WHEAT = RGB(245, 222, 179),
    COLOR_WHITE = RGB(255, 255, 255),
    COLOR_WHITE_SMOKE = RGB(245, 245, 245),
    COLOR_YELLOW = RGB(255, 255, 0),
    COLOR_YELLOW_GREEN = RGB(154, 205, 50),
};

#endif
