/* Copyright (c) 2020 Dennis Wölfing
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* libc/src/grp/getgrgid.c
 * Get group information.
 */

#include <grp.h>
#include <string.h>

// We don't support multiple users or groups, so we just hardcode this.
static const char* const users[] = { "user", NULL };
static const struct group usersGroup = {
    .gr_name = "users",
    .gr_gid = 0,
    .gr_mem = (char**) users
};

struct group* getgrgid(gid_t gid) {
    if (gid == 0) {
        return (struct group*) &usersGroup;
    }
    return NULL;
}

struct group* getgrnam(const char* name) {
    if (strcmp(name, "users") == 0) {
        return (struct group*) &usersGroup;
    }
    return NULL;
}
