/* Copyright (c) 2018, 2022 Dennis Wölfing
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* libc/src/fcntl/fcntl.c
 * File control. (POSIX2008, called from C89)
 */

#include <fcntl.h>
#include <stdarg.h>
#include <sys/syscall.h>

DEFINE_SYSCALL(SYSCALL_FCNTL, int, sys_fcntl, (int, int, int));

int __fcntl(int fd, int cmd, ...) {
    va_list ap;
    va_start(ap, cmd);
    int param = 0;
    switch (cmd) {
        case F_DUPFD:
        case F_DUPFD_CLOEXEC:
        case F_SETFD:
        case F_SETFL:
            param = va_arg(ap, int);
    }
    va_end(ap);

    return sys_fcntl(fd, cmd, param);
}
__weak_alias(__fcntl, fcntl);
