/* Copyright (c) 2018, 2019, 2020, 2021, 2022, 2024 Dennis Wölfing
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* libc/include/sys/time.h
 * XSI time functions.
 */

#ifndef _SYS_TIME_H
#define _SYS_TIME_H

#include <sys/select.h>

#ifdef __cplusplus
extern "C" {
#endif

int utimes(const char*, const struct timeval[2]);

#if __USE_DENNIX || __USE_POSIX <= 200809L
int gettimeofday(struct timeval* __restrict, void* __restrict);
#endif

#ifdef __cplusplus
}
#endif

#endif
