/* Copyright (c) 2020, 2022 Dennis Wölfing
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* kernel/include/dennix/mouse.h
 * Mouse data.
 */

#ifndef _DENNIX_MOUSE_H
#define _DENNIX_MOUSE_H

#include <stdint.h>
#include <dennix/devctl.h>

#define MOUSE_LEFT (1 << 0)
#define MOUSE_RIGHT (1 << 1)
#define MOUSE_MIDDLE (1 << 2)
#define MOUSE_SCROLL_UP (1 << 3)
#define MOUSE_SCROLL_DOWN (1 << 4)
#define MOUSE_ABSOLUTE (1 << 5)
#define MOUSE_NO_BUTTON_INFO (1 << 6)

#define MOUSE_SET_ABSOLUTE _DEVCTL(_IOCTL_INT, 2)

struct mouse_data {
    int16_t mouse_x;
    int16_t mouse_y;
    uint8_t mouse_flags;
};

#endif
