# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](code-of-conduct.md). By participating in this
project you agree to abide by its terms.

---

Ensure your pull request adheres to the following guidelines:

- To add a new entry, [edit the README.md file](https://github.com/deluks/awesome-ios-apps/edit/master/README.md) through Github's web interface or a text editor, and send a Pull Request.
- Make an individual pull request for each suggestion.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Use the following format for your suggestions: `- [App Name](link-to-app-store) - Why this app is awesome. ![][iphone]`
    - The primary link for the app should point to its App Store page, not its homepage.
    - End all descriptions with a full stop/period.
    - Use the following icons to denote on which platforms the app is available:
        - `![][iphone]`, `![][ipad]`, `![][watch]`, `![][tv]`
        - If multiple platforms are supported use the order above.
- Put your suggestion into a category that fits best. Don't put it in multiple categories.
- Order link titles alphabetically within each category.
- Check your spelling and grammar.


## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.
