{ ***************************************************** }
{                                                       }
{  Pascal language binding for the Capstone engine      }
{                                                       }
{  Unit Name: Capstone Api Header                       }
{     Author: Lsuper 2024.05.01                         }
{    Purpose: arm64.h                                   }
{    License: Mozilla Public License 2.0                }
{                                                       }
{  Copyright (c) 1998-2024 Super Studio                 }
{                                                       }
{ ***************************************************** }

unit Capstone.Arm64;

{$I Capstone.inc}

interface

/// ARM64 shift type
type
  arm64_shifter = Integer;
  Parm64_shifter = ^arm64_shifter;

const
  ARM64_SFT_INVALID = 0;
  ARM64_SFT_LSL = 1;
  ARM64_SFT_MSL = 2;
  ARM64_SFT_LSR = 3;
  ARM64_SFT_ASR = 4;
  ARM64_SFT_ROR = 5;

/// ARM64 extender type
type
  arm64_extender = Integer;
  Parm64_extender = ^arm64_extender;

const
  ARM64_EXT_INVALID = 0;
  ARM64_EXT_UXTB = 1;
  ARM64_EXT_UXTH = 2;
  ARM64_EXT_UXTW = 3;
  ARM64_EXT_UXTX = 4;
  ARM64_EXT_SXTB = 5;
  ARM64_EXT_SXTH = 6;
  ARM64_EXT_SXTW = 7;
  ARM64_EXT_SXTX = 8;

/// ARM64 condition code
type
  arm64_cc = Integer;
  Parm64_cc = ^arm64_cc;

const
  ARM64_CC_INVALID = 0;
  /// Equal
  ARM64_CC_EQ = 1;
  /// Not equal:                 Not equal, or unordered
  ARM64_CC_NE = 2;
  /// Unsigned higher or same:   >, ==, or unordered
  ARM64_CC_HS = 3;
  /// Unsigned lower or same:    Less than
  ARM64_CC_LO = 4;
  /// Minus, negative:           Less than
  ARM64_CC_MI = 5;
  /// Plus, positive or zero:    >, ==, or unordered
  ARM64_CC_PL = 6;
  /// Overflow:                  Unordered
  ARM64_CC_VS = 7;
  /// No overflow:               Ordered
  ARM64_CC_VC = 8;
  /// Unsigned higher:           Greater than, or unordered
  ARM64_CC_HI = 9;
  /// Unsigned lower or same:    Less than or equal
  ARM64_CC_LS = 10;
  /// Greater than or equal:     Greater than or equal
  ARM64_CC_GE = 11;
  /// Less than:                 Less than, or unordered
  ARM64_CC_LT = 12;
  /// Signed greater than:       Greater than
  ARM64_CC_GT = 13;
  /// Signed less than or equal: <, ==, or unordered
  ARM64_CC_LE = 14;
  /// Always (unconditional):    Always (unconditional)
  ARM64_CC_AL = 15;
  /// Always (unconditional):   Always (unconditional)
  ARM64_CC_NV = 16;

/// System registers
type
  arm64_sysreg = Integer;
  Parm64_sysreg = ^arm64_sysreg;

const
  ARM64_SYSREG_INVALID = 0;
  ARM64_SYSREG_ACCDATA_EL1 = 50821;
  ARM64_SYSREG_ACTLR_EL1 = 49281;
  ARM64_SYSREG_ACTLR_EL2 = 57473;
  ARM64_SYSREG_ACTLR_EL3 = 61569;
  ARM64_SYSREG_AFSR0_EL1 = 49800;
  ARM64_SYSREG_AFSR0_EL12 = 60040;
  ARM64_SYSREG_AFSR0_EL2 = 57992;
  ARM64_SYSREG_AFSR0_EL3 = 62088;
  ARM64_SYSREG_AFSR1_EL1 = 49801;
  ARM64_SYSREG_AFSR1_EL12 = 60041;
  ARM64_SYSREG_AFSR1_EL2 = 57993;
  ARM64_SYSREG_AFSR1_EL3 = 62089;
  ARM64_SYSREG_AIDR_EL1 = 51207;
  ARM64_SYSREG_AMAIR_EL1 = 50456;
  ARM64_SYSREG_AMAIR_EL12 = 60696;
  ARM64_SYSREG_AMAIR_EL2 = 58648;
  ARM64_SYSREG_AMAIR_EL3 = 62744;
  ARM64_SYSREG_AMCFGR_EL0 = 56977;
  ARM64_SYSREG_AMCGCR_EL0 = 56978;
  ARM64_SYSREG_AMCNTENCLR0_EL0 = 56980;
  ARM64_SYSREG_AMCNTENCLR1_EL0 = 56984;
  ARM64_SYSREG_AMCNTENSET0_EL0 = 56981;
  ARM64_SYSREG_AMCNTENSET1_EL0 = 56985;
  ARM64_SYSREG_AMCR_EL0 = 56976;
  ARM64_SYSREG_AMEVCNTR00_EL0 = 56992;
  ARM64_SYSREG_AMEVCNTR01_EL0 = 56993;
  ARM64_SYSREG_AMEVCNTR02_EL0 = 56994;
  ARM64_SYSREG_AMEVCNTR03_EL0 = 56995;
  ARM64_SYSREG_AMEVCNTR10_EL0 = 57056;
  ARM64_SYSREG_AMEVCNTR110_EL0 = 57066;
  ARM64_SYSREG_AMEVCNTR111_EL0 = 57067;
  ARM64_SYSREG_AMEVCNTR112_EL0 = 57068;
  ARM64_SYSREG_AMEVCNTR113_EL0 = 57069;
  ARM64_SYSREG_AMEVCNTR114_EL0 = 57070;
  ARM64_SYSREG_AMEVCNTR115_EL0 = 57071;
  ARM64_SYSREG_AMEVCNTR11_EL0 = 57057;
  ARM64_SYSREG_AMEVCNTR12_EL0 = 57058;
  ARM64_SYSREG_AMEVCNTR13_EL0 = 57059;
  ARM64_SYSREG_AMEVCNTR14_EL0 = 57060;
  ARM64_SYSREG_AMEVCNTR15_EL0 = 57061;
  ARM64_SYSREG_AMEVCNTR16_EL0 = 57062;
  ARM64_SYSREG_AMEVCNTR17_EL0 = 57063;
  ARM64_SYSREG_AMEVCNTR18_EL0 = 57064;
  ARM64_SYSREG_AMEVCNTR19_EL0 = 57065;
  ARM64_SYSREG_AMEVCNTVOFF00_EL2 = 59072;
  ARM64_SYSREG_AMEVCNTVOFF010_EL2 = 59082;
  ARM64_SYSREG_AMEVCNTVOFF011_EL2 = 59083;
  ARM64_SYSREG_AMEVCNTVOFF012_EL2 = 59084;
  ARM64_SYSREG_AMEVCNTVOFF013_EL2 = 59085;
  ARM64_SYSREG_AMEVCNTVOFF014_EL2 = 59086;
  ARM64_SYSREG_AMEVCNTVOFF015_EL2 = 59087;
  ARM64_SYSREG_AMEVCNTVOFF01_EL2 = 59073;
  ARM64_SYSREG_AMEVCNTVOFF02_EL2 = 59074;
  ARM64_SYSREG_AMEVCNTVOFF03_EL2 = 59075;
  ARM64_SYSREG_AMEVCNTVOFF04_EL2 = 59076;
  ARM64_SYSREG_AMEVCNTVOFF05_EL2 = 59077;
  ARM64_SYSREG_AMEVCNTVOFF06_EL2 = 59078;
  ARM64_SYSREG_AMEVCNTVOFF07_EL2 = 59079;
  ARM64_SYSREG_AMEVCNTVOFF08_EL2 = 59080;
  ARM64_SYSREG_AMEVCNTVOFF09_EL2 = 59081;
  ARM64_SYSREG_AMEVCNTVOFF10_EL2 = 59088;
  ARM64_SYSREG_AMEVCNTVOFF110_EL2 = 59098;
  ARM64_SYSREG_AMEVCNTVOFF111_EL2 = 59099;
  ARM64_SYSREG_AMEVCNTVOFF112_EL2 = 59100;
  ARM64_SYSREG_AMEVCNTVOFF113_EL2 = 59101;
  ARM64_SYSREG_AMEVCNTVOFF114_EL2 = 59102;
  ARM64_SYSREG_AMEVCNTVOFF115_EL2 = 59103;
  ARM64_SYSREG_AMEVCNTVOFF11_EL2 = 59089;
  ARM64_SYSREG_AMEVCNTVOFF12_EL2 = 59090;
  ARM64_SYSREG_AMEVCNTVOFF13_EL2 = 59091;
  ARM64_SYSREG_AMEVCNTVOFF14_EL2 = 59092;
  ARM64_SYSREG_AMEVCNTVOFF15_EL2 = 59093;
  ARM64_SYSREG_AMEVCNTVOFF16_EL2 = 59094;
  ARM64_SYSREG_AMEVCNTVOFF17_EL2 = 59095;
  ARM64_SYSREG_AMEVCNTVOFF18_EL2 = 59096;
  ARM64_SYSREG_AMEVCNTVOFF19_EL2 = 59097;
  ARM64_SYSREG_AMEVTYPER00_EL0 = 57008;
  ARM64_SYSREG_AMEVTYPER01_EL0 = 57009;
  ARM64_SYSREG_AMEVTYPER02_EL0 = 57010;
  ARM64_SYSREG_AMEVTYPER03_EL0 = 57011;
  ARM64_SYSREG_AMEVTYPER10_EL0 = 57072;
  ARM64_SYSREG_AMEVTYPER110_EL0 = 57082;
  ARM64_SYSREG_AMEVTYPER111_EL0 = 57083;
  ARM64_SYSREG_AMEVTYPER112_EL0 = 57084;
  ARM64_SYSREG_AMEVTYPER113_EL0 = 57085;
  ARM64_SYSREG_AMEVTYPER114_EL0 = 57086;
  ARM64_SYSREG_AMEVTYPER115_EL0 = 57087;
  ARM64_SYSREG_AMEVTYPER11_EL0 = 57073;
  ARM64_SYSREG_AMEVTYPER12_EL0 = 57074;
  ARM64_SYSREG_AMEVTYPER13_EL0 = 57075;
  ARM64_SYSREG_AMEVTYPER14_EL0 = 57076;
  ARM64_SYSREG_AMEVTYPER15_EL0 = 57077;
  ARM64_SYSREG_AMEVTYPER16_EL0 = 57078;
  ARM64_SYSREG_AMEVTYPER17_EL0 = 57079;
  ARM64_SYSREG_AMEVTYPER18_EL0 = 57080;
  ARM64_SYSREG_AMEVTYPER19_EL0 = 57081;
  ARM64_SYSREG_AMUSERENR_EL0 = 56979;
  ARM64_SYSREG_APDAKEYHI_EL1 = 49425;
  ARM64_SYSREG_APDAKEYLO_EL1 = 49424;
  ARM64_SYSREG_APDBKEYHI_EL1 = 49427;
  ARM64_SYSREG_APDBKEYLO_EL1 = 49426;
  ARM64_SYSREG_APGAKEYHI_EL1 = 49433;
  ARM64_SYSREG_APGAKEYLO_EL1 = 49432;
  ARM64_SYSREG_APIAKEYHI_EL1 = 49417;
  ARM64_SYSREG_APIAKEYLO_EL1 = 49416;
  ARM64_SYSREG_APIBKEYHI_EL1 = 49419;
  ARM64_SYSREG_APIBKEYLO_EL1 = 49418;
  ARM64_SYSREG_BRBCR_EL1 = 35968;
  ARM64_SYSREG_BRBCR_EL12 = 44160;
  ARM64_SYSREG_BRBCR_EL2 = 42112;
  ARM64_SYSREG_BRBFCR_EL1 = 35969;
  ARM64_SYSREG_BRBIDR0_EL1 = 35984;
  ARM64_SYSREG_BRBINF0_EL1 = 35840;
  ARM64_SYSREG_BRBINF10_EL1 = 35920;
  ARM64_SYSREG_BRBINF11_EL1 = 35928;
  ARM64_SYSREG_BRBINF12_EL1 = 35936;
  ARM64_SYSREG_BRBINF13_EL1 = 35944;
  ARM64_SYSREG_BRBINF14_EL1 = 35952;
  ARM64_SYSREG_BRBINF15_EL1 = 35960;
  ARM64_SYSREG_BRBINF16_EL1 = 35844;
  ARM64_SYSREG_BRBINF17_EL1 = 35852;
  ARM64_SYSREG_BRBINF18_EL1 = 35860;
  ARM64_SYSREG_BRBINF19_EL1 = 35868;
  ARM64_SYSREG_BRBINF1_EL1 = 35848;
  ARM64_SYSREG_BRBINF20_EL1 = 35876;
  ARM64_SYSREG_BRBINF21_EL1 = 35884;
  ARM64_SYSREG_BRBINF22_EL1 = 35892;
  ARM64_SYSREG_BRBINF23_EL1 = 35900;
  ARM64_SYSREG_BRBINF24_EL1 = 35908;
  ARM64_SYSREG_BRBINF25_EL1 = 35916;
  ARM64_SYSREG_BRBINF26_EL1 = 35924;
  ARM64_SYSREG_BRBINF27_EL1 = 35932;
  ARM64_SYSREG_BRBINF28_EL1 = 35940;
  ARM64_SYSREG_BRBINF29_EL1 = 35948;
  ARM64_SYSREG_BRBINF2_EL1 = 35856;
  ARM64_SYSREG_BRBINF30_EL1 = 35956;
  ARM64_SYSREG_BRBINF31_EL1 = 35964;
  ARM64_SYSREG_BRBINF3_EL1 = 35864;
  ARM64_SYSREG_BRBINF4_EL1 = 35872;
  ARM64_SYSREG_BRBINF5_EL1 = 35880;
  ARM64_SYSREG_BRBINF6_EL1 = 35888;
  ARM64_SYSREG_BRBINF7_EL1 = 35896;
  ARM64_SYSREG_BRBINF8_EL1 = 35904;
  ARM64_SYSREG_BRBINF9_EL1 = 35912;
  ARM64_SYSREG_BRBINFINJ_EL1 = 35976;
  ARM64_SYSREG_BRBSRC0_EL1 = 35841;
  ARM64_SYSREG_BRBSRC10_EL1 = 35921;
  ARM64_SYSREG_BRBSRC11_EL1 = 35929;
  ARM64_SYSREG_BRBSRC12_EL1 = 35937;
  ARM64_SYSREG_BRBSRC13_EL1 = 35945;
  ARM64_SYSREG_BRBSRC14_EL1 = 35953;
  ARM64_SYSREG_BRBSRC15_EL1 = 35961;
  ARM64_SYSREG_BRBSRC16_EL1 = 35845;
  ARM64_SYSREG_BRBSRC17_EL1 = 35853;
  ARM64_SYSREG_BRBSRC18_EL1 = 35861;
  ARM64_SYSREG_BRBSRC19_EL1 = 35869;
  ARM64_SYSREG_BRBSRC1_EL1 = 35849;
  ARM64_SYSREG_BRBSRC20_EL1 = 35877;
  ARM64_SYSREG_BRBSRC21_EL1 = 35885;
  ARM64_SYSREG_BRBSRC22_EL1 = 35893;
  ARM64_SYSREG_BRBSRC23_EL1 = 35901;
  ARM64_SYSREG_BRBSRC24_EL1 = 35909;
  ARM64_SYSREG_BRBSRC25_EL1 = 35917;
  ARM64_SYSREG_BRBSRC26_EL1 = 35925;
  ARM64_SYSREG_BRBSRC27_EL1 = 35933;
  ARM64_SYSREG_BRBSRC28_EL1 = 35941;
  ARM64_SYSREG_BRBSRC29_EL1 = 35949;
  ARM64_SYSREG_BRBSRC2_EL1 = 35857;
  ARM64_SYSREG_BRBSRC30_EL1 = 35957;
  ARM64_SYSREG_BRBSRC31_EL1 = 35965;
  ARM64_SYSREG_BRBSRC3_EL1 = 35865;
  ARM64_SYSREG_BRBSRC4_EL1 = 35873;
  ARM64_SYSREG_BRBSRC5_EL1 = 35881;
  ARM64_SYSREG_BRBSRC6_EL1 = 35889;
  ARM64_SYSREG_BRBSRC7_EL1 = 35897;
  ARM64_SYSREG_BRBSRC8_EL1 = 35905;
  ARM64_SYSREG_BRBSRC9_EL1 = 35913;
  ARM64_SYSREG_BRBSRCINJ_EL1 = 35977;
  ARM64_SYSREG_BRBTGT0_EL1 = 35842;
  ARM64_SYSREG_BRBTGT10_EL1 = 35922;
  ARM64_SYSREG_BRBTGT11_EL1 = 35930;
  ARM64_SYSREG_BRBTGT12_EL1 = 35938;
  ARM64_SYSREG_BRBTGT13_EL1 = 35946;
  ARM64_SYSREG_BRBTGT14_EL1 = 35954;
  ARM64_SYSREG_BRBTGT15_EL1 = 35962;
  ARM64_SYSREG_BRBTGT16_EL1 = 35846;
  ARM64_SYSREG_BRBTGT17_EL1 = 35854;
  ARM64_SYSREG_BRBTGT18_EL1 = 35862;
  ARM64_SYSREG_BRBTGT19_EL1 = 35870;
  ARM64_SYSREG_BRBTGT1_EL1 = 35850;
  ARM64_SYSREG_BRBTGT20_EL1 = 35878;
  ARM64_SYSREG_BRBTGT21_EL1 = 35886;
  ARM64_SYSREG_BRBTGT22_EL1 = 35894;
  ARM64_SYSREG_BRBTGT23_EL1 = 35902;
  ARM64_SYSREG_BRBTGT24_EL1 = 35910;
  ARM64_SYSREG_BRBTGT25_EL1 = 35918;
  ARM64_SYSREG_BRBTGT26_EL1 = 35926;
  ARM64_SYSREG_BRBTGT27_EL1 = 35934;
  ARM64_SYSREG_BRBTGT28_EL1 = 35942;
  ARM64_SYSREG_BRBTGT29_EL1 = 35950;
  ARM64_SYSREG_BRBTGT2_EL1 = 35858;
  ARM64_SYSREG_BRBTGT30_EL1 = 35958;
  ARM64_SYSREG_BRBTGT31_EL1 = 35966;
  ARM64_SYSREG_BRBTGT3_EL1 = 35866;
  ARM64_SYSREG_BRBTGT4_EL1 = 35874;
  ARM64_SYSREG_BRBTGT5_EL1 = 35882;
  ARM64_SYSREG_BRBTGT6_EL1 = 35890;
  ARM64_SYSREG_BRBTGT7_EL1 = 35898;
  ARM64_SYSREG_BRBTGT8_EL1 = 35906;
  ARM64_SYSREG_BRBTGT9_EL1 = 35914;
  ARM64_SYSREG_BRBTGTINJ_EL1 = 35978;
  ARM64_SYSREG_BRBTS_EL1 = 35970;
  ARM64_SYSREG_CCSIDR2_EL1 = 51202;
  ARM64_SYSREG_CCSIDR_EL1 = 51200;
  ARM64_SYSREG_CLIDR_EL1 = 51201;
  ARM64_SYSREG_CNTFRQ_EL0 = 57088;
  ARM64_SYSREG_CNTHCTL_EL2 = 59144;
  ARM64_SYSREG_CNTHPS_CTL_EL2 = 59177;
  ARM64_SYSREG_CNTHPS_CVAL_EL2 = 59178;
  ARM64_SYSREG_CNTHPS_TVAL_EL2 = 59176;
  ARM64_SYSREG_CNTHP_CTL_EL2 = 59153;
  ARM64_SYSREG_CNTHP_CVAL_EL2 = 59154;
  ARM64_SYSREG_CNTHP_TVAL_EL2 = 59152;
  ARM64_SYSREG_CNTHVS_CTL_EL2 = 59169;
  ARM64_SYSREG_CNTHVS_CVAL_EL2 = 59170;
  ARM64_SYSREG_CNTHVS_TVAL_EL2 = 59168;
  ARM64_SYSREG_CNTHV_CTL_EL2 = 59161;
  ARM64_SYSREG_CNTHV_CVAL_EL2 = 59162;
  ARM64_SYSREG_CNTHV_TVAL_EL2 = 59160;
  ARM64_SYSREG_CNTISCALE_EL2 = 59141;
  ARM64_SYSREG_CNTKCTL_EL1 = 50952;
  ARM64_SYSREG_CNTKCTL_EL12 = 61192;
  ARM64_SYSREG_CNTPCTSS_EL0 = 57093;
  ARM64_SYSREG_CNTPCT_EL0 = 57089;
  ARM64_SYSREG_CNTPOFF_EL2 = 59142;
  ARM64_SYSREG_CNTPS_CTL_EL1 = 65297;
  ARM64_SYSREG_CNTPS_CVAL_EL1 = 65298;
  ARM64_SYSREG_CNTPS_TVAL_EL1 = 65296;
  ARM64_SYSREG_CNTP_CTL_EL0 = 57105;
  ARM64_SYSREG_CNTP_CTL_EL02 = 61201;
  ARM64_SYSREG_CNTP_CVAL_EL0 = 57106;
  ARM64_SYSREG_CNTP_CVAL_EL02 = 61202;
  ARM64_SYSREG_CNTP_TVAL_EL0 = 57104;
  ARM64_SYSREG_CNTP_TVAL_EL02 = 61200;
  ARM64_SYSREG_CNTSCALE_EL2 = 59140;
  ARM64_SYSREG_CNTVCTSS_EL0 = 57094;
  ARM64_SYSREG_CNTVCT_EL0 = 57090;
  ARM64_SYSREG_CNTVFRQ_EL2 = 59143;
  ARM64_SYSREG_CNTVOFF_EL2 = 59139;
  ARM64_SYSREG_CNTV_CTL_EL0 = 57113;
  ARM64_SYSREG_CNTV_CTL_EL02 = 61209;
  ARM64_SYSREG_CNTV_CVAL_EL0 = 57114;
  ARM64_SYSREG_CNTV_CVAL_EL02 = 61210;
  ARM64_SYSREG_CNTV_TVAL_EL0 = 57112;
  ARM64_SYSREG_CNTV_TVAL_EL02 = 61208;
  ARM64_SYSREG_CONTEXTIDR_EL1 = 50817;
  ARM64_SYSREG_CONTEXTIDR_EL12 = 61057;
  ARM64_SYSREG_CONTEXTIDR_EL2 = 59009;
  ARM64_SYSREG_CPACR_EL1 = 49282;
  ARM64_SYSREG_CPACR_EL12 = 59522;
  ARM64_SYSREG_CPM_IOACC_CTL_EL3 = 65424;
  ARM64_SYSREG_CPTR_EL2 = 57482;
  ARM64_SYSREG_CPTR_EL3 = 61578;
  ARM64_SYSREG_CSSELR_EL1 = 53248;
  ARM64_SYSREG_CTR_EL0 = 55297;
  ARM64_SYSREG_CURRENTEL = 49682;
  ARM64_SYSREG_DACR32_EL2 = 57728;
  ARM64_SYSREG_DAIF = 55825;
  ARM64_SYSREG_DBGAUTHSTATUS_EL1 = 33782;
  ARM64_SYSREG_DBGBCR0_EL1 = 32773;
  ARM64_SYSREG_DBGBCR10_EL1 = 32853;
  ARM64_SYSREG_DBGBCR11_EL1 = 32861;
  ARM64_SYSREG_DBGBCR12_EL1 = 32869;
  ARM64_SYSREG_DBGBCR13_EL1 = 32877;
  ARM64_SYSREG_DBGBCR14_EL1 = 32885;
  ARM64_SYSREG_DBGBCR15_EL1 = 32893;
  ARM64_SYSREG_DBGBCR1_EL1 = 32781;
  ARM64_SYSREG_DBGBCR2_EL1 = 32789;
  ARM64_SYSREG_DBGBCR3_EL1 = 32797;
  ARM64_SYSREG_DBGBCR4_EL1 = 32805;
  ARM64_SYSREG_DBGBCR5_EL1 = 32813;
  ARM64_SYSREG_DBGBCR6_EL1 = 32821;
  ARM64_SYSREG_DBGBCR7_EL1 = 32829;
  ARM64_SYSREG_DBGBCR8_EL1 = 32837;
  ARM64_SYSREG_DBGBCR9_EL1 = 32845;
  ARM64_SYSREG_DBGBVR0_EL1 = 32772;
  ARM64_SYSREG_DBGBVR10_EL1 = 32852;
  ARM64_SYSREG_DBGBVR11_EL1 = 32860;
  ARM64_SYSREG_DBGBVR12_EL1 = 32868;
  ARM64_SYSREG_DBGBVR13_EL1 = 32876;
  ARM64_SYSREG_DBGBVR14_EL1 = 32884;
  ARM64_SYSREG_DBGBVR15_EL1 = 32892;
  ARM64_SYSREG_DBGBVR1_EL1 = 32780;
  ARM64_SYSREG_DBGBVR2_EL1 = 32788;
  ARM64_SYSREG_DBGBVR3_EL1 = 32796;
  ARM64_SYSREG_DBGBVR4_EL1 = 32804;
  ARM64_SYSREG_DBGBVR5_EL1 = 32812;
  ARM64_SYSREG_DBGBVR6_EL1 = 32820;
  ARM64_SYSREG_DBGBVR7_EL1 = 32828;
  ARM64_SYSREG_DBGBVR8_EL1 = 32836;
  ARM64_SYSREG_DBGBVR9_EL1 = 32844;
  ARM64_SYSREG_DBGCLAIMCLR_EL1 = 33742;
  ARM64_SYSREG_DBGCLAIMSET_EL1 = 33734;
  ARM64_SYSREG_DBGDTRRX_EL0 = 38952;
  ARM64_SYSREG_DBGDTRTX_EL0 = 38952;
  ARM64_SYSREG_DBGDTR_EL0 = 38944;
  ARM64_SYSREG_DBGPRCR_EL1 = 32932;
  ARM64_SYSREG_DBGVCR32_EL2 = 41016;
  ARM64_SYSREG_DBGWCR0_EL1 = 32775;
  ARM64_SYSREG_DBGWCR10_EL1 = 32855;
  ARM64_SYSREG_DBGWCR11_EL1 = 32863;
  ARM64_SYSREG_DBGWCR12_EL1 = 32871;
  ARM64_SYSREG_DBGWCR13_EL1 = 32879;
  ARM64_SYSREG_DBGWCR14_EL1 = 32887;
  ARM64_SYSREG_DBGWCR15_EL1 = 32895;
  ARM64_SYSREG_DBGWCR1_EL1 = 32783;
  ARM64_SYSREG_DBGWCR2_EL1 = 32791;
  ARM64_SYSREG_DBGWCR3_EL1 = 32799;
  ARM64_SYSREG_DBGWCR4_EL1 = 32807;
  ARM64_SYSREG_DBGWCR5_EL1 = 32815;
  ARM64_SYSREG_DBGWCR6_EL1 = 32823;
  ARM64_SYSREG_DBGWCR7_EL1 = 32831;
  ARM64_SYSREG_DBGWCR8_EL1 = 32839;
  ARM64_SYSREG_DBGWCR9_EL1 = 32847;
  ARM64_SYSREG_DBGWVR0_EL1 = 32774;
  ARM64_SYSREG_DBGWVR10_EL1 = 32854;
  ARM64_SYSREG_DBGWVR11_EL1 = 32862;
  ARM64_SYSREG_DBGWVR12_EL1 = 32870;
  ARM64_SYSREG_DBGWVR13_EL1 = 32878;
  ARM64_SYSREG_DBGWVR14_EL1 = 32886;
  ARM64_SYSREG_DBGWVR15_EL1 = 32894;
  ARM64_SYSREG_DBGWVR1_EL1 = 32782;
  ARM64_SYSREG_DBGWVR2_EL1 = 32790;
  ARM64_SYSREG_DBGWVR3_EL1 = 32798;
  ARM64_SYSREG_DBGWVR4_EL1 = 32806;
  ARM64_SYSREG_DBGWVR5_EL1 = 32814;
  ARM64_SYSREG_DBGWVR6_EL1 = 32822;
  ARM64_SYSREG_DBGWVR7_EL1 = 32830;
  ARM64_SYSREG_DBGWVR8_EL1 = 32838;
  ARM64_SYSREG_DBGWVR9_EL1 = 32846;
  ARM64_SYSREG_DCZID_EL0 = 55303;
  ARM64_SYSREG_DISR_EL1 = 50697;
  ARM64_SYSREG_DIT = 55829;
  ARM64_SYSREG_DLR_EL0 = 55849;
  ARM64_SYSREG_DSPSR_EL0 = 55848;
  ARM64_SYSREG_ELR_EL1 = 49665;
  ARM64_SYSREG_ELR_EL12 = 59905;
  ARM64_SYSREG_ELR_EL2 = 57857;
  ARM64_SYSREG_ELR_EL3 = 61953;
  ARM64_SYSREG_ERRIDR_EL1 = 49816;
  ARM64_SYSREG_ERRSELR_EL1 = 49817;
  ARM64_SYSREG_ERXADDR_EL1 = 49827;
  ARM64_SYSREG_ERXCTLR_EL1 = 49825;
  ARM64_SYSREG_ERXFR_EL1 = 49824;
  ARM64_SYSREG_ERXMISC0_EL1 = 49832;
  ARM64_SYSREG_ERXMISC1_EL1 = 49833;
  ARM64_SYSREG_ERXMISC2_EL1 = 49834;
  ARM64_SYSREG_ERXMISC3_EL1 = 49835;
  ARM64_SYSREG_ERXPFGCDN_EL1 = 49830;
  ARM64_SYSREG_ERXPFGCTL_EL1 = 49829;
  ARM64_SYSREG_ERXPFGF_EL1 = 49828;
  ARM64_SYSREG_ERXSTATUS_EL1 = 49826;
  ARM64_SYSREG_ESR_EL1 = 49808;
  ARM64_SYSREG_ESR_EL12 = 60048;
  ARM64_SYSREG_ESR_EL2 = 58000;
  ARM64_SYSREG_ESR_EL3 = 62096;
  ARM64_SYSREG_FAR_EL1 = 49920;
  ARM64_SYSREG_FAR_EL12 = 60160;
  ARM64_SYSREG_FAR_EL2 = 58112;
  ARM64_SYSREG_FAR_EL3 = 62208;
  ARM64_SYSREG_FPCR = 55840;
  ARM64_SYSREG_FPEXC32_EL2 = 58008;
  ARM64_SYSREG_FPSR = 55841;
  ARM64_SYSREG_GCR_EL1 = 49286;
  ARM64_SYSREG_GMID_EL1 = 51204;
  ARM64_SYSREG_GPCCR_EL3 = 61710;
  ARM64_SYSREG_GPTBR_EL3 = 61708;
  ARM64_SYSREG_HACR_EL2 = 57487;
  ARM64_SYSREG_HCRX_EL2 = 57490;
  ARM64_SYSREG_HCR_EL2 = 57480;
  ARM64_SYSREG_HDFGRTR_EL2 = 57740;
  ARM64_SYSREG_HDFGWTR_EL2 = 57741;
  ARM64_SYSREG_HFGITR_EL2 = 57486;
  ARM64_SYSREG_HFGRTR_EL2 = 57484;
  ARM64_SYSREG_HFGWTR_EL2 = 57485;
  ARM64_SYSREG_HPFAR_EL2 = 58116;
  ARM64_SYSREG_HSTR_EL2 = 57483;
  ARM64_SYSREG_ICC_AP0R0_EL1 = 50756;
  ARM64_SYSREG_ICC_AP0R1_EL1 = 50757;
  ARM64_SYSREG_ICC_AP0R2_EL1 = 50758;
  ARM64_SYSREG_ICC_AP0R3_EL1 = 50759;
  ARM64_SYSREG_ICC_AP1R0_EL1 = 50760;
  ARM64_SYSREG_ICC_AP1R1_EL1 = 50761;
  ARM64_SYSREG_ICC_AP1R2_EL1 = 50762;
  ARM64_SYSREG_ICC_AP1R3_EL1 = 50763;
  ARM64_SYSREG_ICC_ASGI1R_EL1 = 50782;
  ARM64_SYSREG_ICC_BPR0_EL1 = 50755;
  ARM64_SYSREG_ICC_BPR1_EL1 = 50787;
  ARM64_SYSREG_ICC_CTLR_EL1 = 50788;
  ARM64_SYSREG_ICC_CTLR_EL3 = 63076;
  ARM64_SYSREG_ICC_DIR_EL1 = 50777;
  ARM64_SYSREG_ICC_EOIR0_EL1 = 50753;
  ARM64_SYSREG_ICC_EOIR1_EL1 = 50785;
  ARM64_SYSREG_ICC_HPPIR0_EL1 = 50754;
  ARM64_SYSREG_ICC_HPPIR1_EL1 = 50786;
  ARM64_SYSREG_ICC_IAR0_EL1 = 50752;
  ARM64_SYSREG_ICC_IAR1_EL1 = 50784;
  ARM64_SYSREG_ICC_IGRPEN0_EL1 = 50790;
  ARM64_SYSREG_ICC_IGRPEN1_EL1 = 50791;
  ARM64_SYSREG_ICC_IGRPEN1_EL3 = 63079;
  ARM64_SYSREG_ICC_PMR_EL1 = 49712;
  ARM64_SYSREG_ICC_RPR_EL1 = 50779;
  ARM64_SYSREG_ICC_SGI0R_EL1 = 50783;
  ARM64_SYSREG_ICC_SGI1R_EL1 = 50781;
  ARM64_SYSREG_ICC_SRE_EL1 = 50789;
  ARM64_SYSREG_ICC_SRE_EL2 = 58957;
  ARM64_SYSREG_ICC_SRE_EL3 = 63077;
  ARM64_SYSREG_ICH_AP0R0_EL2 = 58944;
  ARM64_SYSREG_ICH_AP0R1_EL2 = 58945;
  ARM64_SYSREG_ICH_AP0R2_EL2 = 58946;
  ARM64_SYSREG_ICH_AP0R3_EL2 = 58947;
  ARM64_SYSREG_ICH_AP1R0_EL2 = 58952;
  ARM64_SYSREG_ICH_AP1R1_EL2 = 58953;
  ARM64_SYSREG_ICH_AP1R2_EL2 = 58954;
  ARM64_SYSREG_ICH_AP1R3_EL2 = 58955;
  ARM64_SYSREG_ICH_EISR_EL2 = 58971;
  ARM64_SYSREG_ICH_ELRSR_EL2 = 58973;
  ARM64_SYSREG_ICH_HCR_EL2 = 58968;
  ARM64_SYSREG_ICH_LR0_EL2 = 58976;
  ARM64_SYSREG_ICH_LR10_EL2 = 58986;
  ARM64_SYSREG_ICH_LR11_EL2 = 58987;
  ARM64_SYSREG_ICH_LR12_EL2 = 58988;
  ARM64_SYSREG_ICH_LR13_EL2 = 58989;
  ARM64_SYSREG_ICH_LR14_EL2 = 58990;
  ARM64_SYSREG_ICH_LR15_EL2 = 58991;
  ARM64_SYSREG_ICH_LR1_EL2 = 58977;
  ARM64_SYSREG_ICH_LR2_EL2 = 58978;
  ARM64_SYSREG_ICH_LR3_EL2 = 58979;
  ARM64_SYSREG_ICH_LR4_EL2 = 58980;
  ARM64_SYSREG_ICH_LR5_EL2 = 58981;
  ARM64_SYSREG_ICH_LR6_EL2 = 58982;
  ARM64_SYSREG_ICH_LR7_EL2 = 58983;
  ARM64_SYSREG_ICH_LR8_EL2 = 58984;
  ARM64_SYSREG_ICH_LR9_EL2 = 58985;
  ARM64_SYSREG_ICH_MISR_EL2 = 58970;
  ARM64_SYSREG_ICH_VMCR_EL2 = 58975;
  ARM64_SYSREG_ICH_VTR_EL2 = 58969;
  ARM64_SYSREG_ID_AA64AFR0_EL1 = 49196;
  ARM64_SYSREG_ID_AA64AFR1_EL1 = 49197;
  ARM64_SYSREG_ID_AA64DFR0_EL1 = 49192;
  ARM64_SYSREG_ID_AA64DFR1_EL1 = 49193;
  ARM64_SYSREG_ID_AA64ISAR0_EL1 = 49200;
  ARM64_SYSREG_ID_AA64ISAR1_EL1 = 49201;
  ARM64_SYSREG_ID_AA64ISAR2_EL1 = 49202;
  ARM64_SYSREG_ID_AA64MMFR0_EL1 = 49208;
  ARM64_SYSREG_ID_AA64MMFR1_EL1 = 49209;
  ARM64_SYSREG_ID_AA64MMFR2_EL1 = 49210;
  ARM64_SYSREG_ID_AA64PFR0_EL1 = 49184;
  ARM64_SYSREG_ID_AA64PFR1_EL1 = 49185;
  ARM64_SYSREG_ID_AA64SMFR0_EL1 = 49189;
  ARM64_SYSREG_ID_AA64ZFR0_EL1 = 49188;
  ARM64_SYSREG_ID_AFR0_EL1 = 49163;
  ARM64_SYSREG_ID_DFR0_EL1 = 49162;
  ARM64_SYSREG_ID_ISAR0_EL1 = 49168;
  ARM64_SYSREG_ID_ISAR1_EL1 = 49169;
  ARM64_SYSREG_ID_ISAR2_EL1 = 49170;
  ARM64_SYSREG_ID_ISAR3_EL1 = 49171;
  ARM64_SYSREG_ID_ISAR4_EL1 = 49172;
  ARM64_SYSREG_ID_ISAR5_EL1 = 49173;
  ARM64_SYSREG_ID_ISAR6_EL1 = 49175;
  ARM64_SYSREG_ID_MMFR0_EL1 = 49164;
  ARM64_SYSREG_ID_MMFR1_EL1 = 49165;
  ARM64_SYSREG_ID_MMFR2_EL1 = 49166;
  ARM64_SYSREG_ID_MMFR3_EL1 = 49167;
  ARM64_SYSREG_ID_MMFR4_EL1 = 49174;
  ARM64_SYSREG_ID_MMFR5_EL1 = 49182;
  ARM64_SYSREG_ID_PFR0_EL1 = 49160;
  ARM64_SYSREG_ID_PFR1_EL1 = 49161;
  ARM64_SYSREG_ID_PFR2_EL1 = 49180;
  ARM64_SYSREG_IFSR32_EL2 = 57985;
  ARM64_SYSREG_ISR_EL1 = 50696;
  ARM64_SYSREG_LORC_EL1 = 50467;
  ARM64_SYSREG_LOREA_EL1 = 50465;
  ARM64_SYSREG_LORID_EL1 = 50471;
  ARM64_SYSREG_LORN_EL1 = 50466;
  ARM64_SYSREG_LORSA_EL1 = 50464;
  ARM64_SYSREG_MAIR_EL1 = 50448;
  ARM64_SYSREG_MAIR_EL12 = 60688;
  ARM64_SYSREG_MAIR_EL2 = 58640;
  ARM64_SYSREG_MAIR_EL3 = 62736;
  ARM64_SYSREG_MDCCINT_EL1 = 32784;
  ARM64_SYSREG_MDCCSR_EL0 = 38920;
  ARM64_SYSREG_MDCR_EL2 = 57481;
  ARM64_SYSREG_MDCR_EL3 = 61593;
  ARM64_SYSREG_MDRAR_EL1 = 32896;
  ARM64_SYSREG_MDSCR_EL1 = 32786;
  ARM64_SYSREG_MFAR_EL3 = 62213;
  ARM64_SYSREG_MIDR_EL1 = 49152;
  ARM64_SYSREG_MPAM0_EL1 = 50473;
  ARM64_SYSREG_MPAM1_EL1 = 50472;
  ARM64_SYSREG_MPAM1_EL12 = 60712;
  ARM64_SYSREG_MPAM2_EL2 = 58664;
  ARM64_SYSREG_MPAM3_EL3 = 62760;
  ARM64_SYSREG_MPAMHCR_EL2 = 58656;
  ARM64_SYSREG_MPAMIDR_EL1 = 50468;
  ARM64_SYSREG_MPAMSM_EL1 = 50475;
  ARM64_SYSREG_MPAMVPM0_EL2 = 58672;
  ARM64_SYSREG_MPAMVPM1_EL2 = 58673;
  ARM64_SYSREG_MPAMVPM2_EL2 = 58674;
  ARM64_SYSREG_MPAMVPM3_EL2 = 58675;
  ARM64_SYSREG_MPAMVPM4_EL2 = 58676;
  ARM64_SYSREG_MPAMVPM5_EL2 = 58677;
  ARM64_SYSREG_MPAMVPM6_EL2 = 58678;
  ARM64_SYSREG_MPAMVPM7_EL2 = 58679;
  ARM64_SYSREG_MPAMVPMV_EL2 = 58657;
  ARM64_SYSREG_MPIDR_EL1 = 49157;
  ARM64_SYSREG_MPUIR_EL1 = 49156;
  ARM64_SYSREG_MPUIR_EL2 = 57348;
  ARM64_SYSREG_MVFR0_EL1 = 49176;
  ARM64_SYSREG_MVFR1_EL1 = 49177;
  ARM64_SYSREG_MVFR2_EL1 = 49178;
  ARM64_SYSREG_NZCV = 55824;
  ARM64_SYSREG_OSDLR_EL1 = 32924;
  ARM64_SYSREG_OSDTRRX_EL1 = 32770;
  ARM64_SYSREG_OSDTRTX_EL1 = 32794;
  ARM64_SYSREG_OSECCR_EL1 = 32818;
  ARM64_SYSREG_OSLAR_EL1 = 32900;
  ARM64_SYSREG_OSLSR_EL1 = 32908;
  ARM64_SYSREG_PAN = 49683;
  ARM64_SYSREG_PAR_EL1 = 50080;
  ARM64_SYSREG_PMBIDR_EL1 = 50391;
  ARM64_SYSREG_PMBLIMITR_EL1 = 50384;
  ARM64_SYSREG_PMBPTR_EL1 = 50385;
  ARM64_SYSREG_PMBSR_EL1 = 50387;
  ARM64_SYSREG_PMCCFILTR_EL0 = 57215;
  ARM64_SYSREG_PMCCNTR_EL0 = 56552;
  ARM64_SYSREG_PMCEID0_EL0 = 56550;
  ARM64_SYSREG_PMCEID1_EL0 = 56551;
  ARM64_SYSREG_PMCNTENCLR_EL0 = 56546;
  ARM64_SYSREG_PMCNTENSET_EL0 = 56545;
  ARM64_SYSREG_PMCR_EL0 = 56544;
  ARM64_SYSREG_PMEVCNTR0_EL0 = 57152;
  ARM64_SYSREG_PMEVCNTR10_EL0 = 57162;
  ARM64_SYSREG_PMEVCNTR11_EL0 = 57163;
  ARM64_SYSREG_PMEVCNTR12_EL0 = 57164;
  ARM64_SYSREG_PMEVCNTR13_EL0 = 57165;
  ARM64_SYSREG_PMEVCNTR14_EL0 = 57166;
  ARM64_SYSREG_PMEVCNTR15_EL0 = 57167;
  ARM64_SYSREG_PMEVCNTR16_EL0 = 57168;
  ARM64_SYSREG_PMEVCNTR17_EL0 = 57169;
  ARM64_SYSREG_PMEVCNTR18_EL0 = 57170;
  ARM64_SYSREG_PMEVCNTR19_EL0 = 57171;
  ARM64_SYSREG_PMEVCNTR1_EL0 = 57153;
  ARM64_SYSREG_PMEVCNTR20_EL0 = 57172;
  ARM64_SYSREG_PMEVCNTR21_EL0 = 57173;
  ARM64_SYSREG_PMEVCNTR22_EL0 = 57174;
  ARM64_SYSREG_PMEVCNTR23_EL0 = 57175;
  ARM64_SYSREG_PMEVCNTR24_EL0 = 57176;
  ARM64_SYSREG_PMEVCNTR25_EL0 = 57177;
  ARM64_SYSREG_PMEVCNTR26_EL0 = 57178;
  ARM64_SYSREG_PMEVCNTR27_EL0 = 57179;
  ARM64_SYSREG_PMEVCNTR28_EL0 = 57180;
  ARM64_SYSREG_PMEVCNTR29_EL0 = 57181;
  ARM64_SYSREG_PMEVCNTR2_EL0 = 57154;
  ARM64_SYSREG_PMEVCNTR30_EL0 = 57182;
  ARM64_SYSREG_PMEVCNTR3_EL0 = 57155;
  ARM64_SYSREG_PMEVCNTR4_EL0 = 57156;
  ARM64_SYSREG_PMEVCNTR5_EL0 = 57157;
  ARM64_SYSREG_PMEVCNTR6_EL0 = 57158;
  ARM64_SYSREG_PMEVCNTR7_EL0 = 57159;
  ARM64_SYSREG_PMEVCNTR8_EL0 = 57160;
  ARM64_SYSREG_PMEVCNTR9_EL0 = 57161;
  ARM64_SYSREG_PMEVTYPER0_EL0 = 57184;
  ARM64_SYSREG_PMEVTYPER10_EL0 = 57194;
  ARM64_SYSREG_PMEVTYPER11_EL0 = 57195;
  ARM64_SYSREG_PMEVTYPER12_EL0 = 57196;
  ARM64_SYSREG_PMEVTYPER13_EL0 = 57197;
  ARM64_SYSREG_PMEVTYPER14_EL0 = 57198;
  ARM64_SYSREG_PMEVTYPER15_EL0 = 57199;
  ARM64_SYSREG_PMEVTYPER16_EL0 = 57200;
  ARM64_SYSREG_PMEVTYPER17_EL0 = 57201;
  ARM64_SYSREG_PMEVTYPER18_EL0 = 57202;
  ARM64_SYSREG_PMEVTYPER19_EL0 = 57203;
  ARM64_SYSREG_PMEVTYPER1_EL0 = 57185;
  ARM64_SYSREG_PMEVTYPER20_EL0 = 57204;
  ARM64_SYSREG_PMEVTYPER21_EL0 = 57205;
  ARM64_SYSREG_PMEVTYPER22_EL0 = 57206;
  ARM64_SYSREG_PMEVTYPER23_EL0 = 57207;
  ARM64_SYSREG_PMEVTYPER24_EL0 = 57208;
  ARM64_SYSREG_PMEVTYPER25_EL0 = 57209;
  ARM64_SYSREG_PMEVTYPER26_EL0 = 57210;
  ARM64_SYSREG_PMEVTYPER27_EL0 = 57211;
  ARM64_SYSREG_PMEVTYPER28_EL0 = 57212;
  ARM64_SYSREG_PMEVTYPER29_EL0 = 57213;
  ARM64_SYSREG_PMEVTYPER2_EL0 = 57186;
  ARM64_SYSREG_PMEVTYPER30_EL0 = 57214;
  ARM64_SYSREG_PMEVTYPER3_EL0 = 57187;
  ARM64_SYSREG_PMEVTYPER4_EL0 = 57188;
  ARM64_SYSREG_PMEVTYPER5_EL0 = 57189;
  ARM64_SYSREG_PMEVTYPER6_EL0 = 57190;
  ARM64_SYSREG_PMEVTYPER7_EL0 = 57191;
  ARM64_SYSREG_PMEVTYPER8_EL0 = 57192;
  ARM64_SYSREG_PMEVTYPER9_EL0 = 57193;
  ARM64_SYSREG_PMINTENCLR_EL1 = 50418;
  ARM64_SYSREG_PMINTENSET_EL1 = 50417;
  ARM64_SYSREG_PMMIR_EL1 = 50422;
  ARM64_SYSREG_PMOVSCLR_EL0 = 56547;
  ARM64_SYSREG_PMOVSSET_EL0 = 56563;
  ARM64_SYSREG_PMSCR_EL1 = 50376;
  ARM64_SYSREG_PMSCR_EL12 = 60616;
  ARM64_SYSREG_PMSCR_EL2 = 58568;
  ARM64_SYSREG_PMSELR_EL0 = 56549;
  ARM64_SYSREG_PMSEVFR_EL1 = 50381;
  ARM64_SYSREG_PMSFCR_EL1 = 50380;
  ARM64_SYSREG_PMSICR_EL1 = 50378;
  ARM64_SYSREG_PMSIDR_EL1 = 50383;
  ARM64_SYSREG_PMSIRR_EL1 = 50379;
  ARM64_SYSREG_PMSLATFR_EL1 = 50382;
  ARM64_SYSREG_PMSNEVFR_EL1 = 50377;
  ARM64_SYSREG_PMSWINC_EL0 = 56548;
  ARM64_SYSREG_PMUSERENR_EL0 = 56560;
  ARM64_SYSREG_PMXEVCNTR_EL0 = 56554;
  ARM64_SYSREG_PMXEVTYPER_EL0 = 56553;
  ARM64_SYSREG_PRBAR10_EL1 = 50024;
  ARM64_SYSREG_PRBAR10_EL2 = 58216;
  ARM64_SYSREG_PRBAR11_EL1 = 50028;
  ARM64_SYSREG_PRBAR11_EL2 = 58220;
  ARM64_SYSREG_PRBAR12_EL1 = 50032;
  ARM64_SYSREG_PRBAR12_EL2 = 58224;
  ARM64_SYSREG_PRBAR13_EL1 = 50036;
  ARM64_SYSREG_PRBAR13_EL2 = 58228;
  ARM64_SYSREG_PRBAR14_EL1 = 50040;
  ARM64_SYSREG_PRBAR14_EL2 = 58232;
  ARM64_SYSREG_PRBAR15_EL1 = 50044;
  ARM64_SYSREG_PRBAR15_EL2 = 58236;
  ARM64_SYSREG_PRBAR1_EL1 = 49988;
  ARM64_SYSREG_PRBAR1_EL2 = 58180;
  ARM64_SYSREG_PRBAR2_EL1 = 49992;
  ARM64_SYSREG_PRBAR2_EL2 = 58184;
  ARM64_SYSREG_PRBAR3_EL1 = 49996;
  ARM64_SYSREG_PRBAR3_EL2 = 58188;
  ARM64_SYSREG_PRBAR4_EL1 = 50000;
  ARM64_SYSREG_PRBAR4_EL2 = 58192;
  ARM64_SYSREG_PRBAR5_EL1 = 50004;
  ARM64_SYSREG_PRBAR5_EL2 = 58196;
  ARM64_SYSREG_PRBAR6_EL1 = 50008;
  ARM64_SYSREG_PRBAR6_EL2 = 58200;
  ARM64_SYSREG_PRBAR7_EL1 = 50012;
  ARM64_SYSREG_PRBAR7_EL2 = 58204;
  ARM64_SYSREG_PRBAR8_EL1 = 50016;
  ARM64_SYSREG_PRBAR8_EL2 = 58208;
  ARM64_SYSREG_PRBAR9_EL1 = 50020;
  ARM64_SYSREG_PRBAR9_EL2 = 58212;
  ARM64_SYSREG_PRBAR_EL1 = 49984;
  ARM64_SYSREG_PRBAR_EL2 = 58176;
  ARM64_SYSREG_PRENR_EL1 = 49929;
  ARM64_SYSREG_PRENR_EL2 = 58121;
  ARM64_SYSREG_PRLAR10_EL1 = 50025;
  ARM64_SYSREG_PRLAR10_EL2 = 58217;
  ARM64_SYSREG_PRLAR11_EL1 = 50029;
  ARM64_SYSREG_PRLAR11_EL2 = 58221;
  ARM64_SYSREG_PRLAR12_EL1 = 50033;
  ARM64_SYSREG_PRLAR12_EL2 = 58225;
  ARM64_SYSREG_PRLAR13_EL1 = 50037;
  ARM64_SYSREG_PRLAR13_EL2 = 58229;
  ARM64_SYSREG_PRLAR14_EL1 = 50041;
  ARM64_SYSREG_PRLAR14_EL2 = 58233;
  ARM64_SYSREG_PRLAR15_EL1 = 50045;
  ARM64_SYSREG_PRLAR15_EL2 = 58237;
  ARM64_SYSREG_PRLAR1_EL1 = 49989;
  ARM64_SYSREG_PRLAR1_EL2 = 58181;
  ARM64_SYSREG_PRLAR2_EL1 = 49993;
  ARM64_SYSREG_PRLAR2_EL2 = 58185;
  ARM64_SYSREG_PRLAR3_EL1 = 49997;
  ARM64_SYSREG_PRLAR3_EL2 = 58189;
  ARM64_SYSREG_PRLAR4_EL1 = 50001;
  ARM64_SYSREG_PRLAR4_EL2 = 58193;
  ARM64_SYSREG_PRLAR5_EL1 = 50005;
  ARM64_SYSREG_PRLAR5_EL2 = 58197;
  ARM64_SYSREG_PRLAR6_EL1 = 50009;
  ARM64_SYSREG_PRLAR6_EL2 = 58201;
  ARM64_SYSREG_PRLAR7_EL1 = 50013;
  ARM64_SYSREG_PRLAR7_EL2 = 58205;
  ARM64_SYSREG_PRLAR8_EL1 = 50017;
  ARM64_SYSREG_PRLAR8_EL2 = 58209;
  ARM64_SYSREG_PRLAR9_EL1 = 50021;
  ARM64_SYSREG_PRLAR9_EL2 = 58213;
  ARM64_SYSREG_PRLAR_EL1 = 49985;
  ARM64_SYSREG_PRLAR_EL2 = 58177;
  ARM64_SYSREG_PRSELR_EL1 = 49937;
  ARM64_SYSREG_PRSELR_EL2 = 58129;
  ARM64_SYSREG_REVIDR_EL1 = 49158;
  ARM64_SYSREG_RGSR_EL1 = 49285;
  ARM64_SYSREG_RMR_EL1 = 50690;
  ARM64_SYSREG_RMR_EL2 = 58882;
  ARM64_SYSREG_RMR_EL3 = 62978;
  ARM64_SYSREG_RNDR = 55584;
  ARM64_SYSREG_RNDRRS = 55585;
  ARM64_SYSREG_RVBAR_EL1 = 50689;
  ARM64_SYSREG_RVBAR_EL2 = 58881;
  ARM64_SYSREG_RVBAR_EL3 = 62977;
  ARM64_SYSREG_SCR_EL3 = 61576;
  ARM64_SYSREG_SCTLR_EL1 = 49280;
  ARM64_SYSREG_SCTLR_EL12 = 59520;
  ARM64_SYSREG_SCTLR_EL2 = 57472;
  ARM64_SYSREG_SCTLR_EL3 = 61568;
  ARM64_SYSREG_SCXTNUM_EL0 = 56967;
  ARM64_SYSREG_SCXTNUM_EL1 = 50823;
  ARM64_SYSREG_SCXTNUM_EL12 = 61063;
  ARM64_SYSREG_SCXTNUM_EL2 = 59015;
  ARM64_SYSREG_SCXTNUM_EL3 = 63111;
  ARM64_SYSREG_SDER32_EL2 = 57497;
  ARM64_SYSREG_SDER32_EL3 = 61577;
  ARM64_SYSREG_SMCR_EL1 = 49302;
  ARM64_SYSREG_SMCR_EL12 = 59542;
  ARM64_SYSREG_SMCR_EL2 = 57494;
  ARM64_SYSREG_SMCR_EL3 = 61590;
  ARM64_SYSREG_SMIDR_EL1 = 51206;
  ARM64_SYSREG_SMPRIMAP_EL2 = 57493;
  ARM64_SYSREG_SMPRI_EL1 = 49300;
  ARM64_SYSREG_SPSEL = 49680;
  ARM64_SYSREG_SPSR_ABT = 57881;
  ARM64_SYSREG_SPSR_EL1 = 49664;
  ARM64_SYSREG_SPSR_EL12 = 59904;
  ARM64_SYSREG_SPSR_EL2 = 57856;
  ARM64_SYSREG_SPSR_EL3 = 61952;
  ARM64_SYSREG_SPSR_FIQ = 57883;
  ARM64_SYSREG_SPSR_IRQ = 57880;
  ARM64_SYSREG_SPSR_UND = 57882;
  ARM64_SYSREG_SP_EL0 = 49672;
  ARM64_SYSREG_SP_EL1 = 57864;
  ARM64_SYSREG_SP_EL2 = 61960;
  ARM64_SYSREG_SSBS = 55830;
  ARM64_SYSREG_SVCR = 55826;
  ARM64_SYSREG_TCO = 55831;
  ARM64_SYSREG_TCR_EL1 = 49410;
  ARM64_SYSREG_TCR_EL12 = 59650;
  ARM64_SYSREG_TCR_EL2 = 57602;
  ARM64_SYSREG_TCR_EL3 = 61698;
  ARM64_SYSREG_TEECR32_EL1 = 36864;
  ARM64_SYSREG_TEEHBR32_EL1 = 36992;
  ARM64_SYSREG_TFSRE0_EL1 = 49841;
  ARM64_SYSREG_TFSR_EL1 = 49840;
  ARM64_SYSREG_TFSR_EL12 = 60080;
  ARM64_SYSREG_TFSR_EL2 = 58032;
  ARM64_SYSREG_TFSR_EL3 = 62128;
  ARM64_SYSREG_TPIDR2_EL0 = 56965;
  ARM64_SYSREG_TPIDRRO_EL0 = 56963;
  ARM64_SYSREG_TPIDR_EL0 = 56962;
  ARM64_SYSREG_TPIDR_EL1 = 50820;
  ARM64_SYSREG_TPIDR_EL2 = 59010;
  ARM64_SYSREG_TPIDR_EL3 = 63106;
  ARM64_SYSREG_TRBBASER_EL1 = 50394;
  ARM64_SYSREG_TRBIDR_EL1 = 50399;
  ARM64_SYSREG_TRBLIMITR_EL1 = 50392;
  ARM64_SYSREG_TRBMAR_EL1 = 50396;
  ARM64_SYSREG_TRBPTR_EL1 = 50393;
  ARM64_SYSREG_TRBSR_EL1 = 50395;
  ARM64_SYSREG_TRBTRG_EL1 = 50398;
  ARM64_SYSREG_TRCACATR0 = 35074;
  ARM64_SYSREG_TRCACATR1 = 35090;
  ARM64_SYSREG_TRCACATR10 = 35107;
  ARM64_SYSREG_TRCACATR11 = 35123;
  ARM64_SYSREG_TRCACATR12 = 35139;
  ARM64_SYSREG_TRCACATR13 = 35155;
  ARM64_SYSREG_TRCACATR14 = 35171;
  ARM64_SYSREG_TRCACATR15 = 35187;
  ARM64_SYSREG_TRCACATR2 = 35106;
  ARM64_SYSREG_TRCACATR3 = 35122;
  ARM64_SYSREG_TRCACATR4 = 35138;
  ARM64_SYSREG_TRCACATR5 = 35154;
  ARM64_SYSREG_TRCACATR6 = 35170;
  ARM64_SYSREG_TRCACATR7 = 35186;
  ARM64_SYSREG_TRCACATR8 = 35075;
  ARM64_SYSREG_TRCACATR9 = 35091;
  ARM64_SYSREG_TRCACVR0 = 35072;
  ARM64_SYSREG_TRCACVR1 = 35088;
  ARM64_SYSREG_TRCACVR10 = 35105;
  ARM64_SYSREG_TRCACVR11 = 35121;
  ARM64_SYSREG_TRCACVR12 = 35137;
  ARM64_SYSREG_TRCACVR13 = 35153;
  ARM64_SYSREG_TRCACVR14 = 35169;
  ARM64_SYSREG_TRCACVR15 = 35185;
  ARM64_SYSREG_TRCACVR2 = 35104;
  ARM64_SYSREG_TRCACVR3 = 35120;
  ARM64_SYSREG_TRCACVR4 = 35136;
  ARM64_SYSREG_TRCACVR5 = 35152;
  ARM64_SYSREG_TRCACVR6 = 35168;
  ARM64_SYSREG_TRCACVR7 = 35184;
  ARM64_SYSREG_TRCACVR8 = 35073;
  ARM64_SYSREG_TRCACVR9 = 35089;
  ARM64_SYSREG_TRCAUTHSTATUS = 35830;
  ARM64_SYSREG_TRCAUXCTLR = 34864;
  ARM64_SYSREG_TRCBBCTLR = 34936;
  ARM64_SYSREG_TRCCCCTLR = 34928;
  ARM64_SYSREG_TRCCIDCCTLR0 = 35202;
  ARM64_SYSREG_TRCCIDCCTLR1 = 35210;
  ARM64_SYSREG_TRCCIDCVR0 = 35200;
  ARM64_SYSREG_TRCCIDCVR1 = 35216;
  ARM64_SYSREG_TRCCIDCVR2 = 35232;
  ARM64_SYSREG_TRCCIDCVR3 = 35248;
  ARM64_SYSREG_TRCCIDCVR4 = 35264;
  ARM64_SYSREG_TRCCIDCVR5 = 35280;
  ARM64_SYSREG_TRCCIDCVR6 = 35296;
  ARM64_SYSREG_TRCCIDCVR7 = 35312;
  ARM64_SYSREG_TRCCIDR0 = 35815;
  ARM64_SYSREG_TRCCIDR1 = 35823;
  ARM64_SYSREG_TRCCIDR2 = 35831;
  ARM64_SYSREG_TRCCIDR3 = 35839;
  ARM64_SYSREG_TRCCLAIMCLR = 35790;
  ARM64_SYSREG_TRCCLAIMSET = 35782;
  ARM64_SYSREG_TRCCNTCTLR0 = 34853;
  ARM64_SYSREG_TRCCNTCTLR1 = 34861;
  ARM64_SYSREG_TRCCNTCTLR2 = 34869;
  ARM64_SYSREG_TRCCNTCTLR3 = 34877;
  ARM64_SYSREG_TRCCNTRLDVR0 = 34821;
  ARM64_SYSREG_TRCCNTRLDVR1 = 34829;
  ARM64_SYSREG_TRCCNTRLDVR2 = 34837;
  ARM64_SYSREG_TRCCNTRLDVR3 = 34845;
  ARM64_SYSREG_TRCCNTVR0 = 34885;
  ARM64_SYSREG_TRCCNTVR1 = 34893;
  ARM64_SYSREG_TRCCNTVR2 = 34901;
  ARM64_SYSREG_TRCCNTVR3 = 34909;
  ARM64_SYSREG_TRCCONFIGR = 34848;
  ARM64_SYSREG_TRCDEVAFF0 = 35798;
  ARM64_SYSREG_TRCDEVAFF1 = 35806;
  ARM64_SYSREG_TRCDEVARCH = 35838;
  ARM64_SYSREG_TRCDEVID = 35735;
  ARM64_SYSREG_TRCDEVTYPE = 35743;
  ARM64_SYSREG_TRCDVCMR0 = 35078;
  ARM64_SYSREG_TRCDVCMR1 = 35110;
  ARM64_SYSREG_TRCDVCMR2 = 35142;
  ARM64_SYSREG_TRCDVCMR3 = 35174;
  ARM64_SYSREG_TRCDVCMR4 = 35079;
  ARM64_SYSREG_TRCDVCMR5 = 35111;
  ARM64_SYSREG_TRCDVCMR6 = 35143;
  ARM64_SYSREG_TRCDVCMR7 = 35175;
  ARM64_SYSREG_TRCDVCVR0 = 35076;
  ARM64_SYSREG_TRCDVCVR1 = 35108;
  ARM64_SYSREG_TRCDVCVR2 = 35140;
  ARM64_SYSREG_TRCDVCVR3 = 35172;
  ARM64_SYSREG_TRCDVCVR4 = 35077;
  ARM64_SYSREG_TRCDVCVR5 = 35109;
  ARM64_SYSREG_TRCDVCVR6 = 35141;
  ARM64_SYSREG_TRCDVCVR7 = 35173;
  ARM64_SYSREG_TRCEVENTCTL0R = 34880;
  ARM64_SYSREG_TRCEVENTCTL1R = 34888;
  ARM64_SYSREG_TRCEXTINSELR = 34884;
  ARM64_SYSREG_TRCEXTINSELR0 = 34884;
  ARM64_SYSREG_TRCEXTINSELR1 = 34892;
  ARM64_SYSREG_TRCEXTINSELR2 = 34900;
  ARM64_SYSREG_TRCEXTINSELR3 = 34908;
  ARM64_SYSREG_TRCIDR0 = 34887;
  ARM64_SYSREG_TRCIDR1 = 34895;
  ARM64_SYSREG_TRCIDR10 = 34838;
  ARM64_SYSREG_TRCIDR11 = 34846;
  ARM64_SYSREG_TRCIDR12 = 34854;
  ARM64_SYSREG_TRCIDR13 = 34862;
  ARM64_SYSREG_TRCIDR2 = 34903;
  ARM64_SYSREG_TRCIDR3 = 34911;
  ARM64_SYSREG_TRCIDR4 = 34919;
  ARM64_SYSREG_TRCIDR5 = 34927;
  ARM64_SYSREG_TRCIDR6 = 34935;
  ARM64_SYSREG_TRCIDR7 = 34943;
  ARM64_SYSREG_TRCIDR8 = 34822;
  ARM64_SYSREG_TRCIDR9 = 34830;
  ARM64_SYSREG_TRCIMSPEC0 = 34823;
  ARM64_SYSREG_TRCIMSPEC1 = 34831;
  ARM64_SYSREG_TRCIMSPEC2 = 34839;
  ARM64_SYSREG_TRCIMSPEC3 = 34847;
  ARM64_SYSREG_TRCIMSPEC4 = 34855;
  ARM64_SYSREG_TRCIMSPEC5 = 34863;
  ARM64_SYSREG_TRCIMSPEC6 = 34871;
  ARM64_SYSREG_TRCIMSPEC7 = 34879;
  ARM64_SYSREG_TRCITCTRL = 35716;
  ARM64_SYSREG_TRCLAR = 35814;
  ARM64_SYSREG_TRCLSR = 35822;
  ARM64_SYSREG_TRCOSLAR = 34948;
  ARM64_SYSREG_TRCOSLSR = 34956;
  ARM64_SYSREG_TRCPDCR = 34980;
  ARM64_SYSREG_TRCPDSR = 34988;
  ARM64_SYSREG_TRCPIDR0 = 35783;
  ARM64_SYSREG_TRCPIDR1 = 35791;
  ARM64_SYSREG_TRCPIDR2 = 35799;
  ARM64_SYSREG_TRCPIDR3 = 35807;
  ARM64_SYSREG_TRCPIDR4 = 35751;
  ARM64_SYSREG_TRCPIDR5 = 35759;
  ARM64_SYSREG_TRCPIDR6 = 35767;
  ARM64_SYSREG_TRCPIDR7 = 35775;
  ARM64_SYSREG_TRCPRGCTLR = 34824;
  ARM64_SYSREG_TRCPROCSELR = 34832;
  ARM64_SYSREG_TRCQCTLR = 34825;
  ARM64_SYSREG_TRCRSCTLR10 = 35024;
  ARM64_SYSREG_TRCRSCTLR11 = 35032;
  ARM64_SYSREG_TRCRSCTLR12 = 35040;
  ARM64_SYSREG_TRCRSCTLR13 = 35048;
  ARM64_SYSREG_TRCRSCTLR14 = 35056;
  ARM64_SYSREG_TRCRSCTLR15 = 35064;
  ARM64_SYSREG_TRCRSCTLR16 = 34945;
  ARM64_SYSREG_TRCRSCTLR17 = 34953;
  ARM64_SYSREG_TRCRSCTLR18 = 34961;
  ARM64_SYSREG_TRCRSCTLR19 = 34969;
  ARM64_SYSREG_TRCRSCTLR2 = 34960;
  ARM64_SYSREG_TRCRSCTLR20 = 34977;
  ARM64_SYSREG_TRCRSCTLR21 = 34985;
  ARM64_SYSREG_TRCRSCTLR22 = 34993;
  ARM64_SYSREG_TRCRSCTLR23 = 35001;
  ARM64_SYSREG_TRCRSCTLR24 = 35009;
  ARM64_SYSREG_TRCRSCTLR25 = 35017;
  ARM64_SYSREG_TRCRSCTLR26 = 35025;
  ARM64_SYSREG_TRCRSCTLR27 = 35033;
  ARM64_SYSREG_TRCRSCTLR28 = 35041;
  ARM64_SYSREG_TRCRSCTLR29 = 35049;
  ARM64_SYSREG_TRCRSCTLR3 = 34968;
  ARM64_SYSREG_TRCRSCTLR30 = 35057;
  ARM64_SYSREG_TRCRSCTLR31 = 35065;
  ARM64_SYSREG_TRCRSCTLR4 = 34976;
  ARM64_SYSREG_TRCRSCTLR5 = 34984;
  ARM64_SYSREG_TRCRSCTLR6 = 34992;
  ARM64_SYSREG_TRCRSCTLR7 = 35000;
  ARM64_SYSREG_TRCRSCTLR8 = 35008;
  ARM64_SYSREG_TRCRSCTLR9 = 35016;
  ARM64_SYSREG_TRCRSR = 34896;
  ARM64_SYSREG_TRCSEQEVR0 = 34820;
  ARM64_SYSREG_TRCSEQEVR1 = 34828;
  ARM64_SYSREG_TRCSEQEVR2 = 34836;
  ARM64_SYSREG_TRCSEQRSTEVR = 34868;
  ARM64_SYSREG_TRCSEQSTR = 34876;
  ARM64_SYSREG_TRCSSCCR0 = 34946;
  ARM64_SYSREG_TRCSSCCR1 = 34954;
  ARM64_SYSREG_TRCSSCCR2 = 34962;
  ARM64_SYSREG_TRCSSCCR3 = 34970;
  ARM64_SYSREG_TRCSSCCR4 = 34978;
  ARM64_SYSREG_TRCSSCCR5 = 34986;
  ARM64_SYSREG_TRCSSCCR6 = 34994;
  ARM64_SYSREG_TRCSSCCR7 = 35002;
  ARM64_SYSREG_TRCSSCSR0 = 35010;
  ARM64_SYSREG_TRCSSCSR1 = 35018;
  ARM64_SYSREG_TRCSSCSR2 = 35026;
  ARM64_SYSREG_TRCSSCSR3 = 35034;
  ARM64_SYSREG_TRCSSCSR4 = 35042;
  ARM64_SYSREG_TRCSSCSR5 = 35050;
  ARM64_SYSREG_TRCSSCSR6 = 35058;
  ARM64_SYSREG_TRCSSCSR7 = 35066;
  ARM64_SYSREG_TRCSSPCICR0 = 34947;
  ARM64_SYSREG_TRCSSPCICR1 = 34955;
  ARM64_SYSREG_TRCSSPCICR2 = 34963;
  ARM64_SYSREG_TRCSSPCICR3 = 34971;
  ARM64_SYSREG_TRCSSPCICR4 = 34979;
  ARM64_SYSREG_TRCSSPCICR5 = 34987;
  ARM64_SYSREG_TRCSSPCICR6 = 34995;
  ARM64_SYSREG_TRCSSPCICR7 = 35003;
  ARM64_SYSREG_TRCSTALLCTLR = 34904;
  ARM64_SYSREG_TRCSTATR = 34840;
  ARM64_SYSREG_TRCSYNCPR = 34920;
  ARM64_SYSREG_TRCTRACEIDR = 34817;
  ARM64_SYSREG_TRCTSCTLR = 34912;
  ARM64_SYSREG_TRCVDARCCTLR = 34898;
  ARM64_SYSREG_TRCVDCTLR = 34882;
  ARM64_SYSREG_TRCVDSACCTLR = 34890;
  ARM64_SYSREG_TRCVICTLR = 34818;
  ARM64_SYSREG_TRCVIIECTLR = 34826;
  ARM64_SYSREG_TRCVIPCSSCTLR = 34842;
  ARM64_SYSREG_TRCVISSCTLR = 34834;
  ARM64_SYSREG_TRCVMIDCCTLR0 = 35218;
  ARM64_SYSREG_TRCVMIDCCTLR1 = 35226;
  ARM64_SYSREG_TRCVMIDCVR0 = 35201;
  ARM64_SYSREG_TRCVMIDCVR1 = 35217;
  ARM64_SYSREG_TRCVMIDCVR2 = 35233;
  ARM64_SYSREG_TRCVMIDCVR3 = 35249;
  ARM64_SYSREG_TRCVMIDCVR4 = 35265;
  ARM64_SYSREG_TRCVMIDCVR5 = 35281;
  ARM64_SYSREG_TRCVMIDCVR6 = 35297;
  ARM64_SYSREG_TRCVMIDCVR7 = 35313;
  ARM64_SYSREG_TRFCR_EL1 = 49297;
  ARM64_SYSREG_TRFCR_EL12 = 59537;
  ARM64_SYSREG_TRFCR_EL2 = 57489;
  ARM64_SYSREG_TTBR0_EL1 = 49408;
  ARM64_SYSREG_TTBR0_EL12 = 59648;
  ARM64_SYSREG_TTBR0_EL2 = 57600;
  ARM64_SYSREG_TTBR0_EL3 = 61696;
  ARM64_SYSREG_TTBR1_EL1 = 49409;
  ARM64_SYSREG_TTBR1_EL12 = 59649;
  ARM64_SYSREG_TTBR1_EL2 = 57601;
  ARM64_SYSREG_UAO = 49684;
  ARM64_SYSREG_VBAR_EL1 = 50688;
  ARM64_SYSREG_VBAR_EL12 = 60928;
  ARM64_SYSREG_VBAR_EL2 = 58880;
  ARM64_SYSREG_VBAR_EL3 = 62976;
  ARM64_SYSREG_VDISR_EL2 = 58889;
  ARM64_SYSREG_VMPIDR_EL2 = 57349;
  ARM64_SYSREG_VNCR_EL2 = 57616;
  ARM64_SYSREG_VPIDR_EL2 = 57344;
  ARM64_SYSREG_VSCTLR_EL2 = 57600;
  ARM64_SYSREG_VSESR_EL2 = 58003;
  ARM64_SYSREG_VSTCR_EL2 = 57650;
  ARM64_SYSREG_VSTTBR_EL2 = 57648;
  ARM64_SYSREG_VTCR_EL2 = 57610;
  ARM64_SYSREG_VTTBR_EL2 = 57608;
  ARM64_SYSREG_ZCR_EL1 = 49296;
  ARM64_SYSREG_ZCR_EL12 = 59536;
  ARM64_SYSREG_ZCR_EL2 = 57488;
  ARM64_SYSREG_ZCR_EL3 = 61584;

/// System PState Field (MSR instruction)
type
  arm64_pstate = Integer;
  Parm64_pstate = ^arm64_pstate;

const
  ARM64_PSTATE_INVALID = 0;
  ARM64_PSTATE_SPSEL = 5;
  ARM64_PSTATE_DAIFSET = 30;
  ARM64_PSTATE_DAIFCLR = 31;
  ARM64_PSTATE_PAN = 4;
  ARM64_PSTATE_UAO = 3;
  ARM64_PSTATE_DIT = 26;

/// Vector arrangement specifier (for FloatingPoint/Advanced SIMD insn)
type
  arm64_vas = Integer;
  Parm64_vas = ^arm64_vas;

const
  ARM64_VAS_INVALID = 0;
  ARM64_VAS_16B = 1;
  ARM64_VAS_8B = 2;
  ARM64_VAS_4B = 3;
  ARM64_VAS_1B = 4;
  ARM64_VAS_8H = 5;
  ARM64_VAS_4H = 6;
  ARM64_VAS_2H = 7;
  ARM64_VAS_1H = 8;
  ARM64_VAS_4S = 9;
  ARM64_VAS_2S = 10;
  ARM64_VAS_1S = 11;
  ARM64_VAS_2D = 12;
  ARM64_VAS_1D = 13;
  ARM64_VAS_1Q = 14;

/// Memory barrier operands
type
  arm64_barrier_op = Integer;
  Parm64_barrier_op = ^arm64_barrier_op;

const
  ARM64_BARRIER_INVALID = 0;
  ARM64_BARRIER_OSHLD = 1;
  ARM64_BARRIER_OSHST = 2;
  ARM64_BARRIER_OSH = 3;
  ARM64_BARRIER_NSHLD = 5;
  ARM64_BARRIER_NSHST = 6;
  ARM64_BARRIER_NSH = 7;
  ARM64_BARRIER_ISHLD = 9;
  ARM64_BARRIER_ISHST = 10;
  ARM64_BARRIER_ISH = 11;
  ARM64_BARRIER_LD = 13;
  ARM64_BARRIER_ST = 14;
  ARM64_BARRIER_SY = 15;

/// Operand type for instruction's operands
type
  arm64_op_type = Integer;
  Parm64_op_type = ^arm64_op_type;

const
  /// = CS_OP_INVALID (Uninitialized).
  ARM64_OP_INVALID = 0;
  /// = CS_OP_REG (Register operand).
  ARM64_OP_REG = 1;
  /// = CS_OP_IMM (Immediate operand).
  ARM64_OP_IMM = 2;
  /// = CS_OP_MEM (Memory operand).
  ARM64_OP_MEM_ = 3;
  /// = CS_OP_FP (Floating-Point operand).
  ARM64_OP_FP = 4;
  /// C-Immediate
  ARM64_OP_CIMM = 64;
  /// MRS register operand.
  ARM64_OP_REG_MRS = 65;
  /// MSR register operand.
  ARM64_OP_REG_MSR = 66;
  /// PState operand.
  ARM64_OP_PSTATE = 67;
  /// SYS operand for IC/DC/AT/TLBI instructions.
  ARM64_OP_SYS = 68;
  /// SVCR operand for MSR SVCR instructions.
  ARM64_OP_SVCR = 69;
  /// Prefetch operand (PRFM).
  ARM64_OP_PREFETCH = 70;
  /// Memory barrier operand (ISB/DMB/DSB instructions).
  ARM64_OP_BARRIER = 71;
  /// SME instruction operand with with index.
  ARM64_OP_SME_INDEX_ = 72;

/// SYS operands (IC/DC/AC/TLBI)
type
  arm64_sys_op = Integer;
  Parm64_sys_op = ^arm64_sys_op;

const
  ARM64_SYS_INVALID = 0;
  /// TLBI operations
  ARM64_TLBI_ALLE1 = 1;
  /// TLBI operations
  ARM64_TLBI_ALLE1IS = 2;
  /// TLBI operations
  ARM64_TLBI_ALLE1ISNXS = 3;
  /// TLBI operations
  ARM64_TLBI_ALLE1NXS = 4;
  /// TLBI operations
  ARM64_TLBI_ALLE1OS = 5;
  /// TLBI operations
  ARM64_TLBI_ALLE1OSNXS = 6;
  /// TLBI operations
  ARM64_TLBI_ALLE2 = 7;
  /// TLBI operations
  ARM64_TLBI_ALLE2IS = 8;
  /// TLBI operations
  ARM64_TLBI_ALLE2ISNXS = 9;
  /// TLBI operations
  ARM64_TLBI_ALLE2NXS = 10;
  /// TLBI operations
  ARM64_TLBI_ALLE2OS = 11;
  /// TLBI operations
  ARM64_TLBI_ALLE2OSNXS = 12;
  /// TLBI operations
  ARM64_TLBI_ALLE3 = 13;
  /// TLBI operations
  ARM64_TLBI_ALLE3IS = 14;
  /// TLBI operations
  ARM64_TLBI_ALLE3ISNXS = 15;
  /// TLBI operations
  ARM64_TLBI_ALLE3NXS = 16;
  /// TLBI operations
  ARM64_TLBI_ALLE3OS = 17;
  /// TLBI operations
  ARM64_TLBI_ALLE3OSNXS = 18;
  /// TLBI operations
  ARM64_TLBI_ASIDE1 = 19;
  /// TLBI operations
  ARM64_TLBI_ASIDE1IS = 20;
  /// TLBI operations
  ARM64_TLBI_ASIDE1ISNXS = 21;
  /// TLBI operations
  ARM64_TLBI_ASIDE1NXS = 22;
  /// TLBI operations
  ARM64_TLBI_ASIDE1OS = 23;
  /// TLBI operations
  ARM64_TLBI_ASIDE1OSNXS = 24;
  /// TLBI operations
  ARM64_TLBI_IPAS2E1 = 25;
  /// TLBI operations
  ARM64_TLBI_IPAS2E1IS = 26;
  /// TLBI operations
  ARM64_TLBI_IPAS2E1ISNXS = 27;
  /// TLBI operations
  ARM64_TLBI_IPAS2E1NXS = 28;
  /// TLBI operations
  ARM64_TLBI_IPAS2E1OS = 29;
  /// TLBI operations
  ARM64_TLBI_IPAS2E1OSNXS = 30;
  /// TLBI operations
  ARM64_TLBI_IPAS2LE1 = 31;
  /// TLBI operations
  ARM64_TLBI_IPAS2LE1IS = 32;
  /// TLBI operations
  ARM64_TLBI_IPAS2LE1ISNXS = 33;
  /// TLBI operations
  ARM64_TLBI_IPAS2LE1NXS = 34;
  /// TLBI operations
  ARM64_TLBI_IPAS2LE1OS = 35;
  /// TLBI operations
  ARM64_TLBI_IPAS2LE1OSNXS = 36;
  /// TLBI operations
  ARM64_TLBI_PAALL = 37;
  /// TLBI operations
  ARM64_TLBI_PAALLNXS = 38;
  /// TLBI operations
  ARM64_TLBI_PAALLOS = 39;
  /// TLBI operations
  ARM64_TLBI_PAALLOSNXS = 40;
  /// TLBI operations
  ARM64_TLBI_RIPAS2E1 = 41;
  /// TLBI operations
  ARM64_TLBI_RIPAS2E1IS = 42;
  /// TLBI operations
  ARM64_TLBI_RIPAS2E1ISNXS = 43;
  /// TLBI operations
  ARM64_TLBI_RIPAS2E1NXS = 44;
  /// TLBI operations
  ARM64_TLBI_RIPAS2E1OS = 45;
  /// TLBI operations
  ARM64_TLBI_RIPAS2E1OSNXS = 46;
  /// TLBI operations
  ARM64_TLBI_RIPAS2LE1 = 47;
  /// TLBI operations
  ARM64_TLBI_RIPAS2LE1IS = 48;
  /// TLBI operations
  ARM64_TLBI_RIPAS2LE1ISNXS = 49;
  /// TLBI operations
  ARM64_TLBI_RIPAS2LE1NXS = 50;
  /// TLBI operations
  ARM64_TLBI_RIPAS2LE1OS = 51;
  /// TLBI operations
  ARM64_TLBI_RIPAS2LE1OSNXS = 52;
  /// TLBI operations
  ARM64_TLBI_RPALOS = 53;
  /// TLBI operations
  ARM64_TLBI_RPALOSNXS = 54;
  /// TLBI operations
  ARM64_TLBI_RPAOS = 55;
  /// TLBI operations
  ARM64_TLBI_RPAOSNXS = 56;
  /// TLBI operations
  ARM64_TLBI_RVAAE1 = 57;
  /// TLBI operations
  ARM64_TLBI_RVAAE1IS = 58;
  /// TLBI operations
  ARM64_TLBI_RVAAE1ISNXS = 59;
  /// TLBI operations
  ARM64_TLBI_RVAAE1NXS = 60;
  /// TLBI operations
  ARM64_TLBI_RVAAE1OS = 61;
  /// TLBI operations
  ARM64_TLBI_RVAAE1OSNXS = 62;
  /// TLBI operations
  ARM64_TLBI_RVAALE1 = 63;
  /// TLBI operations
  ARM64_TLBI_RVAALE1IS = 64;
  /// TLBI operations
  ARM64_TLBI_RVAALE1ISNXS = 65;
  /// TLBI operations
  ARM64_TLBI_RVAALE1NXS = 66;
  /// TLBI operations
  ARM64_TLBI_RVAALE1OS = 67;
  /// TLBI operations
  ARM64_TLBI_RVAALE1OSNXS = 68;
  /// TLBI operations
  ARM64_TLBI_RVAE1 = 69;
  /// TLBI operations
  ARM64_TLBI_RVAE1IS = 70;
  /// TLBI operations
  ARM64_TLBI_RVAE1ISNXS = 71;
  /// TLBI operations
  ARM64_TLBI_RVAE1NXS = 72;
  /// TLBI operations
  ARM64_TLBI_RVAE1OS = 73;
  /// TLBI operations
  ARM64_TLBI_RVAE1OSNXS = 74;
  /// TLBI operations
  ARM64_TLBI_RVAE2 = 75;
  /// TLBI operations
  ARM64_TLBI_RVAE2IS = 76;
  /// TLBI operations
  ARM64_TLBI_RVAE2ISNXS = 77;
  /// TLBI operations
  ARM64_TLBI_RVAE2NXS = 78;
  /// TLBI operations
  ARM64_TLBI_RVAE2OS = 79;
  /// TLBI operations
  ARM64_TLBI_RVAE2OSNXS = 80;
  /// TLBI operations
  ARM64_TLBI_RVAE3 = 81;
  /// TLBI operations
  ARM64_TLBI_RVAE3IS = 82;
  /// TLBI operations
  ARM64_TLBI_RVAE3ISNXS = 83;
  /// TLBI operations
  ARM64_TLBI_RVAE3NXS = 84;
  /// TLBI operations
  ARM64_TLBI_RVAE3OS = 85;
  /// TLBI operations
  ARM64_TLBI_RVAE3OSNXS = 86;
  /// TLBI operations
  ARM64_TLBI_RVALE1 = 87;
  /// TLBI operations
  ARM64_TLBI_RVALE1IS = 88;
  /// TLBI operations
  ARM64_TLBI_RVALE1ISNXS = 89;
  /// TLBI operations
  ARM64_TLBI_RVALE1NXS = 90;
  /// TLBI operations
  ARM64_TLBI_RVALE1OS = 91;
  /// TLBI operations
  ARM64_TLBI_RVALE1OSNXS = 92;
  /// TLBI operations
  ARM64_TLBI_RVALE2 = 93;
  /// TLBI operations
  ARM64_TLBI_RVALE2IS = 94;
  /// TLBI operations
  ARM64_TLBI_RVALE2ISNXS = 95;
  /// TLBI operations
  ARM64_TLBI_RVALE2NXS = 96;
  /// TLBI operations
  ARM64_TLBI_RVALE2OS = 97;
  /// TLBI operations
  ARM64_TLBI_RVALE2OSNXS = 98;
  /// TLBI operations
  ARM64_TLBI_RVALE3 = 99;
  /// TLBI operations
  ARM64_TLBI_RVALE3IS = 100;
  /// TLBI operations
  ARM64_TLBI_RVALE3ISNXS = 101;
  /// TLBI operations
  ARM64_TLBI_RVALE3NXS = 102;
  /// TLBI operations
  ARM64_TLBI_RVALE3OS = 103;
  /// TLBI operations
  ARM64_TLBI_RVALE3OSNXS = 104;
  /// TLBI operations
  ARM64_TLBI_VAAE1 = 105;
  /// TLBI operations
  ARM64_TLBI_VAAE1IS = 106;
  /// TLBI operations
  ARM64_TLBI_VAAE1ISNXS = 107;
  /// TLBI operations
  ARM64_TLBI_VAAE1NXS = 108;
  /// TLBI operations
  ARM64_TLBI_VAAE1OS = 109;
  /// TLBI operations
  ARM64_TLBI_VAAE1OSNXS = 110;
  /// TLBI operations
  ARM64_TLBI_VAALE1 = 111;
  /// TLBI operations
  ARM64_TLBI_VAALE1IS = 112;
  /// TLBI operations
  ARM64_TLBI_VAALE1ISNXS = 113;
  /// TLBI operations
  ARM64_TLBI_VAALE1NXS = 114;
  /// TLBI operations
  ARM64_TLBI_VAALE1OS = 115;
  /// TLBI operations
  ARM64_TLBI_VAALE1OSNXS = 116;
  /// TLBI operations
  ARM64_TLBI_VAE1 = 117;
  /// TLBI operations
  ARM64_TLBI_VAE1IS = 118;
  /// TLBI operations
  ARM64_TLBI_VAE1ISNXS = 119;
  /// TLBI operations
  ARM64_TLBI_VAE1NXS = 120;
  /// TLBI operations
  ARM64_TLBI_VAE1OS = 121;
  /// TLBI operations
  ARM64_TLBI_VAE1OSNXS = 122;
  /// TLBI operations
  ARM64_TLBI_VAE2 = 123;
  /// TLBI operations
  ARM64_TLBI_VAE2IS = 124;
  /// TLBI operations
  ARM64_TLBI_VAE2ISNXS = 125;
  /// TLBI operations
  ARM64_TLBI_VAE2NXS = 126;
  /// TLBI operations
  ARM64_TLBI_VAE2OS = 127;
  /// TLBI operations
  ARM64_TLBI_VAE2OSNXS = 128;
  /// TLBI operations
  ARM64_TLBI_VAE3 = 129;
  /// TLBI operations
  ARM64_TLBI_VAE3IS = 130;
  /// TLBI operations
  ARM64_TLBI_VAE3ISNXS = 131;
  /// TLBI operations
  ARM64_TLBI_VAE3NXS = 132;
  /// TLBI operations
  ARM64_TLBI_VAE3OS = 133;
  /// TLBI operations
  ARM64_TLBI_VAE3OSNXS = 134;
  /// TLBI operations
  ARM64_TLBI_VALE1 = 135;
  /// TLBI operations
  ARM64_TLBI_VALE1IS = 136;
  /// TLBI operations
  ARM64_TLBI_VALE1ISNXS = 137;
  /// TLBI operations
  ARM64_TLBI_VALE1NXS = 138;
  /// TLBI operations
  ARM64_TLBI_VALE1OS = 139;
  /// TLBI operations
  ARM64_TLBI_VALE1OSNXS = 140;
  /// TLBI operations
  ARM64_TLBI_VALE2 = 141;
  /// TLBI operations
  ARM64_TLBI_VALE2IS = 142;
  /// TLBI operations
  ARM64_TLBI_VALE2ISNXS = 143;
  /// TLBI operations
  ARM64_TLBI_VALE2NXS = 144;
  /// TLBI operations
  ARM64_TLBI_VALE2OS = 145;
  /// TLBI operations
  ARM64_TLBI_VALE2OSNXS = 146;
  /// TLBI operations
  ARM64_TLBI_VALE3 = 147;
  /// TLBI operations
  ARM64_TLBI_VALE3IS = 148;
  /// TLBI operations
  ARM64_TLBI_VALE3ISNXS = 149;
  /// TLBI operations
  ARM64_TLBI_VALE3NXS = 150;
  /// TLBI operations
  ARM64_TLBI_VALE3OS = 151;
  /// TLBI operations
  ARM64_TLBI_VALE3OSNXS = 152;
  /// TLBI operations
  ARM64_TLBI_VMALLE1 = 153;
  /// TLBI operations
  ARM64_TLBI_VMALLE1IS = 154;
  /// TLBI operations
  ARM64_TLBI_VMALLE1ISNXS = 155;
  /// TLBI operations
  ARM64_TLBI_VMALLE1NXS = 156;
  /// TLBI operations
  ARM64_TLBI_VMALLE1OS = 157;
  /// TLBI operations
  ARM64_TLBI_VMALLE1OSNXS = 158;
  /// TLBI operations
  ARM64_TLBI_VMALLS12E1 = 159;
  /// TLBI operations
  ARM64_TLBI_VMALLS12E1IS = 160;
  /// TLBI operations
  ARM64_TLBI_VMALLS12E1ISNXS = 161;
  /// TLBI operations
  ARM64_TLBI_VMALLS12E1NXS = 162;
  /// TLBI operations
  ARM64_TLBI_VMALLS12E1OS = 163;
  /// TLBI operations
  ARM64_TLBI_VMALLS12E1OSNXS = 164;
  /// AT operations
  ARM64_AT_S1E1R = 165;
  /// AT operations
  ARM64_AT_S1E2R = 166;
  /// AT operations
  ARM64_AT_S1E3R = 167;
  /// AT operations
  ARM64_AT_S1E1W = 168;
  /// AT operations
  ARM64_AT_S1E2W = 169;
  /// AT operations
  ARM64_AT_S1E3W = 170;
  /// AT operations
  ARM64_AT_S1E0R = 171;
  /// AT operations
  ARM64_AT_S1E0W = 172;
  /// AT operations
  ARM64_AT_S12E1R = 173;
  /// AT operations
  ARM64_AT_S12E1W = 174;
  /// AT operations
  ARM64_AT_S12E0R = 175;
  /// AT operations
  ARM64_AT_S12E0W = 176;
  /// AT operations
  ARM64_AT_S1E1RP = 177;
  /// AT operations
  ARM64_AT_S1E1WP = 178;
  /// DC operations
  ARM64_DC_CGDSW = 179;
  /// DC operations
  ARM64_DC_CGDVAC = 180;
  /// DC operations
  ARM64_DC_CGDVADP = 181;
  /// DC operations
  ARM64_DC_CGDVAP = 182;
  /// DC operations
  ARM64_DC_CGSW = 183;
  /// DC operations
  ARM64_DC_CGVAC = 184;
  /// DC operations
  ARM64_DC_CGVADP = 185;
  /// DC operations
  ARM64_DC_CGVAP = 186;
  /// DC operations
  ARM64_DC_CIGDSW = 187;
  /// DC operations
  ARM64_DC_CIGDVAC = 188;
  /// DC operations
  ARM64_DC_CIGSW = 189;
  /// DC operations
  ARM64_DC_CIGVAC = 190;
  /// DC operations
  ARM64_DC_CISW = 191;
  /// DC operations
  ARM64_DC_CIVAC = 192;
  /// DC operations
  ARM64_DC_CSW = 193;
  /// DC operations
  ARM64_DC_CVAC = 194;
  /// DC operations
  ARM64_DC_CVADP = 195;
  /// DC operations
  ARM64_DC_CVAP = 196;
  /// DC operations
  ARM64_DC_CVAU = 197;
  /// DC operations
  ARM64_DC_GVA = 198;
  /// DC operations
  ARM64_DC_GZVA = 199;
  /// DC operations
  ARM64_DC_IGDSW = 200;
  /// DC operations
  ARM64_DC_IGDVAC = 201;
  /// DC operations
  ARM64_DC_IGSW = 202;
  /// DC operations
  ARM64_DC_IGVAC = 203;
  /// DC operations
  ARM64_DC_ISW = 204;
  /// DC operations
  ARM64_DC_IVAC = 205;
  /// DC operations
  ARM64_DC_ZVA = 206;
  /// IC operations
  ARM64_IC_IALLUIS = 207;
  /// IC operations
  ARM64_IC_IALLU = 208;
  /// IC operations
  ARM64_IC_IVAU = 209;

/// SVCR operands
type
  arm64_svcr_op = Integer;
  Parm64_svcr_op = ^arm64_svcr_op;

const
  ARM64_SVCR_INVALID = 0;
  ARM64_SVCR_SVCRSM = 1;
  ARM64_SVCR_SVCRSMZA = 3;
  ARM64_SVCR_SVCRZA = 2;

/// Prefetch operations (PRFM)
type
  arm64_prefetch_op = Integer;
  Parm64_prefetch_op = ^arm64_prefetch_op;

const
  ARM64_PRFM_INVALID = 0;
  ARM64_PRFM_PLDL1KEEP = 1;
  ARM64_PRFM_PLDL1STRM = 2;
  ARM64_PRFM_PLDL2KEEP = 3;
  ARM64_PRFM_PLDL2STRM = 4;
  ARM64_PRFM_PLDL3KEEP = 5;
  ARM64_PRFM_PLDL3STRM = 6;
  ARM64_PRFM_PLIL1KEEP = 9;
  ARM64_PRFM_PLIL1STRM = 10;
  ARM64_PRFM_PLIL2KEEP = 11;
  ARM64_PRFM_PLIL2STRM = 12;
  ARM64_PRFM_PLIL3KEEP = 13;
  ARM64_PRFM_PLIL3STRM = 14;
  ARM64_PRFM_PSTL1KEEP = 17;
  ARM64_PRFM_PSTL1STRM = 18;
  ARM64_PRFM_PSTL2KEEP = 19;
  ARM64_PRFM_PSTL2STRM = 20;
  ARM64_PRFM_PSTL3KEEP = 21;
  ARM64_PRFM_PSTL3STRM = 22;

/// ARM64 registers
type
  arm64_reg = Integer;
  Parm64_reg = ^arm64_reg;

const
  ARM64_REG_INVALID = 0;
  ARM64_REG_FFR = 1;
  ARM64_REG_FP = 2;
  ARM64_REG_LR = 3;
  ARM64_REG_NZCV = 4;
  ARM64_REG_SP = 5;
  ARM64_REG_VG = 6;
  ARM64_REG_WSP = 7;
  ARM64_REG_WZR = 8;
  ARM64_REG_XZR = 9;
  ARM64_REG_ZA = 10;
  ARM64_REG_B0 = 11;
  ARM64_REG_B1 = 12;
  ARM64_REG_B2 = 13;
  ARM64_REG_B3 = 14;
  ARM64_REG_B4 = 15;
  ARM64_REG_B5 = 16;
  ARM64_REG_B6 = 17;
  ARM64_REG_B7 = 18;
  ARM64_REG_B8 = 19;
  ARM64_REG_B9 = 20;
  ARM64_REG_B10 = 21;
  ARM64_REG_B11 = 22;
  ARM64_REG_B12 = 23;
  ARM64_REG_B13 = 24;
  ARM64_REG_B14 = 25;
  ARM64_REG_B15 = 26;
  ARM64_REG_B16 = 27;
  ARM64_REG_B17 = 28;
  ARM64_REG_B18 = 29;
  ARM64_REG_B19 = 30;
  ARM64_REG_B20 = 31;
  ARM64_REG_B21 = 32;
  ARM64_REG_B22 = 33;
  ARM64_REG_B23 = 34;
  ARM64_REG_B24 = 35;
  ARM64_REG_B25 = 36;
  ARM64_REG_B26 = 37;
  ARM64_REG_B27 = 38;
  ARM64_REG_B28 = 39;
  ARM64_REG_B29 = 40;
  ARM64_REG_B30 = 41;
  ARM64_REG_B31 = 42;
  ARM64_REG_D0 = 43;
  ARM64_REG_D1 = 44;
  ARM64_REG_D2 = 45;
  ARM64_REG_D3 = 46;
  ARM64_REG_D4 = 47;
  ARM64_REG_D5 = 48;
  ARM64_REG_D6 = 49;
  ARM64_REG_D7 = 50;
  ARM64_REG_D8 = 51;
  ARM64_REG_D9 = 52;
  ARM64_REG_D10 = 53;
  ARM64_REG_D11 = 54;
  ARM64_REG_D12 = 55;
  ARM64_REG_D13 = 56;
  ARM64_REG_D14 = 57;
  ARM64_REG_D15 = 58;
  ARM64_REG_D16 = 59;
  ARM64_REG_D17 = 60;
  ARM64_REG_D18 = 61;
  ARM64_REG_D19 = 62;
  ARM64_REG_D20 = 63;
  ARM64_REG_D21 = 64;
  ARM64_REG_D22 = 65;
  ARM64_REG_D23 = 66;
  ARM64_REG_D24 = 67;
  ARM64_REG_D25 = 68;
  ARM64_REG_D26 = 69;
  ARM64_REG_D27 = 70;
  ARM64_REG_D28 = 71;
  ARM64_REG_D29 = 72;
  ARM64_REG_D30 = 73;
  ARM64_REG_D31 = 74;
  ARM64_REG_H0 = 75;
  ARM64_REG_H1 = 76;
  ARM64_REG_H2 = 77;
  ARM64_REG_H3 = 78;
  ARM64_REG_H4 = 79;
  ARM64_REG_H5 = 80;
  ARM64_REG_H6 = 81;
  ARM64_REG_H7 = 82;
  ARM64_REG_H8 = 83;
  ARM64_REG_H9 = 84;
  ARM64_REG_H10 = 85;
  ARM64_REG_H11 = 86;
  ARM64_REG_H12 = 87;
  ARM64_REG_H13 = 88;
  ARM64_REG_H14 = 89;
  ARM64_REG_H15 = 90;
  ARM64_REG_H16 = 91;
  ARM64_REG_H17 = 92;
  ARM64_REG_H18 = 93;
  ARM64_REG_H19 = 94;
  ARM64_REG_H20 = 95;
  ARM64_REG_H21 = 96;
  ARM64_REG_H22 = 97;
  ARM64_REG_H23 = 98;
  ARM64_REG_H24 = 99;
  ARM64_REG_H25 = 100;
  ARM64_REG_H26 = 101;
  ARM64_REG_H27 = 102;
  ARM64_REG_H28 = 103;
  ARM64_REG_H29 = 104;
  ARM64_REG_H30 = 105;
  ARM64_REG_H31 = 106;
  ARM64_REG_P0 = 107;
  ARM64_REG_P1 = 108;
  ARM64_REG_P2 = 109;
  ARM64_REG_P3 = 110;
  ARM64_REG_P4 = 111;
  ARM64_REG_P5 = 112;
  ARM64_REG_P6 = 113;
  ARM64_REG_P7 = 114;
  ARM64_REG_P8 = 115;
  ARM64_REG_P9 = 116;
  ARM64_REG_P10 = 117;
  ARM64_REG_P11 = 118;
  ARM64_REG_P12 = 119;
  ARM64_REG_P13 = 120;
  ARM64_REG_P14 = 121;
  ARM64_REG_P15 = 122;
  ARM64_REG_Q0 = 123;
  ARM64_REG_Q1 = 124;
  ARM64_REG_Q2 = 125;
  ARM64_REG_Q3 = 126;
  ARM64_REG_Q4 = 127;
  ARM64_REG_Q5 = 128;
  ARM64_REG_Q6 = 129;
  ARM64_REG_Q7 = 130;
  ARM64_REG_Q8 = 131;
  ARM64_REG_Q9 = 132;
  ARM64_REG_Q10 = 133;
  ARM64_REG_Q11 = 134;
  ARM64_REG_Q12 = 135;
  ARM64_REG_Q13 = 136;
  ARM64_REG_Q14 = 137;
  ARM64_REG_Q15 = 138;
  ARM64_REG_Q16 = 139;
  ARM64_REG_Q17 = 140;
  ARM64_REG_Q18 = 141;
  ARM64_REG_Q19 = 142;
  ARM64_REG_Q20 = 143;
  ARM64_REG_Q21 = 144;
  ARM64_REG_Q22 = 145;
  ARM64_REG_Q23 = 146;
  ARM64_REG_Q24 = 147;
  ARM64_REG_Q25 = 148;
  ARM64_REG_Q26 = 149;
  ARM64_REG_Q27 = 150;
  ARM64_REG_Q28 = 151;
  ARM64_REG_Q29 = 152;
  ARM64_REG_Q30 = 153;
  ARM64_REG_Q31 = 154;
  ARM64_REG_S0 = 155;
  ARM64_REG_S1 = 156;
  ARM64_REG_S2 = 157;
  ARM64_REG_S3 = 158;
  ARM64_REG_S4 = 159;
  ARM64_REG_S5 = 160;
  ARM64_REG_S6 = 161;
  ARM64_REG_S7 = 162;
  ARM64_REG_S8 = 163;
  ARM64_REG_S9 = 164;
  ARM64_REG_S10 = 165;
  ARM64_REG_S11 = 166;
  ARM64_REG_S12 = 167;
  ARM64_REG_S13 = 168;
  ARM64_REG_S14 = 169;
  ARM64_REG_S15 = 170;
  ARM64_REG_S16 = 171;
  ARM64_REG_S17 = 172;
  ARM64_REG_S18 = 173;
  ARM64_REG_S19 = 174;
  ARM64_REG_S20 = 175;
  ARM64_REG_S21 = 176;
  ARM64_REG_S22 = 177;
  ARM64_REG_S23 = 178;
  ARM64_REG_S24 = 179;
  ARM64_REG_S25 = 180;
  ARM64_REG_S26 = 181;
  ARM64_REG_S27 = 182;
  ARM64_REG_S28 = 183;
  ARM64_REG_S29 = 184;
  ARM64_REG_S30 = 185;
  ARM64_REG_S31 = 186;
  ARM64_REG_W0 = 187;
  ARM64_REG_W1 = 188;
  ARM64_REG_W2 = 189;
  ARM64_REG_W3 = 190;
  ARM64_REG_W4 = 191;
  ARM64_REG_W5 = 192;
  ARM64_REG_W6 = 193;
  ARM64_REG_W7 = 194;
  ARM64_REG_W8 = 195;
  ARM64_REG_W9 = 196;
  ARM64_REG_W10 = 197;
  ARM64_REG_W11 = 198;
  ARM64_REG_W12 = 199;
  ARM64_REG_W13 = 200;
  ARM64_REG_W14 = 201;
  ARM64_REG_W15 = 202;
  ARM64_REG_W16 = 203;
  ARM64_REG_W17 = 204;
  ARM64_REG_W18 = 205;
  ARM64_REG_W19 = 206;
  ARM64_REG_W20 = 207;
  ARM64_REG_W21 = 208;
  ARM64_REG_W22 = 209;
  ARM64_REG_W23 = 210;
  ARM64_REG_W24 = 211;
  ARM64_REG_W25 = 212;
  ARM64_REG_W26 = 213;
  ARM64_REG_W27 = 214;
  ARM64_REG_W28 = 215;
  ARM64_REG_W29 = 216;
  ARM64_REG_W30 = 217;
  ARM64_REG_X0 = 218;
  ARM64_REG_X1 = 219;
  ARM64_REG_X2 = 220;
  ARM64_REG_X3 = 221;
  ARM64_REG_X4 = 222;
  ARM64_REG_X5 = 223;
  ARM64_REG_X6 = 224;
  ARM64_REG_X7 = 225;
  ARM64_REG_X8 = 226;
  ARM64_REG_X9 = 227;
  ARM64_REG_X10 = 228;
  ARM64_REG_X11 = 229;
  ARM64_REG_X12 = 230;
  ARM64_REG_X13 = 231;
  ARM64_REG_X14 = 232;
  ARM64_REG_X15 = 233;
  ARM64_REG_X16 = 234;
  ARM64_REG_X17 = 235;
  ARM64_REG_X18 = 236;
  ARM64_REG_X19 = 237;
  ARM64_REG_X20 = 238;
  ARM64_REG_X21 = 239;
  ARM64_REG_X22 = 240;
  ARM64_REG_X23 = 241;
  ARM64_REG_X24 = 242;
  ARM64_REG_X25 = 243;
  ARM64_REG_X26 = 244;
  ARM64_REG_X27 = 245;
  ARM64_REG_X28 = 246;
  ARM64_REG_Z0 = 247;
  ARM64_REG_Z1 = 248;
  ARM64_REG_Z2 = 249;
  ARM64_REG_Z3 = 250;
  ARM64_REG_Z4 = 251;
  ARM64_REG_Z5 = 252;
  ARM64_REG_Z6 = 253;
  ARM64_REG_Z7 = 254;
  ARM64_REG_Z8 = 255;
  ARM64_REG_Z9 = 256;
  ARM64_REG_Z10 = 257;
  ARM64_REG_Z11 = 258;
  ARM64_REG_Z12 = 259;
  ARM64_REG_Z13 = 260;
  ARM64_REG_Z14 = 261;
  ARM64_REG_Z15 = 262;
  ARM64_REG_Z16 = 263;
  ARM64_REG_Z17 = 264;
  ARM64_REG_Z18 = 265;
  ARM64_REG_Z19 = 266;
  ARM64_REG_Z20 = 267;
  ARM64_REG_Z21 = 268;
  ARM64_REG_Z22 = 269;
  ARM64_REG_Z23 = 270;
  ARM64_REG_Z24 = 271;
  ARM64_REG_Z25 = 272;
  ARM64_REG_Z26 = 273;
  ARM64_REG_Z27 = 274;
  ARM64_REG_Z28 = 275;
  ARM64_REG_Z29 = 276;
  ARM64_REG_Z30 = 277;
  ARM64_REG_Z31 = 278;
  ARM64_REG_ZAB0 = 279;
  ARM64_REG_ZAD0 = 280;
  ARM64_REG_ZAD1 = 281;
  ARM64_REG_ZAD2 = 282;
  ARM64_REG_ZAD3 = 283;
  ARM64_REG_ZAD4 = 284;
  ARM64_REG_ZAD5 = 285;
  ARM64_REG_ZAD6 = 286;
  ARM64_REG_ZAD7 = 287;
  ARM64_REG_ZAH0 = 288;
  ARM64_REG_ZAH1 = 289;
  ARM64_REG_ZAQ0 = 290;
  ARM64_REG_ZAQ1 = 291;
  ARM64_REG_ZAQ2 = 292;
  ARM64_REG_ZAQ3 = 293;
  ARM64_REG_ZAQ4 = 294;
  ARM64_REG_ZAQ5 = 295;
  ARM64_REG_ZAQ6 = 296;
  ARM64_REG_ZAQ7 = 297;
  ARM64_REG_ZAQ8 = 298;
  ARM64_REG_ZAQ9 = 299;
  ARM64_REG_ZAQ10 = 300;
  ARM64_REG_ZAQ11 = 301;
  ARM64_REG_ZAQ12 = 302;
  ARM64_REG_ZAQ13 = 303;
  ARM64_REG_ZAQ14 = 304;
  ARM64_REG_ZAQ15 = 305;
  ARM64_REG_ZAS0 = 306;
  ARM64_REG_ZAS1 = 307;
  ARM64_REG_ZAS2 = 308;
  ARM64_REG_ZAS3 = 309;
  ARM64_REG_V0 = 310;
  ARM64_REG_V1 = 311;
  ARM64_REG_V2 = 312;
  ARM64_REG_V3 = 313;
  ARM64_REG_V4 = 314;
  ARM64_REG_V5 = 315;
  ARM64_REG_V6 = 316;
  ARM64_REG_V7 = 317;
  ARM64_REG_V8 = 318;
  ARM64_REG_V9 = 319;
  ARM64_REG_V10 = 320;
  ARM64_REG_V11 = 321;
  ARM64_REG_V12 = 322;
  ARM64_REG_V13 = 323;
  ARM64_REG_V14 = 324;
  ARM64_REG_V15 = 325;
  ARM64_REG_V16 = 326;
  ARM64_REG_V17 = 327;
  ARM64_REG_V18 = 328;
  ARM64_REG_V19 = 329;
  ARM64_REG_V20 = 330;
  ARM64_REG_V21 = 331;
  ARM64_REG_V22 = 332;
  ARM64_REG_V23 = 333;
  ARM64_REG_V24 = 334;
  ARM64_REG_V25 = 335;
  ARM64_REG_V26 = 336;
  ARM64_REG_V27 = 337;
  ARM64_REG_V28 = 338;
  ARM64_REG_V29 = 339;
  ARM64_REG_V30 = 340;
  ARM64_REG_V31 = 341;
  ARM64_REG_ENDING = 342;
  ARM64_REG_IP0 = 234;
  ARM64_REG_IP1 = 235;
  ARM64_REG_X29 = 2;
  ARM64_REG_X30 = 3;

/// ARM64 instruction
type
  arm64_insn = Integer;
  Parm64_insn = ^arm64_insn;

const
  ARM64_INS_INVALID = 0;
  ARM64_INS_ABS = 1;
  ARM64_INS_ADC = 2;
  ARM64_INS_ADCLB = 3;
  ARM64_INS_ADCLT = 4;
  ARM64_INS_ADCS = 5;
  ARM64_INS_ADD = 6;
  ARM64_INS_ADDG = 7;
  ARM64_INS_ADDHA = 8;
  ARM64_INS_ADDHN = 9;
  ARM64_INS_ADDHN2 = 10;
  ARM64_INS_ADDHNB = 11;
  ARM64_INS_ADDHNT = 12;
  ARM64_INS_ADDP = 13;
  ARM64_INS_ADDPL = 14;
  ARM64_INS_ADDS = 15;
  ARM64_INS_ADDV = 16;
  ARM64_INS_ADDVA = 17;
  ARM64_INS_ADDVL = 18;
  ARM64_INS_ADR = 19;
  ARM64_INS_ADRP = 20;
  ARM64_INS_AESD = 21;
  ARM64_INS_AESE = 22;
  ARM64_INS_AESIMC = 23;
  ARM64_INS_AESMC = 24;
  ARM64_INS_AND = 25;
  ARM64_INS_ANDS = 26;
  ARM64_INS_ANDV = 27;
  ARM64_INS_ASR = 28;
  ARM64_INS_ASRD = 29;
  ARM64_INS_ASRR = 30;
  ARM64_INS_ASRV = 31;
  ARM64_INS_AUTDA = 32;
  ARM64_INS_AUTDB = 33;
  ARM64_INS_AUTDZA = 34;
  ARM64_INS_AUTDZB = 35;
  ARM64_INS_AUTIA = 36;
  ARM64_INS_AUTIA1716 = 37;
  ARM64_INS_AUTIASP = 38;
  ARM64_INS_AUTIAZ = 39;
  ARM64_INS_AUTIB = 40;
  ARM64_INS_AUTIB1716 = 41;
  ARM64_INS_AUTIBSP = 42;
  ARM64_INS_AUTIBZ = 43;
  ARM64_INS_AUTIZA = 44;
  ARM64_INS_AUTIZB = 45;
  ARM64_INS_AXFLAG = 46;
  ARM64_INS_B = 47;
  ARM64_INS_BC = 48;
  ARM64_INS_BCAX = 49;
  ARM64_INS_BDEP = 50;
  ARM64_INS_BEXT = 51;
  ARM64_INS_BFCVT = 52;
  ARM64_INS_BFCVTN = 53;
  ARM64_INS_BFCVTN2 = 54;
  ARM64_INS_BFCVTNT = 55;
  ARM64_INS_BFDOT = 56;
  ARM64_INS_BFM = 57;
  ARM64_INS_BFMLALB = 58;
  ARM64_INS_BFMLALT = 59;
  ARM64_INS_BFMMLA = 60;
  ARM64_INS_BFMOPA = 61;
  ARM64_INS_BFMOPS = 62;
  ARM64_INS_BGRP = 63;
  ARM64_INS_BIC = 64;
  ARM64_INS_BICS = 65;
  ARM64_INS_BIF = 66;
  ARM64_INS_BIT = 67;
  ARM64_INS_BL = 68;
  ARM64_INS_BLR = 69;
  ARM64_INS_BLRAA = 70;
  ARM64_INS_BLRAAZ = 71;
  ARM64_INS_BLRAB = 72;
  ARM64_INS_BLRABZ = 73;
  ARM64_INS_BR = 74;
  ARM64_INS_BRAA = 75;
  ARM64_INS_BRAAZ = 76;
  ARM64_INS_BRAB = 77;
  ARM64_INS_BRABZ = 78;
  ARM64_INS_BRB = 79;
  ARM64_INS_BRK = 80;
  ARM64_INS_BRKA = 81;
  ARM64_INS_BRKAS = 82;
  ARM64_INS_BRKB = 83;
  ARM64_INS_BRKBS = 84;
  ARM64_INS_BRKN = 85;
  ARM64_INS_BRKNS = 86;
  ARM64_INS_BRKPA = 87;
  ARM64_INS_BRKPAS = 88;
  ARM64_INS_BRKPB = 89;
  ARM64_INS_BRKPBS = 90;
  ARM64_INS_BSL = 91;
  ARM64_INS_BSL1N = 92;
  ARM64_INS_BSL2N = 93;
  ARM64_INS_BTI = 94;
  ARM64_INS_CADD = 95;
  ARM64_INS_CAS = 96;
  ARM64_INS_CASA = 97;
  ARM64_INS_CASAB = 98;
  ARM64_INS_CASAH = 99;
  ARM64_INS_CASAL = 100;
  ARM64_INS_CASALB = 101;
  ARM64_INS_CASALH = 102;
  ARM64_INS_CASB = 103;
  ARM64_INS_CASH = 104;
  ARM64_INS_CASL = 105;
  ARM64_INS_CASLB = 106;
  ARM64_INS_CASLH = 107;
  ARM64_INS_CASP = 108;
  ARM64_INS_CASPA = 109;
  ARM64_INS_CASPAL = 110;
  ARM64_INS_CASPL = 111;
  ARM64_INS_CBNZ = 112;
  ARM64_INS_CBZ = 113;
  ARM64_INS_CCMN = 114;
  ARM64_INS_CCMP = 115;
  ARM64_INS_CDOT = 116;
  ARM64_INS_CFINV = 117;
  ARM64_INS_CINC = 118;
  ARM64_INS_CINV = 119;
  ARM64_INS_CLASTA = 120;
  ARM64_INS_CLASTB = 121;
  ARM64_INS_CLREX = 122;
  ARM64_INS_CLS = 123;
  ARM64_INS_CLZ = 124;
  ARM64_INS_CMEQ = 125;
  ARM64_INS_CMGE = 126;
  ARM64_INS_CMGT = 127;
  ARM64_INS_CMHI = 128;
  ARM64_INS_CMHS = 129;
  ARM64_INS_CMLA = 130;
  ARM64_INS_CMLE = 131;
  ARM64_INS_CMLO = 132;
  ARM64_INS_CMLS = 133;
  ARM64_INS_CMLT = 134;
  ARM64_INS_CMN = 135;
  ARM64_INS_CMP = 136;
  ARM64_INS_CMPEQ = 137;
  ARM64_INS_CMPGE = 138;
  ARM64_INS_CMPGT = 139;
  ARM64_INS_CMPHI = 140;
  ARM64_INS_CMPHS = 141;
  ARM64_INS_CMPLE = 142;
  ARM64_INS_CMPLO = 143;
  ARM64_INS_CMPLS = 144;
  ARM64_INS_CMPLT = 145;
  ARM64_INS_CMPNE = 146;
  ARM64_INS_CMPP = 147;
  ARM64_INS_CMTST = 148;
  ARM64_INS_CNEG = 149;
  ARM64_INS_CNOT = 150;
  ARM64_INS_CNT = 151;
  ARM64_INS_CNTB = 152;
  ARM64_INS_CNTD = 153;
  ARM64_INS_CNTH = 154;
  ARM64_INS_CNTP = 155;
  ARM64_INS_CNTW = 156;
  ARM64_INS_COMPACT = 157;
  ARM64_INS_CPY = 158;
  ARM64_INS_CPYE = 159;
  ARM64_INS_CPYEN = 160;
  ARM64_INS_CPYERN = 161;
  ARM64_INS_CPYERT = 162;
  ARM64_INS_CPYERTN = 163;
  ARM64_INS_CPYERTRN = 164;
  ARM64_INS_CPYERTWN = 165;
  ARM64_INS_CPYET = 166;
  ARM64_INS_CPYETN = 167;
  ARM64_INS_CPYETRN = 168;
  ARM64_INS_CPYETWN = 169;
  ARM64_INS_CPYEWN = 170;
  ARM64_INS_CPYEWT = 171;
  ARM64_INS_CPYEWTN = 172;
  ARM64_INS_CPYEWTRN = 173;
  ARM64_INS_CPYEWTWN = 174;
  ARM64_INS_CPYFE = 175;
  ARM64_INS_CPYFEN = 176;
  ARM64_INS_CPYFERN = 177;
  ARM64_INS_CPYFERT = 178;
  ARM64_INS_CPYFERTN = 179;
  ARM64_INS_CPYFERTRN = 180;
  ARM64_INS_CPYFERTWN = 181;
  ARM64_INS_CPYFET = 182;
  ARM64_INS_CPYFETN = 183;
  ARM64_INS_CPYFETRN = 184;
  ARM64_INS_CPYFETWN = 185;
  ARM64_INS_CPYFEWN = 186;
  ARM64_INS_CPYFEWT = 187;
  ARM64_INS_CPYFEWTN = 188;
  ARM64_INS_CPYFEWTRN = 189;
  ARM64_INS_CPYFEWTWN = 190;
  ARM64_INS_CPYFM = 191;
  ARM64_INS_CPYFMN = 192;
  ARM64_INS_CPYFMRN = 193;
  ARM64_INS_CPYFMRT = 194;
  ARM64_INS_CPYFMRTN = 195;
  ARM64_INS_CPYFMRTRN = 196;
  ARM64_INS_CPYFMRTWN = 197;
  ARM64_INS_CPYFMT = 198;
  ARM64_INS_CPYFMTN = 199;
  ARM64_INS_CPYFMTRN = 200;
  ARM64_INS_CPYFMTWN = 201;
  ARM64_INS_CPYFMWN = 202;
  ARM64_INS_CPYFMWT = 203;
  ARM64_INS_CPYFMWTN = 204;
  ARM64_INS_CPYFMWTRN = 205;
  ARM64_INS_CPYFMWTWN = 206;
  ARM64_INS_CPYFP = 207;
  ARM64_INS_CPYFPN = 208;
  ARM64_INS_CPYFPRN = 209;
  ARM64_INS_CPYFPRT = 210;
  ARM64_INS_CPYFPRTN = 211;
  ARM64_INS_CPYFPRTRN = 212;
  ARM64_INS_CPYFPRTWN = 213;
  ARM64_INS_CPYFPT = 214;
  ARM64_INS_CPYFPTN = 215;
  ARM64_INS_CPYFPTRN = 216;
  ARM64_INS_CPYFPTWN = 217;
  ARM64_INS_CPYFPWN = 218;
  ARM64_INS_CPYFPWT = 219;
  ARM64_INS_CPYFPWTN = 220;
  ARM64_INS_CPYFPWTRN = 221;
  ARM64_INS_CPYFPWTWN = 222;
  ARM64_INS_CPYM = 223;
  ARM64_INS_CPYMN = 224;
  ARM64_INS_CPYMRN = 225;
  ARM64_INS_CPYMRT = 226;
  ARM64_INS_CPYMRTN = 227;
  ARM64_INS_CPYMRTRN = 228;
  ARM64_INS_CPYMRTWN = 229;
  ARM64_INS_CPYMT = 230;
  ARM64_INS_CPYMTN = 231;
  ARM64_INS_CPYMTRN = 232;
  ARM64_INS_CPYMTWN = 233;
  ARM64_INS_CPYMWN = 234;
  ARM64_INS_CPYMWT = 235;
  ARM64_INS_CPYMWTN = 236;
  ARM64_INS_CPYMWTRN = 237;
  ARM64_INS_CPYMWTWN = 238;
  ARM64_INS_CPYP = 239;
  ARM64_INS_CPYPN = 240;
  ARM64_INS_CPYPRN = 241;
  ARM64_INS_CPYPRT = 242;
  ARM64_INS_CPYPRTN = 243;
  ARM64_INS_CPYPRTRN = 244;
  ARM64_INS_CPYPRTWN = 245;
  ARM64_INS_CPYPT = 246;
  ARM64_INS_CPYPTN = 247;
  ARM64_INS_CPYPTRN = 248;
  ARM64_INS_CPYPTWN = 249;
  ARM64_INS_CPYPWN = 250;
  ARM64_INS_CPYPWT = 251;
  ARM64_INS_CPYPWTN = 252;
  ARM64_INS_CPYPWTRN = 253;
  ARM64_INS_CPYPWTWN = 254;
  ARM64_INS_CRC32B = 255;
  ARM64_INS_CRC32CB = 256;
  ARM64_INS_CRC32CH = 257;
  ARM64_INS_CRC32CW = 258;
  ARM64_INS_CRC32CX = 259;
  ARM64_INS_CRC32H = 260;
  ARM64_INS_CRC32W = 261;
  ARM64_INS_CRC32X = 262;
  ARM64_INS_CSDB = 263;
  ARM64_INS_CSEL = 264;
  ARM64_INS_CSET = 265;
  ARM64_INS_CSETM = 266;
  ARM64_INS_CSINC = 267;
  ARM64_INS_CSINV = 268;
  ARM64_INS_CSNEG = 269;
  ARM64_INS_CTERMEQ = 270;
  ARM64_INS_CTERMNE = 271;
  ARM64_INS_DCPS1 = 272;
  ARM64_INS_DCPS2 = 273;
  ARM64_INS_DCPS3 = 274;
  ARM64_INS_DECB = 275;
  ARM64_INS_DECD = 276;
  ARM64_INS_DECH = 277;
  ARM64_INS_DECP = 278;
  ARM64_INS_DECW = 279;
  ARM64_INS_DFB = 280;
  ARM64_INS_DGH = 281;
  ARM64_INS_DMB = 282;
  ARM64_INS_DRPS = 283;
  ARM64_INS_DSB = 284;
  ARM64_INS_DUP = 285;
  ARM64_INS_DUPM = 286;
  ARM64_INS_EON = 287;
  ARM64_INS_EOR = 288;
  ARM64_INS_EOR3 = 289;
  ARM64_INS_EORBT = 290;
  ARM64_INS_EORS = 291;
  ARM64_INS_EORTB = 292;
  ARM64_INS_EORV = 293;
  ARM64_INS_ERET = 294;
  ARM64_INS_ERETAA = 295;
  ARM64_INS_ERETAB = 296;
  ARM64_INS_ESB = 297;
  ARM64_INS_EXT = 298;
  ARM64_INS_EXTR = 299;
  ARM64_INS_FABD = 300;
  ARM64_INS_FABS = 301;
  ARM64_INS_FACGE = 302;
  ARM64_INS_FACGT = 303;
  ARM64_INS_FACLE = 304;
  ARM64_INS_FACLT = 305;
  ARM64_INS_FADD = 306;
  ARM64_INS_FADDA = 307;
  ARM64_INS_FADDP = 308;
  ARM64_INS_FADDV = 309;
  ARM64_INS_FCADD = 310;
  ARM64_INS_FCCMP = 311;
  ARM64_INS_FCCMPE = 312;
  ARM64_INS_FCMEQ = 313;
  ARM64_INS_FCMGE = 314;
  ARM64_INS_FCMGT = 315;
  ARM64_INS_FCMLA = 316;
  ARM64_INS_FCMLE = 317;
  ARM64_INS_FCMLT = 318;
  ARM64_INS_FCMNE = 319;
  ARM64_INS_FCMP = 320;
  ARM64_INS_FCMPE = 321;
  ARM64_INS_FCMUO = 322;
  ARM64_INS_FCPY = 323;
  ARM64_INS_FCSEL = 324;
  ARM64_INS_FCVT = 325;
  ARM64_INS_FCVTAS = 326;
  ARM64_INS_FCVTAU = 327;
  ARM64_INS_FCVTL = 328;
  ARM64_INS_FCVTL2 = 329;
  ARM64_INS_FCVTLT = 330;
  ARM64_INS_FCVTMS = 331;
  ARM64_INS_FCVTMU = 332;
  ARM64_INS_FCVTN = 333;
  ARM64_INS_FCVTN2 = 334;
  ARM64_INS_FCVTNS = 335;
  ARM64_INS_FCVTNT = 336;
  ARM64_INS_FCVTNU = 337;
  ARM64_INS_FCVTPS = 338;
  ARM64_INS_FCVTPU = 339;
  ARM64_INS_FCVTX = 340;
  ARM64_INS_FCVTXN = 341;
  ARM64_INS_FCVTXN2 = 342;
  ARM64_INS_FCVTXNT = 343;
  ARM64_INS_FCVTZS = 344;
  ARM64_INS_FCVTZU = 345;
  ARM64_INS_FDIV = 346;
  ARM64_INS_FDIVR = 347;
  ARM64_INS_FDUP = 348;
  ARM64_INS_FEXPA = 349;
  ARM64_INS_FJCVTZS = 350;
  ARM64_INS_FLOGB = 351;
  ARM64_INS_FMAD = 352;
  ARM64_INS_FMADD = 353;
  ARM64_INS_FMAX = 354;
  ARM64_INS_FMAXNM = 355;
  ARM64_INS_FMAXNMP = 356;
  ARM64_INS_FMAXNMV = 357;
  ARM64_INS_FMAXP = 358;
  ARM64_INS_FMAXV = 359;
  ARM64_INS_FMIN = 360;
  ARM64_INS_FMINNM = 361;
  ARM64_INS_FMINNMP = 362;
  ARM64_INS_FMINNMV = 363;
  ARM64_INS_FMINP = 364;
  ARM64_INS_FMINV = 365;
  ARM64_INS_FMLA = 366;
  ARM64_INS_FMLAL = 367;
  ARM64_INS_FMLAL2 = 368;
  ARM64_INS_FMLALB = 369;
  ARM64_INS_FMLALT = 370;
  ARM64_INS_FMLS = 371;
  ARM64_INS_FMLSL = 372;
  ARM64_INS_FMLSL2 = 373;
  ARM64_INS_FMLSLB = 374;
  ARM64_INS_FMLSLT = 375;
  ARM64_INS_FMMLA = 376;
  ARM64_INS_FMOPA = 377;
  ARM64_INS_FMOPS = 378;
  ARM64_INS_FMOV = 379;
  ARM64_INS_FMSB = 380;
  ARM64_INS_FMSUB = 381;
  ARM64_INS_FMUL = 382;
  ARM64_INS_FMULX = 383;
  ARM64_INS_FNEG = 384;
  ARM64_INS_FNMAD = 385;
  ARM64_INS_FNMADD = 386;
  ARM64_INS_FNMLA = 387;
  ARM64_INS_FNMLS = 388;
  ARM64_INS_FNMSB = 389;
  ARM64_INS_FNMSUB = 390;
  ARM64_INS_FNMUL = 391;
  ARM64_INS_FRECPE = 392;
  ARM64_INS_FRECPS = 393;
  ARM64_INS_FRECPX = 394;
  ARM64_INS_FRINT32X = 395;
  ARM64_INS_FRINT32Z = 396;
  ARM64_INS_FRINT64X = 397;
  ARM64_INS_FRINT64Z = 398;
  ARM64_INS_FRINTA = 399;
  ARM64_INS_FRINTI = 400;
  ARM64_INS_FRINTM = 401;
  ARM64_INS_FRINTN = 402;
  ARM64_INS_FRINTP = 403;
  ARM64_INS_FRINTX = 404;
  ARM64_INS_FRINTZ = 405;
  ARM64_INS_FRSQRTE = 406;
  ARM64_INS_FRSQRTS = 407;
  ARM64_INS_FSCALE = 408;
  ARM64_INS_FSQRT = 409;
  ARM64_INS_FSUB = 410;
  ARM64_INS_FSUBR = 411;
  ARM64_INS_FTMAD = 412;
  ARM64_INS_FTSMUL = 413;
  ARM64_INS_FTSSEL = 414;
  ARM64_INS_GMI = 415;
  ARM64_INS_HINT = 416;
  ARM64_INS_HISTCNT = 417;
  ARM64_INS_HISTSEG = 418;
  ARM64_INS_HLT = 419;
  ARM64_INS_HVC = 420;
  ARM64_INS_INCB = 421;
  ARM64_INS_INCD = 422;
  ARM64_INS_INCH = 423;
  ARM64_INS_INCP = 424;
  ARM64_INS_INCW = 425;
  ARM64_INS_INDEX = 426;
  ARM64_INS_INS = 427;
  ARM64_INS_INSR = 428;
  ARM64_INS_IRG = 429;
  ARM64_INS_ISB = 430;
  ARM64_INS_LASTA = 431;
  ARM64_INS_LASTB = 432;
  ARM64_INS_LD1 = 433;
  ARM64_INS_LD1B = 434;
  ARM64_INS_LD1D = 435;
  ARM64_INS_LD1H = 436;
  ARM64_INS_LD1Q = 437;
  ARM64_INS_LD1R = 438;
  ARM64_INS_LD1RB = 439;
  ARM64_INS_LD1RD = 440;
  ARM64_INS_LD1RH = 441;
  ARM64_INS_LD1ROB = 442;
  ARM64_INS_LD1ROD = 443;
  ARM64_INS_LD1ROH = 444;
  ARM64_INS_LD1ROW = 445;
  ARM64_INS_LD1RQB = 446;
  ARM64_INS_LD1RQD = 447;
  ARM64_INS_LD1RQH = 448;
  ARM64_INS_LD1RQW = 449;
  ARM64_INS_LD1RSB = 450;
  ARM64_INS_LD1RSH = 451;
  ARM64_INS_LD1RSW = 452;
  ARM64_INS_LD1RW = 453;
  ARM64_INS_LD1SB = 454;
  ARM64_INS_LD1SH = 455;
  ARM64_INS_LD1SW = 456;
  ARM64_INS_LD1W = 457;
  ARM64_INS_LD2 = 458;
  ARM64_INS_LD2B = 459;
  ARM64_INS_LD2D = 460;
  ARM64_INS_LD2H = 461;
  ARM64_INS_LD2R = 462;
  ARM64_INS_LD2W = 463;
  ARM64_INS_LD3 = 464;
  ARM64_INS_LD3B = 465;
  ARM64_INS_LD3D = 466;
  ARM64_INS_LD3H = 467;
  ARM64_INS_LD3R = 468;
  ARM64_INS_LD3W = 469;
  ARM64_INS_LD4 = 470;
  ARM64_INS_LD4B = 471;
  ARM64_INS_LD4D = 472;
  ARM64_INS_LD4H = 473;
  ARM64_INS_LD4R = 474;
  ARM64_INS_LD4W = 475;
  ARM64_INS_LD64B = 476;
  ARM64_INS_LDADD = 477;
  ARM64_INS_LDADDA = 478;
  ARM64_INS_LDADDAB = 479;
  ARM64_INS_LDADDAH = 480;
  ARM64_INS_LDADDAL = 481;
  ARM64_INS_LDADDALB = 482;
  ARM64_INS_LDADDALH = 483;
  ARM64_INS_LDADDB = 484;
  ARM64_INS_LDADDH = 485;
  ARM64_INS_LDADDL = 486;
  ARM64_INS_LDADDLB = 487;
  ARM64_INS_LDADDLH = 488;
  ARM64_INS_LDAPR = 489;
  ARM64_INS_LDAPRB = 490;
  ARM64_INS_LDAPRH = 491;
  ARM64_INS_LDAPUR = 492;
  ARM64_INS_LDAPURB = 493;
  ARM64_INS_LDAPURH = 494;
  ARM64_INS_LDAPURSB = 495;
  ARM64_INS_LDAPURSH = 496;
  ARM64_INS_LDAPURSW = 497;
  ARM64_INS_LDAR = 498;
  ARM64_INS_LDARB = 499;
  ARM64_INS_LDARH = 500;
  ARM64_INS_LDAXP = 501;
  ARM64_INS_LDAXR = 502;
  ARM64_INS_LDAXRB = 503;
  ARM64_INS_LDAXRH = 504;
  ARM64_INS_LDCLR = 505;
  ARM64_INS_LDCLRA = 506;
  ARM64_INS_LDCLRAB = 507;
  ARM64_INS_LDCLRAH = 508;
  ARM64_INS_LDCLRAL = 509;
  ARM64_INS_LDCLRALB = 510;
  ARM64_INS_LDCLRALH = 511;
  ARM64_INS_LDCLRB = 512;
  ARM64_INS_LDCLRH = 513;
  ARM64_INS_LDCLRL = 514;
  ARM64_INS_LDCLRLB = 515;
  ARM64_INS_LDCLRLH = 516;
  ARM64_INS_LDEOR = 517;
  ARM64_INS_LDEORA = 518;
  ARM64_INS_LDEORAB = 519;
  ARM64_INS_LDEORAH = 520;
  ARM64_INS_LDEORAL = 521;
  ARM64_INS_LDEORALB = 522;
  ARM64_INS_LDEORALH = 523;
  ARM64_INS_LDEORB = 524;
  ARM64_INS_LDEORH = 525;
  ARM64_INS_LDEORL = 526;
  ARM64_INS_LDEORLB = 527;
  ARM64_INS_LDEORLH = 528;
  ARM64_INS_LDFF1B = 529;
  ARM64_INS_LDFF1D = 530;
  ARM64_INS_LDFF1H = 531;
  ARM64_INS_LDFF1SB = 532;
  ARM64_INS_LDFF1SH = 533;
  ARM64_INS_LDFF1SW = 534;
  ARM64_INS_LDFF1W = 535;
  ARM64_INS_LDG = 536;
  ARM64_INS_LDGM = 537;
  ARM64_INS_LDLAR = 538;
  ARM64_INS_LDLARB = 539;
  ARM64_INS_LDLARH = 540;
  ARM64_INS_LDNF1B = 541;
  ARM64_INS_LDNF1D = 542;
  ARM64_INS_LDNF1H = 543;
  ARM64_INS_LDNF1SB = 544;
  ARM64_INS_LDNF1SH = 545;
  ARM64_INS_LDNF1SW = 546;
  ARM64_INS_LDNF1W = 547;
  ARM64_INS_LDNP = 548;
  ARM64_INS_LDNT1B = 549;
  ARM64_INS_LDNT1D = 550;
  ARM64_INS_LDNT1H = 551;
  ARM64_INS_LDNT1SB = 552;
  ARM64_INS_LDNT1SH = 553;
  ARM64_INS_LDNT1SW = 554;
  ARM64_INS_LDNT1W = 555;
  ARM64_INS_LDP = 556;
  ARM64_INS_LDPSW = 557;
  ARM64_INS_LDR = 558;
  ARM64_INS_LDRAA = 559;
  ARM64_INS_LDRAB = 560;
  ARM64_INS_LDRB = 561;
  ARM64_INS_LDRH = 562;
  ARM64_INS_LDRSB = 563;
  ARM64_INS_LDRSH = 564;
  ARM64_INS_LDRSW = 565;
  ARM64_INS_LDSET = 566;
  ARM64_INS_LDSETA = 567;
  ARM64_INS_LDSETAB = 568;
  ARM64_INS_LDSETAH = 569;
  ARM64_INS_LDSETAL = 570;
  ARM64_INS_LDSETALB = 571;
  ARM64_INS_LDSETALH = 572;
  ARM64_INS_LDSETB = 573;
  ARM64_INS_LDSETH = 574;
  ARM64_INS_LDSETL = 575;
  ARM64_INS_LDSETLB = 576;
  ARM64_INS_LDSETLH = 577;
  ARM64_INS_LDSMAX = 578;
  ARM64_INS_LDSMAXA = 579;
  ARM64_INS_LDSMAXAB = 580;
  ARM64_INS_LDSMAXAH = 581;
  ARM64_INS_LDSMAXAL = 582;
  ARM64_INS_LDSMAXALB = 583;
  ARM64_INS_LDSMAXALH = 584;
  ARM64_INS_LDSMAXB = 585;
  ARM64_INS_LDSMAXH = 586;
  ARM64_INS_LDSMAXL = 587;
  ARM64_INS_LDSMAXLB = 588;
  ARM64_INS_LDSMAXLH = 589;
  ARM64_INS_LDSMIN = 590;
  ARM64_INS_LDSMINA = 591;
  ARM64_INS_LDSMINAB = 592;
  ARM64_INS_LDSMINAH = 593;
  ARM64_INS_LDSMINAL = 594;
  ARM64_INS_LDSMINALB = 595;
  ARM64_INS_LDSMINALH = 596;
  ARM64_INS_LDSMINB = 597;
  ARM64_INS_LDSMINH = 598;
  ARM64_INS_LDSMINL = 599;
  ARM64_INS_LDSMINLB = 600;
  ARM64_INS_LDSMINLH = 601;
  ARM64_INS_LDTR = 602;
  ARM64_INS_LDTRB = 603;
  ARM64_INS_LDTRH = 604;
  ARM64_INS_LDTRSB = 605;
  ARM64_INS_LDTRSH = 606;
  ARM64_INS_LDTRSW = 607;
  ARM64_INS_LDUMAX = 608;
  ARM64_INS_LDUMAXA = 609;
  ARM64_INS_LDUMAXAB = 610;
  ARM64_INS_LDUMAXAH = 611;
  ARM64_INS_LDUMAXAL = 612;
  ARM64_INS_LDUMAXALB = 613;
  ARM64_INS_LDUMAXALH = 614;
  ARM64_INS_LDUMAXB = 615;
  ARM64_INS_LDUMAXH = 616;
  ARM64_INS_LDUMAXL = 617;
  ARM64_INS_LDUMAXLB = 618;
  ARM64_INS_LDUMAXLH = 619;
  ARM64_INS_LDUMIN = 620;
  ARM64_INS_LDUMINA = 621;
  ARM64_INS_LDUMINAB = 622;
  ARM64_INS_LDUMINAH = 623;
  ARM64_INS_LDUMINAL = 624;
  ARM64_INS_LDUMINALB = 625;
  ARM64_INS_LDUMINALH = 626;
  ARM64_INS_LDUMINB = 627;
  ARM64_INS_LDUMINH = 628;
  ARM64_INS_LDUMINL = 629;
  ARM64_INS_LDUMINLB = 630;
  ARM64_INS_LDUMINLH = 631;
  ARM64_INS_LDUR = 632;
  ARM64_INS_LDURB = 633;
  ARM64_INS_LDURH = 634;
  ARM64_INS_LDURSB = 635;
  ARM64_INS_LDURSH = 636;
  ARM64_INS_LDURSW = 637;
  ARM64_INS_LDXP = 638;
  ARM64_INS_LDXR = 639;
  ARM64_INS_LDXRB = 640;
  ARM64_INS_LDXRH = 641;
  ARM64_INS_LSL = 642;
  ARM64_INS_LSLR = 643;
  ARM64_INS_LSLV = 644;
  ARM64_INS_LSR = 645;
  ARM64_INS_LSRR = 646;
  ARM64_INS_LSRV = 647;
  ARM64_INS_MAD = 648;
  ARM64_INS_MADD = 649;
  ARM64_INS_MATCH = 650;
  ARM64_INS_MLA = 651;
  ARM64_INS_MLS = 652;
  ARM64_INS_MNEG = 653;
  ARM64_INS_MOV = 654;
  ARM64_INS_MOVA = 655;
  ARM64_INS_MOVI = 656;
  ARM64_INS_MOVK = 657;
  ARM64_INS_MOVN = 658;
  ARM64_INS_MOVPRFX = 659;
  ARM64_INS_MOVS = 660;
  ARM64_INS_MOVZ = 661;
  ARM64_INS_MRS = 662;
  ARM64_INS_MSB = 663;
  ARM64_INS_MSR = 664;
  ARM64_INS_MSUB = 665;
  ARM64_INS_MUL = 666;
  ARM64_INS_MVN = 667;
  ARM64_INS_MVNI = 668;
  ARM64_INS_NAND = 669;
  ARM64_INS_NANDS = 670;
  ARM64_INS_NBSL = 671;
  ARM64_INS_NEG = 672;
  ARM64_INS_NEGS = 673;
  ARM64_INS_NGC = 674;
  ARM64_INS_NGCS = 675;
  ARM64_INS_NMATCH = 676;
  ARM64_INS_NOP = 677;
  ARM64_INS_NOR = 678;
  ARM64_INS_NORS = 679;
  ARM64_INS_NOT = 680;
  ARM64_INS_NOTS = 681;
  ARM64_INS_ORN = 682;
  ARM64_INS_ORNS = 683;
  ARM64_INS_ORR = 684;
  ARM64_INS_ORRS = 685;
  ARM64_INS_ORV = 686;
  ARM64_INS_PACDA = 687;
  ARM64_INS_PACDB = 688;
  ARM64_INS_PACDZA = 689;
  ARM64_INS_PACDZB = 690;
  ARM64_INS_PACGA = 691;
  ARM64_INS_PACIA = 692;
  ARM64_INS_PACIA1716 = 693;
  ARM64_INS_PACIASP = 694;
  ARM64_INS_PACIAZ = 695;
  ARM64_INS_PACIB = 696;
  ARM64_INS_PACIB1716 = 697;
  ARM64_INS_PACIBSP = 698;
  ARM64_INS_PACIBZ = 699;
  ARM64_INS_PACIZA = 700;
  ARM64_INS_PACIZB = 701;
  ARM64_INS_PFALSE = 702;
  ARM64_INS_PFIRST = 703;
  ARM64_INS_PMUL = 704;
  ARM64_INS_PMULL = 705;
  ARM64_INS_PMULL2 = 706;
  ARM64_INS_PMULLB = 707;
  ARM64_INS_PMULLT = 708;
  ARM64_INS_PNEXT = 709;
  ARM64_INS_PRFB = 710;
  ARM64_INS_PRFD = 711;
  ARM64_INS_PRFH = 712;
  ARM64_INS_PRFM = 713;
  ARM64_INS_PRFUM = 714;
  ARM64_INS_PRFW = 715;
  ARM64_INS_PSB = 716;
  ARM64_INS_PSEL = 717;
  ARM64_INS_PSSBB = 718;
  ARM64_INS_PTEST = 719;
  ARM64_INS_PTRUE = 720;
  ARM64_INS_PTRUES = 721;
  ARM64_INS_PUNPKHI = 722;
  ARM64_INS_PUNPKLO = 723;
  ARM64_INS_RADDHN = 724;
  ARM64_INS_RADDHN2 = 725;
  ARM64_INS_RADDHNB = 726;
  ARM64_INS_RADDHNT = 727;
  ARM64_INS_RAX1 = 728;
  ARM64_INS_RBIT = 729;
  ARM64_INS_RDFFR = 730;
  ARM64_INS_RDFFRS = 731;
  ARM64_INS_RDVL = 732;
  ARM64_INS_RET = 733;
  ARM64_INS_RETAA = 734;
  ARM64_INS_RETAB = 735;
  ARM64_INS_REV = 736;
  ARM64_INS_REV16 = 737;
  ARM64_INS_REV32 = 738;
  ARM64_INS_REV64 = 739;
  ARM64_INS_REVB = 740;
  ARM64_INS_REVD = 741;
  ARM64_INS_REVH = 742;
  ARM64_INS_REVW = 743;
  ARM64_INS_RMIF = 744;
  ARM64_INS_ROR = 745;
  ARM64_INS_RORV = 746;
  ARM64_INS_RSHRN = 747;
  ARM64_INS_RSHRN2 = 748;
  ARM64_INS_RSHRNB = 749;
  ARM64_INS_RSHRNT = 750;
  ARM64_INS_RSUBHN = 751;
  ARM64_INS_RSUBHN2 = 752;
  ARM64_INS_RSUBHNB = 753;
  ARM64_INS_RSUBHNT = 754;
  ARM64_INS_SABA = 755;
  ARM64_INS_SABAL = 756;
  ARM64_INS_SABAL2 = 757;
  ARM64_INS_SABALB = 758;
  ARM64_INS_SABALT = 759;
  ARM64_INS_SABD = 760;
  ARM64_INS_SABDL = 761;
  ARM64_INS_SABDL2 = 762;
  ARM64_INS_SABDLB = 763;
  ARM64_INS_SABDLT = 764;
  ARM64_INS_SADALP = 765;
  ARM64_INS_SADDL = 766;
  ARM64_INS_SADDL2 = 767;
  ARM64_INS_SADDLB = 768;
  ARM64_INS_SADDLBT = 769;
  ARM64_INS_SADDLP = 770;
  ARM64_INS_SADDLT = 771;
  ARM64_INS_SADDLV = 772;
  ARM64_INS_SADDV = 773;
  ARM64_INS_SADDW = 774;
  ARM64_INS_SADDW2 = 775;
  ARM64_INS_SADDWB = 776;
  ARM64_INS_SADDWT = 777;
  ARM64_INS_SB = 778;
  ARM64_INS_SBC = 779;
  ARM64_INS_SBCLB = 780;
  ARM64_INS_SBCLT = 781;
  ARM64_INS_SBCS = 782;
  ARM64_INS_SBFM = 783;
  ARM64_INS_SCLAMP = 784;
  ARM64_INS_SCVTF = 785;
  ARM64_INS_SDIV = 786;
  ARM64_INS_SDIVR = 787;
  ARM64_INS_SDOT = 788;
  ARM64_INS_SEL = 789;
  ARM64_INS_SETE = 790;
  ARM64_INS_SETEN = 791;
  ARM64_INS_SETET = 792;
  ARM64_INS_SETETN = 793;
  ARM64_INS_SETF16 = 794;
  ARM64_INS_SETF8 = 795;
  ARM64_INS_SETFFR = 796;
  ARM64_INS_SETGE = 797;
  ARM64_INS_SETGEN = 798;
  ARM64_INS_SETGET = 799;
  ARM64_INS_SETGETN = 800;
  ARM64_INS_SETGM = 801;
  ARM64_INS_SETGMN = 802;
  ARM64_INS_SETGMT = 803;
  ARM64_INS_SETGMTN = 804;
  ARM64_INS_SETGP = 805;
  ARM64_INS_SETGPN = 806;
  ARM64_INS_SETGPT = 807;
  ARM64_INS_SETGPTN = 808;
  ARM64_INS_SETM = 809;
  ARM64_INS_SETMN = 810;
  ARM64_INS_SETMT = 811;
  ARM64_INS_SETMTN = 812;
  ARM64_INS_SETP = 813;
  ARM64_INS_SETPN = 814;
  ARM64_INS_SETPT = 815;
  ARM64_INS_SETPTN = 816;
  ARM64_INS_SEV = 817;
  ARM64_INS_SEVL = 818;
  ARM64_INS_SHA1C = 819;
  ARM64_INS_SHA1H = 820;
  ARM64_INS_SHA1M = 821;
  ARM64_INS_SHA1P = 822;
  ARM64_INS_SHA1SU0 = 823;
  ARM64_INS_SHA1SU1 = 824;
  ARM64_INS_SHA256H = 825;
  ARM64_INS_SHA256H2 = 826;
  ARM64_INS_SHA256SU0 = 827;
  ARM64_INS_SHA256SU1 = 828;
  ARM64_INS_SHA512H = 829;
  ARM64_INS_SHA512H2 = 830;
  ARM64_INS_SHA512SU0 = 831;
  ARM64_INS_SHA512SU1 = 832;
  ARM64_INS_SHADD = 833;
  ARM64_INS_SHL = 834;
  ARM64_INS_SHLL = 835;
  ARM64_INS_SHLL2 = 836;
  ARM64_INS_SHRN = 837;
  ARM64_INS_SHRN2 = 838;
  ARM64_INS_SHRNB = 839;
  ARM64_INS_SHRNT = 840;
  ARM64_INS_SHSUB = 841;
  ARM64_INS_SHSUBR = 842;
  ARM64_INS_SLI = 843;
  ARM64_INS_SM3PARTW1 = 844;
  ARM64_INS_SM3PARTW2 = 845;
  ARM64_INS_SM3SS1 = 846;
  ARM64_INS_SM3TT1A = 847;
  ARM64_INS_SM3TT1B = 848;
  ARM64_INS_SM3TT2A = 849;
  ARM64_INS_SM3TT2B = 850;
  ARM64_INS_SM4E = 851;
  ARM64_INS_SM4EKEY = 852;
  ARM64_INS_SMADDL = 853;
  ARM64_INS_SMAX = 854;
  ARM64_INS_SMAXP = 855;
  ARM64_INS_SMAXV = 856;
  ARM64_INS_SMC = 857;
  ARM64_INS_SMIN = 858;
  ARM64_INS_SMINP = 859;
  ARM64_INS_SMINV = 860;
  ARM64_INS_SMLAL = 861;
  ARM64_INS_SMLAL2 = 862;
  ARM64_INS_SMLALB = 863;
  ARM64_INS_SMLALT = 864;
  ARM64_INS_SMLSL = 865;
  ARM64_INS_SMLSL2 = 866;
  ARM64_INS_SMLSLB = 867;
  ARM64_INS_SMLSLT = 868;
  ARM64_INS_SMMLA = 869;
  ARM64_INS_SMNEGL = 870;
  ARM64_INS_SMOPA = 871;
  ARM64_INS_SMOPS = 872;
  ARM64_INS_SMOV = 873;
  ARM64_INS_SMSTART = 874;
  ARM64_INS_SMSTOP = 875;
  ARM64_INS_SMSUBL = 876;
  ARM64_INS_SMULH = 877;
  ARM64_INS_SMULL = 878;
  ARM64_INS_SMULL2 = 879;
  ARM64_INS_SMULLB = 880;
  ARM64_INS_SMULLT = 881;
  ARM64_INS_SPLICE = 882;
  ARM64_INS_SQABS = 883;
  ARM64_INS_SQADD = 884;
  ARM64_INS_SQCADD = 885;
  ARM64_INS_SQDECB = 886;
  ARM64_INS_SQDECD = 887;
  ARM64_INS_SQDECH = 888;
  ARM64_INS_SQDECP = 889;
  ARM64_INS_SQDECW = 890;
  ARM64_INS_SQDMLAL = 891;
  ARM64_INS_SQDMLAL2 = 892;
  ARM64_INS_SQDMLALB = 893;
  ARM64_INS_SQDMLALBT = 894;
  ARM64_INS_SQDMLALT = 895;
  ARM64_INS_SQDMLSL = 896;
  ARM64_INS_SQDMLSL2 = 897;
  ARM64_INS_SQDMLSLB = 898;
  ARM64_INS_SQDMLSLBT = 899;
  ARM64_INS_SQDMLSLT = 900;
  ARM64_INS_SQDMULH = 901;
  ARM64_INS_SQDMULL = 902;
  ARM64_INS_SQDMULL2 = 903;
  ARM64_INS_SQDMULLB = 904;
  ARM64_INS_SQDMULLT = 905;
  ARM64_INS_SQINCB = 906;
  ARM64_INS_SQINCD = 907;
  ARM64_INS_SQINCH = 908;
  ARM64_INS_SQINCP = 909;
  ARM64_INS_SQINCW = 910;
  ARM64_INS_SQNEG = 911;
  ARM64_INS_SQRDCMLAH = 912;
  ARM64_INS_SQRDMLAH = 913;
  ARM64_INS_SQRDMLSH = 914;
  ARM64_INS_SQRDMULH = 915;
  ARM64_INS_SQRSHL = 916;
  ARM64_INS_SQRSHLR = 917;
  ARM64_INS_SQRSHRN = 918;
  ARM64_INS_SQRSHRN2 = 919;
  ARM64_INS_SQRSHRNB = 920;
  ARM64_INS_SQRSHRNT = 921;
  ARM64_INS_SQRSHRUN = 922;
  ARM64_INS_SQRSHRUN2 = 923;
  ARM64_INS_SQRSHRUNB = 924;
  ARM64_INS_SQRSHRUNT = 925;
  ARM64_INS_SQSHL = 926;
  ARM64_INS_SQSHLR = 927;
  ARM64_INS_SQSHLU = 928;
  ARM64_INS_SQSHRN = 929;
  ARM64_INS_SQSHRN2 = 930;
  ARM64_INS_SQSHRNB = 931;
  ARM64_INS_SQSHRNT = 932;
  ARM64_INS_SQSHRUN = 933;
  ARM64_INS_SQSHRUN2 = 934;
  ARM64_INS_SQSHRUNB = 935;
  ARM64_INS_SQSHRUNT = 936;
  ARM64_INS_SQSUB = 937;
  ARM64_INS_SQSUBR = 938;
  ARM64_INS_SQXTN = 939;
  ARM64_INS_SQXTN2 = 940;
  ARM64_INS_SQXTNB = 941;
  ARM64_INS_SQXTNT = 942;
  ARM64_INS_SQXTUN = 943;
  ARM64_INS_SQXTUN2 = 944;
  ARM64_INS_SQXTUNB = 945;
  ARM64_INS_SQXTUNT = 946;
  ARM64_INS_SRHADD = 947;
  ARM64_INS_SRI = 948;
  ARM64_INS_SRSHL = 949;
  ARM64_INS_SRSHLR = 950;
  ARM64_INS_SRSHR = 951;
  ARM64_INS_SRSRA = 952;
  ARM64_INS_SSBB = 953;
  ARM64_INS_SSHL = 954;
  ARM64_INS_SSHLL = 955;
  ARM64_INS_SSHLL2 = 956;
  ARM64_INS_SSHLLB = 957;
  ARM64_INS_SSHLLT = 958;
  ARM64_INS_SSHR = 959;
  ARM64_INS_SSRA = 960;
  ARM64_INS_SSUBL = 961;
  ARM64_INS_SSUBL2 = 962;
  ARM64_INS_SSUBLB = 963;
  ARM64_INS_SSUBLBT = 964;
  ARM64_INS_SSUBLT = 965;
  ARM64_INS_SSUBLTB = 966;
  ARM64_INS_SSUBW = 967;
  ARM64_INS_SSUBW2 = 968;
  ARM64_INS_SSUBWB = 969;
  ARM64_INS_SSUBWT = 970;
  ARM64_INS_ST1 = 971;
  ARM64_INS_ST1B = 972;
  ARM64_INS_ST1D = 973;
  ARM64_INS_ST1H = 974;
  ARM64_INS_ST1Q = 975;
  ARM64_INS_ST1W = 976;
  ARM64_INS_ST2 = 977;
  ARM64_INS_ST2B = 978;
  ARM64_INS_ST2D = 979;
  ARM64_INS_ST2G = 980;
  ARM64_INS_ST2H = 981;
  ARM64_INS_ST2W = 982;
  ARM64_INS_ST3 = 983;
  ARM64_INS_ST3B = 984;
  ARM64_INS_ST3D = 985;
  ARM64_INS_ST3H = 986;
  ARM64_INS_ST3W = 987;
  ARM64_INS_ST4 = 988;
  ARM64_INS_ST4B = 989;
  ARM64_INS_ST4D = 990;
  ARM64_INS_ST4H = 991;
  ARM64_INS_ST4W = 992;
  ARM64_INS_ST64B = 993;
  ARM64_INS_ST64BV = 994;
  ARM64_INS_ST64BV0 = 995;
  ARM64_INS_STADD = 996;
  ARM64_INS_STADDB = 997;
  ARM64_INS_STADDH = 998;
  ARM64_INS_STADDL = 999;
  ARM64_INS_STADDLB = 1000;
  ARM64_INS_STADDLH = 1001;
  ARM64_INS_STCLR = 1002;
  ARM64_INS_STCLRB = 1003;
  ARM64_INS_STCLRH = 1004;
  ARM64_INS_STCLRL = 1005;
  ARM64_INS_STCLRLB = 1006;
  ARM64_INS_STCLRLH = 1007;
  ARM64_INS_STEOR = 1008;
  ARM64_INS_STEORB = 1009;
  ARM64_INS_STEORH = 1010;
  ARM64_INS_STEORL = 1011;
  ARM64_INS_STEORLB = 1012;
  ARM64_INS_STEORLH = 1013;
  ARM64_INS_STG = 1014;
  ARM64_INS_STGM = 1015;
  ARM64_INS_STGP = 1016;
  ARM64_INS_STLLR = 1017;
  ARM64_INS_STLLRB = 1018;
  ARM64_INS_STLLRH = 1019;
  ARM64_INS_STLR = 1020;
  ARM64_INS_STLRB = 1021;
  ARM64_INS_STLRH = 1022;
  ARM64_INS_STLUR = 1023;
  ARM64_INS_STLURB = 1024;
  ARM64_INS_STLURH = 1025;
  ARM64_INS_STLXP = 1026;
  ARM64_INS_STLXR = 1027;
  ARM64_INS_STLXRB = 1028;
  ARM64_INS_STLXRH = 1029;
  ARM64_INS_STNP = 1030;
  ARM64_INS_STNT1B = 1031;
  ARM64_INS_STNT1D = 1032;
  ARM64_INS_STNT1H = 1033;
  ARM64_INS_STNT1W = 1034;
  ARM64_INS_STP = 1035;
  ARM64_INS_STR = 1036;
  ARM64_INS_STRB = 1037;
  ARM64_INS_STRH = 1038;
  ARM64_INS_STSET = 1039;
  ARM64_INS_STSETB = 1040;
  ARM64_INS_STSETH = 1041;
  ARM64_INS_STSETL = 1042;
  ARM64_INS_STSETLB = 1043;
  ARM64_INS_STSETLH = 1044;
  ARM64_INS_STSMAX = 1045;
  ARM64_INS_STSMAXB = 1046;
  ARM64_INS_STSMAXH = 1047;
  ARM64_INS_STSMAXL = 1048;
  ARM64_INS_STSMAXLB = 1049;
  ARM64_INS_STSMAXLH = 1050;
  ARM64_INS_STSMIN = 1051;
  ARM64_INS_STSMINB = 1052;
  ARM64_INS_STSMINH = 1053;
  ARM64_INS_STSMINL = 1054;
  ARM64_INS_STSMINLB = 1055;
  ARM64_INS_STSMINLH = 1056;
  ARM64_INS_STTR = 1057;
  ARM64_INS_STTRB = 1058;
  ARM64_INS_STTRH = 1059;
  ARM64_INS_STUMAX = 1060;
  ARM64_INS_STUMAXB = 1061;
  ARM64_INS_STUMAXH = 1062;
  ARM64_INS_STUMAXL = 1063;
  ARM64_INS_STUMAXLB = 1064;
  ARM64_INS_STUMAXLH = 1065;
  ARM64_INS_STUMIN = 1066;
  ARM64_INS_STUMINB = 1067;
  ARM64_INS_STUMINH = 1068;
  ARM64_INS_STUMINL = 1069;
  ARM64_INS_STUMINLB = 1070;
  ARM64_INS_STUMINLH = 1071;
  ARM64_INS_STUR = 1072;
  ARM64_INS_STURB = 1073;
  ARM64_INS_STURH = 1074;
  ARM64_INS_STXP = 1075;
  ARM64_INS_STXR = 1076;
  ARM64_INS_STXRB = 1077;
  ARM64_INS_STXRH = 1078;
  ARM64_INS_STZ2G = 1079;
  ARM64_INS_STZG = 1080;
  ARM64_INS_STZGM = 1081;
  ARM64_INS_SUB = 1082;
  ARM64_INS_SUBG = 1083;
  ARM64_INS_SUBHN = 1084;
  ARM64_INS_SUBHN2 = 1085;
  ARM64_INS_SUBHNB = 1086;
  ARM64_INS_SUBHNT = 1087;
  ARM64_INS_SUBP = 1088;
  ARM64_INS_SUBPS = 1089;
  ARM64_INS_SUBR = 1090;
  ARM64_INS_SUBS = 1091;
  ARM64_INS_SUDOT = 1092;
  ARM64_INS_SUMOPA = 1093;
  ARM64_INS_SUMOPS = 1094;
  ARM64_INS_SUNPKHI = 1095;
  ARM64_INS_SUNPKLO = 1096;
  ARM64_INS_SUQADD = 1097;
  ARM64_INS_SVC = 1098;
  ARM64_INS_SWP = 1099;
  ARM64_INS_SWPA = 1100;
  ARM64_INS_SWPAB = 1101;
  ARM64_INS_SWPAH = 1102;
  ARM64_INS_SWPAL = 1103;
  ARM64_INS_SWPALB = 1104;
  ARM64_INS_SWPALH = 1105;
  ARM64_INS_SWPB = 1106;
  ARM64_INS_SWPH = 1107;
  ARM64_INS_SWPL = 1108;
  ARM64_INS_SWPLB = 1109;
  ARM64_INS_SWPLH = 1110;
  ARM64_INS_SXTB = 1111;
  ARM64_INS_SXTH = 1112;
  ARM64_INS_SXTL = 1113;
  ARM64_INS_SXTL2 = 1114;
  ARM64_INS_SXTW = 1115;
  ARM64_INS_SYS = 1116;
  ARM64_INS_SYSL = 1117;
  ARM64_INS_TBL = 1118;
  ARM64_INS_TBNZ = 1119;
  ARM64_INS_TBX = 1120;
  ARM64_INS_TBZ = 1121;
  ARM64_INS_TCANCEL = 1122;
  ARM64_INS_TCOMMIT = 1123;
  ARM64_INS_TRN1 = 1124;
  ARM64_INS_TRN2 = 1125;
  ARM64_INS_TSB = 1126;
  ARM64_INS_TST = 1127;
  ARM64_INS_TSTART = 1128;
  ARM64_INS_TTEST = 1129;
  ARM64_INS_UABA = 1130;
  ARM64_INS_UABAL = 1131;
  ARM64_INS_UABAL2 = 1132;
  ARM64_INS_UABALB = 1133;
  ARM64_INS_UABALT = 1134;
  ARM64_INS_UABD = 1135;
  ARM64_INS_UABDL = 1136;
  ARM64_INS_UABDL2 = 1137;
  ARM64_INS_UABDLB = 1138;
  ARM64_INS_UABDLT = 1139;
  ARM64_INS_UADALP = 1140;
  ARM64_INS_UADDL = 1141;
  ARM64_INS_UADDL2 = 1142;
  ARM64_INS_UADDLB = 1143;
  ARM64_INS_UADDLP = 1144;
  ARM64_INS_UADDLT = 1145;
  ARM64_INS_UADDLV = 1146;
  ARM64_INS_UADDV = 1147;
  ARM64_INS_UADDW = 1148;
  ARM64_INS_UADDW2 = 1149;
  ARM64_INS_UADDWB = 1150;
  ARM64_INS_UADDWT = 1151;
  ARM64_INS_UBFM = 1152;
  ARM64_INS_UCLAMP = 1153;
  ARM64_INS_UCVTF = 1154;
  ARM64_INS_UDF = 1155;
  ARM64_INS_UDIV = 1156;
  ARM64_INS_UDIVR = 1157;
  ARM64_INS_UDOT = 1158;
  ARM64_INS_UHADD = 1159;
  ARM64_INS_UHSUB = 1160;
  ARM64_INS_UHSUBR = 1161;
  ARM64_INS_UMADDL = 1162;
  ARM64_INS_UMAX = 1163;
  ARM64_INS_UMAXP = 1164;
  ARM64_INS_UMAXV = 1165;
  ARM64_INS_UMIN = 1166;
  ARM64_INS_UMINP = 1167;
  ARM64_INS_UMINV = 1168;
  ARM64_INS_UMLAL = 1169;
  ARM64_INS_UMLAL2 = 1170;
  ARM64_INS_UMLALB = 1171;
  ARM64_INS_UMLALT = 1172;
  ARM64_INS_UMLSL = 1173;
  ARM64_INS_UMLSL2 = 1174;
  ARM64_INS_UMLSLB = 1175;
  ARM64_INS_UMLSLT = 1176;
  ARM64_INS_UMMLA = 1177;
  ARM64_INS_UMNEGL = 1178;
  ARM64_INS_UMOPA = 1179;
  ARM64_INS_UMOPS = 1180;
  ARM64_INS_UMOV = 1181;
  ARM64_INS_UMSUBL = 1182;
  ARM64_INS_UMULH = 1183;
  ARM64_INS_UMULL = 1184;
  ARM64_INS_UMULL2 = 1185;
  ARM64_INS_UMULLB = 1186;
  ARM64_INS_UMULLT = 1187;
  ARM64_INS_UQADD = 1188;
  ARM64_INS_UQDECB = 1189;
  ARM64_INS_UQDECD = 1190;
  ARM64_INS_UQDECH = 1191;
  ARM64_INS_UQDECP = 1192;
  ARM64_INS_UQDECW = 1193;
  ARM64_INS_UQINCB = 1194;
  ARM64_INS_UQINCD = 1195;
  ARM64_INS_UQINCH = 1196;
  ARM64_INS_UQINCP = 1197;
  ARM64_INS_UQINCW = 1198;
  ARM64_INS_UQRSHL = 1199;
  ARM64_INS_UQRSHLR = 1200;
  ARM64_INS_UQRSHRN = 1201;
  ARM64_INS_UQRSHRN2 = 1202;
  ARM64_INS_UQRSHRNB = 1203;
  ARM64_INS_UQRSHRNT = 1204;
  ARM64_INS_UQSHL = 1205;
  ARM64_INS_UQSHLR = 1206;
  ARM64_INS_UQSHRN = 1207;
  ARM64_INS_UQSHRN2 = 1208;
  ARM64_INS_UQSHRNB = 1209;
  ARM64_INS_UQSHRNT = 1210;
  ARM64_INS_UQSUB = 1211;
  ARM64_INS_UQSUBR = 1212;
  ARM64_INS_UQXTN = 1213;
  ARM64_INS_UQXTN2 = 1214;
  ARM64_INS_UQXTNB = 1215;
  ARM64_INS_UQXTNT = 1216;
  ARM64_INS_URECPE = 1217;
  ARM64_INS_URHADD = 1218;
  ARM64_INS_URSHL = 1219;
  ARM64_INS_URSHLR = 1220;
  ARM64_INS_URSHR = 1221;
  ARM64_INS_URSQRTE = 1222;
  ARM64_INS_URSRA = 1223;
  ARM64_INS_USDOT = 1224;
  ARM64_INS_USHL = 1225;
  ARM64_INS_USHLL = 1226;
  ARM64_INS_USHLL2 = 1227;
  ARM64_INS_USHLLB = 1228;
  ARM64_INS_USHLLT = 1229;
  ARM64_INS_USHR = 1230;
  ARM64_INS_USMMLA = 1231;
  ARM64_INS_USMOPA = 1232;
  ARM64_INS_USMOPS = 1233;
  ARM64_INS_USQADD = 1234;
  ARM64_INS_USRA = 1235;
  ARM64_INS_USUBL = 1236;
  ARM64_INS_USUBL2 = 1237;
  ARM64_INS_USUBLB = 1238;
  ARM64_INS_USUBLT = 1239;
  ARM64_INS_USUBW = 1240;
  ARM64_INS_USUBW2 = 1241;
  ARM64_INS_USUBWB = 1242;
  ARM64_INS_USUBWT = 1243;
  ARM64_INS_UUNPKHI = 1244;
  ARM64_INS_UUNPKLO = 1245;
  ARM64_INS_UXTB = 1246;
  ARM64_INS_UXTH = 1247;
  ARM64_INS_UXTL = 1248;
  ARM64_INS_UXTL2 = 1249;
  ARM64_INS_UXTW = 1250;
  ARM64_INS_UZP1 = 1251;
  ARM64_INS_UZP2 = 1252;
  ARM64_INS_WFE = 1253;
  ARM64_INS_WFET = 1254;
  ARM64_INS_WFI = 1255;
  ARM64_INS_WFIT = 1256;
  ARM64_INS_WHILEGE = 1257;
  ARM64_INS_WHILEGT = 1258;
  ARM64_INS_WHILEHI = 1259;
  ARM64_INS_WHILEHS = 1260;
  ARM64_INS_WHILELE = 1261;
  ARM64_INS_WHILELO = 1262;
  ARM64_INS_WHILELS = 1263;
  ARM64_INS_WHILELT = 1264;
  ARM64_INS_WHILERW = 1265;
  ARM64_INS_WHILEWR = 1266;
  ARM64_INS_WRFFR = 1267;
  ARM64_INS_XAFLAG = 1268;
  ARM64_INS_XAR = 1269;
  ARM64_INS_XPACD = 1270;
  ARM64_INS_XPACI = 1271;
  ARM64_INS_XPACLRI = 1272;
  ARM64_INS_XTN = 1273;
  ARM64_INS_XTN2 = 1274;
  ARM64_INS_YIELD = 1275;
  ARM64_INS_ZERO = 1276;
  ARM64_INS_ZIP1 = 1277;
  ARM64_INS_ZIP2 = 1278;
  ARM64_INS_SBFIZ = 1279;
  ARM64_INS_UBFIZ = 1280;
  ARM64_INS_SBFX = 1281;
  ARM64_INS_UBFX = 1282;
  ARM64_INS_BFI = 1283;
  ARM64_INS_BFXIL = 1284;
  ARM64_INS_IC = 1285;
  ARM64_INS_DC = 1286;
  ARM64_INS_AT = 1287;
  ARM64_INS_TLBI = 1288;
  ARM64_INS_ENDING = 1289;

/// Group of ARM64 instructions
type
  arm64_insn_group = Integer;
  Parm64_insn_group = ^arm64_insn_group;

const
  /// = CS_GRP_INVALID
  ARM64_GRP_INVALID = 0;
  /// = CS_GRP_JUMP
  ARM64_GRP_JUMP = 1;
  ARM64_GRP_CALL = 2;
  ARM64_GRP_RET = 3;
  ARM64_GRP_INT = 4;
  /// = CS_GRP_PRIVILEGE
  ARM64_GRP_PRIVILEGE = 6;
  /// = CS_GRP_BRANCH_RELATIVE
  ARM64_GRP_BRANCH_RELATIVE = 7;
  ARM64_GRP_PAC = 8;
  ARM64_GRP_CRYPTO = 128;
  ARM64_GRP_FPARMV8 = 129;
  ARM64_GRP_NEON = 130;
  ARM64_GRP_CRC = 131;
  ARM64_GRP_AES = 132;
  ARM64_GRP_DOTPROD = 133;
  ARM64_GRP_FULLFP16 = 134;
  ARM64_GRP_LSE = 135;
  ARM64_GRP_RCPC = 136;
  ARM64_GRP_RDM = 137;
  ARM64_GRP_SHA2 = 138;
  ARM64_GRP_SHA3 = 139;
  ARM64_GRP_SM4 = 140;
  ARM64_GRP_SVE = 141;
  ARM64_GRP_SVE2 = 142;
  ARM64_GRP_SVE2AES = 143;
  ARM64_GRP_SVE2BitPerm = 144;
  ARM64_GRP_SVE2SHA3 = 145;
  ARM64_GRP_SVE2SM4 = 146;
  ARM64_GRP_SME = 147;
  ARM64_GRP_SMEF64 = 148;
  ARM64_GRP_SMEI64 = 149;
  ARM64_GRP_MatMulFP32 = 150;
  ARM64_GRP_MatMulFP64 = 151;
  ARM64_GRP_MatMulInt8 = 152;
  ARM64_GRP_V8_1A = 153;
  ARM64_GRP_V8_3A = 154;
  ARM64_GRP_V8_4A = 155;
  ARM64_GRP_ENDING = 156;

type
  // Forward declarations
  Parm64_op_mem = ^arm64_op_mem;
  Parm64_op_sme_index = ^arm64_op_sme_index;
  Pcs_arm64_op = ^cs_arm64_op;
  Pcs_arm64 = ^cs_arm64;

  /// Instruction's operand referring to memory
  /// This is associated with ARM64_OP_MEM operand type above
  arm64_op_mem = record
    /// base register
    base: arm64_reg;
    /// index register
    index: arm64_reg;
    /// displacement/offset value
    disp: Int32;
  end;

  /// SME Instruction's operand has index
  /// This is associated with ARM64_OP_SME_INDEX operand type above
  arm64_op_sme_index = record
    /// register being indexed
    reg: arm64_reg;
    /// base register
    base: arm64_reg;
    /// displacement/offset value
    disp: Int32;
  end;

  cs_arm64_op_shift = record
    /// shifter type of this operand
    type_: arm64_shifter;
    /// shifter value of this operand
    value: Cardinal;
  end;

  cs_arm64_op_detail = record
    case Integer of
      0: (/// register value for REG operand
    reg: arm64_reg);
      1: (/// immediate value, or index for C-IMM or IMM operand
    imm: Int64);
      2: (/// floating point value for FP operand
    fp: Double);
      3: (/// base/index/scale/disp value for MEM operand
    mem: arm64_op_mem);
      4: (/// PState field of MSR instruction.
    pstate: arm64_pstate);
      5: (/// IC/DC/AT/TLBI operation (see arm64_ic_op,
          ///< arm64_dc_op, arm64_at_op, arm64_tlbi_op)
    sys: arm64_sys_op);
      6: (/// PRFM operation.
    prefetch: arm64_prefetch_op);
      7: (/// Memory barrier operation (ISB/DMB/DSB instructions).
    barrier: arm64_barrier_op);
      8: (/// base/disp value for matrix tile slice
      ///< instructions.
    sme_index: arm64_op_sme_index);
  end;

  /// Instruction operand
  cs_arm64_op = record
    /// Vector Index for some vector operands (or -1 if
        ///< irrelevant)
    vector_index: Integer;
    /// Vector Arrangement Specifier
    vas: arm64_vas;
    /// shifter type detail
    shift: cs_arm64_op_shift;
    /// extender type of this operand
    ext: arm64_extender;
    /// operand type
    type_: arm64_op_type;
    /// MSR/MRS SVCR instruction variant.
    svcr: arm64_svcr_op;
    /// union detail
    detail: cs_arm64_op_detail;
    /// How is this operand accessed? (READ, WRITE or READ|WRITE)
      /// This field is combined of cs_ac_type.
      /// NOTE: this field is irrelevant if engine is compiled in DIET mode.
    access: UInt8;
  end;

  /// Instruction structure
  cs_arm64 = record
    /// conditional code for this insn
    cc: arm64_cc;
    /// does this insn update flags?
    update_flags: Boolean;
    /// does this insn request writeback? 'True' means 'yes'
    writeback: Boolean;
    /// only set if writeback is 'True', if 'False' pre-index, otherwise post.
    post_index: Boolean;
    /// Number of operands of this instruction,
      /// or 0 when instruction has no operand.
    op_count: UInt8;
    /// operands for this instruction.
    operands: array[0..7] of cs_arm64_op;
  end;

implementation

end.
