{
 * Main form for DelphiDabbler Console Application Runner Classes demo program
 * #1: ExecAndWait.
 *
 * Any copyright in this file is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/
}

unit FmDemo1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

uses
  PJConsoleApp;

{$R *.dfm}

{
  This code snippet was generated by DelphiDabbler CodeSnip Release 1.7.3 on
  Sun, 30 Sep 2007 16:00:24 GMT. It is made available on an "AS IS" basis,
  WITHOUT WARRANTY OF ANY KIND, either express or implied. The code is used
  entirely at your own risk.
  Modified to work with Unicode versions of CreateProcess, 19 Jul 2010.
}
function ExecAndWait(const CommandLine: string) : Boolean;
  {Executes the given command line and waits for the program started by the
  command line to exit. Returns true if the program returns a zero exit code and
  false if the program doesn't start or returns a non-zero error code.}
var
  StartupInfo: Windows.TStartupInfo;        // start-up info passed to process
  ProcessInfo: Windows.TProcessInformation; // info about the process
  ProcessExitCode: Windows.DWord;           // process's exit code
  SafeCommandLine: string;                  // unique copy of CommandLine
begin
  // Modification to work round "feature" in CreateProcessW API function used
  // by Unicode Delphis. See http://bit.ly/adgQ8H.
  SafeCommandLine := CommandLine;
  UniqueString(SafeCommandLine);
  // Set default error result
  Result := False;
  // Initialise startup info structure to 0, and record length
  FillChar(StartupInfo, SizeOf(StartupInfo), 0);
  StartupInfo.cb := SizeOf(StartupInfo);
  // Execute application commandline
  if Windows.CreateProcess(nil, PChar(SafeCommandLine),
    nil, nil, False, 0, nil, nil,
    StartupInfo, ProcessInfo) then
  begin
    try
      // Now wait for application to complete
      if Windows.WaitForSingleObject(ProcessInfo.hProcess, INFINITE)
        = WAIT_OBJECT_0 then
        // It's completed - get its exit code
        if Windows.GetExitCodeProcess(ProcessInfo.hProcess,
          ProcessExitCode) then
          // Check exit code is zero => successful completion
          if ProcessExitCode = 0 then
            Result := True;
    finally
      // Tidy up
      Windows.CloseHandle(ProcessInfo.hProcess);
      Windows.CloseHandle(ProcessInfo.hThread);
    end;
  end;
end;
// End of code snippet

function ExecAndWait2(const CommandLine: string): Boolean;
var
  App: TPJConsoleApp;
begin
  App := TPJConsoleApp.Create;
  try
    App.MaxExecTime := INFINITE;  // don't time out
    App.TimeSlice := INFINITE;    // timeout for WaitForSingleObject
    App.Visible := True;          // ensure we see the app
    if App.Execute(CommandLine) then
      Result := App.ExitCode = 0  // app executed OK  check its exit code
    else
      Result := False;            // app didn't execute
  finally
    App.Free;
  end;
end;

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
  if not ExecAndWait('Timed 3') then  // runs Timed.exe for 3 seconds.
    ShowMessage('Non-zero error code or application could not be executed');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if not ExecAndWait2('Timed 3') then // runs Timed.exe for 3 seconds.
    ShowMessage('Non-zero error code or application could not be executed');
end;

end.

