import { simpleGraphQLGetByIdHandler, simpleGraphQLGetAllHandler } from "utils/requestHandlers";	

export const resolvers = {
  Query: {
    ammo: async (_, args) => simpleGraphQLGetAllHandler(_, args, "ammos"),
    armor: async (_, args) => simpleGraphQLGetAllHandler(_, args, "armors"),
    ashOfWar: async (_, args) => simpleGraphQLGetAllHandler(_, args, "ashes"),
    boss: async (_, args) => simpleGraphQLGetAllHandler(_, args, "bosses"),
    class: async (_, args) => simpleGraphQLGetAllHandler(_, args, "classes"),
    creature: async (_, args) => simpleGraphQLGetAllHandler(_, args, "creatures"),
    getAmmo: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "ammos"),
    getArmor: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "armors"),
    getAshOfWar: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "ashes"),
    getBoss: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "bosses"),
    getClass: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "classes"),
    getCreature: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "creatures"),
    getIncantation: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "incantations"),
    getItem: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "items"),
    getLocation: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "locations"),
    getNpc: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "npcs"),
    getShield: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "shields"),
    getSorcery: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "sorceries"),
    getSpirit: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "spirits"),
    getTalisman: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "talismans"),
    getWeapon: async (_, args) => simpleGraphQLGetByIdHandler(_, args, "weapons"),
    incantation: async (_, args) => simpleGraphQLGetAllHandler(_, args, "incantations"),
    item: async (_, args) => simpleGraphQLGetAllHandler(_, args, "items"),
    location: async (_, args) => simpleGraphQLGetAllHandler(_, args, "locations"),
    npc: async (_, args) => simpleGraphQLGetAllHandler(_, args, "npcs"),
    shield: async (_, args) => simpleGraphQLGetAllHandler(_, args, "shields"),
    sorcery: async (_, args) => simpleGraphQLGetAllHandler(_, args, "sorceries"),
    spirit: async (_, args) => simpleGraphQLGetAllHandler(_, args, "spirits"),
    talisman: async (_, args) => simpleGraphQLGetAllHandler(_, args, "talismans"),
    weapon: async (_, args) => simpleGraphQLGetAllHandler(_, args, "weapons"),
  },
};
