# Cutting a Wagi Release

To cut a release of Wagi, you will need to do the following:

1. Create a pull request that changes the version number for your new version (e.g. 1.2.2 becomes 1.2.3)
    - `Cargo.toml` is the most important place to make this change
    - Check the docs for hard-coded version strings
2. Merge the PR created in #1 (Such PRs are still required to get approvals, so make sure you get signoff on the PR)
3. Create a new tag with a `v` and then the version number (`v1.2.3`)
4. Push the tag up to `main` on GitHub
    - This will trigger a release build
5. Wait for the `release` [action](https://github.com/deislabs/wagi/actions/workflows/release.yaml) to complete, and download the binary artifacts that are generated by that action.
6. Generate SHAs of the Windows, Mac, and Linux binaries with `shasum` or a similar command
7. Go to the GitHub [tags page](https://github.com/deislabs/wagi/releases) and create a release, adding release notes, and uploading the binaries you downloaded above. The SHAs should go in the release notes.


At this point, you can just verify that all things are good.