---
title: Impact of CVE-2021-4428
---

# Impact of CVE-2021-4428

As part of our periodic scan of our own images, we detected CVE-2021-44228 Log4j2 vulnerability in `deepfenceio/deepfence_elastic_ce:latest` image in package `/usr/share/elasticsearch/lib/log4j-core-2.11.1.jar`.

**Am I affected?**

1. If ThreatMapper console is installed as per the instructions and the deployment scripts provided, you are not affected. It assumes that security groups are set to receive traffic from agents/browser on port 443 and all other ports are locked down.
2. However, we have set the appropriate flag (`-Dlog4j2.formatMsgNoLookups=true`) as recommended by [elasticsearch](https://discuss.elastic.co/t/apache-log4j2-remote-code-execution-rce-vulnerability-cve-2021-44228-esa-2021-31/291476). 
3. Please use the latest version of the code and update the container image `deepfenceio/deepfence_elastic_ce:latest`

**CVE-2021-44228 Exploitability and Attack Path Details**

Deepfence ThreatMapper can scan your images and hosts for this vulnerability.

![CVE 2021 44228 Detail](https://deepfence-public.s3.amazonaws.com/vulnerability/CVE-2021-44228-1.png)

In addition, ThreatMapper can visually show the attack path for those containers and hosts which have an application that uses the vulnerable log4j library and are receiving external network traffic.

![CVE 2021 44228 Attack Path](https://deepfence-public.s3.amazonaws.com/vulnerability/CVE-2021-44228-2.png)
