package ingesters

import (
	"time"
)

type MalwareScanStatus struct {
	Timestamp   time.Time `json:"@timestamp"`
	ScanID      string    `json:"scan_id"`
	ScanStatus  string    `json:"scan_status"`
	ScanMessage string    `json:"scan_message"`
}

type MetaRules struct {
	RuleID       string `json:"rule_id"`
	RuleName     string `json:"rule_name"`
	Author       string `json:"author"`
	Date         string `json:"date"`
	Description  string `json:"description"`
	Filetype     string `json:"filetype"`
	Info         string `json:"info"`
	Version      string `json:"version"`
	Reference    string `json:"reference"`
	FileSeverity string `json:"file_severity"`
}

type Malware struct {
	FileSevScore     float64   `json:"file_sev_score"`
	ImageLayerID     string    `json:"image_layer_id"`
	MetaRules        MetaRules `json:"meta_rules"`
	SeverityScore    int       `json:"severity_score"`
	RuleName         string    `json:"rule_name"`
	StringsToMatch   []string  `json:"strings_to_match"`
	FileSeverity     string    `json:"file_severity"`
	CompleteFilename string    `json:"complete_filename"`
	Meta             []string  `json:"meta"`
	Summary          string    `json:"summary"`
	Class            string    `json:"class"`
	ScanID           string    `json:"scan_id"`
	Timestamp        time.Time `json:"timestamp"`
}
