package vulnerabilitydatabase

import (
	"github.com/deepfence/ThreatMapper/deepfence_utils/sqlite"
)

const (
	VulnerabilityMatchExclusionTableName = "vulnerability_match_exclusion"
)

// VulnerabilityMatchExclusionModel is a struct used to serialize db.VulnerabilityMatchExclusion information into a sqlite3 DB.
type VulnerabilityMatchExclusionModel struct {
	PK            uint64            `gorm:"primary_key;auto_increment;"`
	ID            string            `gorm:"column:id; index:get_vulnerability_match_exclusion_index"`
	Constraints   sqlite.NullString `gorm:"column:constraints; default:null"`
	Justification string            `gorm:"column:justification"`
}

// TableName returns the table which all db.VulnerabilityMatchExclusion model instances are stored into.
func (VulnerabilityMatchExclusionModel) TableName() string {
	return VulnerabilityMatchExclusionTableName
}
