package vulnerabilitydatabase

import (
	"strings"
)

const (
	metasploitURLPattern = "github.com/rapid7/metasploit-framework"
)

func ExtractExploitPocURL(url []string) (string, []string) {
	if len(url) == 0 {
		return "", nil
	}
	var nonExploitPocUrls []string
	var metasploitURL string
	for _, u := range url {
		if strings.Contains(u, metasploitURLPattern) {
			metasploitURL = u
		} else {
			nonExploitPocUrls = append(nonExploitPocUrls, u)
		}
	}
	return metasploitURL, nonExploitPocUrls
}
