package vulnerabilitydatabase

import "strings"

const (
	DefaultCVSSCritical = 9.0
	DefaultCVSSHigh     = 7.0
	DefaultCVSSMedium   = 5.0
	DefaultCVSSLow      = 2.0
)

// Cvss is a struct that represents the CVSS object
func GetCvss(c []Cvss) (float64, float64, string) {
	var cvssScore float64
	var overallScore float64
	var attackVector string

	if len(c) == 0 {
		return 0, 0, ""
	}

	if len(c) == 1 {
		if c[0].Metrics.ExploitabilityScore != nil {
			cvssScore = *c[0].Metrics.ExploitabilityScore
			overallScore = *c[0].Metrics.ExploitabilityScore
		}
		if c[0].Vector != "" {
			attackVector = c[0].Vector
		}
	} else {
		for _, score := range c {
			if score.Version == "3.1" {
				if score.Metrics.ExploitabilityScore != nil {
					cvssScore = *score.Metrics.ExploitabilityScore
					overallScore = *score.Metrics.ExploitabilityScore
				}
				if score.Vector != "" {
					attackVector = score.Vector
				}
				break
			}
		}
	}

	// return cvss
	return cvssScore, overallScore, strings.ToLower(attackVector)
}
