// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.26.0
// source: queries.sql

package postgresql_db

import (
	"context"
	"database/sql"
	"encoding/json"
	"time"

	"github.com/deepfence/ThreatMapper/deepfence_utils/integrations"
	"github.com/google/uuid"
	"github.com/lib/pq"
)

const countActiveAdminUsers = `-- name: CountActiveAdminUsers :one
SELECT count(*)
FROM users
         INNER JOIN role ON role.id = users.role_id
WHERE users.is_active = true
  AND role.name = 'admin'
`

func (q *Queries) CountActiveAdminUsers(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countActiveAdminUsers)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countActiveUsers = `-- name: CountActiveUsers :one
SELECT count(*)
FROM users
WHERE users.is_active = true
`

func (q *Queries) CountActiveUsers(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countActiveUsers)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countAuditLogs = `-- name: CountAuditLogs :one
SELECT count(*)
FROM audit_log
`

func (q *Queries) CountAuditLogs(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countAuditLogs)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countCompanies = `-- name: CountCompanies :one
SELECT count(*)
FROM company
`

func (q *Queries) CountCompanies(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countCompanies)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countContainerRegistry = `-- name: CountContainerRegistry :one
SELECT count(*)
FROM container_registry
`

func (q *Queries) CountContainerRegistry(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countContainerRegistry)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countGenerativeAiIntegrationByLabel = `-- name: CountGenerativeAiIntegrationByLabel :one
SELECT COUNT(*)
FROM generative_ai_integration
WHERE label = $1
LIMIT 1
`

func (q *Queries) CountGenerativeAiIntegrationByLabel(ctx context.Context, label string) (int64, error) {
	row := q.db.QueryRowContext(ctx, countGenerativeAiIntegrationByLabel, label)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countLicenses = `-- name: CountLicenses :one
SELECT count(*)
FROM license
`

func (q *Queries) CountLicenses(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countLicenses)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const countUsers = `-- name: CountUsers :one
SELECT count(*)
FROM users
`

func (q *Queries) CountUsers(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, countUsers)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const createApiToken = `-- name: CreateApiToken :one
INSERT INTO api_token (api_token, name, company_id, role_id, group_id, created_by_user_id)
VALUES ($1, $2, $3, $4, $5, $6)
RETURNING id, api_token, name, company_id, group_id, role_id, created_by_user_id, created_at, updated_at
`

type CreateApiTokenParams struct {
	ApiToken        uuid.UUID `json:"api_token"`
	Name            string    `json:"name"`
	CompanyID       int32     `json:"company_id"`
	RoleID          int32     `json:"role_id"`
	GroupID         int32     `json:"group_id"`
	CreatedByUserID int64     `json:"created_by_user_id"`
}

func (q *Queries) CreateApiToken(ctx context.Context, arg CreateApiTokenParams) (ApiToken, error) {
	row := q.db.QueryRowContext(ctx, createApiToken,
		arg.ApiToken,
		arg.Name,
		arg.CompanyID,
		arg.RoleID,
		arg.GroupID,
		arg.CreatedByUserID,
	)
	var i ApiToken
	err := row.Scan(
		&i.ID,
		&i.ApiToken,
		&i.Name,
		&i.CompanyID,
		&i.GroupID,
		&i.RoleID,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createAuditLog = `-- name: CreateAuditLog :exec
INSERT INTO audit_log (event, action, resources, success, user_email, user_role, created_at)
VALUES ($1, $2, $3, $4, $5, $6, $7)
`

type CreateAuditLogParams struct {
	Event     string    `json:"event"`
	Action    string    `json:"action"`
	Resources string    `json:"resources"`
	Success   bool      `json:"success"`
	UserEmail string    `json:"user_email"`
	UserRole  string    `json:"user_role"`
	CreatedAt time.Time `json:"created_at"`
}

func (q *Queries) CreateAuditLog(ctx context.Context, arg CreateAuditLogParams) error {
	_, err := q.db.ExecContext(ctx, createAuditLog,
		arg.Event,
		arg.Action,
		arg.Resources,
		arg.Success,
		arg.UserEmail,
		arg.UserRole,
		arg.CreatedAt,
	)
	return err
}

const createCompany = `-- name: CreateCompany :one
INSERT INTO company (name, email_domain, namespace)
VALUES ($1, $2, $3)
RETURNING id, name, email_domain, created_at, updated_at, namespace
`

type CreateCompanyParams struct {
	Name        string `json:"name"`
	EmailDomain string `json:"email_domain"`
	Namespace   string `json:"namespace"`
}

func (q *Queries) CreateCompany(ctx context.Context, arg CreateCompanyParams) (Company, error) {
	row := q.db.QueryRowContext(ctx, createCompany, arg.Name, arg.EmailDomain, arg.Namespace)
	var i Company
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.EmailDomain,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.Namespace,
	)
	return i, err
}

const createContainerRegistry = `-- name: CreateContainerRegistry :one
INSERT INTO container_registry (name, registry_type, encrypted_secret, non_secret, extras)
VALUES ($1, $2, $3, $4, $5)
RETURNING id, name, registry_type, encrypted_secret, non_secret, extras, created_at, updated_at
`

type CreateContainerRegistryParams struct {
	Name            string          `json:"name"`
	RegistryType    string          `json:"registry_type"`
	EncryptedSecret json.RawMessage `json:"encrypted_secret"`
	NonSecret       json.RawMessage `json:"non_secret"`
	Extras          json.RawMessage `json:"extras"`
}

func (q *Queries) CreateContainerRegistry(ctx context.Context, arg CreateContainerRegistryParams) (ContainerRegistry, error) {
	row := q.db.QueryRowContext(ctx, createContainerRegistry,
		arg.Name,
		arg.RegistryType,
		arg.EncryptedSecret,
		arg.NonSecret,
		arg.Extras,
	)
	var i ContainerRegistry
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.RegistryType,
		&i.EncryptedSecret,
		&i.NonSecret,
		&i.Extras,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createGenerativeAiIntegration = `-- name: CreateGenerativeAiIntegration :one
INSERT INTO generative_ai_integration (integration_type, label, config, created_by_user_id)
VALUES ($1, $2, $3, $4)
RETURNING id, integration_type, label, last_sent_time, config, error_msg, default_integration, created_by_user_id, created_at, updated_at
`

type CreateGenerativeAiIntegrationParams struct {
	IntegrationType string          `json:"integration_type"`
	Label           string          `json:"label"`
	Config          json.RawMessage `json:"config"`
	CreatedByUserID int64           `json:"created_by_user_id"`
}

func (q *Queries) CreateGenerativeAiIntegration(ctx context.Context, arg CreateGenerativeAiIntegrationParams) (GenerativeAiIntegration, error) {
	row := q.db.QueryRowContext(ctx, createGenerativeAiIntegration,
		arg.IntegrationType,
		arg.Label,
		arg.Config,
		arg.CreatedByUserID,
	)
	var i GenerativeAiIntegration
	err := row.Scan(
		&i.ID,
		&i.IntegrationType,
		&i.Label,
		&i.LastSentTime,
		&i.Config,
		&i.ErrorMsg,
		&i.DefaultIntegration,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createIntegration = `-- name: CreateIntegration :one
INSERT INTO integration (resource, filters, integration_type, interval_minutes, config, created_by_user_id)
VALUES ($1, $2, $3, $4, $5, $6)
RETURNING id, resource, filters, integration_type, interval_minutes, last_sent_time, config, error_msg, created_by_user_id, created_at, updated_at, last_event_updated_at, metrics
`

type CreateIntegrationParams struct {
	Resource        string          `json:"resource"`
	Filters         json.RawMessage `json:"filters"`
	IntegrationType string          `json:"integration_type"`
	IntervalMinutes int32           `json:"interval_minutes"`
	Config          json.RawMessage `json:"config"`
	CreatedByUserID int64           `json:"created_by_user_id"`
}

func (q *Queries) CreateIntegration(ctx context.Context, arg CreateIntegrationParams) (Integration, error) {
	row := q.db.QueryRowContext(ctx, createIntegration,
		arg.Resource,
		arg.Filters,
		arg.IntegrationType,
		arg.IntervalMinutes,
		arg.Config,
		arg.CreatedByUserID,
	)
	var i Integration
	err := row.Scan(
		&i.ID,
		&i.Resource,
		&i.Filters,
		&i.IntegrationType,
		&i.IntervalMinutes,
		&i.LastSentTime,
		&i.Config,
		&i.ErrorMsg,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.LastEventUpdatedAt,
		&i.Metrics,
	)
	return i, err
}

const createPasswordReset = `-- name: CreatePasswordReset :one
INSERT INTO password_reset (code, expiry, user_id)
VALUES ($1, $2, $3)
RETURNING id, user_id, code, expiry, created_at, updated_at
`

type CreatePasswordResetParams struct {
	Code   uuid.UUID `json:"code"`
	Expiry time.Time `json:"expiry"`
	UserID int64     `json:"user_id"`
}

func (q *Queries) CreatePasswordReset(ctx context.Context, arg CreatePasswordResetParams) (PasswordReset, error) {
	row := q.db.QueryRowContext(ctx, createPasswordReset, arg.Code, arg.Expiry, arg.UserID)
	var i PasswordReset
	err := row.Scan(
		&i.ID,
		&i.UserID,
		&i.Code,
		&i.Expiry,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createRole = `-- name: CreateRole :one
INSERT INTO role (name)
VALUES ($1)
RETURNING id, name, created_at, updated_at
`

func (q *Queries) CreateRole(ctx context.Context, name string) (Role, error) {
	row := q.db.QueryRowContext(ctx, createRole, name)
	var i Role
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createSchedule = `-- name: CreateSchedule :one
INSERT INTO scheduler (action, description, cron_expr, payload, is_enabled, is_system, status)
VALUES ($1, $2, $3, $4, $5, $6, '')
RETURNING id, action, description, cron_expr, payload, is_enabled, is_system, status, last_ran_at, created_at, updated_at
`

type CreateScheduleParams struct {
	Action      string          `json:"action"`
	Description string          `json:"description"`
	CronExpr    string          `json:"cron_expr"`
	Payload     json.RawMessage `json:"payload"`
	IsEnabled   bool            `json:"is_enabled"`
	IsSystem    bool            `json:"is_system"`
}

func (q *Queries) CreateSchedule(ctx context.Context, arg CreateScheduleParams) (Scheduler, error) {
	row := q.db.QueryRowContext(ctx, createSchedule,
		arg.Action,
		arg.Description,
		arg.CronExpr,
		arg.Payload,
		arg.IsEnabled,
		arg.IsSystem,
	)
	var i Scheduler
	err := row.Scan(
		&i.ID,
		&i.Action,
		&i.Description,
		&i.CronExpr,
		&i.Payload,
		&i.IsEnabled,
		&i.IsSystem,
		&i.Status,
		&i.LastRanAt,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createSetting = `-- name: CreateSetting :one
INSERT INTO setting (key, value, is_visible_on_ui)
VALUES ($1, $2, $3)
RETURNING id, key, value, is_visible_on_ui, created_at, updated_at
`

type CreateSettingParams struct {
	Key           string          `json:"key"`
	Value         json.RawMessage `json:"value"`
	IsVisibleOnUi bool            `json:"is_visible_on_ui"`
}

func (q *Queries) CreateSetting(ctx context.Context, arg CreateSettingParams) (Setting, error) {
	row := q.db.QueryRowContext(ctx, createSetting, arg.Key, arg.Value, arg.IsVisibleOnUi)
	var i Setting
	err := row.Scan(
		&i.ID,
		&i.Key,
		&i.Value,
		&i.IsVisibleOnUi,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createUser = `-- name: CreateUser :one
INSERT INTO users (first_name, last_name, email, role_id, group_ids, company_id, password_hash, is_active,
                   password_invalidated)
VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)
RETURNING id, first_name, last_name, email, role_id, group_ids, company_id, password_hash, is_active, password_invalidated, created_at, updated_at
`

type CreateUserParams struct {
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	PasswordHash        string          `json:"password_hash"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
}

func (q *Queries) CreateUser(ctx context.Context, arg CreateUserParams) (User, error) {
	row := q.db.QueryRowContext(ctx, createUser,
		arg.FirstName,
		arg.LastName,
		arg.Email,
		arg.RoleID,
		arg.GroupIds,
		arg.CompanyID,
		arg.PasswordHash,
		arg.IsActive,
		arg.PasswordInvalidated,
	)
	var i User
	err := row.Scan(
		&i.ID,
		&i.FirstName,
		&i.LastName,
		&i.Email,
		&i.RoleID,
		&i.GroupIds,
		&i.CompanyID,
		&i.PasswordHash,
		&i.IsActive,
		&i.PasswordInvalidated,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createUserGroup = `-- name: CreateUserGroup :one
INSERT INTO user_group (name, company_id, is_system)
VALUES ($1, $2, $3)
RETURNING id, name, is_system, company_id, created_at, updated_at
`

type CreateUserGroupParams struct {
	Name      string `json:"name"`
	CompanyID int32  `json:"company_id"`
	IsSystem  bool   `json:"is_system"`
}

func (q *Queries) CreateUserGroup(ctx context.Context, arg CreateUserGroupParams) (UserGroup, error) {
	row := q.db.QueryRowContext(ctx, createUserGroup, arg.Name, arg.CompanyID, arg.IsSystem)
	var i UserGroup
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.IsSystem,
		&i.CompanyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createUserInvite = `-- name: CreateUserInvite :one
INSERT INTO user_invite (email, code, created_by_user_id, role_id, company_id, accepted, expiry)
VALUES ($1, $2, $3, $4, $5, $6, $7)
RETURNING id, email, code, created_by_user_id, role_id, company_id, accepted, expiry, created_at, updated_at
`

type CreateUserInviteParams struct {
	Email           string    `json:"email"`
	Code            uuid.UUID `json:"code"`
	CreatedByUserID int64     `json:"created_by_user_id"`
	RoleID          int32     `json:"role_id"`
	CompanyID       int32     `json:"company_id"`
	Accepted        bool      `json:"accepted"`
	Expiry          time.Time `json:"expiry"`
}

func (q *Queries) CreateUserInvite(ctx context.Context, arg CreateUserInviteParams) (UserInvite, error) {
	row := q.db.QueryRowContext(ctx, createUserInvite,
		arg.Email,
		arg.Code,
		arg.CreatedByUserID,
		arg.RoleID,
		arg.CompanyID,
		arg.Accepted,
		arg.Expiry,
	)
	var i UserInvite
	err := row.Scan(
		&i.ID,
		&i.Email,
		&i.Code,
		&i.CreatedByUserID,
		&i.RoleID,
		&i.CompanyID,
		&i.Accepted,
		&i.Expiry,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteApiToken = `-- name: DeleteApiToken :exec
DELETE
FROM api_token
WHERE id = $1
`

func (q *Queries) DeleteApiToken(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteApiToken, id)
	return err
}

const deleteApiTokensByUserID = `-- name: DeleteApiTokensByUserID :exec
DELETE
FROM api_token
WHERE created_by_user_id = $1
`

func (q *Queries) DeleteApiTokensByUserID(ctx context.Context, createdByUserID int64) error {
	_, err := q.db.ExecContext(ctx, deleteApiTokensByUserID, createdByUserID)
	return err
}

const deleteAuditLogsOlderThan30days = `-- name: DeleteAuditLogsOlderThan30days :one
WITH deleted AS (
    DELETE
        FROM audit_log
            WHERE created_at < (now() - interval '30 days')
            RETURNING id, event, action, resources, success, user_email, user_role, created_at)
SELECT count(*)
FROM deleted
`

func (q *Queries) DeleteAuditLogsOlderThan30days(ctx context.Context) (int64, error) {
	row := q.db.QueryRowContext(ctx, deleteAuditLogsOlderThan30days)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const deleteCompany = `-- name: DeleteCompany :exec
DELETE
FROM company
WHERE id = $1
`

func (q *Queries) DeleteCompany(ctx context.Context, id int32) error {
	_, err := q.db.ExecContext(ctx, deleteCompany, id)
	return err
}

const deleteContainerRegistry = `-- name: DeleteContainerRegistry :exec
DELETE
FROM container_registry
WHERE id = $1
`

func (q *Queries) DeleteContainerRegistry(ctx context.Context, id int32) error {
	_, err := q.db.ExecContext(ctx, deleteContainerRegistry, id)
	return err
}

const deleteCustomSchedule = `-- name: DeleteCustomSchedule :exec
DELETE
FROM scheduler
WHERE id = $1
  AND is_system = 'f'
`

func (q *Queries) DeleteCustomSchedule(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteCustomSchedule, id)
	return err
}

const deleteGenerativeAiIntegration = `-- name: DeleteGenerativeAiIntegration :one
DELETE
FROM generative_ai_integration
WHERE id = $1
RETURNING id, integration_type, label, last_sent_time, config, error_msg, default_integration, created_by_user_id, created_at, updated_at
`

func (q *Queries) DeleteGenerativeAiIntegration(ctx context.Context, id int32) (GenerativeAiIntegration, error) {
	row := q.db.QueryRowContext(ctx, deleteGenerativeAiIntegration, id)
	var i GenerativeAiIntegration
	err := row.Scan(
		&i.ID,
		&i.IntegrationType,
		&i.Label,
		&i.LastSentTime,
		&i.Config,
		&i.ErrorMsg,
		&i.DefaultIntegration,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteIntegrationByUserID = `-- name: DeleteIntegrationByUserID :exec
DELETE
FROM integration
WHERE created_by_user_id = $1
`

func (q *Queries) DeleteIntegrationByUserID(ctx context.Context, createdByUserID int64) error {
	_, err := q.db.ExecContext(ctx, deleteIntegrationByUserID, createdByUserID)
	return err
}

const deleteIntegrations = `-- name: DeleteIntegrations :exec
DELETE
FROM integration
WHERE id = ANY ($1::int[])
`

func (q *Queries) DeleteIntegrations(ctx context.Context, dollar_1 []int32) error {
	_, err := q.db.ExecContext(ctx, deleteIntegrations, pq.Array(dollar_1))
	return err
}

const deleteLicense = `-- name: DeleteLicense :exec
DELETE
FROM license
WHERE license_key = $1
`

func (q *Queries) DeleteLicense(ctx context.Context, licenseKey uuid.UUID) error {
	_, err := q.db.ExecContext(ctx, deleteLicense, licenseKey)
	return err
}

const deletePasswordResetByExpiry = `-- name: DeletePasswordResetByExpiry :exec
DELETE
FROM password_reset
WHERE expiry < now()
`

func (q *Queries) DeletePasswordResetByExpiry(ctx context.Context) error {
	_, err := q.db.ExecContext(ctx, deletePasswordResetByExpiry)
	return err
}

const deletePasswordResetByUserEmail = `-- name: DeletePasswordResetByUserEmail :exec
DELETE
FROM password_reset pr
    USING users u
WHERE pr.user_id = u.id
  AND u.email = $1
`

func (q *Queries) DeletePasswordResetByUserEmail(ctx context.Context, email string) error {
	_, err := q.db.ExecContext(ctx, deletePasswordResetByUserEmail, email)
	return err
}

const deleteSchedule = `-- name: DeleteSchedule :exec
DELETE
FROM scheduler
WHERE id = $1
`

func (q *Queries) DeleteSchedule(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteSchedule, id)
	return err
}

const deleteSettingByID = `-- name: DeleteSettingByID :exec
DELETE
FROM setting
WHERE id = $1
`

func (q *Queries) DeleteSettingByID(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteSettingByID, id)
	return err
}

const deleteUser = `-- name: DeleteUser :exec
DELETE
FROM users
WHERE id = $1
`

func (q *Queries) DeleteUser(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteUser, id)
	return err
}

const deleteUserInviteByExpiry = `-- name: DeleteUserInviteByExpiry :exec
DELETE
FROM user_invite
WHERE expiry < now()
`

func (q *Queries) DeleteUserInviteByExpiry(ctx context.Context) error {
	_, err := q.db.ExecContext(ctx, deleteUserInviteByExpiry)
	return err
}

const deleteUserInviteByUserID = `-- name: DeleteUserInviteByUserID :exec
DELETE
FROM user_invite
WHERE created_by_user_id = $1
`

func (q *Queries) DeleteUserInviteByUserID(ctx context.Context, createdByUserID int64) error {
	_, err := q.db.ExecContext(ctx, deleteUserInviteByUserID, createdByUserID)
	return err
}

const getActiveLicense = `-- name: GetActiveLicense :one
SELECT id, license_key, start_date, end_date, no_of_hosts, current_hosts, is_active, license_type, deepfence_support_email, notification_threshold_percentage, notification_threshold_updated_at, registry_credentials, message, description, created_at, updated_at, license_email, license_email_domain, no_of_cloud_accounts, no_of_registries, no_of_images_in_registry
FROM license
WHERE is_active = true
ORDER BY end_date DESC
LIMIT 1
`

func (q *Queries) GetActiveLicense(ctx context.Context) (License, error) {
	row := q.db.QueryRowContext(ctx, getActiveLicense)
	var i License
	err := row.Scan(
		&i.ID,
		&i.LicenseKey,
		&i.StartDate,
		&i.EndDate,
		&i.NoOfHosts,
		&i.CurrentHosts,
		&i.IsActive,
		&i.LicenseType,
		&i.DeepfenceSupportEmail,
		&i.NotificationThresholdPercentage,
		&i.NotificationThresholdUpdatedAt,
		&i.RegistryCredentials,
		&i.Message,
		&i.Description,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.LicenseEmail,
		&i.LicenseEmailDomain,
		&i.NoOfCloudAccounts,
		&i.NoOfRegistries,
		&i.NoOfImagesInRegistry,
	)
	return i, err
}

const getActiveSchedules = `-- name: GetActiveSchedules :many
SELECT id, action, description, cron_expr, payload, is_enabled, is_system, status, last_ran_at, created_at, updated_at
FROM scheduler
WHERE is_enabled = 't'
ORDER BY created_at
`

func (q *Queries) GetActiveSchedules(ctx context.Context) ([]Scheduler, error) {
	rows, err := q.db.QueryContext(ctx, getActiveSchedules)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Scheduler
	for rows.Next() {
		var i Scheduler
		if err := rows.Scan(
			&i.ID,
			&i.Action,
			&i.Description,
			&i.CronExpr,
			&i.Payload,
			&i.IsEnabled,
			&i.IsSystem,
			&i.Status,
			&i.LastRanAt,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getActiveUsers = `-- name: GetActiveUsers :many
SELECT users.id,
       users.first_name,
       users.last_name,
       users.email,
       users.role_id,
       role.name         as role_name,
       users.group_ids,
       users.company_id,
       company.name      as company_name,
       users.is_active,
       users.password_invalidated,
       users.created_at,
       users.updated_at,
       company.namespace as company_namespace
FROM users
         INNER JOIN role ON role.id = users.role_id
         INNER JOIN company ON company.id = users.company_id
WHERE is_active = 't'
ORDER BY first_name
`

type GetActiveUsersRow struct {
	ID                  int64           `json:"id"`
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	RoleName            string          `json:"role_name"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	CompanyName         string          `json:"company_name"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	CreatedAt           time.Time       `json:"created_at"`
	UpdatedAt           time.Time       `json:"updated_at"`
	CompanyNamespace    string          `json:"company_namespace"`
}

func (q *Queries) GetActiveUsers(ctx context.Context) ([]GetActiveUsersRow, error) {
	rows, err := q.db.QueryContext(ctx, getActiveUsers)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetActiveUsersRow
	for rows.Next() {
		var i GetActiveUsersRow
		if err := rows.Scan(
			&i.ID,
			&i.FirstName,
			&i.LastName,
			&i.Email,
			&i.RoleID,
			&i.RoleName,
			&i.GroupIds,
			&i.CompanyID,
			&i.CompanyName,
			&i.IsActive,
			&i.PasswordInvalidated,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.CompanyNamespace,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getActiveUsersByCompanyID = `-- name: GetActiveUsersByCompanyID :many
SELECT users.id,
       users.first_name,
       users.last_name,
       users.email,
       users.role_id,
       role.name         as role_name,
       users.group_ids,
       users.company_id,
       company.name      as company_name,
       users.is_active,
       users.password_invalidated,
       users.created_at,
       users.updated_at,
       company.namespace as company_namespace
FROM users
         INNER JOIN role ON role.id = users.role_id
         INNER JOIN company ON company.id = users.company_id
WHERE company_id = $1
  AND is_active = 't'
ORDER BY first_name
`

type GetActiveUsersByCompanyIDRow struct {
	ID                  int64           `json:"id"`
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	RoleName            string          `json:"role_name"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	CompanyName         string          `json:"company_name"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	CreatedAt           time.Time       `json:"created_at"`
	UpdatedAt           time.Time       `json:"updated_at"`
	CompanyNamespace    string          `json:"company_namespace"`
}

func (q *Queries) GetActiveUsersByCompanyID(ctx context.Context, companyID int32) ([]GetActiveUsersByCompanyIDRow, error) {
	rows, err := q.db.QueryContext(ctx, getActiveUsersByCompanyID, companyID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetActiveUsersByCompanyIDRow
	for rows.Next() {
		var i GetActiveUsersByCompanyIDRow
		if err := rows.Scan(
			&i.ID,
			&i.FirstName,
			&i.LastName,
			&i.Email,
			&i.RoleID,
			&i.RoleName,
			&i.GroupIds,
			&i.CompanyID,
			&i.CompanyName,
			&i.IsActive,
			&i.PasswordInvalidated,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.CompanyNamespace,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getApiToken = `-- name: GetApiToken :one
SELECT id, api_token, name, company_id, group_id, role_id, created_by_user_id, created_at, updated_at
FROM api_token
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetApiToken(ctx context.Context, id int64) (ApiToken, error) {
	row := q.db.QueryRowContext(ctx, getApiToken, id)
	var i ApiToken
	err := row.Scan(
		&i.ID,
		&i.ApiToken,
		&i.Name,
		&i.CompanyID,
		&i.GroupID,
		&i.RoleID,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getApiTokenByActiveUser = `-- name: GetApiTokenByActiveUser :one
SELECT api_token.api_token
FROM api_token
         INNER JOIN users u on api_token.created_by_user_id = u.id
WHERE u.is_active = 'true'
LIMIT 1
`

func (q *Queries) GetApiTokenByActiveUser(ctx context.Context) (uuid.UUID, error) {
	row := q.db.QueryRowContext(ctx, getApiTokenByActiveUser)
	var api_token uuid.UUID
	err := row.Scan(&api_token)
	return api_token, err
}

const getApiTokenByToken = `-- name: GetApiTokenByToken :one
SELECT api_token.api_token,
       api_token.name,
       api_token.company_id,
       api_token.role_id,
       api_token.group_id,
       api_token.created_by_user_id,
       users.first_name           as first_name,
       users.last_name            as last_name,
       users.email                as email,
       role.name                  as role_name,
       company.name               as company_name,
       company.namespace          as company_namespace,
       users.is_active            as is_user_active,
       users.password_invalidated as user_password_invalidated,
       api_token.created_at,
       api_token.updated_at
FROM api_token
         INNER JOIN users ON users.id = api_token.created_by_user_id
         INNER JOIN role ON role.id = api_token.role_id
         INNER JOIN company ON company.id = api_token.company_id
WHERE api_token = $1
LIMIT 1
`

type GetApiTokenByTokenRow struct {
	ApiToken                uuid.UUID `json:"api_token"`
	Name                    string    `json:"name"`
	CompanyID               int32     `json:"company_id"`
	RoleID                  int32     `json:"role_id"`
	GroupID                 int32     `json:"group_id"`
	CreatedByUserID         int64     `json:"created_by_user_id"`
	FirstName               string    `json:"first_name"`
	LastName                string    `json:"last_name"`
	Email                   string    `json:"email"`
	RoleName                string    `json:"role_name"`
	CompanyName             string    `json:"company_name"`
	CompanyNamespace        string    `json:"company_namespace"`
	IsUserActive            bool      `json:"is_user_active"`
	UserPasswordInvalidated bool      `json:"user_password_invalidated"`
	CreatedAt               time.Time `json:"created_at"`
	UpdatedAt               time.Time `json:"updated_at"`
}

func (q *Queries) GetApiTokenByToken(ctx context.Context, apiToken uuid.UUID) (GetApiTokenByTokenRow, error) {
	row := q.db.QueryRowContext(ctx, getApiTokenByToken, apiToken)
	var i GetApiTokenByTokenRow
	err := row.Scan(
		&i.ApiToken,
		&i.Name,
		&i.CompanyID,
		&i.RoleID,
		&i.GroupID,
		&i.CreatedByUserID,
		&i.FirstName,
		&i.LastName,
		&i.Email,
		&i.RoleName,
		&i.CompanyName,
		&i.CompanyNamespace,
		&i.IsUserActive,
		&i.UserPasswordInvalidated,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getApiTokens = `-- name: GetApiTokens :many
SELECT id, api_token, name, company_id, group_id, role_id, created_by_user_id, created_at, updated_at
FROM api_token
WHERE company_id = $1
ORDER BY name
`

func (q *Queries) GetApiTokens(ctx context.Context, companyID int32) ([]ApiToken, error) {
	rows, err := q.db.QueryContext(ctx, getApiTokens, companyID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ApiToken
	for rows.Next() {
		var i ApiToken
		if err := rows.Scan(
			&i.ID,
			&i.ApiToken,
			&i.Name,
			&i.CompanyID,
			&i.GroupID,
			&i.RoleID,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getApiTokensByUser = `-- name: GetApiTokensByUser :many
SELECT id, api_token, name, company_id, group_id, role_id, created_by_user_id, created_at, updated_at
FROM api_token
WHERE created_by_user_id = $1
`

func (q *Queries) GetApiTokensByUser(ctx context.Context, createdByUserID int64) ([]ApiToken, error) {
	rows, err := q.db.QueryContext(ctx, getApiTokensByUser, createdByUserID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ApiToken
	for rows.Next() {
		var i ApiToken
		if err := rows.Scan(
			&i.ID,
			&i.ApiToken,
			&i.Name,
			&i.CompanyID,
			&i.GroupID,
			&i.RoleID,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getAuditLogs = `-- name: GetAuditLogs :many
SELECT l.event,
       l.action,
       l.resources,
       l.success,
       l.user_email as email,
       l.user_role  as role,
       l.created_at
FROM audit_log l
ORDER BY id DESC
OFFSET $1 LIMIT $2
`

type GetAuditLogsParams struct {
	Offset int32 `json:"offset"`
	Limit  int32 `json:"limit"`
}

type GetAuditLogsRow struct {
	Event     string    `json:"event"`
	Action    string    `json:"action"`
	Resources string    `json:"resources"`
	Success   bool      `json:"success"`
	Email     string    `json:"email"`
	Role      string    `json:"role"`
	CreatedAt time.Time `json:"created_at"`
}

func (q *Queries) GetAuditLogs(ctx context.Context, arg GetAuditLogsParams) ([]GetAuditLogsRow, error) {
	rows, err := q.db.QueryContext(ctx, getAuditLogs, arg.Offset, arg.Limit)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetAuditLogsRow
	for rows.Next() {
		var i GetAuditLogsRow
		if err := rows.Scan(
			&i.Event,
			&i.Action,
			&i.Resources,
			&i.Success,
			&i.Email,
			&i.Role,
			&i.CreatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getAuditLogsLast5Minutes = `-- name: GetAuditLogsLast5Minutes :many
SELECT l.event,
       l.action,
       l.resources,
       l.success,
       l.user_email as email,
       l.user_role  as role,
       l.created_at
FROM audit_log l
WHERE l.created_at < (now() - interval '5 minutes')
ORDER BY l.created_at DESC
`

type GetAuditLogsLast5MinutesRow struct {
	Event     string    `json:"event"`
	Action    string    `json:"action"`
	Resources string    `json:"resources"`
	Success   bool      `json:"success"`
	Email     string    `json:"email"`
	Role      string    `json:"role"`
	CreatedAt time.Time `json:"created_at"`
}

func (q *Queries) GetAuditLogsLast5Minutes(ctx context.Context) ([]GetAuditLogsLast5MinutesRow, error) {
	rows, err := q.db.QueryContext(ctx, getAuditLogsLast5Minutes)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetAuditLogsLast5MinutesRow
	for rows.Next() {
		var i GetAuditLogsLast5MinutesRow
		if err := rows.Scan(
			&i.Event,
			&i.Action,
			&i.Resources,
			&i.Success,
			&i.Email,
			&i.Role,
			&i.CreatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getCompanies = `-- name: GetCompanies :many
SELECT id, name, email_domain, created_at, updated_at, namespace
FROM company
ORDER BY name
`

func (q *Queries) GetCompanies(ctx context.Context) ([]Company, error) {
	rows, err := q.db.QueryContext(ctx, getCompanies)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Company
	for rows.Next() {
		var i Company
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.EmailDomain,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.Namespace,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getCompany = `-- name: GetCompany :one
SELECT id, name, email_domain, created_at, updated_at, namespace
FROM company
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetCompany(ctx context.Context, id int32) (Company, error) {
	row := q.db.QueryRowContext(ctx, getCompany, id)
	var i Company
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.EmailDomain,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.Namespace,
	)
	return i, err
}

const getCompanyByDomain = `-- name: GetCompanyByDomain :one
SELECT id, name, email_domain, created_at, updated_at, namespace
FROM company
WHERE email_domain = $1
LIMIT 1
`

func (q *Queries) GetCompanyByDomain(ctx context.Context, emailDomain string) (Company, error) {
	row := q.db.QueryRowContext(ctx, getCompanyByDomain, emailDomain)
	var i Company
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.EmailDomain,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.Namespace,
	)
	return i, err
}

const getContainerRegistries = `-- name: GetContainerRegistries :many
SELECT container_registry.id,
       container_registry.name,
       container_registry.registry_type,
       container_registry.encrypted_secret,
       container_registry.non_secret,
       container_registry.created_at,
       container_registry.updated_at,
       container_registry.extras
FROM container_registry
`

type GetContainerRegistriesRow struct {
	ID              int32           `json:"id"`
	Name            string          `json:"name"`
	RegistryType    string          `json:"registry_type"`
	EncryptedSecret json.RawMessage `json:"encrypted_secret"`
	NonSecret       json.RawMessage `json:"non_secret"`
	CreatedAt       time.Time       `json:"created_at"`
	UpdatedAt       time.Time       `json:"updated_at"`
	Extras          json.RawMessage `json:"extras"`
}

func (q *Queries) GetContainerRegistries(ctx context.Context) ([]GetContainerRegistriesRow, error) {
	rows, err := q.db.QueryContext(ctx, getContainerRegistries)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetContainerRegistriesRow
	for rows.Next() {
		var i GetContainerRegistriesRow
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.RegistryType,
			&i.EncryptedSecret,
			&i.NonSecret,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.Extras,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getContainerRegistriesSafe = `-- name: GetContainerRegistriesSafe :many
SELECT container_registry.id,
       container_registry.name,
       container_registry.registry_type,
       container_registry.non_secret,
       container_registry.created_at,
       container_registry.updated_at
FROM container_registry
`

type GetContainerRegistriesSafeRow struct {
	ID           int32           `json:"id"`
	Name         string          `json:"name"`
	RegistryType string          `json:"registry_type"`
	NonSecret    json.RawMessage `json:"non_secret"`
	CreatedAt    time.Time       `json:"created_at"`
	UpdatedAt    time.Time       `json:"updated_at"`
}

func (q *Queries) GetContainerRegistriesSafe(ctx context.Context) ([]GetContainerRegistriesSafeRow, error) {
	rows, err := q.db.QueryContext(ctx, getContainerRegistriesSafe)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetContainerRegistriesSafeRow
	for rows.Next() {
		var i GetContainerRegistriesSafeRow
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.RegistryType,
			&i.NonSecret,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getContainerRegistry = `-- name: GetContainerRegistry :one
SELECT container_registry.id,
       container_registry.name,
       container_registry.registry_type,
       container_registry.encrypted_secret,
       container_registry.non_secret,
       container_registry.created_at,
       container_registry.updated_at,
       container_registry.extras
FROM container_registry
WHERE container_registry.id = $1
LIMIT 1
`

type GetContainerRegistryRow struct {
	ID              int32           `json:"id"`
	Name            string          `json:"name"`
	RegistryType    string          `json:"registry_type"`
	EncryptedSecret json.RawMessage `json:"encrypted_secret"`
	NonSecret       json.RawMessage `json:"non_secret"`
	CreatedAt       time.Time       `json:"created_at"`
	UpdatedAt       time.Time       `json:"updated_at"`
	Extras          json.RawMessage `json:"extras"`
}

func (q *Queries) GetContainerRegistry(ctx context.Context, id int32) (GetContainerRegistryRow, error) {
	row := q.db.QueryRowContext(ctx, getContainerRegistry, id)
	var i GetContainerRegistryRow
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.RegistryType,
		&i.EncryptedSecret,
		&i.NonSecret,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.Extras,
	)
	return i, err
}

const getContainerRegistryByType = `-- name: GetContainerRegistryByType :many
SELECT container_registry.id,
       container_registry.name,
       container_registry.registry_type,
       container_registry.encrypted_secret,
       container_registry.non_secret,
       container_registry.created_at,
       container_registry.updated_at,
       container_registry.extras
FROM container_registry
WHERE container_registry.registry_type = $1
`

type GetContainerRegistryByTypeRow struct {
	ID              int32           `json:"id"`
	Name            string          `json:"name"`
	RegistryType    string          `json:"registry_type"`
	EncryptedSecret json.RawMessage `json:"encrypted_secret"`
	NonSecret       json.RawMessage `json:"non_secret"`
	CreatedAt       time.Time       `json:"created_at"`
	UpdatedAt       time.Time       `json:"updated_at"`
	Extras          json.RawMessage `json:"extras"`
}

func (q *Queries) GetContainerRegistryByType(ctx context.Context, registryType string) ([]GetContainerRegistryByTypeRow, error) {
	rows, err := q.db.QueryContext(ctx, getContainerRegistryByType, registryType)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetContainerRegistryByTypeRow
	for rows.Next() {
		var i GetContainerRegistryByTypeRow
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.RegistryType,
			&i.EncryptedSecret,
			&i.NonSecret,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.Extras,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getContainerRegistryByTypeAndName = `-- name: GetContainerRegistryByTypeAndName :one
SELECT container_registry.id,
       container_registry.name,
       container_registry.registry_type,
       container_registry.encrypted_secret,
       container_registry.non_secret,
       container_registry.created_at,
       container_registry.updated_at,
       container_registry.extras
FROM container_registry
WHERE container_registry.registry_type = $1
  AND container_registry.name = $2
LIMIT 1
`

type GetContainerRegistryByTypeAndNameParams struct {
	RegistryType string `json:"registry_type"`
	Name         string `json:"name"`
}

type GetContainerRegistryByTypeAndNameRow struct {
	ID              int32           `json:"id"`
	Name            string          `json:"name"`
	RegistryType    string          `json:"registry_type"`
	EncryptedSecret json.RawMessage `json:"encrypted_secret"`
	NonSecret       json.RawMessage `json:"non_secret"`
	CreatedAt       time.Time       `json:"created_at"`
	UpdatedAt       time.Time       `json:"updated_at"`
	Extras          json.RawMessage `json:"extras"`
}

func (q *Queries) GetContainerRegistryByTypeAndName(ctx context.Context, arg GetContainerRegistryByTypeAndNameParams) (GetContainerRegistryByTypeAndNameRow, error) {
	row := q.db.QueryRowContext(ctx, getContainerRegistryByTypeAndName, arg.RegistryType, arg.Name)
	var i GetContainerRegistryByTypeAndNameRow
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.RegistryType,
		&i.EncryptedSecret,
		&i.NonSecret,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.Extras,
	)
	return i, err
}

const getContainerRegistrySafe = `-- name: GetContainerRegistrySafe :one
SELECT container_registry.id,
       container_registry.name,
       container_registry.registry_type,
       container_registry.non_secret,
       container_registry.created_at,
       container_registry.updated_at
FROM container_registry
WHERE container_registry.id = $1
LIMIT 1
`

type GetContainerRegistrySafeRow struct {
	ID           int32           `json:"id"`
	Name         string          `json:"name"`
	RegistryType string          `json:"registry_type"`
	NonSecret    json.RawMessage `json:"non_secret"`
	CreatedAt    time.Time       `json:"created_at"`
	UpdatedAt    time.Time       `json:"updated_at"`
}

func (q *Queries) GetContainerRegistrySafe(ctx context.Context, id int32) (GetContainerRegistrySafeRow, error) {
	row := q.db.QueryRowContext(ctx, getContainerRegistrySafe, id)
	var i GetContainerRegistrySafeRow
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.RegistryType,
		&i.NonSecret,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getDefaultGenerativeAiIntegration = `-- name: GetDefaultGenerativeAiIntegration :one
SELECT id, integration_type, label, last_sent_time, config, error_msg, default_integration, created_by_user_id, created_at, updated_at
FROM generative_ai_integration
WHERE default_integration = true
LIMIT 1
`

func (q *Queries) GetDefaultGenerativeAiIntegration(ctx context.Context) (GenerativeAiIntegration, error) {
	row := q.db.QueryRowContext(ctx, getDefaultGenerativeAiIntegration)
	var i GenerativeAiIntegration
	err := row.Scan(
		&i.ID,
		&i.IntegrationType,
		&i.Label,
		&i.LastSentTime,
		&i.Config,
		&i.ErrorMsg,
		&i.DefaultIntegration,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getGenerativeAiIntegrationByType = `-- name: GetGenerativeAiIntegrationByType :many
SELECT id, integration_type, label, last_sent_time, config, error_msg, default_integration, created_by_user_id, created_at, updated_at
FROM generative_ai_integration
WHERE integration_type = $1
`

func (q *Queries) GetGenerativeAiIntegrationByType(ctx context.Context, integrationType string) ([]GenerativeAiIntegration, error) {
	rows, err := q.db.QueryContext(ctx, getGenerativeAiIntegrationByType, integrationType)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GenerativeAiIntegration
	for rows.Next() {
		var i GenerativeAiIntegration
		if err := rows.Scan(
			&i.ID,
			&i.IntegrationType,
			&i.Label,
			&i.LastSentTime,
			&i.Config,
			&i.ErrorMsg,
			&i.DefaultIntegration,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getGenerativeAiIntegrationFromID = `-- name: GetGenerativeAiIntegrationFromID :one
SELECT id, integration_type, label, last_sent_time, config, error_msg, default_integration, created_by_user_id, created_at, updated_at
FROM generative_ai_integration
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetGenerativeAiIntegrationFromID(ctx context.Context, id int32) (GenerativeAiIntegration, error) {
	row := q.db.QueryRowContext(ctx, getGenerativeAiIntegrationFromID, id)
	var i GenerativeAiIntegration
	err := row.Scan(
		&i.ID,
		&i.IntegrationType,
		&i.Label,
		&i.LastSentTime,
		&i.Config,
		&i.ErrorMsg,
		&i.DefaultIntegration,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getGenerativeAiIntegrations = `-- name: GetGenerativeAiIntegrations :many
SELECT id, integration_type, label, last_sent_time, config, error_msg, default_integration, created_by_user_id, created_at, updated_at
FROM generative_ai_integration
`

func (q *Queries) GetGenerativeAiIntegrations(ctx context.Context) ([]GenerativeAiIntegration, error) {
	rows, err := q.db.QueryContext(ctx, getGenerativeAiIntegrations)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GenerativeAiIntegration
	for rows.Next() {
		var i GenerativeAiIntegration
		if err := rows.Scan(
			&i.ID,
			&i.IntegrationType,
			&i.Label,
			&i.LastSentTime,
			&i.Config,
			&i.ErrorMsg,
			&i.DefaultIntegration,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getIntegrationFromID = `-- name: GetIntegrationFromID :one
SELECT id, resource, filters, integration_type, interval_minutes, last_sent_time, config, error_msg, created_by_user_id, created_at, updated_at, last_event_updated_at, metrics
FROM integration
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetIntegrationFromID(ctx context.Context, id int32) (Integration, error) {
	row := q.db.QueryRowContext(ctx, getIntegrationFromID, id)
	var i Integration
	err := row.Scan(
		&i.ID,
		&i.Resource,
		&i.Filters,
		&i.IntegrationType,
		&i.IntervalMinutes,
		&i.LastSentTime,
		&i.Config,
		&i.ErrorMsg,
		&i.CreatedByUserID,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.LastEventUpdatedAt,
		&i.Metrics,
	)
	return i, err
}

const getIntegrationMetrics = `-- name: GetIntegrationMetrics :one
SELECT metrics
FROM integration
WHERE id = $1
`

func (q *Queries) GetIntegrationMetrics(ctx context.Context, id int32) (*integrations.Metrics, error) {
	row := q.db.QueryRowContext(ctx, getIntegrationMetrics, id)
	var metrics *integrations.Metrics
	err := row.Scan(&metrics)
	return metrics, err
}

const getIntegrations = `-- name: GetIntegrations :many
SELECT id, resource, filters, integration_type, interval_minutes, last_sent_time, config, error_msg, created_by_user_id, created_at, updated_at, last_event_updated_at, metrics
FROM integration
`

func (q *Queries) GetIntegrations(ctx context.Context) ([]Integration, error) {
	rows, err := q.db.QueryContext(ctx, getIntegrations)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Integration
	for rows.Next() {
		var i Integration
		if err := rows.Scan(
			&i.ID,
			&i.Resource,
			&i.Filters,
			&i.IntegrationType,
			&i.IntervalMinutes,
			&i.LastSentTime,
			&i.Config,
			&i.ErrorMsg,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.LastEventUpdatedAt,
			&i.Metrics,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getIntegrationsFromIDs = `-- name: GetIntegrationsFromIDs :many
SELECT id, resource, filters, integration_type, interval_minutes, last_sent_time, config, error_msg, created_by_user_id, created_at, updated_at, last_event_updated_at, metrics
FROM integration
WHERE id = ANY($1::int[])
`

func (q *Queries) GetIntegrationsFromIDs(ctx context.Context, dollar_1 []int32) ([]Integration, error) {
	rows, err := q.db.QueryContext(ctx, getIntegrationsFromIDs, pq.Array(dollar_1))
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Integration
	for rows.Next() {
		var i Integration
		if err := rows.Scan(
			&i.ID,
			&i.Resource,
			&i.Filters,
			&i.IntegrationType,
			&i.IntervalMinutes,
			&i.LastSentTime,
			&i.Config,
			&i.ErrorMsg,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.LastEventUpdatedAt,
			&i.Metrics,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getIntegrationsFromType = `-- name: GetIntegrationsFromType :many
SELECT id, resource, filters, integration_type, interval_minutes, last_sent_time, config, error_msg, created_by_user_id, created_at, updated_at, last_event_updated_at, metrics
FROM integration
WHERE integration_type = $1
`

func (q *Queries) GetIntegrationsFromType(ctx context.Context, integrationType string) ([]Integration, error) {
	rows, err := q.db.QueryContext(ctx, getIntegrationsFromType, integrationType)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Integration
	for rows.Next() {
		var i Integration
		if err := rows.Scan(
			&i.ID,
			&i.Resource,
			&i.Filters,
			&i.IntegrationType,
			&i.IntervalMinutes,
			&i.LastSentTime,
			&i.Config,
			&i.ErrorMsg,
			&i.CreatedByUserID,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.LastEventUpdatedAt,
			&i.Metrics,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLicense = `-- name: GetLicense :one
SELECT id, license_key, start_date, end_date, no_of_hosts, current_hosts, is_active, license_type, deepfence_support_email, notification_threshold_percentage, notification_threshold_updated_at, registry_credentials, message, description, created_at, updated_at, license_email, license_email_domain, no_of_cloud_accounts, no_of_registries, no_of_images_in_registry
FROM license
LIMIT 1
`

func (q *Queries) GetLicense(ctx context.Context) (License, error) {
	row := q.db.QueryRowContext(ctx, getLicense)
	var i License
	err := row.Scan(
		&i.ID,
		&i.LicenseKey,
		&i.StartDate,
		&i.EndDate,
		&i.NoOfHosts,
		&i.CurrentHosts,
		&i.IsActive,
		&i.LicenseType,
		&i.DeepfenceSupportEmail,
		&i.NotificationThresholdPercentage,
		&i.NotificationThresholdUpdatedAt,
		&i.RegistryCredentials,
		&i.Message,
		&i.Description,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.LicenseEmail,
		&i.LicenseEmailDomain,
		&i.NoOfCloudAccounts,
		&i.NoOfRegistries,
		&i.NoOfImagesInRegistry,
	)
	return i, err
}

const getLicenseByKey = `-- name: GetLicenseByKey :one
SELECT id, license_key, start_date, end_date, no_of_hosts, current_hosts, is_active, license_type, deepfence_support_email, notification_threshold_percentage, notification_threshold_updated_at, registry_credentials, message, description, created_at, updated_at, license_email, license_email_domain, no_of_cloud_accounts, no_of_registries, no_of_images_in_registry
FROM license
WHERE license_key = $1
LIMIT 1
`

func (q *Queries) GetLicenseByKey(ctx context.Context, licenseKey uuid.UUID) (License, error) {
	row := q.db.QueryRowContext(ctx, getLicenseByKey, licenseKey)
	var i License
	err := row.Scan(
		&i.ID,
		&i.LicenseKey,
		&i.StartDate,
		&i.EndDate,
		&i.NoOfHosts,
		&i.CurrentHosts,
		&i.IsActive,
		&i.LicenseType,
		&i.DeepfenceSupportEmail,
		&i.NotificationThresholdPercentage,
		&i.NotificationThresholdUpdatedAt,
		&i.RegistryCredentials,
		&i.Message,
		&i.Description,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.LicenseEmail,
		&i.LicenseEmailDomain,
		&i.NoOfCloudAccounts,
		&i.NoOfRegistries,
		&i.NoOfImagesInRegistry,
	)
	return i, err
}

const getPasswordHash = `-- name: GetPasswordHash :one
SELECT password_hash
FROM users
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetPasswordHash(ctx context.Context, id int64) (string, error) {
	row := q.db.QueryRowContext(ctx, getPasswordHash, id)
	var password_hash string
	err := row.Scan(&password_hash)
	return password_hash, err
}

const getPasswordResetByCode = `-- name: GetPasswordResetByCode :one
SELECT password_reset.id,
       password_reset.code,
       password_reset.expiry,
       password_reset.user_id,
       password_reset.created_at,
       password_reset.updated_at
FROM password_reset
         INNER JOIN users u on password_reset.user_id = u.id
WHERE password_reset.code = $1
LIMIT 1
`

type GetPasswordResetByCodeRow struct {
	ID        int32     `json:"id"`
	Code      uuid.UUID `json:"code"`
	Expiry    time.Time `json:"expiry"`
	UserID    int64     `json:"user_id"`
	CreatedAt time.Time `json:"created_at"`
	UpdatedAt time.Time `json:"updated_at"`
}

func (q *Queries) GetPasswordResetByCode(ctx context.Context, code uuid.UUID) (GetPasswordResetByCodeRow, error) {
	row := q.db.QueryRowContext(ctx, getPasswordResetByCode, code)
	var i GetPasswordResetByCodeRow
	err := row.Scan(
		&i.ID,
		&i.Code,
		&i.Expiry,
		&i.UserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getPasswordResetById = `-- name: GetPasswordResetById :one
SELECT password_reset.id,
       password_reset.code,
       password_reset.expiry,
       password_reset.user_id,
       password_reset.created_at,
       password_reset.updated_at
FROM password_reset
         INNER JOIN users u on password_reset.user_id = u.id
WHERE password_reset.id = $1
LIMIT 1
`

type GetPasswordResetByIdRow struct {
	ID        int32     `json:"id"`
	Code      uuid.UUID `json:"code"`
	Expiry    time.Time `json:"expiry"`
	UserID    int64     `json:"user_id"`
	CreatedAt time.Time `json:"created_at"`
	UpdatedAt time.Time `json:"updated_at"`
}

func (q *Queries) GetPasswordResetById(ctx context.Context, id int32) (GetPasswordResetByIdRow, error) {
	row := q.db.QueryRowContext(ctx, getPasswordResetById, id)
	var i GetPasswordResetByIdRow
	err := row.Scan(
		&i.ID,
		&i.Code,
		&i.Expiry,
		&i.UserID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getRoleByID = `-- name: GetRoleByID :one
SELECT id, name, created_at, updated_at
FROM role
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetRoleByID(ctx context.Context, id int32) (Role, error) {
	row := q.db.QueryRowContext(ctx, getRoleByID, id)
	var i Role
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getRoleByName = `-- name: GetRoleByName :one
SELECT id, name, created_at, updated_at
FROM role
WHERE name = $1
LIMIT 1
`

func (q *Queries) GetRoleByName(ctx context.Context, name string) (Role, error) {
	row := q.db.QueryRowContext(ctx, getRoleByName, name)
	var i Role
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getRoles = `-- name: GetRoles :many
SELECT id, name, created_at, updated_at
FROM role
ORDER BY name
`

func (q *Queries) GetRoles(ctx context.Context) ([]Role, error) {
	rows, err := q.db.QueryContext(ctx, getRoles)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Role
	for rows.Next() {
		var i Role
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getSchedule = `-- name: GetSchedule :one
SELECT id, action, description, cron_expr, payload, is_enabled, is_system, status, last_ran_at, created_at, updated_at
FROM scheduler
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetSchedule(ctx context.Context, id int64) (Scheduler, error) {
	row := q.db.QueryRowContext(ctx, getSchedule, id)
	var i Scheduler
	err := row.Scan(
		&i.ID,
		&i.Action,
		&i.Description,
		&i.CronExpr,
		&i.Payload,
		&i.IsEnabled,
		&i.IsSystem,
		&i.Status,
		&i.LastRanAt,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getSchedules = `-- name: GetSchedules :many
SELECT id, action, description, cron_expr, payload, is_enabled, is_system, status, last_ran_at, created_at, updated_at
FROM scheduler
ORDER BY created_at
`

func (q *Queries) GetSchedules(ctx context.Context) ([]Scheduler, error) {
	rows, err := q.db.QueryContext(ctx, getSchedules)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Scheduler
	for rows.Next() {
		var i Scheduler
		if err := rows.Scan(
			&i.ID,
			&i.Action,
			&i.Description,
			&i.CronExpr,
			&i.Payload,
			&i.IsEnabled,
			&i.IsSystem,
			&i.Status,
			&i.LastRanAt,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getSetting = `-- name: GetSetting :one
SELECT id, key, value, is_visible_on_ui, created_at, updated_at
FROM setting
WHERE key = $1
LIMIT 1
`

func (q *Queries) GetSetting(ctx context.Context, key string) (Setting, error) {
	row := q.db.QueryRowContext(ctx, getSetting, key)
	var i Setting
	err := row.Scan(
		&i.ID,
		&i.Key,
		&i.Value,
		&i.IsVisibleOnUi,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getSettings = `-- name: GetSettings :many
SELECT id, key, value, is_visible_on_ui, created_at, updated_at
FROM setting
ORDER BY key
`

func (q *Queries) GetSettings(ctx context.Context) ([]Setting, error) {
	rows, err := q.db.QueryContext(ctx, getSettings)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Setting
	for rows.Next() {
		var i Setting
		if err := rows.Scan(
			&i.ID,
			&i.Key,
			&i.Value,
			&i.IsVisibleOnUi,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getUser = `-- name: GetUser :one
SELECT users.id,
       users.first_name,
       users.last_name,
       users.email,
       users.role_id,
       role.name         as role_name,
       users.group_ids,
       users.company_id,
       company.name      as company_name,
       users.password_hash,
       users.is_active,
       users.password_invalidated,
       users.created_at,
       users.updated_at,
       company.namespace as company_namespace
FROM users
         INNER JOIN role ON role.id = users.role_id
         INNER JOIN company ON company.id = users.company_id
WHERE users.id = $1
LIMIT 1
`

type GetUserRow struct {
	ID                  int64           `json:"id"`
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	RoleName            string          `json:"role_name"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	CompanyName         string          `json:"company_name"`
	PasswordHash        string          `json:"password_hash"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	CreatedAt           time.Time       `json:"created_at"`
	UpdatedAt           time.Time       `json:"updated_at"`
	CompanyNamespace    string          `json:"company_namespace"`
}

func (q *Queries) GetUser(ctx context.Context, id int64) (GetUserRow, error) {
	row := q.db.QueryRowContext(ctx, getUser, id)
	var i GetUserRow
	err := row.Scan(
		&i.ID,
		&i.FirstName,
		&i.LastName,
		&i.Email,
		&i.RoleID,
		&i.RoleName,
		&i.GroupIds,
		&i.CompanyID,
		&i.CompanyName,
		&i.PasswordHash,
		&i.IsActive,
		&i.PasswordInvalidated,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.CompanyNamespace,
	)
	return i, err
}

const getUserByEmail = `-- name: GetUserByEmail :one
SELECT users.id,
       users.first_name,
       users.last_name,
       users.email,
       users.role_id,
       role.name         as role_name,
       users.group_ids,
       users.company_id,
       company.name      as company_name,
       users.password_hash,
       users.is_active,
       users.password_invalidated,
       users.created_at,
       users.updated_at,
       company.namespace as company_namespace
FROM users
         INNER JOIN role ON role.id = users.role_id
         INNER JOIN company ON company.id = users.company_id
WHERE users.email = $1
LIMIT 1
`

type GetUserByEmailRow struct {
	ID                  int64           `json:"id"`
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	RoleName            string          `json:"role_name"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	CompanyName         string          `json:"company_name"`
	PasswordHash        string          `json:"password_hash"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	CreatedAt           time.Time       `json:"created_at"`
	UpdatedAt           time.Time       `json:"updated_at"`
	CompanyNamespace    string          `json:"company_namespace"`
}

func (q *Queries) GetUserByEmail(ctx context.Context, email string) (GetUserByEmailRow, error) {
	row := q.db.QueryRowContext(ctx, getUserByEmail, email)
	var i GetUserByEmailRow
	err := row.Scan(
		&i.ID,
		&i.FirstName,
		&i.LastName,
		&i.Email,
		&i.RoleID,
		&i.RoleName,
		&i.GroupIds,
		&i.CompanyID,
		&i.CompanyName,
		&i.PasswordHash,
		&i.IsActive,
		&i.PasswordInvalidated,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.CompanyNamespace,
	)
	return i, err
}

const getUserGroupByID = `-- name: GetUserGroupByID :one
SELECT id, name, is_system, company_id, created_at, updated_at
FROM user_group
WHERE id = $1
LIMIT 1
`

func (q *Queries) GetUserGroupByID(ctx context.Context, id int32) (UserGroup, error) {
	row := q.db.QueryRowContext(ctx, getUserGroupByID, id)
	var i UserGroup
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.IsSystem,
		&i.CompanyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getUserGroups = `-- name: GetUserGroups :many
SELECT id, name, is_system, company_id, created_at, updated_at
FROM user_group
WHERE company_id = $1
ORDER BY name
`

func (q *Queries) GetUserGroups(ctx context.Context, companyID int32) ([]UserGroup, error) {
	rows, err := q.db.QueryContext(ctx, getUserGroups, companyID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []UserGroup
	for rows.Next() {
		var i UserGroup
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.IsSystem,
			&i.CompanyID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getUserInviteByCode = `-- name: GetUserInviteByCode :one
SELECT id, email, code, created_by_user_id, role_id, company_id, accepted, expiry, created_at, updated_at
FROM user_invite
WHERE code = $1
LIMIT 1
`

func (q *Queries) GetUserInviteByCode(ctx context.Context, code uuid.UUID) (UserInvite, error) {
	row := q.db.QueryRowContext(ctx, getUserInviteByCode, code)
	var i UserInvite
	err := row.Scan(
		&i.ID,
		&i.Email,
		&i.Code,
		&i.CreatedByUserID,
		&i.RoleID,
		&i.CompanyID,
		&i.Accepted,
		&i.Expiry,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getUserInviteByEmail = `-- name: GetUserInviteByEmail :one
SELECT id, email, code, created_by_user_id, role_id, company_id, accepted, expiry, created_at, updated_at
FROM user_invite
WHERE email = $1
LIMIT 1
`

func (q *Queries) GetUserInviteByEmail(ctx context.Context, email string) (UserInvite, error) {
	row := q.db.QueryRowContext(ctx, getUserInviteByEmail, email)
	var i UserInvite
	err := row.Scan(
		&i.ID,
		&i.Email,
		&i.Code,
		&i.CreatedByUserID,
		&i.RoleID,
		&i.CompanyID,
		&i.Accepted,
		&i.Expiry,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getUsers = `-- name: GetUsers :many
SELECT users.id,
       users.first_name,
       users.last_name,
       users.email,
       users.role_id,
       role.name         as role_name,
       users.group_ids,
       users.company_id,
       company.name      as company_name,
       users.is_active,
       users.password_invalidated,
       users.created_at,
       users.updated_at,
       company.namespace as company_namespace
FROM users
         INNER JOIN role ON role.id = users.role_id
         INNER JOIN company ON company.id = users.company_id
ORDER BY first_name
`

type GetUsersRow struct {
	ID                  int64           `json:"id"`
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	RoleName            string          `json:"role_name"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	CompanyName         string          `json:"company_name"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	CreatedAt           time.Time       `json:"created_at"`
	UpdatedAt           time.Time       `json:"updated_at"`
	CompanyNamespace    string          `json:"company_namespace"`
}

func (q *Queries) GetUsers(ctx context.Context) ([]GetUsersRow, error) {
	rows, err := q.db.QueryContext(ctx, getUsers)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetUsersRow
	for rows.Next() {
		var i GetUsersRow
		if err := rows.Scan(
			&i.ID,
			&i.FirstName,
			&i.LastName,
			&i.Email,
			&i.RoleID,
			&i.RoleName,
			&i.GroupIds,
			&i.CompanyID,
			&i.CompanyName,
			&i.IsActive,
			&i.PasswordInvalidated,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.CompanyNamespace,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getUsersByCompanyID = `-- name: GetUsersByCompanyID :many
SELECT users.id,
       users.first_name,
       users.last_name,
       users.email,
       users.role_id,
       role.name         as role_name,
       users.group_ids,
       users.company_id,
       company.name      as company_name,
       users.is_active,
       users.password_invalidated,
       users.created_at,
       users.updated_at,
       company.namespace as company_namespace
FROM users
         INNER JOIN role ON role.id = users.role_id
         INNER JOIN company ON company.id = users.company_id
WHERE company_id = $1
ORDER BY first_name
`

type GetUsersByCompanyIDRow struct {
	ID                  int64           `json:"id"`
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	Email               string          `json:"email"`
	RoleID              int32           `json:"role_id"`
	RoleName            string          `json:"role_name"`
	GroupIds            json.RawMessage `json:"group_ids"`
	CompanyID           int32           `json:"company_id"`
	CompanyName         string          `json:"company_name"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	CreatedAt           time.Time       `json:"created_at"`
	UpdatedAt           time.Time       `json:"updated_at"`
	CompanyNamespace    string          `json:"company_namespace"`
}

func (q *Queries) GetUsersByCompanyID(ctx context.Context, companyID int32) ([]GetUsersByCompanyIDRow, error) {
	rows, err := q.db.QueryContext(ctx, getUsersByCompanyID, companyID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetUsersByCompanyIDRow
	for rows.Next() {
		var i GetUsersByCompanyIDRow
		if err := rows.Scan(
			&i.ID,
			&i.FirstName,
			&i.LastName,
			&i.Email,
			&i.RoleID,
			&i.RoleName,
			&i.GroupIds,
			&i.CompanyID,
			&i.CompanyName,
			&i.IsActive,
			&i.PasswordInvalidated,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.CompanyNamespace,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getVisibleSettings = `-- name: GetVisibleSettings :many
SELECT id, key, value, is_visible_on_ui, created_at, updated_at
FROM setting
WHERE is_visible_on_ui = true
ORDER BY key
`

func (q *Queries) GetVisibleSettings(ctx context.Context) ([]Setting, error) {
	rows, err := q.db.QueryContext(ctx, getVisibleSettings)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Setting
	for rows.Next() {
		var i Setting
		if err := rows.Scan(
			&i.ID,
			&i.Key,
			&i.Value,
			&i.IsVisibleOnUi,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const setIntegrationMetrics = `-- name: SetIntegrationMetrics :exec
UPDATE integration
SET metrics = $2
WHERE id = $1
`

type SetIntegrationMetricsParams struct {
	ID      int32                 `json:"id"`
	Metrics *integrations.Metrics `json:"metrics"`
}

func (q *Queries) SetIntegrationMetrics(ctx context.Context, arg SetIntegrationMetricsParams) error {
	_, err := q.db.ExecContext(ctx, setIntegrationMetrics, arg.ID, arg.Metrics)
	return err
}

const updateContainerRegistry = `-- name: UpdateContainerRegistry :one
UPDATE container_registry
SET name=$1,
    registry_type=$2,
    encrypted_secret=$3,
    non_secret=$4,
    extras=$5
WHERE id = $6
RETURNING id, name, registry_type, encrypted_secret, non_secret, extras, created_at, updated_at
`

type UpdateContainerRegistryParams struct {
	Name            string          `json:"name"`
	RegistryType    string          `json:"registry_type"`
	EncryptedSecret json.RawMessage `json:"encrypted_secret"`
	NonSecret       json.RawMessage `json:"non_secret"`
	Extras          json.RawMessage `json:"extras"`
	ID              int32           `json:"id"`
}

func (q *Queries) UpdateContainerRegistry(ctx context.Context, arg UpdateContainerRegistryParams) (ContainerRegistry, error) {
	row := q.db.QueryRowContext(ctx, updateContainerRegistry,
		arg.Name,
		arg.RegistryType,
		arg.EncryptedSecret,
		arg.NonSecret,
		arg.Extras,
		arg.ID,
	)
	var i ContainerRegistry
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.RegistryType,
		&i.EncryptedSecret,
		&i.NonSecret,
		&i.Extras,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const updateGenerativeAiIntegrationDefault = `-- name: UpdateGenerativeAiIntegrationDefault :exec
UPDATE generative_ai_integration
SET default_integration = (CASE WHEN id = $1 THEN true ELSE false END)
`

func (q *Queries) UpdateGenerativeAiIntegrationDefault(ctx context.Context, id int32) error {
	_, err := q.db.ExecContext(ctx, updateGenerativeAiIntegrationDefault, id)
	return err
}

const updateGenerativeAiIntegrationFirstRowDefault = `-- name: UpdateGenerativeAiIntegrationFirstRowDefault :exec
UPDATE generative_ai_integration
SET default_integration= true
WHERE ID = (SELECT ID FROM generative_ai_integration ORDER BY ID LIMIT 1)
`

func (q *Queries) UpdateGenerativeAiIntegrationFirstRowDefault(ctx context.Context) error {
	_, err := q.db.ExecContext(ctx, updateGenerativeAiIntegrationFirstRowDefault)
	return err
}

const updateGenerativeAiIntegrationStatus = `-- name: UpdateGenerativeAiIntegrationStatus :exec
UPDATE generative_ai_integration
SET error_msg      = $2,
    last_sent_time = now()
WHERE id = $1
`

type UpdateGenerativeAiIntegrationStatusParams struct {
	ID       int32          `json:"id"`
	ErrorMsg sql.NullString `json:"error_msg"`
}

func (q *Queries) UpdateGenerativeAiIntegrationStatus(ctx context.Context, arg UpdateGenerativeAiIntegrationStatusParams) error {
	_, err := q.db.ExecContext(ctx, updateGenerativeAiIntegrationStatus, arg.ID, arg.ErrorMsg)
	return err
}

const updateIntegration = `-- name: UpdateIntegration :exec
UPDATE integration
SET resource        = $1,
    filters         = $2,
    integration_type= $3,
    interval_minutes= $4,
    config          = $5
WHERE id = $6
`

type UpdateIntegrationParams struct {
	Resource        string          `json:"resource"`
	Filters         json.RawMessage `json:"filters"`
	IntegrationType string          `json:"integration_type"`
	IntervalMinutes int32           `json:"interval_minutes"`
	Config          json.RawMessage `json:"config"`
	ID              int32           `json:"id"`
}

func (q *Queries) UpdateIntegration(ctx context.Context, arg UpdateIntegrationParams) error {
	_, err := q.db.ExecContext(ctx, updateIntegration,
		arg.Resource,
		arg.Filters,
		arg.IntegrationType,
		arg.IntervalMinutes,
		arg.Config,
		arg.ID,
	)
	return err
}

const updateIntegrationLastEventUpdatedAt = `-- name: UpdateIntegrationLastEventUpdatedAt :exec
UPDATE integration
SET last_event_updated_at = $2
WHERE id = $1
`

type UpdateIntegrationLastEventUpdatedAtParams struct {
	ID                 int32        `json:"id"`
	LastEventUpdatedAt sql.NullTime `json:"last_event_updated_at"`
}

func (q *Queries) UpdateIntegrationLastEventUpdatedAt(ctx context.Context, arg UpdateIntegrationLastEventUpdatedAtParams) error {
	_, err := q.db.ExecContext(ctx, updateIntegrationLastEventUpdatedAt, arg.ID, arg.LastEventUpdatedAt)
	return err
}

const updateIntegrationStatus = `-- name: UpdateIntegrationStatus :exec
UPDATE integration
SET error_msg      = $2,
    last_sent_time = now()
WHERE id = $1
`

type UpdateIntegrationStatusParams struct {
	ID       int32          `json:"id"`
	ErrorMsg sql.NullString `json:"error_msg"`
}

func (q *Queries) UpdateIntegrationStatus(ctx context.Context, arg UpdateIntegrationStatusParams) error {
	_, err := q.db.ExecContext(ctx, updateIntegrationStatus, arg.ID, arg.ErrorMsg)
	return err
}

const updateNotificationThreshold = `-- name: UpdateNotificationThreshold :exec
UPDATE license
SET notification_threshold_percentage = $1,
    notification_threshold_updated_at = now()
WHERE license_key = $2
`

type UpdateNotificationThresholdParams struct {
	NotificationThresholdPercentage int32     `json:"notification_threshold_percentage"`
	LicenseKey                      uuid.UUID `json:"license_key"`
}

func (q *Queries) UpdateNotificationThreshold(ctx context.Context, arg UpdateNotificationThresholdParams) error {
	_, err := q.db.ExecContext(ctx, updateNotificationThreshold, arg.NotificationThresholdPercentage, arg.LicenseKey)
	return err
}

const updatePassword = `-- name: UpdatePassword :exec
UPDATE users
SET password_hash = $1
WHERE id = $2
`

type UpdatePasswordParams struct {
	PasswordHash string `json:"password_hash"`
	ID           int64  `json:"id"`
}

func (q *Queries) UpdatePassword(ctx context.Context, arg UpdatePasswordParams) error {
	_, err := q.db.ExecContext(ctx, updatePassword, arg.PasswordHash, arg.ID)
	return err
}

const updateSchedule = `-- name: UpdateSchedule :exec
UPDATE scheduler
SET description = $1,
    cron_expr   = $2,
    payload     = $3,
    is_enabled  = $4,
    status      = $5
WHERE id = $6
`

type UpdateScheduleParams struct {
	Description string          `json:"description"`
	CronExpr    string          `json:"cron_expr"`
	Payload     json.RawMessage `json:"payload"`
	IsEnabled   bool            `json:"is_enabled"`
	Status      string          `json:"status"`
	ID          int64           `json:"id"`
}

func (q *Queries) UpdateSchedule(ctx context.Context, arg UpdateScheduleParams) error {
	_, err := q.db.ExecContext(ctx, updateSchedule,
		arg.Description,
		arg.CronExpr,
		arg.Payload,
		arg.IsEnabled,
		arg.Status,
		arg.ID,
	)
	return err
}

const updateScheduleStatus = `-- name: UpdateScheduleStatus :exec
UPDATE scheduler
SET status      = $1,
    last_ran_at = now()
WHERE id = $2
`

type UpdateScheduleStatusParams struct {
	Status string `json:"status"`
	ID     int64  `json:"id"`
}

func (q *Queries) UpdateScheduleStatus(ctx context.Context, arg UpdateScheduleStatusParams) error {
	_, err := q.db.ExecContext(ctx, updateScheduleStatus, arg.Status, arg.ID)
	return err
}

const updateSetting = `-- name: UpdateSetting :exec
UPDATE setting
SET value            = $1,
    is_visible_on_ui = $2
WHERE key = $3
`

type UpdateSettingParams struct {
	Value         json.RawMessage `json:"value"`
	IsVisibleOnUi bool            `json:"is_visible_on_ui"`
	Key           string          `json:"key"`
}

func (q *Queries) UpdateSetting(ctx context.Context, arg UpdateSettingParams) error {
	_, err := q.db.ExecContext(ctx, updateSetting, arg.Value, arg.IsVisibleOnUi, arg.Key)
	return err
}

const updateSettingById = `-- name: UpdateSettingById :exec
UPDATE setting
SET value            = $1,
    is_visible_on_ui = $2
WHERE id = $3
`

type UpdateSettingByIdParams struct {
	Value         json.RawMessage `json:"value"`
	IsVisibleOnUi bool            `json:"is_visible_on_ui"`
	ID            int64           `json:"id"`
}

func (q *Queries) UpdateSettingById(ctx context.Context, arg UpdateSettingByIdParams) error {
	_, err := q.db.ExecContext(ctx, updateSettingById, arg.Value, arg.IsVisibleOnUi, arg.ID)
	return err
}

const updateUser = `-- name: UpdateUser :one
UPDATE users
SET first_name           = $1,
    last_name            = $2,
    role_id              = $3,
    group_ids            = $4,
    is_active            = $5,
    password_invalidated = $6
WHERE id = $7
RETURNING id, first_name, last_name, email, role_id, group_ids, company_id, password_hash, is_active, password_invalidated, created_at, updated_at
`

type UpdateUserParams struct {
	FirstName           string          `json:"first_name"`
	LastName            string          `json:"last_name"`
	RoleID              int32           `json:"role_id"`
	GroupIds            json.RawMessage `json:"group_ids"`
	IsActive            bool            `json:"is_active"`
	PasswordInvalidated bool            `json:"password_invalidated"`
	ID                  int64           `json:"id"`
}

func (q *Queries) UpdateUser(ctx context.Context, arg UpdateUserParams) (User, error) {
	row := q.db.QueryRowContext(ctx, updateUser,
		arg.FirstName,
		arg.LastName,
		arg.RoleID,
		arg.GroupIds,
		arg.IsActive,
		arg.PasswordInvalidated,
		arg.ID,
	)
	var i User
	err := row.Scan(
		&i.ID,
		&i.FirstName,
		&i.LastName,
		&i.Email,
		&i.RoleID,
		&i.GroupIds,
		&i.CompanyID,
		&i.PasswordHash,
		&i.IsActive,
		&i.PasswordInvalidated,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const updateUserInvite = `-- name: UpdateUserInvite :one
UPDATE user_invite
SET code=$1,
    created_by_user_id=$2,
    role_id=$3,
    company_id=$4,
    accepted=$5,
    expiry=$6
WHERE id = $7
RETURNING id, email, code, created_by_user_id, role_id, company_id, accepted, expiry, created_at, updated_at
`

type UpdateUserInviteParams struct {
	Code            uuid.UUID `json:"code"`
	CreatedByUserID int64     `json:"created_by_user_id"`
	RoleID          int32     `json:"role_id"`
	CompanyID       int32     `json:"company_id"`
	Accepted        bool      `json:"accepted"`
	Expiry          time.Time `json:"expiry"`
	ID              int32     `json:"id"`
}

func (q *Queries) UpdateUserInvite(ctx context.Context, arg UpdateUserInviteParams) (UserInvite, error) {
	row := q.db.QueryRowContext(ctx, updateUserInvite,
		arg.Code,
		arg.CreatedByUserID,
		arg.RoleID,
		arg.CompanyID,
		arg.Accepted,
		arg.Expiry,
		arg.ID,
	)
	var i UserInvite
	err := row.Scan(
		&i.ID,
		&i.Email,
		&i.Code,
		&i.CreatedByUserID,
		&i.RoleID,
		&i.CompanyID,
		&i.Accepted,
		&i.Expiry,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const upsertLicense = `-- name: UpsertLicense :one
INSERT INTO license (license_key, start_date, end_date, no_of_hosts, current_hosts, is_active, license_type,
                     deepfence_support_email, notification_threshold_percentage, registry_credentials, message,
                     description, no_of_cloud_accounts, no_of_registries, no_of_images_in_registry, license_email,
                     license_email_domain)
VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17)
ON CONFLICT (license_key) DO UPDATE
    SET start_date                        = $2,
        end_date                          = $3,
        no_of_hosts                       = $4,
        current_hosts                     = $5,
        is_active                         = $6,
        license_type                      = $7,
        deepfence_support_email           = $8,
        notification_threshold_percentage = $9,
        registry_credentials              = $10,
        message                           = $11,
        description                       = $12,
        no_of_cloud_accounts              = $13,
        no_of_registries                  = $14,
        no_of_images_in_registry          = $15,
        license_email                     = $16,
        license_email_domain              = $17
RETURNING id, license_key, start_date, end_date, no_of_hosts, current_hosts, is_active, license_type, deepfence_support_email, notification_threshold_percentage, notification_threshold_updated_at, registry_credentials, message, description, created_at, updated_at, license_email, license_email_domain, no_of_cloud_accounts, no_of_registries, no_of_images_in_registry
`

type UpsertLicenseParams struct {
	LicenseKey                      uuid.UUID       `json:"license_key"`
	StartDate                       time.Time       `json:"start_date"`
	EndDate                         time.Time       `json:"end_date"`
	NoOfHosts                       int64           `json:"no_of_hosts"`
	CurrentHosts                    int64           `json:"current_hosts"`
	IsActive                        bool            `json:"is_active"`
	LicenseType                     string          `json:"license_type"`
	DeepfenceSupportEmail           string          `json:"deepfence_support_email"`
	NotificationThresholdPercentage int32           `json:"notification_threshold_percentage"`
	RegistryCredentials             json.RawMessage `json:"registry_credentials"`
	Message                         string          `json:"message"`
	Description                     string          `json:"description"`
	NoOfCloudAccounts               int64           `json:"no_of_cloud_accounts"`
	NoOfRegistries                  int64           `json:"no_of_registries"`
	NoOfImagesInRegistry            int64           `json:"no_of_images_in_registry"`
	LicenseEmail                    string          `json:"license_email"`
	LicenseEmailDomain              string          `json:"license_email_domain"`
}

func (q *Queries) UpsertLicense(ctx context.Context, arg UpsertLicenseParams) (License, error) {
	row := q.db.QueryRowContext(ctx, upsertLicense,
		arg.LicenseKey,
		arg.StartDate,
		arg.EndDate,
		arg.NoOfHosts,
		arg.CurrentHosts,
		arg.IsActive,
		arg.LicenseType,
		arg.DeepfenceSupportEmail,
		arg.NotificationThresholdPercentage,
		arg.RegistryCredentials,
		arg.Message,
		arg.Description,
		arg.NoOfCloudAccounts,
		arg.NoOfRegistries,
		arg.NoOfImagesInRegistry,
		arg.LicenseEmail,
		arg.LicenseEmailDomain,
	)
	var i License
	err := row.Scan(
		&i.ID,
		&i.LicenseKey,
		&i.StartDate,
		&i.EndDate,
		&i.NoOfHosts,
		&i.CurrentHosts,
		&i.IsActive,
		&i.LicenseType,
		&i.DeepfenceSupportEmail,
		&i.NotificationThresholdPercentage,
		&i.NotificationThresholdUpdatedAt,
		&i.RegistryCredentials,
		&i.Message,
		&i.Description,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.LicenseEmail,
		&i.LicenseEmailDomain,
		&i.NoOfCloudAccounts,
		&i.NoOfRegistries,
		&i.NoOfImagesInRegistry,
	)
	return i, err
}
