package report

// node metadata keys
const (
	// Node
	NodeActiveControls = "active_controls"
	CounterPrefix      = "count_"
	// probe/endpoint
	ReverseDNSNames = "reverse_dns_names"
	SnoopedDNSNames = "snooped_dns_names"
	CopyOf          = "copy_of"
	ConnectionCount = "conn_count"

	// probe/process
	PID       = "pid"
	Name      = "name" // also used by probe/docker
	PPID      = "ppid"
	Cmdline   = "cmdline"
	Threads   = "threads"
	OpenFiles = "OpenFiles"
	// probe/docker
	DockerContainerID            = "docker_container_id"
	DockerImageID                = "docker_image_id"
	DockerImageName              = "docker_image_name"
	DockerImageTag               = "docker_image_tag"
	DockerImageSize              = "docker_image_size"
	DockerImageCreatedAt         = "docker_image_created_at"
	DockerImageVirtualSize       = "docker_image_virtual_size"
	DockerIsInHostNetwork        = "docker_is_in_host_network"
	DockerServiceName            = "service_name"
	DockerStackNamespace         = "stack_namespace"
	DockerDefaultNamespace       = "No stack"
	DockerStopContainer          = "docker_stop_container"
	DockerStartContainer         = "docker_start_container"
	DockerRestartContainer       = "docker_restart_container"
	DockerPauseContainer         = "docker_pause_container"
	DockerUnpauseContainer       = "docker_unpause_container"
	DockerRemoveContainer        = "docker_remove_container"
	DockerAttachContainer        = "docker_attach_container"
	DockerExecContainer          = "docker_exec_container"
	DockerContainerName          = "docker_container_name"
	DockerContainerCommand       = "docker_container_command"
	DockerContainerPorts         = "docker_container_ports"
	DockerContainerCreated       = "docker_container_created"
	DockerContainerNetworks      = "docker_container_networks"
	DockerContainerIPs           = "docker_container_ips"
	DockerContainerHostname      = "docker_container_hostname"
	DockerContainerIPsWithScopes = "docker_container_ips_with_scopes"
	DockerContainerState         = "docker_container_state"
	DockerContainerStateHuman    = "docker_container_state_human"
	DockerContainerUptime        = "docker_container_uptime"
	DockerContainerRestartCount  = "docker_container_restart_count"
	DockerContainerNetworkMode   = "docker_container_network_mode"
	DockerEnvPrefix              = "docker_env_"
	// probe/kubernetes
	KubernetesName                 = "kubernetes_name"
	KubernetesNamespace            = "kubernetes_namespace"
	KubernetesCreated              = "kubernetes_created"
	KubernetesIP                   = "kubernetes_ip"
	KubernetesObservedGeneration   = "kubernetes_observed_generation"
	KubernetesReplicas             = "kubernetes_replicas"
	KubernetesDesiredReplicas      = "kubernetes_desired_replicas"
	KubernetesNodeType             = "kubernetes_node_type"
	KubernetesGetLogs              = "kubernetes_get_logs"
	KubernetesDeletePod            = "kubernetes_delete_pod"
	KubernetesScaleUp              = "kubernetes_scale_up"
	KubernetesScaleDown            = "kubernetes_scale_down"
	KubernetesUpdatedReplicas      = "kubernetes_updated_replicas"
	KubernetesAvailableReplicas    = "kubernetes_available_replicas"
	KubernetesUnavailableReplicas  = "kubernetes_unavailable_replicas"
	KubernetesStrategy             = "kubernetes_strategy"
	KubernetesFullyLabeledReplicas = "kubernetes_fully_labeled_replicas"
	KubernetesState                = "kubernetes_state"
	KubernetesIsInHostNetwork      = "kubernetes_is_in_host_network"
	KubernetesRestartCount         = "kubernetes_restart_count"
	KubernetesMisscheduledReplicas = "kubernetes_misscheduled_replicas"
	KubernetesPublicIP             = "kubernetes_public_ip"
	KubernetesIngressIP            = "kubernetes_ingress_ip"
	KubernetesSchedule             = "kubernetes_schedule"
	KubernetesSuspended            = "kubernetes_suspended"
	KubernetesLastScheduled        = "kubernetes_last_scheduled"
	KubernetesActiveJobs           = "kubernetes_active_jobs"
	KubernetesType                 = "kubernetes_type"
	KubernetesPorts                = "kubernetes_ports"
	KubernetesVolumeClaim          = "kubernetes_volume_claim"
	KubernetesStorageClassName     = "kubernetes_storage_class_name"
	KubernetesAccessModes          = "kubernetes_access_modes"
	KubernetesReclaimPolicy        = "kubernetes_reclaim_policy"
	KubernetesStatus               = "kubernetes_status"
	KubernetesMessage              = "kubernetes_message"
	KubernetesVolumeName           = "kubernetes_volume_name"
	KubernetesProvisioner          = "kubernetes_provisioner"
	KubernetesStorageDriver        = "kubernetes_storage_driver"
	KubernetesVolumeSnapshotName   = "kubernetes_volume_snapshot_name"
	KubernetesSnapshotData         = "kuberneets_snapshot_data"
	KubernetesCreateVolumeSnapshot = "kubernetes_create_volume_snapshot"
	KubernetesVolumeCapacity       = "kubernetes_volume_capacity"
	KubernetesCloneVolumeSnapshot  = "kubernetes_clone_volume_snapshot"
	KubernetesDeleteVolumeSnapshot = "kubernetes_delete_volume_snapshot"
	KubernetesDescribe             = "kubernetes_describe"
	KubernetesClusterID            = "kubernetes_cluster_id"
	KubernetesClusterName          = "kubernetes_cluster_name"
	// probe/awsecs
	ECSCluster             = "ecs_cluster"
	ECSCreatedAt           = "ecs_created_at"
	ECSTaskFamily          = "ecs_task_family"
	ECSServiceDesiredCount = "ecs_service_desired_count"
	ECSServiceRunningCount = "ecs_service_running_count"
	ECSScaleUp             = "ecs_scale_up"
	ECSScaleDown           = "ecs_scale_down"
	// probe/host
	Timestamp         = "ts"
	HostName          = "host_name"
	HostLocalNetworks = "local_networks"
	OS                = "os"
	KernelVersion     = "kernel_version"
	Uptime            = "uptime"
	Load1             = "load1"
	HostCPUUsage      = "host_cpu_usage_percent"
	HostMemoryUsage   = "host_mem_usage_bytes"
	ScopeVersion      = "host_scope_version"

	CloudProviderServerless = "Serverless"
	CloudRegionServerless   = "Global"
	// probe/overlay/weave
	WeavePeerName     = "weave_peer_name"
	WeavePeerNickName = "weave_peer_nick_name"
)
