package common

var CSPMResources = map[string]string{
	"aws_s3_bucket":                        "aws_s3",
	"aws_s3_account_settings":              "aws_s3",
	"aws_iam_user":                         "aws_iam",
	"aws_iam_account_summary":              "aws_iam",
	"aws_iam_access_key":                   "aws_iam",
	"aws_iam_role":                         "aws_iam",
	"aws_iam_virtual_mfa_device":           "aws_iam",
	"aws_iam_policy":                       "aws_iam",
	"aws_iam_group":                        "aws_iam",
	"aws_iam_credential_report":            "aws_iam",
	"aws_iam_account_password_policy":      "aws_iam",
	"aws_vpc":                              "aws_vpc",
	"aws_vpc_flow_log":                     "aws_vpc",
	"aws_vpc_security_group":               "aws_vpc",
	"aws_vpc_route_table":                  "aws_vpc",
	"aws_vpc_eip":                          "aws_vpc",
	"aws_vpc_vpn_connection":               "aws_vpc",
	"aws_vpc_internet_gateway":             "aws_vpc",
	"aws_vpc_security_group_rule":          "aws_vpc",
	"aws_vpc_subnet":                       "aws_vpc",
	"aws_config_rule":                      "aws_config",
	"aws_config_configuration_recorder":    "aws_config",
	"aws_cloudwatch_log_group":             "aws_cloudwatch",
	"aws_cloudwatch_log_metric_filter":     "aws_cloudwatch",
	"aws_cloudwatch_alarm":                 "aws_cloudwatch",
	"aws_ebs_volume":                       "aws_ebs",
	"aws_ebs_snapshot":                     "aws_ebs",
	"aws_cloudtrail_trail":                 "aws_cloudtrail",
	"aws_kms_key":                          "aws_kms",
	"aws_dms_replication_instance":         "aws_dms",
	"aws_acm_certificate":                  "aws_acm",
	"aws_elastic_beanstalk_environment":    "aws_elasticbeanstalk",
	"aws_lambda_function":                  "aws_lambda",
	"aws_elasticsearch_domain":             "aws_es",
	"aws_ec2_classic_load_balancer":        "aws_elb",
	"aws_ec2_application_load_balancer":    "aws_elb",
	"aws_ec2_network_load_balancer":        "aws_elb",
	"aws_ec2_load_balancer_listener":       "aws_elbv2",
	"aws_eks_cluster":                      "aws_eks",
	"aws_ssm_parameter":                    "aws_ssm",
	"aws_ssm_managed_instance":             "aws_ssm",
	"aws_ssm_managed_instance_compliance":  "aws_ssm",
	"aws_sagemaker_endpoint_configuration": "aws_sagemaker",
	"aws_sagemaker_notebook_instance":      "aws_sagemaker",
	"aws_cloudfront_distribution":          "aws_cloudfront",
	"aws_secretsmanager_secret":            "aws_secretsmanager",
	"aws_ec2_instance":                     "aws_ec2",
	"aws_ec2_regional_settings":            "aws_ec2",
	"aws_ecr_repository":                   "aws_ecr",
	"aws_ecrpublic_repository":             "aws_ecr_public",
	"aws_sqs_queue":                        "aws_sqs",
	"aws_redshift_cluster":                 "aws_redshift",
	"aws_redshift_parameter_group":         "aws_redshift",
	"aws_efs_file_system":                  "aws_efs",
	"aws_emr_cluster":                      "aws_emr",
	"aws_api_gateway_stage":                "aws_api_gateway",
	"aws_api_gatewayv2_stage":              "aws_api_gateway",
	"aws_opensearch_domain":                "aws_opensearch",
	"aws_guardduty_detector":               "aws_guardduty",
	"aws_guardduty_finding":                "aws_guardduty",
	"aws_codebuild_project":                "aws_codebuild",
	"aws_codebuild_source_credential":      "aws_codebuild",
	"aws_dynamodb_table":                   "aws_dynamodb",
	"aws_ecs_cluster":                      "aws_ecs",
	"aws_ecs_service":                      "aws_ecs_service",
	"aws_ecs_task":                         "aws_ecs_task",
	"aws_ecs_task_definiton":               "aws_ecs_task_definiton",
	"aws_sns_topic":                        "aws_sns",
	"aws_ec2_autoscaling_group":            "aws_autoscaling",
	"aws_elasticache_replication_group":    "aws_elasticache",
	"aws_securityhub_hub":                  "aws_securityhub",
	"aws_rds_db_snapshot":                  "aws_rds",
	"aws_rds_db_cluster_snapshot":          "aws_rds",
	"aws_rds_db_instance":                  "aws_rds",
	"aws_rds_db_cluster":                   "aws_rds",
	"aws_backup_plan":                      "aws_backup",
	"aws_backup_vault":                     "aws_backup",
	"aws_backup_recovery_point":            "aws_backup",
	"aws_wafv2_web_acl":                    "aws_wafv2",
	"aws_fsx_file_system":                  "aws_fsx",
	"aws_dax_cluster":                      "aws_dax",
	// azure
	"azure_compute_virtual_machine":    "azure_compute_vm",
	"azure_resource_group":             "azure_resource_group",
	"azure_storage_account":            "azure_storage_account",
	"azure_storage_blob":               "azure_storage_blob",
	"azure_virtual_network":            "azure_virtual_network",
	"azure_ad_user":                    "azure_ad_user",
	"azure_sql_database":               "azure_sql",
	"azure_mssql_managed_instance":     "azure_mssql_managed",
	"azure_mssql_virtual_machine":      "azure_mssql_vm",
	"azure_cosmosdb_sql_database":      "azure_cosmosdb_sql",
	"azure_mysql_server":               "azure_mysql_server",
	"azure_storage_table":              "azure_storage_table",
	"azure_log_profile":                "azure_log",
	"azure_policy_definition":          "azure_policy",
	"azure_policy_assignment":          "azure_policy_assignment",
	"azure_app_service_environment":    "azure_app_service",
	"azure_app_service_function_app":   "azure_app_service_function",
	"azure_network_interface":          "azure_network_interface",
	"azure_container_registry":         "azure_container_registry",
	"azure_key_vault_secret":           "azure_key_vault",
	"azure_app_service_plan":           "azure_app_service_plan",
	"azure_app_service_web_app":        "azure_app_service_web_app",
	"azure_application_security_group": "azure_application_security_group",
	"azure_synapse_workspace":          "azure_synapse",
	"azure_hdinsight_cluster":          "azure_hdinsight_cluster",
	"azure_kubernetes_cluster":         "azure_kubernetes_cluster",
	"azure_storage_queue":              "azure_storage_queue",
	"azure_servicebus_namespace":       "azure_servicebus",
	"azure_network_security_group":     "azure_network_security_group",
	"azure_storage_container":          "azure_storage_container",
	// gcp
	"gcp_compute_instance":        "gcp_compute",
	"gcp_cloudfunctions_function": "gcp_cloud_function",
	"gcp_compute_network":         "gcp_compute_network",
	"gcp_compute_resource_policy": "gcp_compute_resource_policy",
	"gcp_iam_policy":              "gcp_iam_policy",
	"gcp_iam_role":                "gcp_iam",
	"gcp_logging_bucket":          "gcp_logging",
	"gcp_project":                 "gcp_project",
	"gcp_pubsub_topic":            "gcp_pubsub_topic",
	"gcp_service_account":         "gcp_sa",
	"gcp_sql_database_instance":   "gcp_sql",
	"gcp_storage_bucket":          "gcp_storage",
	"gcp_compute_disk":            "gcp_compute_disk",
	"gcp_compute_firewall":        "gcp_compute_firewall",
	"gcp_compute_subnetwork":      "gcp_compute_subnetwork",
}

var CSPMResourceLabels = map[string]string{
	"aws_s3":                 "AWS S3 Bucket",
	"aws_iam":                "AWS Identity and Access Management (IAM)",
	"aws_vpc":                "AWS VPC",
	"aws_config":             "AWS Config",
	"aws_cloudwatch":         "AWS Cloud Watch",
	"aws_ebs":                "AWS Elastic Block Store",
	"aws_cloudtrail":         "AWS CloudTrail",
	"aws_kms":                "AWS Key Management Service",
	"aws_dms":                "AWS Database Migration Service (DMS)",
	"aws_acm":                "AWS ACM",
	"aws_elasticbeanstalk":   "AWS Elastic Beanstalk",
	"aws_eks":                "AWS EKS",
	"aws_lambda":             "AWS Lambda",
	"aws_es":                 "AWS ElasticSearch",
	"aws_elb":                "AWS ELB",
	"aws_elbv2":              "AWS ELBv2",
	"aws_ssm":                "AWS Systems Manager(SSM)",
	"aws_sagemaker":          "AWS SageMaker",
	"aws_cloudfront":         "AWS CloudFront",
	"aws_secretsmanager":     "AWS Secrets Manager",
	"aws_ec2":                "AWS EC2",
	"aws_ecr":                "AWS ECR",
	"aws_ecr_public":         "AWS Public ECR",
	"aws_sqs":                "AWS SQS",
	"aws_redshift":           "AWS Redshift",
	"aws_efs":                "AWS EFS",
	"aws_emr":                "AWS EMR",
	"aws_api_gateway":        "AWS API Gateway",
	"aws_opensearch":         "AWS OpenSearch Service",
	"aws_guardduty":          "AWS GuardDuty",
	"aws_codebuild":          "AWS CodeBuild",
	"aws_dynamodb":           "Amazon DynamoDB",
	"aws_ecs":                "Amazon ECS",
	"aws_ecs_task":           "AWS ECS Task",
	"aws_ecs_service":        "AWS ECS Service",
	"aws_ecs_task_definiton": "AWS ECS Task Definition",
	"aws_sns":                "AWS SNS",
	"aws_autoscaling":        "AWS Autoscaling",
	"aws_rds":                "AWS RDS",
	"aws_elasticache":        "AWS ElastiCache",
	"aws_securityhub":        "AWS Security Hub",
	"aws_backup":             "AWS Backup",
	"aws_wafv2":              "AWS WAF v2",
	"aws_fsx":                "AWS FSx",
	"aws_dax":                "AWS DAX",
	// azure
	"azure_ad_user":                    "Azure AD User",
	"azure_app_service":                "Azure App Service Environment",
	"azure_app_service_function":       "Azure App Service Function",
	"azure_app_service_plan":           "Azure App Service Plan",
	"azure_app_service_web_app":        "Azure App Service Web Application",
	"azure_application_security_group": "Azure Application Security Groups",
	"azure_compute_vm":                 "Azure Virtual Machines",
	"azure_container_registry":         "Azure Container Registry",
	"azure_cosmosdb_sql":               "Azure Cosmos DB",
	"azure_hdinsight_cluster":          "Azure HDInsight",
	"azure_key_vault":                  "Azure Key Vault",
	"azure_kubernetes_cluster":         "Azure Kubernetes Cluster",
	"azure_log":                        "Azure Log Profiles",
	"azure_mssql_managed":              "Azure SQL Managed Instance",
	"azure_mssql_vm":                   "Azure SQL Virtual Machines ",
	"azure_mysql_server":               "Azure Database for MySQL Server",
	"azure_network_interface":          "Azure Network Interface",
	"azure_network_security_group":     "Azure Network Security Group",
	"azure_policy":                     "Azure Policy",
	"azure_policy_assignment":          "Azure Policy Assignment",
	"azure_resource_group":             "Azure Resource Group",
	"azure_servicebus":                 "Azure Servicebus Namespace",
	"azure_sql":                        "Azure SQL Database",
	"azure_storage_account":            "Azure Storage Account",
	"azure_storage_blob":               "Azure Blob Storage",
	"azure_storage_queue":              "Azure Queue Storage",
	"azure_storage_table":              "Azure Table storage",
	"azure_synapse":                    "Azure Synapse",
	"azure_virtual_network":            "Azure Virtual Network",
	"azure_storage_container":          "Azure Storage Container",
	// gcp
	"gcp_cloud_function":          "GCP Cloud Functions",
	"gcp_compute":                 "GCP VM Instance",
	"gcp_compute_network":         "GCP VPC Network",
	"gcp_compute_resource_policy": "GCP Compute Resource Policy",
	"gcp_iam":                     "GCP IAM Role",
	"gcp_iam_policy":              "GCP IAM Policy",
	"gcp_logging":                 "GCP Log Buckets",
	"gcp_project":                 "GCP Project",
	"gcp_pubsub_topic":            "GCP Cloud Pub/Sub",
	"gcp_sa":                      "GCP Service Account",
	"gcp_sql":                     "GCP Cloud SQL Instance",
	"gcp_storage":                 "GCP Cloud Storage Buckets",
	"gcp_compute_disk":            "GCP Compute Disk",
	"gcp_compute_firewall":        "GCP Compute Firewall",
	"gcp_compute_subnetwork":      "GCP Compute SubNet",
}
