import { Breadcrumb, BreadcrumbLink, Button } from 'ui-components';

import { DFLink } from '@/components/DFLink';
import { CaretDown } from '@/components/icons/common/CaretDown';
import { FileLineIcon } from '@/components/icons/common/FileLine';
import { SeverityLegend } from '@/components/SeverityBadge';
import { VulnerabilityIcon } from '@/components/sideNavigation/icons/Vulnerability';
import { BreadcrumbWrapper } from '@/features/common/BreadcrumbWrapper';
import { MostExploitablePromoCard } from '@/features/vulnerabilities/components/landing/MostExploitablePromoCard';
import { TopAttackPaths } from '@/features/vulnerabilities/components/landing/TopAttackPaths';
import { TopNVulnerableCard } from '@/features/vulnerabilities/components/landing/TopNVulnerableCard';
import { UniqueVulnerabilitiesCountsCard } from '@/features/vulnerabilities/components/landing/VulnerabilitiesCountsCard';

const Vulnerability = () => {
  return (
    <div>
      <BreadcrumbWrapper>
        <Breadcrumb>
          <BreadcrumbLink
            icon={<VulnerabilityIcon />}
            className="text-text-input-value leading-[30px]"
          >
            Vulnerabilities
          </BreadcrumbLink>
        </Breadcrumb>
        <DFLink unstyled to="/vulnerability/rbom" className="ml-auto">
          <Button variant="flat" size="sm" startIcon={<FileLineIcon />}>
            Runtime BOM
          </Button>
        </DFLink>
      </BreadcrumbWrapper>
      <div className="mx-4 h-12 flex items-center">
        <div className="-ml-2.5">
          <DFLink unstyled to="/vulnerability/scans" className="ml-auto">
            <Button
              variant="flat"
              size="sm"
              endIcon={
                <div className="-rotate-90">
                  <CaretDown />
                </div>
              }
            >
              View all scans
            </Button>
          </DFLink>
        </div>
        <div className="flex gap-2 items-center ml-auto">
          <span className="text-p6 text-text-text-and-icon self-center">Legends</span>
          <div className="flex gap-5">
            <SeverityLegend severity="critical" />
            <SeverityLegend severity="high" />
            <SeverityLegend severity="medium" />
            <SeverityLegend severity="low" />
            <SeverityLegend severity="unknown" />
          </div>
        </div>
      </div>
      <div className="mx-4 pb-4 grid grid-cols-12 gap-4">
        <div className="col-span-3">
          <UniqueVulnerabilitiesCountsCard />
        </div>

        <div className="col-span-3">
          <MostExploitablePromoCard />
        </div>
        <div className="col-span-6">
          <TopAttackPaths />
        </div>

        <div className="col-span-4">
          <TopNVulnerableCard type="container" />
        </div>
        <div className="col-span-4">
          <TopNVulnerableCard type="host" />
        </div>
        <div className="col-span-4">
          <TopNVulnerableCard type="image" />
        </div>
      </div>
    </div>
  );
};

export const module = {
  element: <Vulnerability />,
};
