import { Button, Card } from 'ui-components';

import { DFLink } from '@/components/DFLink';
import { ArrowLine } from '@/components/icons/common/ArrowLine';
import { VulnerabilityIcon } from '@/components/sideNavigation/icons/Vulnerability';
import { CardHeader } from '@/features/vulnerabilities/components/landing/CardHeader';

export const MostExploitablePromoCard = () => {
  return (
    <Card className="rounded min-h-full flex flex-col">
      <CardHeader
        icon={<VulnerabilityIcon />}
        title={'Most Exploitable Vulnerabilities'}
        infoText={
          <span className="text-text-input-value">
            This capability helps you to get the most exploitable vulnerabilities by
            correlating data across Live VMs, Running Applications and Threat
            Intelligence. Fixing these exploitable vulnerabilities first would drastically
            reduce the attack surface. Click{' '}
            <a
              href="https://www.deepfence.io/blog/tackling-the-most-exploitable-vulnerabilities-prioritization-in-a-sea-of-risks"
              target="_blank"
              rel="noreferrer"
              className="text-text-link"
            >
              here
            </a>{' '}
            for more details
          </span>
        }
      />
      <div className="flex-1 flex flex-col items-center justify-center gap-4">
        <div className="text-h4 text-text-input-value">Too Many Vulnerabilities?</div>
        <DFLink
          unstyled
          className="my-2"
          href="https://deepfence.io/threatstryker/"
          target="_blank"
        >
          <Button
            color="success"
            endIcon={<ArrowLine className="rotate-90" />}
            className="bg-[#009852] dark:bg-[#15b77e]"
          >
            Get ThreatStryker
          </Button>
        </DFLink>
      </div>
    </Card>
  );
};
