import { Button, Card } from 'ui-components';

import { DFLink } from '@/components/DFLink';
import { ArrowLine } from '@/components/icons/common/ArrowLine';
import { VulnerabilityIcon } from '@/components/sideNavigation/icons/Vulnerability';
import { CardHeader } from '@/features/vulnerabilities/components/landing/CardHeader';

export const MostExploitablePromoCard = () => {
  return (
    <Card className="rounded min-h-full flex flex-col">
      <CardHeader icon={<VulnerabilityIcon />} title={'Most Exploitable Malwares'} />
      <div className="flex-1 flex flex-col items-center justify-center gap-4">
        <div className="text-h4 text-text-input-value">Too Many Malwares?</div>
        <DFLink
          unstyled
          className="my-2"
          href="https://deepfence.io/threatstryker/"
          target="_blank"
        >
          <Button
            color="success"
            endIcon={<ArrowLine className="rotate-90" />}
            className="bg-[#009852] dark:bg-[#15b77e]"
          >
            Get ThreatStryker
          </Button>
        </DFLink>
      </div>
    </Card>
  );
};
